/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.DbOperationDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolActions {
    @NotNull
    public static JBIterable<PsiElement> getSelectedElements(@NotNull DataContext dataContext) {
        PsiElement element;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/ToolActions", "getSelectedElements"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiReference ref = editor == null || file == null ? null : file.findReferenceAt(editor.getCaretModel().getOffset());
        PsiElement psiElement = element = ref == null ? null : ref.resolve();
        if (element != null) {
            JBIterable jBIterable = JBIterable.of((Object[])new PsiElement[]{element});
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions", "getSelectedElements"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions", "getSelectedElements"));
        }
        return jBIterable;
    }

    public static class TruncateTablesAction
    extends ToolActionBase {
        public TruncateTablesAction() {
            super("Truncate Table", "_Truncate", "Truncate selected tables", AllIcons.Actions.GC);
        }

        @Override
        protected boolean isSupported(@NotNull DatabaseDialectEx dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "isSupported"));
            }
            return TruncateTablesAction.hasOperation(dialect, DasDdlOperations.TRUNCATE_TABLE);
        }

        @Override
        @NotNull
        protected JBIterable<? extends DbElement> getObjects(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "getObjects"));
            }
            JBIterable jBIterable = super.getObjects(e).filter(DbTable.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.TABLE));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "getObjects"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected DbOperationDialog createDialog(@NotNull DatabaseEditorContext context, @NotNull JBIterable<? extends DbElement> selection) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "createDialog"));
            }
            if (selection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "createDialog"));
            }
            DbOperationDialog dbOperationDialog = DbOperationDialog.createDialog(context, selection, new DdlGraph.DdlOperation[]{DasDdlOperations.TRUNCATE_TABLE});
            if (dbOperationDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "createDialog"));
            }
            return dbOperationDialog;
        }
    }

    public static abstract class ToolActionBase
    extends DumbAwareAction {
        private final String myTitle;

        public ToolActionBase(@NotNull String title, @Nullable String text, @Nullable String description, @Nullable Icon icon) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/actions/ToolActions$ToolActionBase", "<init>"));
            }
            super(text, description, icon);
            this.myTitle = title;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ToolActions$ToolActionBase", "update"));
            }
            DbElement selected = (DbElement)this.getObjects(e).first();
            boolean enabled = selected != null && DbImplUtil.canConnectToAndModify(selected) && this.isSupported(DbImplUtil.getDatabaseDialect(selected));
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        protected abstract boolean isSupported(@NotNull DatabaseDialectEx var1);

        protected static boolean hasOperation(@NotNull DatabaseDialectEx dialect, @NotNull DdlGraph.DdlOperation op) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/actions/ToolActions$ToolActionBase", "hasOperation"));
            }
            if (op == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/actions/ToolActions$ToolActionBase", "hasOperation"));
            }
            return dialect.getSchemaEditor().getDdlOperations().get(op) != null;
        }

        @NotNull
        protected JBIterable<? extends DbElement> getObjects(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ToolActions$ToolActionBase", "getObjects"));
            }
            JBIterable jBIterable = ToolActions.getSelectedElements(e.getDataContext()).filter(DbElement.class);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$ToolActionBase", "getObjects"));
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ToolActions$ToolActionBase", "actionPerformed"));
            }
            JBIterable<? extends DbElement> selection = this.getObjects(e);
            DbElement first = (DbElement)selection.first();
            if (first == null) {
                return;
            }
            DatabaseEditorContext context = new DatabaseEditorContext(first.getDataSource(), null);
            DbOperationDialog dialog = this.createDialog(context, selection);
            dialog.setTitle(this.myTitle);
            dialog.show();
        }

        @NotNull
        protected abstract DbOperationDialog createDialog(@NotNull DatabaseEditorContext var1, @NotNull JBIterable<? extends DbElement> var2);
    }
}

