/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.actions.ImportDataSourceAction;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConfigFileWatcher
implements ProjectComponent {
    private final Project myProject;
    private final MergingUpdateQueue myQueue;

    public DatabaseConfigFileWatcher(Project project) {
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue(this.getComponentName(), 3000, true, null, (Disposable)project, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myQueue.setRestartTimerOnAdd(true);
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                DatabaseConfigFileWatcher.this.myQueue.suspend();
            }

            public void exitDumbMode() {
                DatabaseConfigFileWatcher.this.myQueue.resume();
            }
        });
    }

    public static void ensureAllPendingUpdatesProcessed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher", "ensureAllPendingUpdatesProcessed"));
        }
        DatabaseConfigFileWatcher configFileWatcher = (DatabaseConfigFileWatcher)project.getComponent(DatabaseConfigFileWatcher.class);
        if (configFileWatcher != null) {
            configFileWatcher.myQueue.flush();
        }
    }

    @NotNull
    public String getComponentName() {
        if ("DatabaseConfigFileWatcher" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher", "getComponentName"));
        }
        return "DatabaseConfigFileWatcher";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void initPsiListener() {
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$2", "childAdded"));
                }
                this.update(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$2", "childRemoved"));
                }
                this.update(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$2", "childReplaced"));
                }
                this.update(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$2", "childMoved"));
                }
                this.update(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$2", "childrenChanged"));
                }
                this.update(event);
            }

            private void update(PsiTreeChangeEvent event) {
                DatabaseConfigFileWatcher.this.update(DatabaseConfigFileWatcher.getFile(event));
            }
        }, (Disposable)this.myProject);
    }

    @Nullable
    private static PsiFile getFile(PsiTreeChangeEvent event) {
        PsiFile file = event.getFile();
        PsiElement child = event.getChild();
        if (file == null && child instanceof PsiFile) {
            return (PsiFile)child;
        }
        return file;
    }

    private void update(PsiFile file) {
        final VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile == null) {
            return;
        }
        this.myQueue.queue(new Update(virtualFile){

            public void run() {
                boolean done;
                final DataSourceRegistry registry = new DataSourceRegistry(DatabaseConfigFileWatcher.this.myProject);
                boolean bl = done = !DumbService.isDumb((Project)DatabaseConfigFileWatcher.this.myProject) && ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DatabaseConfigFileWatcher.this.scanForNewConfigurationsOnTheFly(registry, virtualFile);
                    }
                });
                if (done) {
                    DatabaseConfigFileWatcher.configure(DatabaseConfigFileWatcher.this.myProject, registry);
                } else if (virtualFile.isValid() && DatabaseConfigFileWatcher.this.myProject.isOpen()) {
                    DatabaseConfigFileWatcher.this.myQueue.queue((Update)this);
                }
            }

            public boolean canEat(Update update) {
                return this.equals(update);
            }
        });
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                DatabaseConfigFileWatcher.this.initPsiListener();
                DatabaseConfigFileWatcher.this.myQueue.queue(new Update(DatabaseConfigFileWatcher.this.myProject){

                    public void run() {
                        boolean done;
                        final DataSourceRegistry registry = new DataSourceRegistry(DatabaseConfigFileWatcher.this.myProject);
                        boolean bl = done = !DumbService.isDumb((Project)DatabaseConfigFileWatcher.this.myProject) && ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                DatabaseConfigFileWatcher.this.scanForNewConfigurations(registry);
                            }
                        });
                        if (done) {
                            if (DatabaseConfigFileWatcher.configure(DatabaseConfigFileWatcher.this.myProject, registry)) {
                                DatabaseConfigFileWatcher.notifyNewDataSourcesDetected(DatabaseConfigFileWatcher.this.myProject);
                            }
                        } else if (DatabaseConfigFileWatcher.this.myProject.isOpen()) {
                            DatabaseConfigFileWatcher.this.myQueue.queue((Update)this);
                        }
                    }

                    public boolean canEat(Update update) {
                        return this.equals(update);
                    }
                });
            }
        });
    }

    protected void scanForNewConfigurations(@NotNull DataSourceRegistry registry) {
        Module[] modules;
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher", "scanForNewConfigurations"));
        }
        Module[] moduleArray = modules = this.myProject.isDisposed() ? Module.EMPTY_ARRAY : ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length == 0) {
            return;
        }
        for (DataSourceDetector detector : (DataSourceDetector[])Extensions.getExtensions((ExtensionPointName)DataSourceDetector.EP_NAME)) {
            for (Module module : modules) {
                detector.collectDataSources(module, registry.getBuilder(), false);
            }
        }
    }

    protected void scanForNewConfigurationsOnTheFly(@NotNull DataSourceRegistry registry, @NotNull VirtualFile virtualFile) {
        Module module;
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher", "scanForNewConfigurationsOnTheFly"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher", "scanForNewConfigurationsOnTheFly"));
        }
        PsiFile file = this.myProject.isDisposed() || !virtualFile.isValid() ? null : PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        Module module2 = module = file == null ? null : ModuleUtilCore.findModuleForPsiElement(file);
        if (module == null || module.isDisposed()) {
            return;
        }
        for (DataSourceDetector detector : (DataSourceDetector[])Extensions.getExtensions((ExtensionPointName)DataSourceDetector.EP_NAME)) {
            if (!detector.isRelevantFile(file)) continue;
            detector.collectDataSources(module, registry.getBuilder(), true);
        }
    }

    public void projectClosed() {
    }

    private static boolean configure(final @NotNull Project project, final @NotNull DataSourceRegistry registry) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher", "configure"));
        }
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher", "configure"));
        }
        if (registry.isEmpty()) {
            return false;
        }
        boolean result = !registry.getNewDataSources().isEmpty();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DataSourceConfigUtil.configureDetectedDataSources(project, registry, false);
            }
        }, ModalityState.any());
        return result;
    }

    private static void notifyNewDataSourcesDetected(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher", "notifyNewDataSourcesDetected"));
        }
        String content = "<html><body><font face=\"verdana\">\n<font size=\"3\">Database connection properties are detected.<br>\n<a href=\"create\">Discover and setup</a> new data sources.";
        DatabaseNotifications.DATABASE_DETECTION_GROUP.createNotification("Database connections detector", content, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$6", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$6", "hyperlinkActivated"));
                }
                ImportDataSourceAction.doImportAction(DbPsiFacade.getInstance((Project)project), true);
            }
        }).notify(project);
    }
}

