/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatForm;
import com.intellij.database.csv.ui.CsvFormatsListComponent;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CsvFormatsUI
implements Disposable {
    private CsvFormatsListComponent myFormatsList;
    private JPanel myPanel;
    private JPanel myFormatListPanel;
    private JBLabel myFormatsLabel;
    private CsvFormatForm myFormatForm;
    private JBScrollPane myFormatFormScrollPane;
    private CsvFormatPreview myPreview;

    public CsvFormatsUI(boolean allowNameEditing) {
        this.$$$setupUI$$$();
        new FormatsListToFormatEditorBond();
        ToolbarDecorator decorator = this.createFormatListDecorator();
        this.myFormatListPanel.add((Component)DatabaseEditorUtil.labeledDecorator((JComponent)this.myFormatsLabel, decorator), "Center");
        this.myFormatListPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)8, (int)UIUtil.getScrollBarWidth()));
        AnActionButton button = ToolbarDecorator.findEditButton((JComponent)decorator.getActionsPanel());
        if (button != null) {
            button.setVisible(false);
        }
        this.myFormatsList.setNameEditingAllowed(allowNameEditing);
        this.myFormatsList.addChangeListener(new CsvFormatsListComponent.ChangeListener(){

            @Override
            public void formatsChanged(@NotNull CsvFormatsListComponent formatsListComponent) {
                if (formatsListComponent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatsListComponent", "com/intellij/database/csv/ui/CsvFormatsUI$1", "formatsChanged"));
                }
                CsvFormat selectedFormat = CsvFormatsUI.this.getSelectedFormat();
                if (selectedFormat == null) {
                    return;
                }
                if (CsvFormatsUI.this.myPreview != null) {
                    CsvFormatsUI.this.myPreview.setFormat(selectedFormat);
                }
            }
        });
        this.myFormatFormScrollPane.setPreferredSize(this.myFormatFormScrollPane.getViewport().getView().getPreferredSize());
        this.myFormatFormScrollPane.getVerticalScrollBar().setUnitIncrement(10);
    }

    private void createUIComponents() {
        this.myFormatForm = new CsvFormatForm(this);
        this.myFormatsList = new CsvFormatsListComponent(this);
        this.myFormatFormScrollPane = (JBScrollPane)ScrollPaneFactory.createScrollPane();
        this.myFormatFormScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
    }

    public void reset(@NotNull List<CsvFormat> formats, @Nullable String nameToSelect) {
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/csv/ui/CsvFormatsUI", "reset"));
        }
        this.myFormatsList.reset(formats, nameToSelect);
    }

    @NotNull
    public List<CsvFormat> getFormats() {
        List<CsvFormat> list = this.myFormatsList.getFormats();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsUI", "getFormats"));
        }
        return list;
    }

    @Nullable
    public CsvFormat getSelectedFormat() {
        return this.myFormatsList.getSelected();
    }

    public void attachPreview(@NotNull CsvFormatPreview preview) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/csv/ui/CsvFormatsUI", "attachPreview"));
        }
        this.myPreview = preview;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsUI", "getComponent"));
        }
        return jPanel;
    }

    public void dispose() {
    }

    @NotNull
    protected CsvFormatsListComponent getFormatsListComponent() {
        CsvFormatsListComponent csvFormatsListComponent = this.myFormatsList;
        if (csvFormatsListComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsUI", "getFormatsListComponent"));
        }
        return csvFormatsListComponent;
    }

    @NotNull
    protected abstract ToolbarDecorator createFormatListDecorator();

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = this.myFormatFormScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), null, 0, 0, null, null));
        CsvFormatForm csvFormatForm = this.myFormatForm;
        JComponent jComponent = csvFormatForm.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myFormatListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(1, -1), null));
        this.myFormatsLabel = jBLabel = new JBLabel();
        jBLabel.setText("Formats:");
        jPanel.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class FormatsListToFormatEditorBond
    implements CsvFormatsListComponent.ChangeListener,
    CsvFormatForm.ChangeListener {
        private boolean myUpdating;

        public FormatsListToFormatEditorBond() {
            CsvFormatsUI.this.myFormatsList.addChangeListener(this);
            CsvFormatsUI.this.myFormatForm.addChangeListener(this);
        }

        @Override
        public void formatsChanged(@NotNull CsvFormatsListComponent formatsListComponent) {
            if (formatsListComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatsListComponent", "com/intellij/database/csv/ui/CsvFormatsUI$FormatsListToFormatEditorBond", "formatsChanged"));
            }
            this.update(new Runnable(){

                @Override
                public void run() {
                    CsvFormat selectedFormat = CsvFormatsUI.this.myFormatsList.getSelected();
                    if (selectedFormat == null) {
                        CsvFormatsUI.this.myFormatForm.getComponent().setVisible(false);
                    } else {
                        CsvFormatsUI.this.myFormatForm.getComponent().setVisible(true);
                        CsvFormatsUI.this.myFormatForm.reset(selectedFormat);
                    }
                }
            });
        }

        @Override
        public void formatChanged(@NotNull CsvFormatForm source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/csv/ui/CsvFormatsUI$FormatsListToFormatEditorBond", "formatChanged"));
            }
            this.update(new Runnable(){

                @Override
                public void run() {
                    CsvFormat format = CsvFormatsUI.this.myFormatForm.getFormat();
                    CsvFormatsUI.this.myFormatsList.updateSelectedFormat(format);
                }
            });
        }

        private void update(Runnable updater) {
            if (this.myUpdating) {
                return;
            }
            this.myUpdating = true;
            try {
                updater.run();
            }
            finally {
                this.myUpdating = false;
            }
        }
    }
}

