/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@State(name="DataSourceManagerImpl", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/dataSources.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class DataSourceManagerImpl
extends DataSourceManagerEx
implements PersistentStateComponent<Element> {
    private final Project myProject;
    private final DataSourceStorage myStorage;

    public DataSourceManagerImpl(Project project) {
        this.myProject = project;
        this.myStorage = new DataSourceStorage(DataSourceStorage.getStorage());
        Disposer.register((Disposable)project, (Disposable)this.myStorage);
    }

    public List<DataSource> getDataSources() {
        return this.myStorage.getDataSources();
    }

    @Override
    public void addDataSource(DataSource dataSource) {
        this.myStorage.addDataSource(dataSource);
        DatabaseCredentials.getInstance().persistCredentials(this.myProject, (DatabaseSystem)dataSource);
    }

    @Nullable
    public DataSource getDataSourceByName(String name) {
        return this.myStorage.getDataSourceByName(name);
    }

    @Override
    public void removeDataSource(DataSource dataSource) {
        this.myStorage.removeDataSource(dataSource);
    }

    public void addDataSourceListener(DataSourceListener listener) {
        this.myStorage.addDataSourceListener(listener);
    }

    public void addDataSourceListener(DataSourceListener listener, Disposable parent) {
        this.myStorage.addDataSourceListener(listener, parent);
    }

    public void removeDataSourceListener(DataSourceListener listener) {
        this.myStorage.removeDataSourceListener(listener);
    }

    @Override
    public void updateDataSource(DataSource dataSource) {
        this.myStorage.updateDataSource(dataSource);
    }

    public long getModificationCount() {
        return this.myStorage.getModificationCount();
    }

    public DataSourceStorage getStorage() {
        return this.myStorage;
    }

    public Element getState() {
        Element element = new Element("DataSourceManagerImpl");
        this.myStorage.writeState(this.myProject, element);
        return element;
    }

    public void loadState(Element state) {
        this.myStorage.readState(this.myProject, state);
    }
}

