/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DataSourceOptionsPanel {
    private final DataSourceConfigurable myConfigurable;
    private ExplainPlanProvider myExplainPlanProvider;
    private JPanel myPanel;
    private ComboBox myExplainPlanCombo;
    private ConfigurableUi<LocalDataSource> myExplainPlanUi;

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/database/dataSource/DataSourceOptionsPanel", "<init>"));
        }
        this.myExplainPlanProvider = ExplainPlanProvider.NULL_PROVIDER;
        this.myConfigurable = configurable;
        this.myPanel = new JPanel(new BorderLayout(10, 4));
        this.myPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        List<ExplainPlanProvider> planProviders = ExplainPlanProvider.getProvidersFor((LocalDataSource)((Object)configurable.getDataSource()));
        this.myExplainPlanCombo = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(planProviders));
        this.myExplainPlanCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<ExplainPlanProvider>(){

            public void customize(JList list, ExplainPlanProvider provider, int index, boolean selected, boolean hasFocus) {
                this.setText(provider.getName());
            }
        });
        JPanel labeledPanelWrapper = new JPanel(new BorderLayout());
        JPanel labeledPanel = new JPanel(new BorderLayout(5, 4));
        labeledPanel.add((Component)new JBLabel("Explain plan:"), "West");
        labeledPanel.add((Component)this.myExplainPlanCombo, "Center");
        labeledPanelWrapper.add((Component)labeledPanel, "West");
        labeledPanelWrapper.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
        this.myPanel.add((Component)labeledPanelWrapper, "North");
        this.myExplainPlanCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataSourceOptionsPanel.this.setProvider((ExplainPlanProvider)DataSourceOptionsPanel.this.myExplainPlanCombo.getSelectedItem())) {
                    if (DataSourceOptionsPanel.this.myExplainPlanUi != null) {
                        DataSourceOptionsPanel.this.myExplainPlanUi.reset((Object)DataSourceOptionsPanel.this.myConfigurable.getTempDataSource());
                    }
                    DataSourceOptionsPanel.this.fireChanged();
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void saveData(@NotNull LocalDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dataSource/DataSourceOptionsPanel", "saveData"));
        }
        source.getExplainPlanConfiguration().setProviderClass(this.myExplainPlanProvider.getClass().getCanonicalName());
        if (this.myExplainPlanUi == null) {
            source.getExplainPlanConfiguration().setProviderConfig(ContainerUtil.newHashMap());
        } else {
            try {
                this.myExplainPlanUi.apply((Object)source);
            }
            catch (ConfigurationException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public void reset(@NotNull LocalDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dataSource/DataSourceOptionsPanel", "reset"));
        }
        ExplainPlanProvider provider = ExplainPlanProvider.getProviderByClassName(source.getExplainPlanConfiguration().getProviderClass());
        this.setProvider(provider);
        if (this.myExplainPlanUi != null) {
            this.myExplainPlanUi.reset((Object)source);
        }
        this.myExplainPlanCombo.setSelectedItem((Object)this.myExplainPlanProvider);
    }

    private boolean setProvider(@NotNull ExplainPlanProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/dataSource/DataSourceOptionsPanel", "setProvider"));
        }
        if (provider == this.myExplainPlanProvider) {
            return false;
        }
        this.myExplainPlanProvider = provider;
        if (this.myExplainPlanUi != null) {
            this.myPanel.remove(this.myExplainPlanUi.getComponent());
        }
        this.myExplainPlanUi = this.myExplainPlanProvider.createOptionsComponent();
        if (this.myExplainPlanUi != null) {
            this.myPanel.add((Component)this.myExplainPlanUi.getComponent(), "Center");
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
        return true;
    }

    private void fireChanged() {
        this.myConfigurable.fireStateChanged();
    }
}

