/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSource;
import com.intellij.openapi.util.text.StringUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSslConfiguration {
    public static final String ELEMENT_NAME = "ssl-config";
    @NotNull
    public String myCaCertPath;
    @NotNull
    public String myClientCertPath;
    @NotNull
    public String myClientKeyPath;
    public boolean myEnabled;

    public DataSourceSslConfiguration(@NotNull String caCertPath, @NotNull String clientCertPath, @NotNull String clientKeyPath, boolean enabled) {
        if (caCertPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caCertPath", "com/intellij/database/dataSource/DataSourceSslConfiguration", "<init>"));
        }
        if (clientCertPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientCertPath", "com/intellij/database/dataSource/DataSourceSslConfiguration", "<init>"));
        }
        if (clientKeyPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientKeyPath", "com/intellij/database/dataSource/DataSourceSslConfiguration", "<init>"));
        }
        this.myCaCertPath = caCertPath;
        this.myClientKeyPath = clientKeyPath;
        this.myClientCertPath = clientCertPath;
        this.myEnabled = enabled;
    }

    public static boolean equal(@Nullable DataSourceSslConfiguration c1, @Nullable DataSourceSslConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myCaCertPath)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myClientCertPath)) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)this.myClientKeyPath);
    }

    public boolean equalConfiguration(@NotNull DataSourceSslConfiguration cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "com/intellij/database/dataSource/DataSourceSslConfiguration", "equalConfiguration"));
        }
        if (this.myEnabled != cfg.myEnabled) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myCaCertPath), (CharSequence)StringUtil.nullize((String)cfg.myCaCertPath))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myClientCertPath), (CharSequence)StringUtil.nullize((String)cfg.myClientCertPath))) {
            return false;
        }
        return StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myClientKeyPath), (CharSequence)StringUtil.nullize((String)cfg.myClientKeyPath));
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/DataSourceSslConfiguration", "serialize"));
        }
        serializer.startNode(ELEMENT_NAME);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"ca-cert", (String)this.myCaCertPath);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"client-cert", (String)this.myClientCertPath);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"client-key", (String)this.myClientKeyPath);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"enabled", (String)Boolean.toString(this.myEnabled));
        serializer.endNode();
    }

    @Nullable
    public static DataSourceSslConfiguration deserialize(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/DataSourceSslConfiguration", "deserialize"));
        }
        boolean enabled = false;
        String caCert = "";
        String clientCert = "";
        String clientKey = "";
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            String value = reader.getValue();
            if ("ca-cert".equals(name)) {
                caCert = value;
            } else if ("client-cert".equals(name)) {
                clientCert = value;
            } else if ("client-key".equals(name)) {
                clientKey = value;
            } else if ("enabled".equals(name)) {
                enabled = StringUtil.parseBoolean((String)value, (boolean)false);
            }
            reader.moveUp();
        }
        DataSourceSslConfiguration cfg = new DataSourceSslConfiguration(caCert, clientCert, clientKey, enabled);
        return cfg.isEmpty() ? null : cfg;
    }
}

