/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceProvider;
import com.intellij.database.dataSource.DataSourceProviderFactory;
import com.intellij.database.dataSource.DataSourceStorageLocal;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.ReaderWrapper;
import com.thoughtworks.xstream.io.json.AbstractJsonWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceStorage
extends SimpleModificationTracker
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceStorage");
    @NonNls
    static final String STORAGE_ENTRY_NAME = "dataSources";
    @NonNls
    static final String STATE_FILE = "dataSources.xml";
    @NonNls
    static final String APP_STORAGE_FILE = "dataSources.ids";
    @NonNls
    static final String COMPONENT_NAME = "dataSourceStorage";
    @NonNls
    static final String COMPRESSED_ATTR_NAME = "compressed";
    @NonNls
    static final String FORMAT_ATTR_NAME = "format";
    @NonNls
    static final String HASH_ATTR_NAME = "hash";
    @NonNls
    private static final String DATA_SOURCE_SOURCE_NAME = "DataSourceSourceName";
    private final DataSourceStorage myParentStorage;
    private final List<DataSource> myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();
    private final EventDispatcher<DataSourceListener> myDispatcher = EventDispatcher.create(DataSourceListener.class);
    private volatile long myLastSaveModificationCount = -1L;
    private final Object myIOLock = new Object();
    private Format myFormat = Format.XML;
    private long myHash;

    public static DataSourceStorage getStorage() {
        return (DataSourceStorage)((Object)ServiceManager.getService(App.class));
    }

    public DataSourceStorage(DataSourceStorage parentStorage) {
        this.myParentStorage = parentStorage;
        if (parentStorage != null) {
            this.myParentStorage.addDataSourceListener(new DataSourceListener(){

                public void dataSourceAdded(@NotNull DataSource dataSource) {
                    if (dataSource == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage$1", "dataSourceAdded"));
                    }
                    ((DataSourceListener)DataSourceStorage.this.myDispatcher.getMulticaster()).dataSourceAdded(dataSource);
                }

                public void dataSourceRemoved(@NotNull DataSource dataSource) {
                    if (dataSource == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage$1", "dataSourceRemoved"));
                    }
                    ((DataSourceListener)DataSourceStorage.this.myDispatcher.getMulticaster()).dataSourceRemoved(dataSource);
                }

                public void dataSourceChanged(DataSource dataSource) {
                    ((DataSourceListener)DataSourceStorage.this.myDispatcher.getMulticaster()).dataSourceChanged(dataSource);
                }
            }, this);
        }
    }

    @Nullable
    private static String getStoragePath(@Nullable Project project) {
        String path;
        if (project == null) {
            path = PathManager.getOptionsPath() + "/" + APP_STORAGE_FILE;
        } else {
            VirtualFile baseDir = project.getBaseDir();
            if (baseDir == null) {
                return null;
            }
            File ideaFolder = new File(FileUtil.toSystemDependentName((String)baseDir.getPath()), ".idea");
            if (ideaFolder.isDirectory()) {
                path = ideaFolder.getPath() + "/" + APP_STORAGE_FILE;
            } else {
                String projectFilePath = project.getProjectFilePath();
                if (projectFilePath == null) {
                    return null;
                }
                path = FileUtil.getNameWithoutExtension((String)projectFilePath) + "." + "ids";
            }
        }
        return FileUtil.toSystemIndependentName((String)path);
    }

    public Element getState() {
        Element element = new Element(COMPONENT_NAME);
        this.writeState(null, element);
        return element;
    }

    public void loadState(Element state) {
        this.readState(null, state);
    }

    public void writeLocalState(@Nullable Project project) {
        Element element = new Element("dataSourceStorageLocal");
        JDomWriter serializer = new JDomWriter(element);
        for (DataSource dataSource : this.myDataSources) {
            dataSource.serialize(project, (HierarchicalStreamWriter)serializer, DataSource.SaveMode.LOCAL_CONFIG);
        }
        DataSourceStorageLocal.getInstance(project).loadState(element);
    }

    public void readLocalState(@Nullable Project project, @Nullable Element element) {
        if (element == null) {
            for (DataSource o : this.myDataSources) {
                LocalDataSource dataSource;
                if (!(o instanceof LocalDataSource) || !StringUtil.isEmpty((String)(dataSource = (LocalDataSource)o).getUsername())) continue;
                dataSource.setSecretStorage(DatabaseCredentials.StorageType.MEMORY);
            }
        } else {
            this.readDataSources(project, (HierarchicalStreamReader)new JDomReader(element), DataSource.SaveMode.LOCAL_CONFIG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readState(final Project project, Element element) {
        if (project != null && project.isDefault()) {
            return;
        }
        Format prevFormat = this.myFormat;
        String formatAttr = element.getAttributeValue(FORMAT_ATTR_NAME);
        if (formatAttr != null) {
            try {
                this.myFormat = Format.valueOf(formatAttr.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                this.myFormat = Format.XML;
            }
        } else {
            String oldCompressedAttr = element.getAttributeValue(COMPRESSED_ATTR_NAME);
            this.myFormat = Boolean.parseBoolean(oldCompressedAttr) ? Format.COMPRESSED_XML : Format.XML;
        }
        final boolean formatChanged = !this.myDataSources.isEmpty() && this.myFormat != prevFormat;
        String hashString = element.getAttributeValue(HASH_ATTR_NAME);
        this.myHash = hashString == null ? 0L : Long.parseLong(hashString);
        this.incModificationCount();
        this.myDataSources.clear();
        Object object = this.myIOLock;
        synchronized (object) {
            this.myDataSources.addAll(this.readDataSources(project, (HierarchicalStreamReader)new JDomReader(element), DataSource.SaveMode.CONFIG));
            this.readLocalState(project, DataSourceStorageLocal.getInstance(project).getState());
            for (DataSource dataSource : this.myDataSources) {
                if (dataSource.getModel() != DasUtil.emptyModel()) continue;
                dataSource.updateState(DasUtil.loadingModel());
            }
        }
        ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceChanged(null);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ErrorHandler errorHandler = new ErrorHandler();
                Object object = DataSourceStorage.this.myIOLock;
                synchronized (object) {
                    try {
                        if (project != null && project.isDisposed()) {
                            return;
                        }
                        if (DataSourceStorage.this.loadFromDisk(project, DataSourceStorage.getStoragePath(project), DataSource.SaveMode.SCHEMA, errorHandler) == null) {
                            if (DataSourceStorage.this.myHash != 0L) {
                                DataSourceStorage.this.myLastSaveModificationCount--;
                            }
                            return;
                        }
                        DataSourceStorage.this.incModificationCount();
                        if (!formatChanged) {
                            DataSourceStorage.this.myLastSaveModificationCount = DataSourceStorage.this.getModificationCount();
                        }
                    }
                    catch (ProcessCanceledException e) {
                        DataSourceStorage.this.myLastSaveModificationCount = DataSourceStorage.this.getModificationCount();
                        return;
                    }
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (DataSource dataSource : DataSourceStorage.this.myDataSources) {
                            if (dataSource.getModel() != DasUtil.loadingModel()) continue;
                            dataSource.updateState(DasUtil.emptyModel());
                        }
                        ((DataSourceListener)DataSourceStorage.this.myDispatcher.getMulticaster()).dataSourceChanged(null);
                        String summary = errorHandler.getSummary();
                        if (StringUtil.isNotEmpty((String)summary)) {
                            String title = (project == null ? "Global" : "Project") + " Data Sources: re-sync required";
                            Notification notification = new Notification("System Messages", title, summary, NotificationType.ERROR);
                            notification.notify(project);
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeState(Project project, Element element) {
        if (project != null && project.isDefault()) {
            return;
        }
        String storagePath = DataSourceStorage.getStoragePath(project);
        if (storagePath != null && this.myLastSaveModificationCount != this.getModificationCount() && ApplicationManager.getApplication().isDispatchThread()) {
            boolean readOnly;
            VirtualFile virtualFile = project == null ? null : VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)storagePath));
            boolean bl = readOnly = virtualFile != null && ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles();
            if (!readOnly) {
                Object object = this.myIOLock;
                synchronized (object) {
                    if (this.myLastSaveModificationCount != this.getModificationCount() && this.writeToDisk(project, storagePath, DataSource.SaveMode.SCHEMA)) {
                        this.myLastSaveModificationCount = this.getModificationCount();
                    }
                }
            }
        }
        this.writeStateInner(project, element);
    }

    public Element getStateInner(@Nullable Project project) {
        Element element = new Element(COMPONENT_NAME);
        this.writeStateInner(project, element);
        return element;
    }

    private void writeStateInner(Project project, Element element) {
        if (!this.myDataSources.isEmpty() || this.myFormat != Format.XML) {
            element.setAttribute(FORMAT_ATTR_NAME, this.myFormat.name().toLowerCase(Locale.ENGLISH));
        }
        if (!this.myDataSources.isEmpty()) {
            if (project != null) {
                boolean skip;
                VirtualFile baseDir = project.getBaseDir();
                VirtualFile idsFile = baseDir == null ? null : baseDir.findFileByRelativePath(".idea/dataSources.xml");
                boolean bl = skip = idsFile != null && ChangeListManager.getInstance((Project)project).isIgnoredFile(idsFile);
                if (!skip) {
                    element.setAttribute(HASH_ATTR_NAME, String.valueOf(this.myHash));
                }
            }
            JDomWriter serializer = new JDomWriter(element);
            for (DataSource dataSource : this.myDataSources) {
                dataSource.serialize(project, (HierarchicalStreamWriter)serializer, DataSource.SaveMode.CONFIG);
            }
        }
        this.writeLocalState(project);
    }

    @Nullable
    private static DataSource createExtDataSource(Project project, String sourceName, String name) {
        for (DataSourceProviderFactory factory : (DataSourceProviderFactory[])Extensions.getExtensions((ExtensionPointName)DataSourceProviderFactory.EP_NAME)) {
            DataSource dataSource;
            DataSourceProvider dataSourceProvider = factory.getDataSourceProvider(name);
            if (dataSourceProvider == null || (dataSource = dataSourceProvider.createNewDataInstance(project, sourceName)) == null) continue;
            return dataSource;
        }
        return null;
    }

    public List<DataSource> getDataSources() {
        return this.getDataSources(new ArrayList());
    }

    public <T extends Collection<DataSource>> T getDataSources(T result) {
        result.addAll(this.myDataSources);
        if (this.myParentStorage != null) {
            this.myParentStorage.getDataSources(result);
        }
        return result;
    }

    public void addDataSource(DataSource dataSource) {
        DataSource existing;
        DataSource dataSource2 = existing = dataSource.getUniqueId() == null ? null : this.getDataSourceById(dataSource.getUniqueId());
        if (existing != null) {
            LOG.error(String.format("Unable to add %s datasource '%s' (%s@%d): '%s' (%s@%d) has the same id: %s", this.myParentStorage == null ? "global" : "project", dataSource.getName(), dataSource.getClass().getSimpleName(), dataSource.hashCode(), existing.getName(), existing.getClass().getSimpleName(), existing.hashCode(), dataSource.getUniqueId()));
        }
        if (dataSource.isGlobal() && this.myParentStorage != null) {
            this.myParentStorage.addDataSource(dataSource);
        } else {
            dataSource.init();
            this.myDataSources.add(dataSource);
            this.incModificationCount();
            ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceAdded(dataSource);
        }
    }

    @Nullable
    public DataSource getDataSourceByName(String name) {
        for (DataSource dataSource : this.getDataSources()) {
            LOG.assertTrue(dataSource.getName() != null);
            if (!dataSource.getName().equalsIgnoreCase(name)) continue;
            return dataSource;
        }
        return null;
    }

    @Nullable
    public DataSource getDataSourceById(String id) {
        return DataSourceStorage.getDataSourcesByIdInner(id, this.getDataSources());
    }

    private static DataSource getDataSourcesByIdInner(String id, List<DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            LOG.assertTrue(dataSource.getUniqueId() != null);
            if (!dataSource.getUniqueId().equals(id)) continue;
            return dataSource;
        }
        return null;
    }

    public void removeDataSource(DataSource dataSource) {
        if (this.myDataSources.remove(dataSource)) {
            this.incModificationCount();
            ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceRemoved(dataSource);
        } else if (this.myParentStorage != null) {
            this.myParentStorage.removeDataSource(dataSource);
        }
    }

    public void addDataSourceListener(DataSourceListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addDataSourceListener(DataSourceListener listener, Disposable parent) {
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public void removeDataSourceListener(DataSourceListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void updateDataSource(DataSource dataSource) {
        boolean isMy = this.myDataSources.contains(dataSource);
        if (this.myParentStorage != null && dataSource.isGlobal() == isMy) {
            this.removeDataSource(dataSource);
            this.addDataSource(dataSource);
        } else if (isMy) {
            this.incModificationCount();
            ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceChanged(dataSource);
        } else if (this.myParentStorage != null) {
            this.myParentStorage.updateDataSource(dataSource);
        }
        dataSource.incModificationCount();
    }

    public long getModificationCount() {
        if (this.myParentStorage != null) {
            return super.getModificationCount() + this.myParentStorage.getModificationCount();
        }
        return super.getModificationCount();
    }

    public void dispose() {
    }

    private List<DataSource> readDataSources(Project project, HierarchicalStreamReader xmlReader, DataSource.SaveMode mode) {
        ArrayList<DataSource> result = new ArrayList<DataSource>();
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String source = (String)ObjectUtils.chooseNotNull((Object)xmlReader.getAttribute(DATA_SOURCE_SOURCE_NAME), (Object)xmlReader.getAttribute("source"));
            if ("data-source".equals(xmlReader.getNodeName())) {
                Object dataSource;
                DataSource existingDataSource;
                String uuid = xmlReader.getAttribute("uuid");
                DataSource dataSource2 = existingDataSource = uuid == null ? null : DataSourceStorage.getDataSourcesByIdInner(uuid, this.myDataSources);
                if ((existingDataSource != null || mode.includeConfig()) && (dataSource = existingDataSource != null ? existingDataSource : (source == null || "LOCAL".equals(source) ? new LocalDataSource() : DataSourceStorage.createExtDataSource(project, source, source))) != null) {
                    LocalDataSource o;
                    dataSource.deserialize(project, xmlReader, mode);
                    dataSource.setGlobal(this.myParentStorage == null);
                    dataSource.init();
                    if (dataSource != existingDataSource && dataSource instanceof LocalDataSource && ((o = (LocalDataSource)((Object)dataSource)).getDatabaseDriver() == null || !o.getOwnClasspath().isEmpty())) {
                        o.ensureDriverConfigured();
                    }
                    if (existingDataSource != dataSource) {
                        result.add((DataSource)dataSource);
                    }
                }
            }
            xmlReader.moveUp();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToDisk(@Nullable Project project, @NotNull String storagePath, DataSource.SaveMode mode) {
        if (storagePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storagePath", "com/intellij/database/dataSource/DataSourceStorage", "writeToDisk"));
        }
        this.myHash = 0L;
        File original = new File(PathUtil.toPresentableUrl((String)storagePath));
        if (this.myDataSources.isEmpty()) {
            if (original.exists()) {
                original.delete();
            }
            return true;
        }
        if (!original.exists()) {
            original.getParentFile().mkdirs();
        }
        Object serializer = null;
        String errorMessage = null;
        MyStream safeStream = null;
        try {
            Object os;
            safeStream = new MyStream(original);
            boolean compressed = this.myFormat == Format.COMPRESSED_XML || this.myFormat == Format.COMPRESSED_JSON;
            boolean isXml = this.myFormat == Format.XML || this.myFormat == Format.COMPRESSED_XML;
            Object object = os = compressed ? new ZipOutputStream((OutputStream)((Object)safeStream)) : safeStream;
            if (os instanceof ZipOutputStream) {
                ((ZipOutputStream)os).putNextEntry(new ZipEntry(STORAGE_ENTRY_NAME + (isXml ? ".xml" : ".json")));
            }
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
            if (isXml) {
                serializer = new PrettyPrintWriter((Writer)printWriter);
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            } else {
                serializer = new JsonWriter(printWriter, new JsonWriter.Format(new char[]{' '}, new char[]{'\n'}, 2)){

                    protected void addValue(String value, AbstractJsonWriter.Type type) {
                        super.addValue(value, AbstractJsonWriter.Type.STRING);
                    }
                };
            }
            serializer.startNode("component");
            serializer.addAttribute("name", COMPONENT_NAME);
            for (DataSource dataSource : this.myDataSources) {
                dataSource.serialize(project, (HierarchicalStreamWriter)serializer, mode);
            }
            serializer.endNode();
            serializer.close();
        }
        catch (XStreamException e) {
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        finally {
            if (serializer != null) {
                try {
                    serializer.close();
                }
                catch (Exception e) {
                    errorMessage = e.getMessage();
                }
            }
        }
        if (errorMessage != null) {
            LOG.warn(errorMessage);
            DataSourceUiUtil.showNotification(project, "", "Failed to save data sources:<br>" + errorMessage, true);
            return false;
        }
        this.myHash = safeStream.getHash();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public List<DataSource> loadFromDisk(Project project, String storagePath, DataSource.SaveMode mode, @Nullable ErrorHandler errorHandler) {
        File file = storagePath == null ? null : new File(PathUtil.toPresentableUrl((String)storagePath));
        if (file == null) return null;
        if (!file.exists()) return null;
        if (file.isDirectory()) {
            return null;
        }
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            boolean isReallyZip = false;
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                InputStreamReader streamReader = new InputStreamReader((InputStream)zis, "UTF-8");
                if (Comparing.equal((String)zipEntry.getName(), (String)STATE_FILE)) {
                    List<DataSource> list = this.loadDataSources(project, (HierarchicalStreamReader)new XppReader((Reader)streamReader), mode, errorHandler);
                    return list;
                }
                if (Comparing.equal((String)zipEntry.getName(), (String)"dataSources.json")) {
                    List<DataSource> list = this.loadDataSources(project, new JettisonMappedXmlDriver().createReader((Reader)streamReader), mode, errorHandler);
                    return list;
                }
                isReallyZip = true;
                zipEntry = zis.getNextEntry();
            }
            if (isReallyZip) {
                LOG.warn("No datasource entries found in: " + file);
                return null;
            }
            boolean isXml = true;
            InputStreamReader formatPicker = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try {
                isXml = StringUtil.isNotEmpty((String)NanoXmlUtil.parseHeader((Reader)formatPicker).getRootTagLocalName());
            }
            finally {
                ((Reader)formatPicker).close();
            }
            InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            if (isXml) {
                List<DataSource> list = this.loadDataSources(project, (HierarchicalStreamReader)new XppReader((Reader)fileReader), mode, errorHandler);
                return list;
            }
            List<DataSource> list = this.loadDataSources(project, new JettisonMappedXmlDriver().createReader((Reader)fileReader), mode, errorHandler);
            return list;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e2) {
            RuntimeException e2;
            String message = e2.getMessage();
            if (message != null && message.length() > 1024) {
                RuntimeException truncated = new RuntimeException(message.substring(0, 1024) + "...");
                truncated.setStackTrace(e2.getStackTrace());
                e2 = truncated;
            }
            LOG.warn((Throwable)e2);
            DataSourceStorage.backupCorruptedVersion(file);
            return null;
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void backupCorruptedVersion(File file) {
        if (file.exists()) {
            try {
                String backupName = FileUtil.getNameWithoutExtension((File)file) + ".corrupted." + new SimpleDateFormat("yyyyMMdd-hhmmss").format(new Date(System.currentTimeMillis())) + "." + FileUtilRt.getExtension((String)file.getName());
                File backup = new File(file.getParentFile(), backupName);
                FileUtil.copy((File)file, (File)backup);
                String message = file.getAbsolutePath() + " is corrupted. Backup copy " + backup.getName() + " is created.";
                Notification notification = new Notification("System Messages", "Failed to load data sources", message, NotificationType.ERROR);
                Notifications.Bus.notify((Notification)notification);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSource> loadDataSources(Project project, HierarchicalStreamReader reader, DataSource.SaveMode mode, final ErrorHandler errorHandler) {
        MyReader wrapper = new MyReader(reader){

            public void appendErrors(ErrorWriter errorWriter) {
                super.appendErrors(errorWriter);
                if (errorHandler != null && errorWriter instanceof ConversionException) {
                    errorHandler.addError(((ConversionException)errorWriter).getShortMessage(), null);
                }
            }
        };
        try {
            if ("component".equals(reader.getNodeName())) {
                List<DataSource> list = this.readDataSources(project, (HierarchicalStreamReader)wrapper, mode);
                return list;
            }
            List<DataSource> list = Collections.emptyList();
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static class MyReader
    extends ReaderWrapper {
        public MyReader(HierarchicalStreamReader reader) {
            super(reader);
        }

        public String getNodeName() {
            return DbUtil.intern2((String)super.getNodeName());
        }

        public String getValue() {
            return DbUtil.intern2((String)super.getValue());
        }

        public String getAttribute(String name) {
            return DbUtil.intern2((String)super.getAttribute(name));
        }

        public String getAttribute(int index) {
            return DbUtil.intern2((String)super.getAttribute(index));
        }
    }

    private static class MyStream
    extends SafeFileOutputStream {
        private final CRC32 myCrc = new CRC32();

        public MyStream(File original) throws FileNotFoundException {
            super(original);
        }

        public void write(byte[] b) throws IOException {
            super.write(b);
            this.myCrc.update(b);
        }

        public void write(int b) throws IOException {
            super.write(b);
            this.myCrc.update(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.myCrc.update(b, off, len);
        }

        public long getHash() {
            return this.myCrc.getValue();
        }
    }

    @State(name="dataSourceStorage", storages={@Storage(file="$APP_CONFIG$/dataSources.xml", roamingType=RoamingType.DISABLED)})
    public static class App
    extends DataSourceStorage
    implements PersistentStateComponent<Element>,
    ExportableComponent {
        public App(VirtualFileManager fileManager, LibraryTablesRegistrar libraryTablesRegistrar) {
            super(null);
        }

        @NotNull
        public File[] getExportFiles() {
            File[] fileArray = new File[]{PathManager.getOptionsFile((String)DataSourceStorage.STORAGE_ENTRY_NAME)};
            if (fileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceStorage$App", "getExportFiles"));
            }
            return fileArray;
        }

        @NotNull
        public String getPresentableName() {
            if ("Database: global data sources" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceStorage$App", "getPresentableName"));
            }
            return "Database: global data sources";
        }
    }

    private static enum Format {
        XML,
        JSON,
        COMPRESSED_XML,
        COMPRESSED_JSON;

    }
}

