/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DataSourceStorageLocal {
    private static final String STATE_FILE_PATH = "/dataSources.local.xml";
    public static final String COMPONENT_NAME = "dataSourceStorageLocal";
    private Element myState;

    public static DataSourceStorageLocal getGlobalInstance() {
        return (DataSourceStorageLocal)ServiceManager.getService(App.class);
    }

    public static DataSourceStorageLocal getProjectInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceStorageLocal", "getProjectInstance"));
        }
        return (DataSourceStorageLocal)ServiceManager.getService((Project)project, Prj.class);
    }

    public static DataSourceStorageLocal getInstance(Project project) {
        return project == null ? DataSourceStorageLocal.getGlobalInstance() : DataSourceStorageLocal.getProjectInstance(project);
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DataSourceStorageLocal", "loadState"));
        }
        this.myState = state;
    }

    public Element getState() {
        return this.myState;
    }

    @State(name="dataSourceStorageLocal", storages={@Storage(file="$PROJECT_FILE$", roamingType=RoamingType.DISABLED), @Storage(file="$PROJECT_CONFIG_DIR$/dataSources.local.xml", scheme=StorageScheme.DIRECTORY_BASED, roamingType=RoamingType.DISABLED)})
    public static class Prj
    extends DataSourceStorageLocal
    implements PersistentStateComponent<Element> {
        public Prj(Project project, ChangeListManager manager) {
            manager.addFilesToIgnore(new IgnoredFileBean[]{IgnoredBeanFactory.ignoreFile((String)".idea/dataSources.local.xml", (Project)project)});
        }
    }

    @State(name="dataSourceStorageLocal", storages={@Storage(file="$APP_CONFIG$/dataSources.local.xml", roamingType=RoamingType.DISABLED)})
    public static class App
    extends DataSourceStorageLocal
    implements PersistentStateComponent<Element> {
    }
}

