/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseModelLegacyLoader;
import com.intellij.database.dataSource.DatabaseModelModernLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Objects;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.InSessionNoResult;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.util.Version;

public class DatabaseModelLoader {
    static final Map<String, Version> SUPPORTED_VERSIONS = ImmutableMap.of((Object)Postgres.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Oracle.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Mssql.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Sybase.RDBMS.code, (Object)Version.of((int[])new int[]{15}), (Object)Mysql.RDBMS.code, (Object)Version.of((int[])new int[]{5, 1}));
    static final Version UNATTAINABLE_FUTURE = Version.of((int[])new int[]{Integer.MAX_VALUE});

    static void performIntrospection(@NotNull LoaderContext context, @NotNull DasModel model, @NotNull Connection connection, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator progressIndicator) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        Rdbms rdbms = DataSourceUiUtil.getRdbmsForIntrospection(context.getFamilyId());
        boolean forceLegacyIntro = DatabaseModelLoader.whetherForcedLegacy(context);
        if (rdbms != null && !forceLegacyIntro) {
            DatabaseModelLoader.performKnownIntrospection(model, rdbms, connection, context, metaData, progressIndicator);
        } else {
            DatabaseModelLoader.performLegacyIntrospection(model, connection, context, metaData, progressIndicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performKnownIntrospection(@NotNull DasModel model, @NotNull Rdbms rdbms, @NotNull Connection connection, @NotNull LoaderContext context, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator progressIndicator) {
        PrimeIntermediateFacade remoteFacade;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemote((Object)connection, RemoteConnection.class);
        assert (remoteConnection != null);
        try {
            RemoteFacade jpdaFacade = remoteConnection.jpdaFacade(rdbms.code);
            remoteFacade = (PrimeIntermediateFacade)RemoteUtil.castToLocal((Object)jpdaFacade, PrimeIntermediateFacade.class);
            assert (remoteFacade != null);
            assert (remoteFacade.rdbms().code.equals(rdbms.code));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        AdaptIntermediateFacade intermediateFacade = null;
        try {
            intermediateFacade = new AdaptIntermediateFacade(remoteFacade);
            BaseFacade facade = new BaseFacade((IntegralIntermediateFacade)intermediateFacade);
            try {
                facade.connect();
                DatabaseModelLoader.performKnownIntrospection(model, (DBFacade)facade, context, metaData, progressIndicator);
            }
            catch (Exception e) {
                context.getErrorHandler().addError(e.getMessage(), (Throwable)e);
            }
            finally {
                facade.disconnect();
            }
        }
        finally {
            if (intermediateFacade != null) {
                intermediateFacade.disconnect();
            }
            remoteFacade.disconnect();
        }
    }

    static void performKnownIntrospection(final @NotNull DasModel model, @NotNull DBFacade facade, final @NotNull LoaderContext context, final @NotNull DatabaseMetaData metaData, final @NotNull ProgressIndicator progressIndicator) {
        boolean modern;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performKnownIntrospection"));
        }
        Version serverVersion = facade.getConnectionInfo().serverVersion;
        Version supportedVersion = Objects.notNull(SUPPORTED_VERSIONS.get(facade.rdbms().code), UNATTAINABLE_FUTURE);
        boolean bl = modern = serverVersion.compareTo(supportedVersion) >= 0;
        if (modern) {
            DatabaseModelLoader.performModernIntrospection(model, facade, context, progressIndicator);
        } else {
            facade.inSession(new InSessionNoResult(){

                public void run(@NotNull DBSession session) {
                    if (session == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/dataSource/DatabaseModelLoader$1", "run"));
                    }
                    Connection connection = (Connection)session.getSpecificService(Connection.class, "jdbc-connection");
                    assert (connection != null) : "Failed to obtain connection";
                    DatabaseModelLoader.performLegacyIntrospection(model, connection, context, metaData, progressIndicator);
                }
            });
        }
    }

    protected static void performModernIntrospection(@NotNull DasModel model, @NotNull DBFacade facade, @NotNull LoaderContext context, @NotNull ProgressIndicator progressIndicator) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performModernIntrospection"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/dataSource/DatabaseModelLoader", "performModernIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performModernIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performModernIntrospection"));
        }
        DatabaseModelModernLoader.performModernIntrospection(facade, context, model, progressIndicator, true);
    }

    private static void performLegacyIntrospection(@NotNull DasModel model, @NotNull Connection connection, @NotNull LoaderContext context, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator progressIndicator) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performLegacyIntrospection"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "performLegacyIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performLegacyIntrospection"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLoader", "performLegacyIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performLegacyIntrospection"));
        }
        String currentCatalogName = null;
        try {
            currentCatalogName = DatabaseModelLoader.getCatalogName(connection);
            DatabaseModelLegacyLoader.loadInner(context, model, connection, metaData, progressIndicator);
        }
        catch (SQLException sqle) {
            throw new LegacyIntrospectionException(sqle);
        }
        finally {
            JdbcUtil.setCatalogSafe((Connection)connection, (String)currentCatalogName);
        }
    }

    private static boolean whetherForcedLegacy(@NotNull LoaderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "whetherForcedLegacy"));
        }
        DataSource dataSource = context.getDataSource();
        return dataSource instanceof LocalDataSource && ((LocalDataSource)dataSource).useLegacyIntrospector();
    }

    private static String getCatalogName(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "getCatalogName"));
        }
        return connection.getCatalog();
    }

    public static class LegacyIntrospectionException
    extends RuntimeException {
        public LegacyIntrospectionException(@NotNull Throwable cause) {
            if (cause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/intellij/database/dataSource/DatabaseModelLoader$LegacyIntrospectionException", "<init>"));
            }
            super(cause.getMessage(), cause);
        }
    }
}

