/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DatabaseModelLegacyLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.util.LoaderContext;
import com.intellij.dbm.common.DBIntrospector;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmModelListener;
import com.intellij.dbm.common.DbmMultiDatabaseModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleDatabaseModel;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionOptions;
import com.intellij.dbm.factories.RdbmsServiceFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;

class DatabaseModelModernLoader {
    @NotNull
    static final RdbmsServiceFactory ourServiceFactory = RdbmsServiceFactory.instance();
    private static final boolean WITH_SOURCES = false;
    private static final boolean WITH_DEPENDENCIES = false;
    private static final Logger LOG = Logger.getInstance(DatabaseModelModernLoader.class);

    DatabaseModelModernLoader() {
    }

    static void performModernIntrospection(@NotNull DBFacade facade, @NotNull LoaderContext context, @NotNull DasModel dasModel, @NotNull ProgressIndicator indicator, boolean ignoreContext) {
        boolean incremental;
        DbmModel model;
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (dasModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasModel", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        DBIntrospector introspector = ourServiceFactory.createIntrospector(facade);
        if (dasModel instanceof DbmModel) {
            indicator.setText("Preparing to incremental introspection (" + facade.rdbms().code + ")");
            model = (DbmModel)dasModel;
            introspector.init(model);
            incremental = true;
        } else {
            indicator.setText("Preparing to complete introspection (" + facade.rdbms().code + ")");
            introspector.init(null);
            model = introspector.getModel();
            incremental = false;
        }
        MultiMap<String, String> scope = DatabaseModelModernLoader.extractSchemaNamesToIntrospect(context, ignoreContext);
        IntrospectionOptions options = IntrospectionOptions.of(scope, incremental, false, false);
        introspector.setOptions(options);
        introspector.setProgressIndicator(indicator);
        UIUpdater uiUpdater = new UIUpdater(model, context);
        try {
            model.addListener(uiUpdater);
            introspector.introspect();
            if (!ignoreContext) {
                DatabaseModelModernLoader.forgetExcludedDatabaseAndOrSchemas(model, scope);
            }
        }
        catch (RuntimeException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            model.removeListener(uiUpdater);
        }
        indicator.setText("Finishing introspection (" + facade.rdbms().code + ")");
        DatabaseModelModernLoader.updateUI(model, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forgetExcludedDatabaseAndOrSchemas(@NotNull DbmModel model, @NotNull MultiMap<String, String> scope) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelModernLoader", "forgetExcludedDatabaseAndOrSchemas"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelModernLoader", "forgetExcludedDatabaseAndOrSchemas"));
        }
        model.startModifications();
        try {
            if (model instanceof DbmMultiDatabaseModel) {
                DbmMultiDatabaseModel multiDatabaseModel = (DbmMultiDatabaseModel)model;
                DatabaseModelModernLoader.forgetExcludedDatabasesAndSchemas(multiDatabaseModel, scope);
            } else if (model instanceof DbmSingleDatabaseModel) {
                TreeSet<String> schemaNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                schemaNames.addAll(scope.values());
                DbmSingleDatabaseModel singleDatabaseModel = (DbmSingleDatabaseModel)model;
                DatabaseModelModernLoader.forgetExcludedNamespaces(singleDatabaseModel.schemas(), schemaNames);
            }
        }
        finally {
            model.finishModifications();
        }
    }

    private static void forgetExcludedDatabasesAndSchemas(@NotNull DbmMultiDatabaseModel<? extends DbmDatabase, ?> model, @NotNull MultiMap<String, String> scope) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelModernLoader", "forgetExcludedDatabasesAndSchemas"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelModernLoader", "forgetExcludedDatabasesAndSchemas"));
        }
        TreeSet<String> retainDatabaseNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        retainDatabaseNames.addAll(scope.keySet());
        Family<DbmDatabase> databases = model.databases();
        DatabaseModelModernLoader.forgetExcludedNamespaces(databases, retainDatabaseNames);
        for (DbmDatabase dbmDatabase : databases) {
            TreeSet<String> retainSchemaNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            retainSchemaNames.addAll(scope.get((Object)dbmDatabase.getName()));
            Family<? extends DbmSchema> schemas = dbmDatabase.schemas();
            DatabaseModelModernLoader.forgetExcludedNamespaces(schemas, retainSchemaNames);
        }
    }

    private static <N extends DbmNamespace> void forgetExcludedNamespaces(@NotNull Family<N> family, @NotNull Set<String> retainedNames) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/database/dataSource/DatabaseModelModernLoader", "forgetExcludedNamespaces"));
        }
        if (retainedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "retainedNames", "com/intellij/database/dataSource/DatabaseModelModernLoader", "forgetExcludedNamespaces"));
        }
        if (retainedNames.contains("*")) {
            return;
        }
        boolean currentIsIncluded = retainedNames.contains("@") || retainedNames.isEmpty();
        SmartList namespacesToForget = new SmartList();
        for (DbmNamespace namespace : family) {
            if (currentIsIncluded && namespace.isCurrent() || retainedNames.contains(namespace.getNameOrEmpty())) continue;
            namespacesToForget.add(namespace);
        }
        for (DbmNamespace namespaceToForget : namespacesToForget) {
            namespaceToForget.drop();
        }
    }

    @NotNull
    private static MultiMap<String, String> extractSchemaNamesToIntrospect(@NotNull LoaderContext context, boolean ignoreContext) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "extractSchemaNamesToIntrospect"));
        }
        LocalDataSource ds = DatabaseModelModernLoader.getLocalDataSource(context);
        MultiMap map = MultiMap.createSmart();
        if (ds != null) {
            String[] schemaPairs;
            String schemaPattern = ds.getSchemaPattern();
            if (schemaPattern == null || schemaPattern.isEmpty()) {
                MultiMap<String, String> multiMap = DatabaseModelModernLoader.currentSchema();
                if (multiMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "extractSchemaNamesToIntrospect"));
                }
                return multiMap;
            }
            for (String pair : schemaPairs = DatabaseModelLegacyLoader.splitSchemaPattern(schemaPattern)) {
                String schemaName;
                String dbName;
                if (pair == null || (pair = pair.trim()).length() == 0) continue;
                if (pair.equals("*") || pair.equals("@")) {
                    dbName = "*";
                    schemaName = pair;
                } else {
                    List split = StringUtil.split((String)pair, (String)".");
                    if (split.size() >= 2) {
                        dbName = (String)split.get(0);
                        schemaName = (String)split.get(1);
                    } else {
                        schemaName = null;
                        dbName = null;
                    }
                }
                if (!ignoreContext && !context.load(dbName, schemaName)) continue;
                map.putValue((Object)dbName, (Object)schemaName);
            }
        } else {
            MultiMap<String, String> multiMap = DatabaseModelModernLoader.currentSchema();
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "extractSchemaNamesToIntrospect"));
            }
            return multiMap;
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "extractSchemaNamesToIntrospect"));
        }
        return multiMap;
    }

    @NotNull
    private static MultiMap<String, String> currentSchema() {
        MultiMap map = MultiMap.createSmart();
        map.putValue((Object)"@", (Object)"@");
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "currentSchema"));
        }
        return multiMap;
    }

    @Nullable
    private static LocalDataSource getLocalDataSource(@NotNull LoaderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getLocalDataSource"));
        }
        DataSource dataSource = context.getDataSource();
        return dataSource instanceof LocalDataSource ? (LocalDataSource)dataSource : null;
    }

    private static void updateUI(@NotNull DbmModel model, @NotNull LoaderContext context) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelModernLoader", "updateUI"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "updateUI"));
        }
        DatabaseModelLegacyLoader.updateUI(context, model, null);
    }

    private static class UIUpdater
    implements DbmModelListener {
        private final DbmModel myModel;
        private final LoaderContext myContext;
        private long last;

        UIUpdater(@NotNull DbmModel model, @NotNull LoaderContext context) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelModernLoader$UIUpdater", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader$UIUpdater", "<init>"));
            }
            this.last = 0L;
            this.myModel = model;
            this.myContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modified(Set<DbmObject> created, Set<DbmObject> modified, Set<DbmObject> removed) {
            if (System.currentTimeMillis() - this.last >= 1000L) {
                try {
                    DatabaseModelModernLoader.updateUI(this.myModel, this.myContext);
                }
                finally {
                    this.last = System.currentTimeMillis();
                }
            }
        }
    }
}

