/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DatabaseModelLegacyLoader;
import com.intellij.database.dataSource.DatabaseSchema;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.LoaderContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultsInstaller {
    public static final String NULL_SCHEMA = "*";
    private final Set<String> mySelectedSchemas;
    private final Set<String> myDefaultSchemas;
    private final OrderedSet<String> myAllSchemas;
    private final List<String> myRows;
    private final LocalDataSource myDataSource;

    public DefaultsInstaller(@NotNull LocalDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dataSource/DefaultsInstaller", "<init>"));
        }
        this(source, (OrderedSet<String>)new OrderedSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE), (Set<String>)ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE), (Set<String>)ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
    }

    public DefaultsInstaller(@NotNull LocalDataSource source, @NotNull OrderedSet<String> allSchemas, @NotNull Set<String> defaultSchemas, @NotNull Set<String> selectedSchemas) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dataSource/DefaultsInstaller", "<init>"));
        }
        if (allSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allSchemas", "com/intellij/database/dataSource/DefaultsInstaller", "<init>"));
        }
        if (defaultSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSchemas", "com/intellij/database/dataSource/DefaultsInstaller", "<init>"));
        }
        if (selectedSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedSchemas", "com/intellij/database/dataSource/DefaultsInstaller", "<init>"));
        }
        this.myRows = ContainerUtil.newArrayList();
        this.myDataSource = source;
        this.myAllSchemas = allSchemas;
        this.myDefaultSchemas = defaultSchemas;
        this.mySelectedSchemas = selectedSchemas;
    }

    @NotNull
    public DefaultsInstaller loadSchemaNames(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DefaultsInstaller", "loadSchemaNames"));
        }
        THashSet set = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        DatabaseMetaData metaData = connection.getMetaData();
        this.myDataSource.refreshDatabaseInfo(metaData);
        TreeSet<DatabaseSchema> databaseSchemas = DatabaseModelLegacyLoader.retrieveSessionAvailableDatabasesAndSchemas(connection, metaData, LoaderContext.loadAll((DataSource)this.myDataSource));
        for (DatabaseSchema pair : databaseSchemas) {
            set.add(LoaderContext.getPattern((String)pair.getCatalog(), null));
            set.add(LoaderContext.getPattern((String)pair.getCatalog(), (String)pair.getName()));
        }
        this.myRows.addAll((Collection<String>)set);
        set.add(NULL_SCHEMA);
        Collections.sort(this.myRows);
        DefaultsInstaller defaultsInstaller = this;
        if (defaultsInstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "loadSchemaNames"));
        }
        return defaultsInstaller;
    }

    @NotNull
    public DefaultsInstaller setupDefaults(@NotNull Connection connection, @Nullable String userName) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DefaultsInstaller", "setupDefaults"));
        }
        this.myAllSchemas.clear();
        this.myAllSchemas.addAll(this.myRows);
        this.fixMissingCatalogName();
        this.setupDefaultSchemas(connection, userName);
        DefaultsInstaller defaultsInstaller = this;
        if (defaultsInstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "setupDefaults"));
        }
        return defaultsInstaller;
    }

    @NotNull
    public DefaultsInstaller saveSchemas() {
        this.myDataSource.setSchemaPattern(StringUtil.nullize((String)DatabaseModelLegacyLoader.joinSchemaPattern(this.removeUnnecessaryOnes(this.getSelectedSchemas(), true))));
        this.myDataSource.setDefaultSchemas(StringUtil.nullize((String)DatabaseModelLegacyLoader.joinSchemaPattern(this.removeUnnecessaryOnes(this.getDefaultSchemas(), false))));
        DefaultsInstaller defaultsInstaller = this;
        if (defaultsInstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "saveSchemas"));
        }
        return defaultsInstaller;
    }

    public static boolean isPresent(@NotNull Collection<String> alreadySelected, @NotNull String catalogSchema) {
        if (alreadySelected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadySelected", "com/intellij/database/dataSource/DefaultsInstaller", "isPresent"));
        }
        if (catalogSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catalogSchema", "com/intellij/database/dataSource/DefaultsInstaller", "isPresent"));
        }
        if (alreadySelected.contains(catalogSchema) || alreadySelected.contains(NULL_SCHEMA)) {
            return true;
        }
        for (String s : alreadySelected) {
            String prefix = s.endsWith(".*") ? s.substring(0, s.length() - 1) : null;
            if (prefix == null || !StringUtil.startsWithIgnoreCase((String)catalogSchema, (String)prefix)) continue;
            return true;
        }
        return false;
    }

    private void fixMissingCatalogName() {
        for (String s : this.myAllSchemas) {
            int dotIndex = s.indexOf(46);
            String nullizeCatalog = dotIndex > 0 ? NULL_SCHEMA + s.substring(dotIndex) : null;
            if (nullizeCatalog == null || !this.getSelectedSchemas().remove(nullizeCatalog)) continue;
            this.getSelectedSchemas().add(s);
        }
    }

    private void setupDefaultSchemas(@NotNull Connection connection, @Nullable String userName) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DefaultsInstaller", "setupDefaultSchemas"));
        }
        if (this.mySelectedSchemas.isEmpty() && this.myDefaultSchemas.isEmpty()) {
            if (this.myDataSource.getFamilyId() == DatabaseFamilyId.ORACLE) {
                String[] userAndSchema = DatabaseModelLegacyLoader.getOracleCurrentUserAndSchema(connection);
                this.mySelectedSchemas.clear();
                this.mySelectedSchemas.addAll(DefaultsInstaller.prefixWithAsterisks(userAndSchema));
                this.mySelectedSchemas.addAll(DefaultsInstaller.prefixWithAsterisks("PUBLIC", "SYS", "SYSTEM"));
                this.mySelectedSchemas.retainAll((Collection<?>)this.myAllSchemas);
                this.myDefaultSchemas.clear();
                this.myDefaultSchemas.addAll(DefaultsInstaller.prefixWithAsterisks(userAndSchema));
                this.myDefaultSchemas.addAll(DefaultsInstaller.prefixWithAsterisks("PUBLIC"));
                this.myDefaultSchemas.retainAll((Collection<?>)this.myAllSchemas);
            } else {
                String currentCatalog = connection.getCatalog();
                Collection<String> toIntrospect = this.getDefaultSchemasToIntrospect(currentCatalog, userName);
                Set<String> toResolve = this.getDefaultSchemasToResolve(currentCatalog, userName);
                for (String s : toIntrospect) {
                    int idx = this.myAllSchemas.indexOf((Object)s);
                    if (idx == -1) continue;
                    String schema = (String)this.myAllSchemas.get(idx);
                    this.mySelectedSchemas.add(schema);
                    if (!toResolve.contains(schema)) continue;
                    this.myDefaultSchemas.add(schema);
                }
            }
        }
    }

    @NotNull
    private static List<String> prefixWithAsterisks(String ... schemaNames) {
        ArrayList<String> result = new ArrayList<String>(schemaNames.length);
        for (String name : schemaNames) {
            result.add("*." + name);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "prefixWithAsterisks"));
        }
        return arrayList;
    }

    @NotNull
    private List<String> removeUnnecessaryOnes(@NotNull Set<String> items, boolean allowAll) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/dataSource/DefaultsInstaller", "removeUnnecessaryOnes"));
        }
        ArrayList selected = ContainerUtil.newArrayList(items);
        if (!allowAll) {
            selected.remove(NULL_SCHEMA);
        }
        if (!this.myAllSchemas.isEmpty()) {
            selected.retainAll((Collection<?>)this.myAllSchemas);
        }
        Collections.sort(selected);
        int len = selected.size();
        for (int i = 1; i < len; ++i) {
            if (!DefaultsInstaller.isPresent(selected.subList(0, i), (String)selected.get(i))) continue;
            selected.remove(i);
            --len;
            --i;
        }
        ArrayList arrayList = selected;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "removeUnnecessaryOnes"));
        }
        return arrayList;
    }

    @NotNull
    private Collection<String> getDefaultSchemasToIntrospect(@Nullable String currentCatalog, @Nullable String userId) {
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
        ArrayList result = ContainerUtil.newArrayList();
        if (familyId.isOracle()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)userId));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"PUBLIC"));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"SYSTEM"));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"SYS"));
        } else if (familyId.isDb2()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)userId));
        } else if (familyId.isDerby()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)userId));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"app"));
        } else if (familyId.isTransactSql() || familyId.isMysql()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, null));
        } else if (familyId.isPostgres()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"public"));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"pg_catalog"));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)userId));
        } else if (familyId.isHsqldb() || familyId.isH2()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"public"));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getDefaultSchemasToIntrospect"));
        }
        return arrayList;
    }

    @NotNull
    private Set<String> getDefaultSchemasToResolve(@Nullable String currentCatalog, @Nullable String userId) {
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (familyId.isOracle()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)userId));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"PUBLIC"));
        } else if (familyId.isDb2()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)userId));
        } else if (familyId.isDerby()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)userId));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"app"));
        } else if (familyId.isTransactSql() || familyId.isMysql()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, null));
        } else if (familyId.isPostgres()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"public"));
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)userId));
        } else if (familyId.isHsqldb() || familyId.isH2()) {
            result.add(LoaderContext.getPattern((String)currentCatalog, (String)"public"));
        }
        TreeSet<String> treeSet = result;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getDefaultSchemasToResolve"));
        }
        return treeSet;
    }

    @NotNull
    public Set<String> getSelectedSchemas() {
        Set<String> set = this.mySelectedSchemas;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getSelectedSchemas"));
        }
        return set;
    }

    @NotNull
    public Set<String> getDefaultSchemas() {
        Set<String> set = this.myDefaultSchemas;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getDefaultSchemas"));
        }
        return set;
    }

    @NotNull
    public OrderedSet<String> getAllSchemas() {
        OrderedSet<String> orderedSet = this.myAllSchemas;
        if (orderedSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getAllSchemas"));
        }
        return orderedSet;
    }
}

