/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyPasswordField {
    private final JBPasswordField myComponent;
    private final Getter<String> myCredentials;
    private boolean myModified;

    public LazyPasswordField(@NotNull Getter<String> credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dataSource/LazyPasswordField", "<init>"));
        }
        this(new JBPasswordField(), credentials);
    }

    public LazyPasswordField(@NotNull JBPasswordField component, @NotNull Getter<String> credentials) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dataSource/LazyPasswordField", "<init>"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dataSource/LazyPasswordField", "<init>"));
        }
        this.myCredentials = credentials;
        this.myComponent = component;
        this.myComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                LazyPasswordField.this.setModified(true);
            }
        });
        this.setModified(false);
    }

    public JBPasswordField getComponent() {
        return this.myComponent;
    }

    private void setModified(boolean modified) {
        this.myModified = modified;
        this.myComponent.setPasswordIsStored(!modified);
    }

    @NotNull
    public String getPassword() {
        String opt = this.getPasswordOpt();
        String string = opt != null ? opt : StringUtil.notNullize((String)((String)this.myCredentials.get()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LazyPasswordField", "getPassword"));
        }
        return string;
    }

    @Nullable
    public String getPasswordOpt() {
        return this.isModified() ? new String(this.myComponent.getPassword()) : null;
    }

    public void reset() {
        this.myComponent.setText("");
        this.setModified(false);
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void setPassword(@Nullable String text) {
        if (Comparing.equal((String)this.getPasswordOpt(), (String)text)) {
            return;
        }
        if (text == null) {
            this.reset();
        } else {
            this.myComponent.setText(text);
        }
    }
}

