/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseModelLegacyLoader;
import com.intellij.database.dataSource.DatabaseObject;
import com.intellij.database.dataSource.DatabaseProcedure;
import com.intellij.database.dataSource.DatabaseSchema;
import com.intellij.database.dataSource.DatabaseTableData;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelSerializer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Base64;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import gnu.trove.THashMap;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacySerializer
implements ModelSerializer {
    public static final State EMPTY_STATE = new State(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);

    @NotNull
    public DasModel deserialize(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/LegacySerializer", "deserialize"));
        }
        ArrayList tables = ContainerUtil.newArrayList();
        ArrayList procedures = ContainerUtil.newArrayList();
        final LinkedHashMap schemaMap = ContainerUtil.newLinkedHashMap();
        PairFunction<String, String, DatabaseSchema> schemaCreator = new PairFunction<String, String, DatabaseSchema>(){

            public DatabaseSchema fun(String t, String v) {
                DatabaseSchema key = new DatabaseSchema(t, v);
                DatabaseSchema existing = (DatabaseSchema)schemaMap.get(key);
                if (existing != null) {
                    return existing;
                }
                schemaMap.put(key, key);
                return key;
            }
        };
        THashMap stateMap = ContainerUtil.newTroveMap();
        while (true) {
            String nodeName;
            if ("table".equals(nodeName = reader.getNodeName())) {
                DatabaseTableData o = new DatabaseTableData();
                DatabaseTableData.State state = o.deserialize(reader, schemaCreator);
                tables.add(o);
                stateMap.put(o, state);
            } else if ("procedure".equals(nodeName)) {
                DatabaseProcedure.deserialize(reader, procedures, schemaCreator);
            } else if ("schema".equals(nodeName)) {
                String name = reader.getAttribute("name");
                String catalog = reader.getAttribute("catalog");
                DatabaseSchema schema = new DatabaseSchema(catalog, name);
                schemaMap.put(schema, schema);
            }
            reader.moveUp();
            if (!reader.hasMoreChildren()) break;
            reader.moveDown();
        }
        for (DatabaseTableData table : tables) {
            table.resolveReferences(tables);
        }
        DatabaseModelLegacyLoader.computeExportedKeysManually(tables, (Map<DatabaseObject, Object>)stateMap);
        State state = new State(tables, procedures, ContainerUtil.newArrayList(schemaMap.values()));
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacySerializer", "deserialize"));
        }
        return state;
    }

    public boolean canSerialize(DasModel model) {
        return model instanceof State;
    }

    public void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/LegacySerializer", "serialize"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/dataSource/LegacySerializer", "serialize"));
        }
        State s = (State)model;
        for (DatabaseSchema databaseSchema : s.schemas) {
            writer.startNode("schema");
            writer.addAttribute("name", StringUtil.notNullize((String)databaseSchema.getName()));
            writer.addAttribute("catalog", StringUtil.notNullize((String)databaseSchema.getCatalog()));
            writer.endNode();
        }
        for (DatabaseTableData databaseTableData : s.tables) {
            databaseTableData.serialize(writer);
        }
        Collection classified = ContainerUtil.classify(s.procedures.iterator(), (Convertor)new Convertor<DatabaseProcedure, String>(){
            DdlBuilder b = new DdlBuilder();

            public String convert(DatabaseProcedure o) {
                this.b.clear();
                return this.b.qualifiedRef(o, o.getName(), DasUtil.getSchemaObject((DasObject)o), o.getSchema(), DasUtil.getCatalogObject((DasObject)o), o.getCatalog(), o.getDbParent(), o.getPackage()).getStatement();
            }
        }).values();
        for (Set overloaded : classified) {
            DatabaseProcedure.serialize(overloaded, writer);
        }
    }

    private static Iterable<? extends DasObject> childrenImpl(DasObject node, Getter<Iterable<? extends DasObject>> schemaChildren) {
        ObjectKind kind = node.getKind();
        if (kind == ObjectKind.DATABASE) {
            return node.getDbChildren(DasObject.class, ObjectKind.SCHEMA);
        }
        if (kind == ObjectKind.SCHEMA) {
            final DasObject o = node;
            final PsiFile f = o instanceof PsiElement ? ((PsiElement)o).getContainingFile() : null;
            return JBIterable.from((Iterable)((Iterable)schemaChildren.get())).filter((Condition)new Condition<DasObject>(){

                public boolean value(DasObject info) {
                    PsiFile file = info instanceof PsiElement ? ((PsiElement)info).getContainingFile() : null;
                    return Comparing.equal((String)StringUtil.nullize((String)o.getName()), (String)StringUtil.nullize((String)DasUtil.getSchema((DasObject)info))) && Comparing.equal((String)StringUtil.nullize((String)DasUtil.getCatalog((DasObject)o)), (String)StringUtil.nullize((String)DasUtil.getCatalog((DasObject)info))) && file == f;
                }
            });
        }
        if (node instanceof DasTable) {
            DasTable o = (DasTable)node;
            return ContainerUtil.concat((Iterable[])new Iterable[]{DasUtil.getColumns((DasObject)o), ContainerUtil.createMaybeSingletonList((Object)DasUtil.getPrimaryKey((DasTable)o)), DasUtil.getForeignKeys((DasTable)o), DasUtil.getIndices((DasTable)o), DasUtil.getTriggers((DasTable)o)});
        }
        return ContainerUtil.emptyIterable();
    }

    @Nullable
    static String deserializeAttribute(@NotNull HierarchicalStreamReader xmlReader, String name) {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/intellij/database/dataSource/LegacySerializer", "deserializeAttribute"));
        }
        String value = xmlReader.getAttribute(name);
        if (value != null) {
            try {
                return DbUtil.intern((String)new String(Base64.decode((String)value), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    static class State
    implements DasModel {
        final List<DatabaseTableData> tables;
        final List<DatabaseProcedure> procedures;
        final List<DatabaseSchema> schemas;
        Casing myCasing;

        State(@NotNull Collection<DatabaseTableData> tables, @NotNull Collection<DatabaseProcedure> procedures, @NotNull Collection<DatabaseSchema> schemas) {
            if (tables == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/dataSource/LegacySerializer$State", "<init>"));
            }
            if (procedures == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedures", "com/intellij/database/dataSource/LegacySerializer$State", "<init>"));
            }
            if (schemas == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/dataSource/LegacySerializer$State", "<init>"));
            }
            this.myCasing = DasUtil.CASING_MIXED;
            this.tables = Arrays.asList(tables.toArray(new DatabaseTableData[tables.size()]));
            this.procedures = Arrays.asList(procedures.toArray(new DatabaseProcedure[procedures.size()]));
            this.schemas = Arrays.asList(schemas.toArray(new DatabaseSchema[schemas.size()]));
        }

        public void setCasing(Casing casing) {
            this.myCasing = casing;
        }

        @NotNull
        public JBIterable<? extends DasObject> getModelRoots() {
            JBIterable jBIterable = JBIterable.from(this.schemas);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacySerializer$State", "getModelRoots"));
            }
            return jBIterable;
        }

        @Nullable
        public DbmNamespace getCurrentRoot() {
            return null;
        }

        @NotNull
        public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dataSource/LegacySerializer$State", "getCasing"));
            }
            Casing casing = this.myCasing;
            if (casing == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacySerializer$State", "getCasing"));
            }
            return casing;
        }

        @NotNull
        public JBTreeTraverser<DasObject> traverser() {
            JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(this.TREE_STRUCTURE()).withRoots(this.schemas);
            if (jBTreeTraverser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacySerializer$State", "traverser"));
            }
            return jBTreeTraverser;
        }

        @NotNull
        private Function<DasObject, Iterable<? extends DasObject>> TREE_STRUCTURE() {
            Getter<Iterable<? extends DasObject>> getter = new Getter<Iterable<? extends DasObject>>(){

                public Iterable<? extends DasObject> get() {
                    return JBIterable.from(State.this.tables).append(State.this.procedures);
                }
            };
            Function<DasObject, Iterable<? extends DasObject>> function = new Function<DasObject, Iterable<? extends DasObject>>((Getter)getter){
                final /* synthetic */ Getter val$getter;
                {
                    this.val$getter = getter;
                }

                public Iterable<? extends DasObject> fun(DasObject object) {
                    return LegacySerializer.childrenImpl(object, (Getter<Iterable<? extends DasObject>>)this.val$getter);
                }
            };
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacySerializer$State", "TREE_STRUCTURE"));
            }
            return function;
        }

        @NotNull
        public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
            JBIterable jBIterable = JBIterable.from(((DatabaseTableData)table).getExportedKeys()).filter(DasConstraint.class);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacySerializer$State", "getExportedKeys"));
            }
            return jBIterable;
        }
    }
}

