/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecompositionUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDecompositionNodes {
    @NotNull
    public static SNode create(@NotNull StatelessTextDecomposition.Node stateless) {
        if (stateless == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        if (stateless.getClass() == StatelessTextDecomposition.TextNode.class) {
            TextSNode textSNode = TextDecompositionNodes.create((StatelessTextDecomposition.TextNode)stateless);
            if (textSNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
            }
            return textSNode;
        }
        if (stateless.getClass() == StatelessTextDecomposition.ParameterNode.class) {
            ParameterSNode parameterSNode = TextDecompositionNodes.create((StatelessTextDecomposition.ParameterNode)stateless);
            if (parameterSNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
            }
            return parameterSNode;
        }
        if (stateless.getClass() == StatelessTextDecomposition.CompositeNode.class) {
            CompositeSNode compositeSNode = TextDecompositionNodes.create((StatelessTextDecomposition.CompositeNode)stateless);
            if (compositeSNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
            }
            return compositeSNode;
        }
        if (stateless.getClass() == StatelessTextDecomposition.OptionalNode.class) {
            OptionalSNode optionalSNode = TextDecompositionNodes.create((StatelessTextDecomposition.OptionalNode)stateless);
            if (optionalSNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
            }
            return optionalSNode;
        }
        if (stateless.getClass() == StatelessTextDecomposition.ListNode.class) {
            ListSNode listSNode = TextDecompositionNodes.create((StatelessTextDecomposition.ListNode)stateless);
            if (listSNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
            }
            return listSNode;
        }
        if (stateless.getClass() == StatelessTextDecomposition.ListChoiceNode.class) {
            ListChoiceSNode listChoiceSNode = TextDecompositionNodes.create((StatelessTextDecomposition.ListChoiceNode)stateless);
            if (listChoiceSNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
            }
            return listChoiceSNode;
        }
        assert (false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        return null;
    }

    @NotNull
    public static TextSNode create(@NotNull StatelessTextDecomposition.TextNode stateless) {
        if (stateless == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        TextSNode textSNode = new TextSNode(stateless);
        if (textSNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        return textSNode;
    }

    @NotNull
    public static ParameterSNode create(@NotNull StatelessTextDecomposition.ParameterNode stateless) {
        if (stateless == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        ParameterSNode parameterSNode = new ParameterSNode(stateless);
        if (parameterSNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        return parameterSNode;
    }

    @NotNull
    public static ListChoiceSNode create(@NotNull StatelessTextDecomposition.ListChoiceNode stateless) {
        if (stateless == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        ListChoiceSNode listChoiceSNode = new ListChoiceSNode(stateless, TextDecompositionNodes.create(stateless.getChildren()[0]));
        if (listChoiceSNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        return listChoiceSNode;
    }

    @NotNull
    public static OptionalSNode create(@NotNull StatelessTextDecomposition.OptionalNode stateless) {
        if (stateless == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        OptionalSNode optionalSNode = new OptionalSNode(stateless, TextDecompositionNodes.create(stateless.getChildren()[0]));
        if (optionalSNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        return optionalSNode;
    }

    @NotNull
    public static CompositeSNode create(@NotNull StatelessTextDecomposition.CompositeNode stateless) {
        if (stateless == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        SNode[] children = new SNode[stateless.getChildren().length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = TextDecompositionNodes.create(stateless.getChildren()[i]);
        }
        CompositeSNode compositeSNode = new CompositeSNode(stateless, children);
        if (compositeSNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        return compositeSNode;
    }

    @NotNull
    public static ListSNode create(@NotNull StatelessTextDecomposition.ListNode stateless) {
        if (stateless == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        StatelessTextDecomposition.Node[] statelessChoices = stateless.getChoice().getChildren();
        ListChoiceSNode[] choices = new ListChoiceSNode[statelessChoices.length];
        for (int i = 0; i < statelessChoices.length; ++i) {
            choices[i] = TextDecompositionNodes.create((StatelessTextDecomposition.ListChoiceNode)statelessChoices[i]);
        }
        ListSNode listSNode = new ListSNode(stateless, choices);
        if (listSNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes", "create"));
        }
        return listSNode;
    }

    static class ParameterSNode
    extends AbstractMatchable
    implements Parameter,
    LeafSNode {
        private final StatelessTextDecomposition.ParameterNode myNode;
        private String myText;
        private BadGroup myBadGroup;

        ParameterSNode(@NotNull StatelessTextDecomposition.ParameterNode stateless) {
            if (stateless == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode", "<init>"));
            }
            this.myText = "";
            this.myNode = stateless;
        }

        @Override
        public void setText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode", "setText"));
            }
            this.myText = text;
        }

        @Override
        public void setBadGroup(@Nullable BadGroup bad) {
            this.myBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getBadGroup() {
            return this.myBadGroup;
        }

        @Override
        @Nullable
        public String getName() {
            return this.myNode.getName();
        }

        @Override
        @NotNull
        public String getType() {
            String string = this.myNode.getType();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode", "getType"));
            }
            return string;
        }

        @Override
        @NotNull
        public Pattern getPattern() {
            Pattern pattern = this.myNode.compilePattern();
            if (pattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode", "getPattern"));
            }
            return pattern;
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode", "getText"));
            }
            return string;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode", "visitChildren"));
            }
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.ParameterNode getStateless() {
            StatelessTextDecomposition.ParameterNode parameterNode = this.myNode;
            if (parameterNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode", "getStateless"));
            }
            return parameterNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text) {
            super.setMatch(text);
            this.setBadGroup(null);
            this.setText(text == null ? "" : text.toString());
        }
    }

    static class ListSNode
    extends AbstractMatchable
    implements SNode {
        private final StatelessTextDecomposition.ListNode myNode;
        private final List<ListChoiceSNode> myMatched;
        private final ListChoiceSNode[] myKnownChoices;

        public ListSNode(@NotNull StatelessTextDecomposition.ListNode stateless, @NotNull ListChoiceSNode[] choices) {
            if (stateless == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "<init>"));
            }
            if (choices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choices", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "<init>"));
            }
            this.myMatched = ContainerUtil.newArrayListWithCapacity((int)0);
            this.myNode = stateless;
            this.myKnownChoices = choices;
            int groupNumber = 1;
            for (ListChoiceSNode choice : this.myKnownChoices) {
                choice.setGroupNumber(groupNumber);
                groupNumber += choice.getStateless().getContainingGroups();
            }
            this.addMissingChoices();
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "visitChildren"));
            }
            for (SNode sNode : this.myMatched) {
                visitor.visit(sNode);
            }
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.ListNode getStateless() {
            StatelessTextDecomposition.ListNode listNode = this.myNode;
            if (listNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "getStateless"));
            }
            return listNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text) {
            super.setMatch(text);
            this.myMatched.clear();
            for (ListChoiceSNode c : this.myKnownChoices) {
                c.setMatch(null);
            }
            int matched = this.subMatch(text == null ? "" : text);
            assert (text == null || matched == text.length()) : "Match differs: " + text;
            this.addMissingChoices();
        }

        private int subMatch(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "subMatch"));
            }
            int matched = 0;
            Matcher m = this.myNode.getChoice().compileIncrementalPattern().matcher(text);
            while (m.lookingAt()) {
                matched = m.end();
                this.processMatch(m);
                if (!ListSNode.contains(text, matched, this.myNode.getSeparator())) break;
                m.region(matched + this.myNode.getSeparator().length(), text.length());
            }
            return matched;
        }

        private int recover(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "recover"));
            }
            Matcher matcher = this.myNode.getChoice().compileRecoverPattern().matcher(text);
            if (!matcher.lookingAt()) {
                return 0;
            }
            return matcher.end();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private RecoverableMatch matchIncremental(@NotNull CharSequence text, @Nullable BadGroup badness) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "matchIncremental"));
            }
            super.setMatch(text);
            RecoverableMatch res = new RecoverableMatch();
            this.myMatched.clear();
            for (ListChoiceSNode c : this.myKnownChoices) {
                c.setMatch(null);
            }
            ListChoiceSNode[] pending = new ListChoiceSNode[this.myKnownChoices.length];
            System.arraycopy(this.myKnownChoices, 0, pending, 0, pending.length);
            ArrayList matchedStrings = ContainerUtil.newArrayList();
            ArrayList matchResults = ContainerUtil.newArrayList();
            int offset = 0;
            boolean extraSeparator = false;
            while (offset != text.length() || this.myMatched.isEmpty()) {
                void var9_12;
                Object var9_13 = null;
                int maxIdx = -1;
                Object current = new CharSequenceSubSequence(text, offset, text.length());
                int recovered = this.recover((CharSequence)current);
                current = current.subSequence(0, recovered);
                for (int i = 0; i < pending.length; ++i) {
                    String prevBadText;
                    String string = prevBadText = badness == null ? "" : badness.getBadText();
                    if (badness != null) {
                        badness.setBadText("");
                    }
                    RecoverableMatch curMatched = pending[i].matchIncrementally((CharSequence)current, this.myMatched.isEmpty() ? badness : null);
                    if (var9_12 == null || curMatched.compareTo((RecoverableMatch)var9_12) > 0) {
                        RecoverableMatch recoverableMatch = curMatched;
                        maxIdx = i;
                        continue;
                    }
                    if (badness == null) continue;
                    badness.setBadText(prevBadText);
                }
                assert (var9_12 != null);
                this.myMatched.add(pending[maxIdx]);
                matchedStrings.add(current);
                matchResults.add(var9_12);
                pending[maxIdx] = TextDecompositionNodes.create(pending[maxIdx].getStateless());
                res.add((RecoverableMatch)var9_12);
                for (ListChoiceSNode node : pending) {
                    node.setMatch(null);
                }
                if (!ListSNode.contains(text, offset += recovered, this.myNode.getSeparator())) break;
                res.matched += this.myNode.getSeparator().length();
                extraSeparator = (offset += this.myNode.getSeparator().length()) == text.length();
            }
            for (ListChoiceSNode choice : this.myKnownChoices) {
                int mini = -1;
                int myi = -1;
                RecoverableMatch maxMatch = null;
                for (int i = 0; i < this.myMatched.size(); ++i) {
                    ListChoiceSNode m = this.myMatched.get(i);
                    if (m != choice && m.getStateless() == choice.getStateless() && (maxMatch == null || ((RecoverableMatch)matchResults.get(i)).compareTo(maxMatch) > 0)) {
                        maxMatch = (RecoverableMatch)matchResults.get(i);
                        mini = i;
                        continue;
                    }
                    if (m != choice) continue;
                    myi = i;
                }
                if (mini == -1 || myi == -1) continue;
                Collections.swap(this.myMatched, mini, myi);
                if ((mini == 0 || myi == 0) && badness != null) {
                    badness.setBadText("");
                }
                this.myMatched.get(mini).matchIncrementally((CharSequence)matchedStrings.get(mini), mini == 0 ? badness : null);
                this.myMatched.get(myi).matchIncrementally((CharSequence)matchedStrings.get(myi), myi == 0 ? badness : null);
            }
            if (extraSeparator) {
                ListChoiceSNode listChoiceSNode = (ListChoiceSNode)ContainerUtil.getLastItem(this.myMatched);
                assert (listChoiceSNode != null);
                BadGroup bg = listChoiceSNode.getEndBadGroup();
                if (bg == null) {
                    bg = new BadGroup();
                    listChoiceSNode.setEndBadGroup(bg);
                }
                bg.setBadText(bg.getBadText() + this.getStateless().getSeparator());
            }
            assert (offset == text.length()) : "Match differs: " + text;
            this.addMissingChoices();
            RecoverableMatch recoverableMatch = res;
            if (recoverableMatch == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "matchIncremental"));
            }
            return recoverableMatch;
        }

        private static boolean contains(@NotNull CharSequence text, int offset, @NotNull CharSequence other) {
            int matched;
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "contains"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "contains"));
            }
            for (matched = 0; offset + matched < text.length() && matched < other.length() && text.charAt(matched + offset) == other.charAt(matched); ++matched) {
            }
            return matched == other.length();
        }

        public void processMatch(@NotNull MatchResult m) {
            if (m == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode", "processMatch"));
            }
            for (ListChoiceSNode choice : this.myKnownChoices) {
                String text = m.group(choice.getGroupNumber());
                ListChoiceSNode matched = null;
                if (!StringUtil.isEmpty((String)text)) {
                    matched = choice.isMatched() ? TextDecompositionNodes.create(choice.getStateless()) : choice;
                    matched.setMatch(text);
                }
                if (matched == null) continue;
                this.myMatched.add(matched);
            }
        }

        private void addMissingChoices() {
            HashSet props = ContainerUtil.newHashSet();
            for (ListChoiceSNode c : this.myMatched) {
                props.add(c);
            }
            for (ListChoiceSNode c : this.myKnownChoices) {
                if (props.contains(c)) continue;
                this.myMatched.add(c);
            }
        }

        public List<ListChoiceSNode> getMatches() {
            return this.myMatched;
        }
    }

    static class ListChoiceSNode
    extends MatchableRoot
    implements SNode {
        private final StatelessTextDecomposition.ListChoiceNode myNode;
        private boolean myEnabled;

        public ListChoiceSNode(@NotNull StatelessTextDecomposition.ListChoiceNode stateless, @NotNull SNode node) {
            if (stateless == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListChoiceSNode", "<init>"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListChoiceSNode", "<init>"));
            }
            super(node);
            this.myNode = stateless;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListChoiceSNode", "visitChildren"));
            }
            visitor.visit(this.getRoot());
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.ListChoiceNode getStateless() {
            StatelessTextDecomposition.ListChoiceNode listChoiceNode = this.myNode;
            if (listChoiceNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListChoiceSNode", "getStateless"));
            }
            return listChoiceNode;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }
    }

    static class TextSNode
    extends AbstractMatchable
    implements LeafSNode {
        private final StatelessTextDecomposition.TextNode myNode;
        private BadGroup myBadGroup;
        private String myMatchedText;

        TextSNode(@NotNull StatelessTextDecomposition.TextNode stateless) {
            if (stateless == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$TextSNode", "<init>"));
            }
            this.myMatchedText = "";
            this.myNode = stateless;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$TextSNode", "visitChildren"));
            }
        }

        @Override
        public void setBadGroup(@Nullable BadGroup bad) {
            this.myBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getBadGroup() {
            return this.myBadGroup;
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myNode.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$TextSNode", "getText"));
            }
            return string;
        }

        @NotNull
        public String getMatchedText() {
            String string = this.myMatchedText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$TextSNode", "getMatchedText"));
            }
            return string;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.TextNode getStateless() {
            StatelessTextDecomposition.TextNode textNode = this.myNode;
            if (textNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$TextSNode", "getStateless"));
            }
            return textNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text) {
            super.setMatch(text);
            this.myMatchedText = text == null ? "" : text.toString();
            this.setBadGroup(null);
        }

        public void setMatchedText(@NotNull String matchedText) {
            if (matchedText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchedText", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$TextSNode", "setMatchedText"));
            }
            this.myMatchedText = matchedText;
        }
    }

    static class CompositeSNode
    extends AbstractMatchable
    implements SNode,
    StartEndBadable {
        private final StatelessTextDecomposition.CompositeNode myNode;
        private final SNode[] myChildren;
        private BadGroup myStartBadGroup;
        private BadGroup myEndBadGroup;

        @Override
        public void setStartBadGroup(@Nullable BadGroup bad) {
            this.myStartBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getStartBadGroup() {
            return this.myStartBadGroup;
        }

        @Override
        public void setEndBadGroup(@Nullable BadGroup bad) {
            this.myEndBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getEndBadGroup() {
            return this.myEndBadGroup;
        }

        CompositeSNode(@NotNull StatelessTextDecomposition.CompositeNode stateless, @NotNull SNode[] children) {
            if (stateless == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$CompositeSNode", "<init>"));
            }
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$CompositeSNode", "<init>"));
            }
            this.myNode = stateless;
            this.myChildren = children;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.CompositeNode getStateless() {
            StatelessTextDecomposition.CompositeNode compositeNode = this.myNode;
            if (compositeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$CompositeSNode", "getStateless"));
            }
            return compositeNode;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$CompositeSNode", "visitChildren"));
            }
            for (SNode c : this.myChildren) {
                visitor.visit(c);
            }
        }

        public SNode[] getChildren() {
            return this.myChildren;
        }

        @Override
        public void setMatch(@Nullable CharSequence text) {
            super.setMatch(text);
            this.myStartBadGroup = null;
            this.myEndBadGroup = null;
        }
    }

    static class OptionalSNode
    extends AbstractMatchable
    implements SNode,
    Badable {
        private final StatelessTextDecomposition.OptionalNode myNode;
        private final SNode mySNode;
        private boolean myEnabled;
        private BadGroup myBadGroup;

        OptionalSNode(@NotNull StatelessTextDecomposition.OptionalNode node, @NotNull SNode snode) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$OptionalSNode", "<init>"));
            }
            if (snode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snode", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$OptionalSNode", "<init>"));
            }
            this.myNode = node;
            this.mySNode = snode;
            this.myEnabled = false;
        }

        @Override
        public void setBadGroup(@Nullable BadGroup bad) {
            this.myBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getBadGroup() {
            return this.myBadGroup;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.OptionalNode getStateless() {
            StatelessTextDecomposition.OptionalNode optionalNode = this.myNode;
            if (optionalNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$OptionalSNode", "getStateless"));
            }
            return optionalNode;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$OptionalSNode", "visitChildren"));
            }
            visitor.visit(this.mySNode);
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public SNode getNode() {
            return this.mySNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text) {
            super.setMatch(text);
            this.setBadGroup(null);
        }
    }

    static class MatchableRoot
    extends AbstractMatchable
    implements StartEndBadable {
        private final Matchable[] myMatchables;
        private final SNode myRoot;
        private BadGroup myStartBadGroup;
        private BadGroup myEndBadGroup;

        MatchableRoot(@NotNull SNode root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot", "<init>"));
            }
            this.myRoot = root;
            this.myMatchables = TextDecompositionUtil.collectMatchables(this.myRoot);
            TextDecompositionUtil.assignGroups(this.myRoot);
        }

        @Override
        public void setStartBadGroup(@Nullable BadGroup bad) {
            this.myStartBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getStartBadGroup() {
            return this.myStartBadGroup;
        }

        @Override
        public void setEndBadGroup(@Nullable BadGroup bad) {
            this.myEndBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getEndBadGroup() {
            return this.myEndBadGroup;
        }

        @NotNull
        public SNode getRoot() {
            SNode sNode = this.myRoot;
            if (sNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot", "getRoot"));
            }
            return sNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text) {
            super.setMatch(text);
            this.myStartBadGroup = null;
            this.myEndBadGroup = null;
            if (text == null) {
                for (Matchable matchable : this.myMatchables) {
                    matchable.setMatch(null);
                }
                return;
            }
            Matcher matcher = this.myRoot.getStateless().compilePattern().matcher(text);
            boolean check = matcher.matches();
            assert (check);
            for (Matchable matchable : this.myMatchables) {
                matchable.setMatch(matcher.group(matchable.getGroupNumber()));
            }
        }

        @NotNull
        public RecoverableMatch matchIncrementally(final @NotNull CharSequence unmatched, final @Nullable BadGroup badness) {
            if (unmatched == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmatched", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot", "matchIncrementally"));
            }
            RecoverableMatch recoverableMatch = new TextDecompositionUtil.SimpleNodeVisitor<Void>(){
                private RecoverableMatchState state = new RecoverableMatchState();
                private boolean myOpt = false;

                @NotNull
                private BadGroup currentBadGroup() {
                    if (this.state.myRecovery == null) {
                        this.state.myRecovery = new BadGroup();
                        ++this.state.myRecoveries;
                        if (this.state.myOffset == 0) {
                            MatchableRoot.this.myStartBadGroup = this.state.myRecovery;
                        }
                    }
                    BadGroup badGroup = this.state.myRecovery;
                    if (badGroup == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "currentBadGroup"));
                    }
                    return badGroup;
                }

                @Override
                public Void visit(@NotNull SNode node) {
                    int matched;
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "visit"));
                    }
                    if (node.getStateless().isEarlyMatchable() && !(node instanceof OptionalSNode) && (matched = this.matchLength(node)) != -1) {
                        this.state.myOffset += matched;
                        this.myOpt = false;
                        assert (this.state.myRecovery == null);
                        return null;
                    }
                    super.visit(node);
                    return null;
                }

                @Override
                public Void visit(@NotNull ParameterSNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "visit"));
                    }
                    node.setMatch(null);
                    node.setBadGroup(this.currentBadGroup());
                    return null;
                }

                @Override
                public Void visit(@NotNull TextSNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "visit"));
                    }
                    node.setMatch(null);
                    node.setBadGroup(this.currentBadGroup());
                    if (this.myOpt) {
                        this.state.myOptTextSkipped += node.getText().length();
                    } else {
                        this.state.myTextSkipped += node.getText().length();
                    }
                    return null;
                }

                @Override
                public Void visit(@NotNull CompositeSNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "visit"));
                    }
                    node.setMatch(null);
                    node.setStartBadGroup(this.state.myRecovery);
                    node.visitChildren(this);
                    node.setEndBadGroup(this.state.myRecovery);
                    return null;
                }

                @Override
                public Void visit(@NotNull OptionalSNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "visit"));
                    }
                    boolean prevOpt = this.myOpt;
                    this.myOpt = true;
                    RecoverableMatchState prevState = new RecoverableMatchState(this.state);
                    node.visitChildren(this);
                    CharSequenceSubSequence segment = new CharSequenceSubSequence(unmatched, prevState.myOffset, unmatched.length());
                    Matcher matcher = node.getStateless().compileRecoverPattern().matcher((CharSequence)segment);
                    boolean shouldRecover = false;
                    if (matcher.lookingAt() && (this.state.myRecovered - prevState.myRecovered > matcher.end() || matcher.end() == 0 && this.state.myRecoveries > prevState.myRecoveries)) {
                        shouldRecover = true;
                    }
                    if (shouldRecover) {
                        this.state = prevState;
                        TextDecompositionUtil.nullizeMatch(node);
                        if (matcher.end() != 0) {
                            if (this.state.myRecovery != null) {
                                this.state.myRecovery.setBadText("");
                            }
                            node.setBadGroup(this.currentBadGroup());
                        }
                        this.myOpt = true;
                    } else {
                        if (!this.myOpt) {
                            this.state.myTextSkipped += this.state.myOptTextSkipped;
                        }
                        this.state.myOptTextSkipped = 0;
                        node.setMatch(unmatched.subSequence(prevState.myOffset, this.state.myOffset));
                    }
                    if (this.myOpt) {
                        this.myOpt = prevOpt;
                    }
                    return null;
                }

                @Override
                public Void visit(@NotNull ListSNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "visit"));
                    }
                    CharSequenceSubSequence segment = new CharSequenceSubSequence(unmatched, this.state.myOffset, unmatched.length());
                    Pattern p = node.getStateless().compileRecoverPattern();
                    Matcher matcher = p.matcher((CharSequence)segment);
                    if (matcher.lookingAt()) {
                        RecoverableMatch res = node.matchIncremental(matcher.group(), this.state.myRecovery);
                        this.state.myOffset += matcher.group().length();
                        this.state.myRecovered = matcher.group().length() - res.matched;
                        this.state.myRecoveries += res.numRecoveries;
                        this.state.myTextSkipped += res.textSkipped;
                        this.state.myRecovery = null;
                    } else {
                        node.setMatch(null);
                    }
                    return null;
                }

                @Override
                public Void visit(@NotNull ListChoiceSNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "visit"));
                    }
                    node.visitChildren(this);
                    return null;
                }

                private int matchLength(@NotNull SNode node) {
                    Matcher matcher;
                    boolean matched;
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "matchLength"));
                    }
                    CharSequenceSubSequence segment = new CharSequenceSubSequence(unmatched, this.state.myOffset, unmatched.length());
                    Pattern p = node.getStateless().compileIncrementalPattern();
                    int recoveryAddition = 0;
                    if (this.state.myRecovery != null) {
                        p = PatternBuilder.build("(.*?)").push().append(p).group().pop().compile();
                        recoveryAddition = 1;
                    }
                    if (!(matched = (matcher = p.matcher((CharSequence)segment)).lookingAt()) && this.state.myRecovery == null && node instanceof ParameterSNode) {
                        matcher = node.getStateless().compilePattern().matcher((CharSequence)segment);
                        matched = matcher.lookingAt();
                    }
                    if (matched) {
                        for (Matchable m : MatchableRoot.this.myMatchables) {
                            int g = m.getGroupNumber() - node.getGroupNumber() + 1 + recoveryAddition;
                            if (g <= recoveryAddition || g > matcher.groupCount() || g > recoveryAddition + node.getStateless().getContainingGroups()) continue;
                            this.setMatchedText(m, matcher.group(g));
                        }
                        if (this.state.myRecovery != null) {
                            this.state.myRecovery.setBadText(matcher.group(1));
                            this.state.myRecovered = this.state.myRecovery.getBadText().length();
                            this.state.myRecovery = null;
                        }
                        return matcher.end();
                    }
                    return -1;
                }

                private void setMatchedText(@NotNull Matchable node, @Nullable CharSequence text) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "setMatchedText"));
                    }
                    node.setMatch(text);
                }

                RecoverableMatch getResult(@NotNull SNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1", "getResult"));
                    }
                    this.state.myRecovery = badness;
                    MatchableRoot.this.myStartBadGroup = badness;
                    this.visit(node);
                    RecoverableMatch res = new RecoverableMatch();
                    res.matched = this.state.myOffset - this.state.myRecovered;
                    res.numRecoveries = this.state.myRecoveries;
                    res.textSkipped = this.state.myTextSkipped;
                    MatchableRoot.this.myEndBadGroup = this.state.myRecovery;
                    if (MatchableRoot.this.myEndBadGroup == null && unmatched.length() != this.state.myOffset) {
                        MatchableRoot.this.myEndBadGroup = this.currentBadGroup();
                    }
                    if (MatchableRoot.this.myEndBadGroup != null) {
                        MatchableRoot.this.myEndBadGroup.setBadText(unmatched.subSequence(this.state.myOffset, unmatched.length()).toString());
                    }
                    return res;
                }
            }.getResult(this.myRoot);
            if (recoverableMatch == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot", "matchIncrementally"));
            }
            return recoverableMatch;
        }

        static class RecoverableMatchState {
            int myOffset;
            BadGroup myRecovery;
            int myRecovered;
            int myRecoveries;
            int myTextSkipped;
            int myOptTextSkipped;

            RecoverableMatchState() {
                this.myOffset = 0;
                this.myRecovery = null;
                this.myRecovered = 0;
                this.myRecoveries = 0;
                this.myTextSkipped = 0;
                this.myOptTextSkipped = 0;
            }

            RecoverableMatchState(@NotNull RecoverableMatchState other) {
                if (other == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$RecoverableMatchState", "<init>"));
                }
                this.myOffset = 0;
                this.myRecovery = null;
                this.myRecovered = 0;
                this.myRecoveries = 0;
                this.myTextSkipped = 0;
                this.myOptTextSkipped = 0;
                this.myOffset = other.myOffset;
                this.myRecovery = other.myRecovery;
                this.myRecovered = other.myRecovered;
                this.myRecoveries = other.myRecoveries;
                this.myTextSkipped = other.myTextSkipped;
                this.myOptTextSkipped = other.myOptTextSkipped;
            }
        }
    }

    static class RecoverableMatch
    implements Comparable<RecoverableMatch> {
        int matched = 0;
        int numRecoveries = 0;
        int textSkipped = 0;

        RecoverableMatch() {
        }

        @Override
        public int compareTo(@NotNull RecoverableMatch o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$RecoverableMatch", "compareTo"));
            }
            int res = -Comparing.compare((int)this.textSkipped, (int)o.textSkipped);
            if (res != 0) {
                return res;
            }
            res = Comparing.compare((int)this.matched, (int)o.matched);
            if (res != 0) {
                return res;
            }
            res = -Comparing.compare((int)this.numRecoveries, (int)o.numRecoveries);
            return res;
        }

        public void add(@NotNull RecoverableMatch o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$RecoverableMatch", "add"));
            }
            this.matched += o.matched;
            this.textSkipped += o.textSkipped;
            this.numRecoveries += o.numRecoveries;
        }

        public boolean equals(Object obj) {
            return obj instanceof RecoverableMatch && this.compareTo((RecoverableMatch)obj) == 0;
        }
    }

    static abstract class AbstractMatchable
    implements Matchable {
        private int myGroupNumber;
        private int myFrom = -1;
        private int myTo = -1;
        private boolean myMatched = false;

        AbstractMatchable() {
        }

        @Override
        public int getGroupNumber() {
            return this.myGroupNumber;
        }

        public void setGroupNumber(int groupNumber) {
            this.myGroupNumber = groupNumber;
        }

        @Override
        public int getFrom() {
            return this.myFrom;
        }

        @Override
        public int getTo() {
            return this.myTo;
        }

        @Override
        public void setMatch(@Nullable CharSequence text) {
            this.setMatchRange(-1, -1);
            this.myMatched = text != null;
        }

        @Override
        public void setMatchRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @Override
        public boolean isMatched() {
            return this.myMatched;
        }
    }

    static interface LeafSNode
    extends SNode,
    Badable {
        @NotNull
        public String getText();
    }

    static interface StartEndBadable {
        public void setStartBadGroup(@Nullable BadGroup var1);

        @Nullable
        public BadGroup getStartBadGroup();

        public void setEndBadGroup(@Nullable BadGroup var1);

        @Nullable
        public BadGroup getEndBadGroup();
    }

    static interface Badable {
        public void setBadGroup(@Nullable BadGroup var1);

        @Nullable
        public BadGroup getBadGroup();
    }

    static interface SNode
    extends Matchable {
        public void visitChildren(@NotNull NodeVisitor var1);

        @NotNull
        public StatelessTextDecomposition.Node getStateless();
    }

    static interface Matchable {
        public int getGroupNumber();

        public int getFrom();

        public int getTo();

        public boolean isMatched();

        public void setMatch(@Nullable CharSequence var1);

        public void setMatchRange(int var1, int var2);
    }

    static class BadGroup {
        private String myBadText;
        private int myFrom;
        private int myTo;

        public BadGroup() {
            this("");
        }

        public BadGroup(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$BadGroup", "<init>"));
            }
            this.myFrom = -1;
            this.myTo = -1;
            this.myBadText = text;
        }

        void setBadText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$BadGroup", "setBadText"));
            }
            this.myBadText = text;
        }

        @NotNull
        String getBadText() {
            String string = this.myBadText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$BadGroup", "getBadText"));
            }
            return string;
        }

        public int getTo() {
            return this.myTo;
        }

        public int getFrom() {
            return this.myFrom;
        }

        public void setRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }
    }

    static interface NodeVisitor<R> {
        public R visit(@NotNull SNode var1);
    }

    static interface Parameter {
        @NotNull
        public String getText();

        public void setText(@NotNull String var1);

        @Nullable
        public String getName();

        @NotNull
        public String getType();

        @NotNull
        public Pattern getPattern();
    }
}

