/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.UpdateableCBParamEditor;
import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfoCache;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpHostParamEditor
extends UpdateableCBParamEditor {
    public static final Key<SsrpInfo> SSRP_INFO = Key.create((String)"SSRP_INFO");
    public static final String SQLSERVER_DISCOVERY = "SQLSERVER_DISCOVERY";
    private final SsrpInfo.SsrpServer myFakeServer;
    private final UpdateableCBParamEditor.MyComboBoxEditor myEditor;

    public SsrpHostParamEditor(@NotNull String label, final @NotNull DataInterchange interchange) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "<init>"));
        }
        super(label, interchange);
        this.myFakeServer = new SsrpInfo.SsrpServer("");
        this.addManualUpdate("Rediscover instances");
        this.addUpdateOnShow();
        ((ComboBox)this.getEditorComponent()).setEditable(true);
        this.myEditor = new UpdateableCBParamEditor.MyComboBoxEditor(this);
        ((ComboBox)this.getEditorComponent()).setEditor((ComboBoxEditor)this.myEditor);
        ((ComboBox)this.getEditorComponent()).setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setText(SsrpHostParamEditor.this.getTextFromItem(value));
            }
        });
        interchange.addUserDataListener(new DataInterchange.UserDataListener(){

            @Override
            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor$2", "userDataChanged"));
                }
                if (changed != SSRP_INFO) {
                    return;
                }
                SsrpHostParamEditor.this.setInfo((SsrpInfo)SSRP_INFO.get((UserDataHolder)interchange));
            }
        }, this);
        SSRP_INFO.set((UserDataHolder)interchange, (Object)SsrpInfoCache.get());
        SsrpInfoCache.addListener(new SsrpInfoCache.Listener(){

            public void consume(final SsrpConstants.SsrpException e) {
                if (e == null) {
                    final SsrpInfo info = SsrpInfoCache.get();
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SSRP_INFO.set((UserDataHolder)interchange, (Object)info);
                        }
                    });
                } else {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            interchange.showError(e, SsrpHostParamEditor.SQLSERVER_DISCOVERY);
                        }
                    });
                }
            }
        }, this);
    }

    @Override
    protected void updateModelAtShow() {
        if (!SSRP_INFO.isIn((UserDataHolder)this.getInterchange())) {
            this.updateModel();
        }
    }

    @Override
    @Nullable
    protected String getTextFromItem(@Nullable Object item) {
        SsrpInfo.SsrpServer srv = (SsrpInfo.SsrpServer)ObjectUtils.tryCast((Object)item, SsrpInfo.SsrpServer.class);
        return srv == null ? null : srv.getName();
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myEditor.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "getText"));
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "setText"));
        }
        this.myEditor.setText(text);
    }

    @Override
    @Nullable
    protected Object getItemFromText(@Nullable String text) {
        SsrpInfo.SsrpServer srv;
        text = StringUtil.notNullize((String)text);
        SsrpInfo info = (SsrpInfo)SSRP_INFO.get((UserDataHolder)this.getInterchange());
        SsrpInfo.SsrpServer ssrpServer = srv = info == null ? null : info.getServer(text);
        if (srv == null) {
            srv = this.myFakeServer;
            srv.setName(text);
        }
        return srv;
    }

    @Override
    protected void updateModel() {
        SsrpInfoCache.update();
    }

    private void setInfo(@Nullable SsrpInfo info) {
        ArrayList list = info == null ? Collections.emptyList() : ContainerUtil.newArrayList(info.getServers());
        Collections.sort(list, new Comparator<SsrpInfo.SsrpServer>(){

            @Override
            public int compare(SsrpInfo.SsrpServer o1, SsrpInfo.SsrpServer o2) {
                return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            }
        });
        ((ComboBox)this.getEditorComponent()).setModel((ComboBoxModel)new CollectionComboBoxModel((List)list, this.getItemFromText(this.getText())));
    }
}

