/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.SsrpHostParamEditor;
import com.intellij.database.dataSource.url.ui.UpdateableCBParamEditor;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInstanceParamEditor
extends UpdateableCBParamEditor {
    private final SsrpInfo.SsrpInstance myFakeInstance;
    private final UpdateableCBParamEditor.MyComboBoxEditor myEditor;
    private final ActionButton myApplyButton;

    public SsrpInstanceParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "<init>"));
        }
        super(label, interchange);
        this.myFakeInstance = new SsrpInfo.SsrpInstance("");
        this.myApplyButton = this.addButton(new AnAction("Apply", "Apply instance parameters", AllIcons.Actions.Install){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(SsrpInstanceParamEditor.this.isApplicable());
            }

            public void actionPerformed(AnActionEvent e) {
                SsrpInfo.SsrpServer server = SsrpInstanceParamEditor.this.getServer();
                SsrpInfo.SsrpInstance instance = server == null ? null : server.getInstance(SsrpInstanceParamEditor.this.getText());
                SsrpInstanceParamEditor.this.getInterchange().putProperty("port", instance == null ? null : instance.getAttribute("tcp"));
            }
        });
        ((ComboBox)this.getEditorComponent()).setEditable(true);
        this.myEditor = new UpdateableCBParamEditor.MyComboBoxEditor(this);
        ((ComboBox)this.getEditorComponent()).setEditor((ComboBoxEditor)this.myEditor);
        ((ComboBox)this.getEditorComponent()).setRenderer((ListCellRenderer)new ColoredListCellRenderer<SsrpInfo.SsrpInstance>(){
            {
                this.setIpad(new Insets(0, 0, 0, 0));
            }

            protected void customizeCellRenderer(JList list, SsrpInfo.SsrpInstance value, int index, boolean selected, boolean hasFocus) {
                String ver;
                this.append(StringUtil.notNullize((String)SsrpInstanceParamEditor.this.getTextFromItem(value)));
                String string = ver = value == null ? null : value.getAttribute("Version");
                if (ver != null) {
                    this.append(" " + ver, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        });
        this.getInterchange().addUserDataListener(new DataInterchange.UserDataListener(){

            @Override
            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor$3", "userDataChanged"));
                }
                if (changed != SsrpHostParamEditor.SSRP_INFO) {
                    return;
                }
                SsrpInstanceParamEditor.this.updateModel();
            }
        }, this);
        this.getInterchange().addPropertyChangeListener("host", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SsrpInstanceParamEditor.this.updateModel();
            }
        }, this);
    }

    @Override
    @Nullable
    protected String getTextFromItem(@Nullable Object item) {
        SsrpInfo.SsrpInstance inst = (SsrpInfo.SsrpInstance)ObjectUtils.tryCast((Object)item, SsrpInfo.SsrpInstance.class);
        return inst == null ? null : inst.getName();
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myEditor.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getText"));
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "setText"));
        }
        this.myEditor.setText(text);
    }

    private void updateButton() {
        this.myApplyButton.addNotify();
    }

    private boolean isApplicable() {
        return this.getItemFromText(this.getText()) != this.myFakeInstance;
    }

    @Nullable
    private SsrpInfo.SsrpServer getServer() {
        SsrpInfo info = (SsrpInfo)SsrpHostParamEditor.SSRP_INFO.get((UserDataHolder)this.getInterchange());
        String host = this.getInterchange().getProperty("host");
        return info == null || host == null ? null : info.getServer(host);
    }

    @Override
    @Nullable
    protected Object getItemFromText(@Nullable String text) {
        SsrpInfo.SsrpInstance inst;
        text = StringUtil.notNullize((String)text);
        SsrpInfo.SsrpServer srv = this.getServer();
        SsrpInfo.SsrpInstance ssrpInstance = inst = srv == null ? null : srv.getInstance(text);
        if (inst == null) {
            inst = this.myFakeInstance;
            inst.setName(text);
        }
        return inst;
    }

    @Override
    protected void updateModel() {
        this.setServer(this.getServer());
    }

    @Override
    protected void fireChanged() {
        super.fireChanged();
        this.updateButton();
    }

    private void setServer(@Nullable SsrpInfo.SsrpServer srv) {
        ArrayList list = srv == null ? Collections.emptyList() : ContainerUtil.newArrayList(srv.getInstances());
        Collections.sort(list, new Comparator<SsrpInfo.SsrpInstance>(){

            @Override
            public int compare(SsrpInfo.SsrpInstance o1, SsrpInfo.SsrpInstance o2) {
                return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            }
        });
        ((ComboBox)this.getEditorComponent()).setModel((ComboBoxModel)new CollectionComboBoxModel((List)list, this.getItemFromText(this.getText())));
        this.updateButton();
    }
}

