/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.openapi.util.Comparing;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceProblem {
    private static final String ACTION_PREFIX = "action";
    private static final Pattern ACTION_PATTERN = Pattern.compile("action(\\d+)");
    private static final Pattern ACTION_PLACEHOLDER = Pattern.compile("\\$ACTION(\\d+)");
    private final Object myOwner;
    private final String myDescription;
    private final String myShortDescription;
    private final NamedProgressive myFix;
    @Nullable
    private final Object myId;
    private final String myTitle;
    private final Object[] myLinkActions;

    public static void formatText(@NotNull StringBuilder builder, @NotNull List<Object> outActions, @NotNull String fmt, Object ... linkActions) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dataSource/validation/DataSourceProblem", "formatText"));
        }
        if (outActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outActions", "com/intellij/database/dataSource/validation/DataSourceProblem", "formatText"));
        }
        if (fmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fmt", "com/intellij/database/dataSource/validation/DataSourceProblem", "formatText"));
        }
        if (linkActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkActions", "com/intellij/database/dataSource/validation/DataSourceProblem", "formatText"));
        }
        Matcher matcher = ACTION_PLACEHOLDER.matcher(fmt);
        int start = 0;
        while (start < fmt.length()) {
            if (matcher.find(start)) {
                int acIdx = Integer.valueOf(matcher.group(1));
                if (acIdx < linkActions.length && linkActions[acIdx] != null) {
                    builder.append(fmt, start, matcher.start());
                    builder.append(ACTION_PREFIX).append(outActions.size());
                    outActions.add(linkActions[acIdx]);
                } else {
                    builder.append(fmt, start, matcher.end());
                }
                start = matcher.end();
                continue;
            }
            builder.append(fmt, start, fmt.length());
            start = fmt.length();
        }
    }

    public static Object extractAction(@Nullable String host, @NotNull List<Object> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/dataSource/validation/DataSourceProblem", "extractAction"));
        }
        if (host == null) {
            return null;
        }
        Matcher matcher = ACTION_PATTERN.matcher(host);
        if (!matcher.matches()) {
            return null;
        }
        int acIdx = Integer.valueOf(matcher.group(1));
        return acIdx < actions.size() ? actions.get(acIdx) : null;
    }

    public DataSourceProblem(@Nullable Object owner, @Nullable Object id, @NotNull String title, @NotNull String description, @Nullable NamedProgressive quickFix, Object ... linkActions) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/dataSource/validation/DataSourceProblem", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/database/dataSource/validation/DataSourceProblem", "<init>"));
        }
        if (linkActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkActions", "com/intellij/database/dataSource/validation/DataSourceProblem", "<init>"));
        }
        this(owner, id, title, description, description, quickFix, linkActions);
    }

    public DataSourceProblem(@Nullable Object owner, @Nullable Object id, @NotNull String title, @NotNull String shortDescription, @NotNull String description, @Nullable NamedProgressive quickFix, Object ... linkActions) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/dataSource/validation/DataSourceProblem", "<init>"));
        }
        if (shortDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortDescription", "com/intellij/database/dataSource/validation/DataSourceProblem", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/database/dataSource/validation/DataSourceProblem", "<init>"));
        }
        if (linkActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkActions", "com/intellij/database/dataSource/validation/DataSourceProblem", "<init>"));
        }
        this.myOwner = owner;
        this.myId = id;
        this.myTitle = title;
        this.myDescription = description;
        this.myShortDescription = shortDescription;
        this.myFix = quickFix;
        this.myLinkActions = linkActions;
    }

    @Nullable
    public Object getId() {
        return this.myId;
    }

    @Nullable
    public Object getOwner() {
        return this.myOwner;
    }

    @NotNull
    public Object[] getLinkActions() {
        if (this.myLinkActions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/validation/DataSourceProblem", "getLinkActions"));
        }
        return this.myLinkActions;
    }

    @NotNull
    public String getShortDescription() {
        String string = this.myShortDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/validation/DataSourceProblem", "getShortDescription"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/validation/DataSourceProblem", "getDescription"));
        }
        return string;
    }

    @Nullable
    public NamedProgressive getFix() {
        return this.myFix;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/validation/DataSourceProblem", "getTitle"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceProblem error = (DataSourceProblem)o;
        if (!Comparing.equal((Object)this.myOwner, (Object)error.myOwner)) {
            return false;
        }
        if (!this.myDescription.equals(error.myDescription)) {
            return false;
        }
        return this.myTitle.equals(error.myTitle);
    }

    public int hashCode() {
        int result = this.myDescription.hashCode();
        result = 31 * result + this.myTitle.hashCode();
        result = 31 * result + (this.myOwner == null ? 0 : this.myOwner.hashCode());
        return result;
    }

    public static class Navigate {
        public final Object target;

        public Navigate(Object target) {
            this.target = target;
        }
    }
}

