/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceValidator;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class LocalDataSourceValidator
extends DataSourceValidator {
    @Override
    public void findProblems(@NotNull Object object, @NotNull Consumer<DataSourceProblem> problems) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/validation/LocalDataSourceValidator", "findProblems"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/LocalDataSourceValidator", "findProblems"));
        }
        LocalDataSource dataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)object, LocalDataSource.class));
        if (dataSource == null) {
            return;
        }
        if (dataSource.getClasspathElements().isEmpty()) {
            DatabaseDriverValidator.findDriverFilesProblems(dataSource.getDatabaseDriver(), dataSource.isDomainAuthentication(), problems);
        }
    }
}

