/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvDocumentDataHookUp
extends DocumentDataHookUp {
    private Parser myParser;

    public CsvDocumentDataHookUp(@NotNull Project project, @NotNull CsvFormat format, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "<init>"));
        }
        super(project, document, range);
        this.myParser = new Parser(format);
    }

    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "setFormat"));
        }
        this.myParser = new Parser(format);
        this.getLoader().reloadCurrentPage(new GridRequestSource(null, this));
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myParser.myDataFormat;
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "getFormat"));
        }
        return csvFormat;
    }

    @Override
    @Nullable
    protected CsvMarkup buildMarkup(@NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "buildMarkup"));
        }
        return this.myParser.parse(sequence.toString());
    }

    @NotNull
    static List<String> values(final @NotNull CharSequence sequence, @NotNull List<ValueRange> ranges) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "values"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "values"));
        }
        List list = ContainerUtil.map(ranges, (Function)new Function<ValueRange, String>(){

            public String fun(ValueRange range) {
                return range.value(sequence).toString();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "values"));
        }
        return list;
    }

    private static class LookAhead {
        private int myNextRecordSeparatorRequestOffset = -1;
        private int myNextRecordSeparatorOffset = -1;

        private LookAhead() {
        }

        public int nextDelimiterOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "nextDelimiterOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "nextDelimiterOffset"));
            }
            int nextPartOffset = this.valuesEndOffset(template, sequence, startOffset);
            int nextValueSeparatorOffset = this.nextValueSeparatorOffset(template, sequence, startOffset);
            return Math.min(nextPartOffset, nextValueSeparatorOffset);
        }

        public int valuesEndOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "valuesEndOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "valuesEndOffset"));
            }
            String suffix = StringUtil.notNullize((String)template.suffix);
            String suffixAndSeparator = suffix + StringUtil.notNullize((String)template.recordSeparator);
            int suffixAndSeparatorIdx = LookAhead.indexOfOrEnd(sequence, startOffset, suffixAndSeparator);
            return suffixAndSeparatorIdx != sequence.length() ? suffixAndSeparatorIdx : (startOffset <= sequence.length() - suffix.length() && StringUtil.endsWith((CharSequence)sequence, (CharSequence)suffix) ? sequence.length() - suffix.length() : sequence.length());
        }

        public int nextRecordSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "nextRecordSeparatorOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "nextRecordSeparatorOffset"));
            }
            if (startOffset >= this.myNextRecordSeparatorRequestOffset && startOffset <= this.myNextRecordSeparatorOffset) {
                return this.myNextRecordSeparatorOffset;
            }
            this.myNextRecordSeparatorRequestOffset = startOffset;
            this.myNextRecordSeparatorOffset = LookAhead.indexOfOrEnd(sequence, startOffset, template.recordSeparator);
            return this.myNextRecordSeparatorOffset;
        }

        public int nextValueSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "nextValueSeparatorOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "nextValueSeparatorOffset"));
            }
            return LookAhead.indexOfOrEnd(sequence, startOffset, template.valueSeparator);
        }

        public int nextDelimiterOrRecordSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int offset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "nextDelimiterOrRecordSeparatorOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "nextDelimiterOrRecordSeparatorOffset"));
            }
            int nextDelimiterOffset = this.nextDelimiterOffset(template, sequence, offset);
            if (nextDelimiterOffset == offset) {
                return nextDelimiterOffset;
            }
            int recordSeparatorOffset = this.nextRecordSeparatorOffset(template, sequence, offset);
            return Math.min(nextDelimiterOffset, recordSeparatorOffset);
        }

        private static int indexOfOrEnd(@NotNull CharSequence sequence, int start, @Nullable CharSequence infix) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$LookAhead", "indexOfOrEnd"));
            }
            int idx = StringUtil.isEmpty((CharSequence)infix) ? -1 : StringUtil.indexOf((CharSequence)sequence, (CharSequence)infix, (int)start);
            return idx == -1 ? sequence.length() : idx;
        }
    }

    static class Parser {
        private final CsvFormat myDataFormat;
        private final Map<Object, Pattern> myCompiledPatterns;
        private LookAhead myLookAhead;

        public Parser(@NotNull CsvFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvDocumentDataHookUp$Parser", "<init>"));
            }
            this.myCompiledPatterns = ContainerUtil.newIdentityHashMap();
            this.myDataFormat = format;
        }

        @Nullable
        public CsvMarkup parse(CharSequence sequence) {
            CsvRecord record;
            this.myLookAhead = new LookAhead();
            List<String> columnNames = null;
            CsvRecord headerRow = null;
            ArrayList rows = ContainerUtil.newArrayList();
            int currentOffset = 0;
            if (this.myDataFormat.headerRecord != null) {
                CsvRecord headerRecord = this.parseRecordSkippingLines(sequence, currentOffset, this.myDataFormat.headerRecord, this.myDataFormat.rowNumbers);
                if (headerRecord == null) {
                    return null;
                }
                headerRow = headerRecord;
                columnNames = CsvDocumentDataHookUp.values(sequence, headerRecord.values);
                currentOffset = headerRecord.range.getEndOffset();
            }
            while ((record = this.parseRecordSkippingLines(sequence, currentOffset, this.myDataFormat.dataRecord, this.myDataFormat.rowNumbers)) != null) {
                if (columnNames == null) {
                    columnNames = CsvDocumentDataHookUp.values(sequence, record.values);
                }
                if (columnNames.size() != record.values.size()) {
                    currentOffset = Parser.skipLine(sequence, currentOffset);
                    continue;
                }
                currentOffset = record.range.getEndOffset();
                rows.add(record);
            }
            return columnNames == null ? null : new CsvMarkup(new CsvFormatter(this.myDataFormat), sequence, rows, headerRow, this.myDataFormat.rowNumbers);
        }

        private CsvRecord parseRecordSkippingLines(CharSequence sequence, int startOffset, CsvRecordFormat template, boolean firstColumnIsTitle) {
            CsvRecord record = null;
            while (startOffset < sequence.length() && (record = this.parseRecord(sequence, startOffset, template, firstColumnIsTitle)) == null) {
                startOffset = Parser.skipLine(sequence, startOffset);
            }
            return record;
        }

        private CsvRecord parseRecord(CharSequence sequence, int startOffset, CsvRecordFormat template, boolean firstColumnIsTitle) {
            Ref titleAndValuesRef = Ref.create();
            int endOffset = startOffset;
            endOffset = StringUtil.isEmpty((String)template.prefix) ? endOffset : (StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)template.prefix) ? endOffset + template.prefix.length() : -1);
            int n = endOffset = endOffset == -1 ? -1 : this.parseValues((Ref<List<ValueRange>>)titleAndValuesRef, sequence, endOffset, template);
            int n2 = endOffset == -1 ? -1 : (StringUtil.isEmpty((String)template.suffix) ? endOffset : (endOffset = StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)template.suffix) ? endOffset + template.suffix.length() : -1));
            if (endOffset == -1) {
                return null;
            }
            boolean hasRecordSeparator = false;
            if (endOffset != sequence.length() && endOffset == this.myLookAhead.nextRecordSeparatorOffset(template, sequence, endOffset)) {
                endOffset += template.recordSeparator.length();
                hasRecordSeparator = true;
            }
            TextRange recordRange = new TextRange(startOffset, endOffset);
            List titleAndValues = (List)titleAndValuesRef.get();
            return firstColumnIsTitle && titleAndValues.size() < 2 ? null : new CsvRecord(recordRange, titleAndValues, hasRecordSeparator);
        }

        private int parseValues(Ref<List<ValueRange>> valuesRef, CharSequence sequence, int startOffset, CsvRecordFormat template) {
            assert (valuesRef.isNull());
            int valuesEndOffset = startOffset;
            ArrayList values = ContainerUtil.newArrayList();
            Ref valueRef = Ref.create();
            boolean first = true;
            while (valuesEndOffset != this.myLookAhead.valuesEndOffset(template, sequence, valuesEndOffset)) {
                int valueEndOffset;
                if (!first) {
                    if (valuesEndOffset != this.myLookAhead.nextValueSeparatorOffset(template, sequence, valuesEndOffset)) {
                        return -1;
                    }
                    valuesEndOffset += template.valueSeparator.length();
                }
                if ((valueEndOffset = this.parseValue((Ref<ValueRange>)valueRef, sequence, valuesEndOffset, template)) == -1) {
                    return -1;
                }
                values.add(ObjectUtils.assertNotNull((Object)valueRef.get()));
                valuesEndOffset = valueEndOffset;
                first = false;
            }
            if (values.isEmpty()) {
                return -1;
            }
            valuesRef.set((Object)values);
            return valuesEndOffset;
        }

        private int parseValue(Ref<ValueRange> value, CharSequence sequence, int startOffset, CsvRecordFormat template) {
            int endOffset;
            int valueStartOffset = endOffset = template.trimWhitespace ? this.skipWhitespaceUpToNextDelimiterOrRecordSeparator(template, sequence, startOffset) : startOffset;
            CsvRecordFormat.Quotes detectedQuotes = null;
            for (CsvRecordFormat.Quotes quotes : template.quotes) {
                if (!StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)quotes.leftQuote)) continue;
                detectedQuotes = quotes;
                break;
            }
            if (detectedQuotes == null) {
                int valueEndOffset;
                endOffset = valueEndOffset = this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, valueStartOffset);
                while (template.trimWhitespace && valueEndOffset > valueStartOffset && Character.isWhitespace(sequence.charAt(valueEndOffset - 1))) {
                    --valueEndOffset;
                }
                value.set((Object)new ValueRange(valueStartOffset, valueEndOffset));
            } else {
                int valueEndOffset;
                Matcher matcher = this.allInQuotesPattern(detectedQuotes).matcher(sequence);
                boolean matched = matcher.find(valueStartOffset + detectedQuotes.leftQuote.length());
                assert (matched);
                endOffset = valueEndOffset = matcher.end(0);
                if (StringUtil.startsWith((CharSequence)sequence, (int)valueEndOffset, (CharSequence)detectedQuotes.rightQuote)) {
                    endOffset = valueEndOffset += detectedQuotes.rightQuote.length();
                    value.set((Object)new QuotedValueRange(valueStartOffset, valueEndOffset, detectedQuotes));
                } else {
                    if (sequence.length() != endOffset) {
                        return -1;
                    }
                    value.set((Object)new ImproperQuotedValueRange(valueStartOffset, valueEndOffset, detectedQuotes));
                }
                if (template.trimWhitespace) {
                    endOffset = this.skipWhitespaceUpToNextDelimiterOrRecordSeparator(template, sequence, endOffset);
                }
            }
            assert (!value.isNull());
            return endOffset;
        }

        @NotNull
        private Pattern allInQuotesPattern(@NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvDocumentDataHookUp$Parser", "allInQuotesPattern"));
            }
            Pattern pattern = this.myCompiledPatterns.get(quotes);
            if (pattern == null) {
                pattern = Pattern.compile("(?:" + Pattern.quote(quotes.rightQuoteEscaped) + "|" + "(?!" + Pattern.quote(quotes.rightQuote) + ")." + ")*+", 32);
                this.myCompiledPatterns.put(quotes, pattern);
            }
            Pattern pattern2 = pattern;
            if (pattern2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp$Parser", "allInQuotesPattern"));
            }
            return pattern2;
        }

        private int skipWhitespaceUpToNextDelimiterOrRecordSeparator(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int offset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvDocumentDataHookUp$Parser", "skipWhitespaceUpToNextDelimiterOrRecordSeparator"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$Parser", "skipWhitespaceUpToNextDelimiterOrRecordSeparator"));
            }
            return Parser.skipWhitespace(sequence, offset, this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, offset));
        }

        private static String unescapeQuotes(CharSequence s, CsvRecordFormat.Quotes quotes) {
            String[] escapedQuotes = new String[]{quotes.leftQuoteEscaped, quotes.rightQuoteEscaped};
            String[] unescapedQuotes = new String[]{quotes.leftQuote, quotes.rightQuote};
            return StringUtil.replace((String)String.valueOf(s), (String[])escapedQuotes, (String[])unescapedQuotes);
        }

        private static int skipWhitespace(CharSequence sequence, int offset, int maxOffset) {
            maxOffset = Math.min(maxOffset, sequence.length());
            while (offset < maxOffset && Character.isWhitespace(sequence.charAt(offset))) {
                ++offset;
            }
            return offset;
        }

        private static int skipLine(CharSequence sequence, int offset) {
            while (offset < sequence.length() && sequence.charAt(offset) != '\n') {
                ++offset;
            }
            if (offset < sequence.length()) {
                ++offset;
            }
            return offset;
        }

        private static class ImproperQuotedValueRange
        extends QuotedValueRange {
            public ImproperQuotedValueRange(int startOffset, int endOffset, @NotNull CsvRecordFormat.Quotes quotes) {
                if (quotes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvDocumentDataHookUp$Parser$ImproperQuotedValueRange", "<init>"));
                }
                super(startOffset, endOffset, quotes);
            }

            @Override
            protected TextRange unquotedRange() {
                return new TextRange(this.getStartOffset() + this.myQuotes.leftQuote.length(), this.getEndOffset());
            }
        }

        private static class QuotedValueRange
        extends ValueRange {
            protected final CsvRecordFormat.Quotes myQuotes;

            public QuotedValueRange(int startOffset, int endOffset, @NotNull CsvRecordFormat.Quotes quotes) {
                if (quotes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvDocumentDataHookUp$Parser$QuotedValueRange", "<init>"));
                }
                super(startOffset, endOffset);
                this.myQuotes = quotes;
            }

            @Override
            public CharSequence value(CharSequence s) {
                return Parser.unescapeQuotes(this.unquotedRange().subSequence(s), this.myQuotes);
            }

            protected TextRange unquotedRange() {
                return new TextRange(this.getStartOffset() + this.myQuotes.leftQuote.length(), this.getEndOffset() - this.myQuotes.rightQuote.length());
            }
        }
    }

    static class ValueRange
    extends TextRange {
        public ValueRange(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        public CharSequence value(CharSequence s) {
            return this.subSequence(s);
        }
    }

    static class CsvRecord {
        public final TextRange range;
        public final List<ValueRange> values;
        public final boolean hasRecordSeparator;

        CsvRecord(@NotNull TextRange range, @NotNull List<ValueRange> values, boolean hasRecordSeparator) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvRecord", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvRecord", "<init>"));
            }
            this.range = range;
            this.values = values;
            this.hasRecordSeparator = hasRecordSeparator;
        }
    }

    static class CsvMarkup
    extends DocumentDataHookUp.DataMarkup {
        private final List<CsvRecord> myRecords;
        private final CsvRecord myHeader;
        private final CsvFormatter myFormatter;

        CsvMarkup(@NotNull CsvFormatter formatter, @NotNull CharSequence sequence, @NotNull List<CsvRecord> records, @Nullable CsvRecord header, boolean rowNumbers) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            super(CsvMarkup.columnsFrom(sequence, records, header, rowNumbers), CsvMarkup.rowsFrom(sequence, records, rowNumbers));
            this.myFormatter = formatter;
            this.myHeader = header;
            this.myRecords = records;
        }

        @Override
        protected boolean deleteRows(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Row> sortedRows) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "deleteRows"));
            }
            if (sortedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedRows", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "deleteRows"));
            }
            for (DataConsumer.Row row : sortedRows) {
                session.delete(this.myRecords.get((int)(row.rowNum - 1)).range);
            }
            return true;
        }

        @Override
        protected boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertRow"));
            }
            return this.insertRow(session, JBIterable.of((Object[])new Object[]{null}).repeat(this.columns.size()).toList());
        }

        @Override
        protected boolean cloneRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Row row) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "cloneRow"));
            }
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "cloneRow"));
            }
            return this.insertRow(session, (List<?>)ContainerUtil.immutableList((Object[])row.values));
        }

        @Override
        protected boolean deleteColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> sortedColumns) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "deleteColumns"));
            }
            if (sortedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedColumns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "deleteColumns"));
            }
            List<DataConsumer.Column> columnsToLeave = this.getColumnsToLeave(sortedColumns);
            if (this.myHeader != null) {
                this.leaveColumns(session, columnsToLeave, this.myHeader);
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                this.leaveColumns(session, columnsToLeave, this.myRecords.get(i), (DataConsumer.Row)this.rows.get(i));
            }
            return true;
        }

        @Override
        protected boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertColumn"));
            }
            return this.insertColumn(session, null);
        }

        @Override
        protected boolean cloneColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Column column) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "cloneColumn"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "cloneColumn"));
            }
            return this.insertColumn(session, column);
        }

        @Override
        protected boolean update(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Row> sortedRows, @NotNull List<DataConsumer.Column> sortedColumns, @Nullable Object newValue) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "update"));
            }
            if (sortedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedRows", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "update"));
            }
            if (sortedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedColumns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "update"));
            }
            String newValueText = this.myFormatter.formatValue(newValue);
            for (DataConsumer.Row row : sortedRows) {
                List<ValueRange> valueRanges = this.myRecords.get((int)(row.rowNum - 1)).values;
                for (DataConsumer.Column column : sortedColumns) {
                    int rangeIdx = column.columnNum + (row instanceof NamedRow ? 1 : 0);
                    session.replace(valueRanges.get(rangeIdx), newValueText);
                }
            }
            return true;
        }

        private boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session, @Nullable DataConsumer.Column column) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertColumn"));
            }
            if (this.myHeader != null) {
                ValueRange lastColumnRange = (ValueRange)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(this.myHeader.values)));
                String columnName = this.myFormatter.formatHeaderValue(column != null ? column.name : "column" + (this.columns.size() + 1));
                session.insert(this.myFormatter.headerValueSeparator() + columnName, lastColumnRange.getEndOffset());
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                ValueRange lastValueRange = (ValueRange)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(this.myRecords.get((int)i).values)));
                String valueText = this.myFormatter.formatValue(column != null ? column.getValue((DataConsumer.Row)this.rows.get(i)) : null);
                session.insert(this.myFormatter.valueSeparator() + valueText, lastValueRange.getEndOffset());
            }
            return true;
        }

        private boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<?> values) {
            int offset;
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertRow"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertRow"));
            }
            CsvRecord lastRecord = (CsvRecord)ObjectUtils.chooseNotNull((Object)ContainerUtil.getLastItem(this.myRecords), (Object)this.myHeader);
            int n = offset = lastRecord != null ? lastRecord.range.getEndOffset() : 0;
            if (lastRecord != null && !lastRecord.hasRecordSeparator) {
                session.insert(this.myFormatter.recordSeparator(), offset);
            }
            if (this.myFormatter.requiresRowNumbers()) {
                String newRecordName = null;
                DataConsumer.Row lastRow = (DataConsumer.Row)ContainerUtil.getLastItem((List)this.rows);
                if (lastRow instanceof NamedRow) {
                    try {
                        newRecordName = String.valueOf(Long.parseLong(((NamedRow)lastRow).name) + 1L);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (newRecordName == null) {
                    newRecordName = String.valueOf(lastRow != null ? lastRow.rowNum + 1 : 1);
                }
                values = ContainerUtil.prepend(values, (Object[])new Object[]{newRecordName});
            }
            session.insert(this.myFormatter.formatRecord(values), offset);
            return true;
        }

        private void leaveColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> columns, @NotNull CsvRecord record, final @NotNull DataConsumer.Row row) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (record == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (columns.isEmpty()) {
                session.delete(record.range);
                return;
            }
            List values = ContainerUtil.map(columns, (Function)new Function<DataConsumer.Column, Object>(){

                public Object fun(DataConsumer.Column column) {
                    return column.getValue(row);
                }
            });
            if (row instanceof NamedRow) {
                values = ContainerUtil.prepend((List)values, (Object[])new Object[]{((NamedRow)row).name});
            }
            String recordText = this.myFormatter.formatRecord(values);
            session.replace(record.range, recordText);
            if (record.hasRecordSeparator) {
                session.insert(this.myFormatter.recordSeparator(), record.range.getEndOffset());
            }
        }

        private void leaveColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> columns, @NotNull CsvRecord headerRecord) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (headerRecord == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerRecord", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            List<ValueRange> values = headerRecord.values;
            int valuesStart = values.get(this.myFormatter.requiresRowNumbers() ? 1 : 0).getStartOffset();
            int valuesEnd = values.get(values.size() - 1).getEndOffset();
            StringBuilder sb = new StringBuilder();
            for (DataConsumer.Column column : columns) {
                sb.append(this.myFormatter.formatHeaderValue(column.name)).append(this.myFormatter.headerValueSeparator());
            }
            sb.setLength(sb.length() != 0 ? sb.length() - this.myFormatter.headerValueSeparator().length() : sb.length());
            session.replace(TextRange.create((int)valuesStart, (int)valuesEnd), sb.toString());
        }

        @NotNull
        private List<DataConsumer.Column> getColumnsToLeave(@NotNull List<DataConsumer.Column> orderedColumnsToDelete) {
            if (orderedColumnsToDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderedColumnsToDelete", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "getColumnsToLeave"));
            }
            ArrayList columnsToLeave = ContainerUtil.newArrayListWithCapacity((int)(this.columns.size() - orderedColumnsToDelete.size()));
            Iterator<DataConsumer.Column> toDeleteIterator = orderedColumnsToDelete.iterator();
            Iterator allColumnsIterator = this.columns.iterator();
            block0: while (allColumnsIterator.hasNext()) {
                DataConsumer.Column column;
                DataConsumer.Column toDelete;
                DataConsumer.Column column2 = toDelete = toDeleteIterator.hasNext() ? toDeleteIterator.next() : null;
                while (!(column = (DataConsumer.Column)allColumnsIterator.next()).equals(toDelete)) {
                    columnsToLeave.add(column);
                    if (allColumnsIterator.hasNext()) continue;
                    continue block0;
                }
            }
            ArrayList arrayList = columnsToLeave;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "getColumnsToLeave"));
            }
            return arrayList;
        }

        @NotNull
        private static List<DataConsumer.Column> columnsFrom(@NotNull CharSequence sequence, @NotNull List<CsvRecord> records, @Nullable CsvRecord header, boolean rowNameColumn) {
            int columnCount;
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "columnsFrom"));
            }
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "columnsFrom"));
            }
            int n = header != null ? header.values.size() : (columnCount = records.isEmpty() ? 0 : records.get((int)0).values.size());
            if (columnCount > 0 && rowNameColumn) {
                --columnCount;
            }
            List<String> columnNames = header != null && rowNameColumn ? CsvDocumentDataHookUp.values(sequence, header.values.subList(1, header.values.size())) : (header != null ? CsvDocumentDataHookUp.values(sequence, header.values) : null);
            ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String name = columnNames == null ? "C" + (i + 1) : columnNames.get(i);
                columns.add(new DataConsumer.Column(i, name, 239, "TEXT", "java.lang.String"));
            }
            ArrayList arrayList = columns;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "columnsFrom"));
            }
            return arrayList;
        }

        @NotNull
        private static List<DataConsumer.Row> rowsFrom(@NotNull CharSequence sequence, @NotNull List<CsvRecord> records, boolean named) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "rowsFrom"));
            }
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "rowsFrom"));
            }
            ArrayList rows = ContainerUtil.newArrayListWithCapacity((int)records.size());
            for (int i = 0; i < records.size(); ++i) {
                DataConsumer.Row row;
                List<ValueRange> valuesList = records.get((int)i).values;
                int rowNum = i + 1;
                if (named) {
                    Object[] values = CsvDocumentDataHookUp.values(sequence, valuesList.subList(1, valuesList.size())).toArray();
                    String name = valuesList.get(0).value(sequence).toString();
                    row = new NamedRow(rowNum, name, values);
                } else {
                    row = new DataConsumer.Row(rowNum, CsvDocumentDataHookUp.values(sequence, valuesList).toArray());
                }
                rows.add(row);
            }
            ArrayList arrayList = rows;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "rowsFrom"));
            }
            return arrayList;
        }
    }
}

