/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.openapi.Disposable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransposedGridModel<Row, Column>
implements GridModel<Row, Column> {
    @NotNull
    private final GridModel<Column, Row> myDelegate;

    public static <Row, Column> TransposedGridModel<Row, Column> create(@NotNull GridModel<Column, Row> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/datagrid/TransposedGridModel", "create"));
        }
        return new TransposedGridModel<Row, Column>(delegate);
    }

    public TransposedGridModel(@NotNull GridModel<Column, Row> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/datagrid/TransposedGridModel", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<Row> row, ModelIndex<Column> column) {
        return this.myDelegate.getValueAt(column, row);
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<Row> rowIndices, @NotNull ModelIndexSet<Column> columnIndices, @Nullable Object what) {
        if (rowIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/TransposedGridModel", "allValuesEqualTo"));
        }
        if (columnIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/TransposedGridModel", "allValuesEqualTo"));
        }
        return this.myDelegate.allValuesEqualTo(columnIndices, rowIndices, what);
    }

    @Override
    @Nullable
    public Row getRow(@NotNull ModelIndex<Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/TransposedGridModel", "getRow"));
        }
        return this.myDelegate.getColumn(row);
    }

    @Override
    @Nullable
    public Column getColumn(@NotNull ModelIndex<Column> column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/TransposedGridModel", "getColumn"));
        }
        return this.myDelegate.getRow(column);
    }

    @Override
    @NotNull
    public List<Row> getRows(@NotNull ModelIndexSet<Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/TransposedGridModel", "getRows"));
        }
        List<Row> list = this.myDelegate.getColumns(rows);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/TransposedGridModel", "getRows"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Column> getColumns(@NotNull ModelIndexSet<Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/TransposedGridModel", "getColumns"));
        }
        List<Column> list = this.myDelegate.getRows(columns);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/TransposedGridModel", "getColumns"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Column> getColumns() {
        List<Column> list = this.myDelegate.getRows();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/TransposedGridModel", "getColumns"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Row> getRows() {
        List<Row> list = this.myDelegate.getColumns();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/TransposedGridModel", "getRows"));
        }
        return list;
    }

    @Override
    @NotNull
    public ModelIndexSet<Column> getColumnIndices() {
        ModelIndexSet<Column> modelIndexSet = this.myDelegate.getRowIndices();
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/TransposedGridModel", "getColumnIndices"));
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<Row> getRowIndices() {
        ModelIndexSet<Row> modelIndexSet = this.myDelegate.getColumnIndices();
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/TransposedGridModel", "getRowIndices"));
        }
        return modelIndexSet;
    }

    @Override
    public int getColumnCount() {
        return this.myDelegate.getRowCount();
    }

    @Override
    public int getRowCount() {
        return this.myDelegate.getColumnCount();
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<Row> rowIdx) {
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/datagrid/TransposedGridModel", "isValidRowIdx"));
        }
        return this.myDelegate.isValidColumnIdx(rowIdx);
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<Column> columnIdx) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/datagrid/TransposedGridModel", "isValidColumnIdx"));
        }
        return this.myDelegate.isValidRowIdx(columnIdx);
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myDelegate.isUpdatingNow();
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<Row, Column> l, @NotNull Disposable disposable) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/datagrid/TransposedGridModel", "addListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/datagrid/TransposedGridModel", "addListener"));
        }
        this.myDelegate.addListener(TransposedListener.create(l), disposable);
    }

    private static class TransposedListener<Row, Column>
    implements GridModel.Listener<Row, Column> {
        @NotNull
        private final GridModel.Listener<Column, Row> myDelegate;

        public static <Row, Column> TransposedListener<Row, Column> create(@NotNull GridModel.Listener<Column, Row> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/datagrid/TransposedGridModel$TransposedListener", "create"));
            }
            return new TransposedListener<Row, Column>(delegate);
        }

        public TransposedListener(@NotNull GridModel.Listener<Column, Row> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/datagrid/TransposedGridModel$TransposedListener", "<init>"));
            }
            this.myDelegate = delegate;
        }

        @Override
        public void columnsAdded(ModelIndexSet<Column> columns) {
            this.myDelegate.rowsAdded(columns);
        }

        @Override
        public void columnsRemoved(ModelIndexSet<Column> columns) {
            this.myDelegate.rowsRemoved(columns);
        }

        @Override
        public void rowsAdded(ModelIndexSet<Row> rows) {
            this.myDelegate.columnsAdded(rows);
        }

        @Override
        public void rowsRemoved(ModelIndexSet<Row> rows) {
            this.myDelegate.columnsRemoved(rows);
        }

        @Override
        public void cellsUpdated(ModelIndexSet<Row> rows, ModelIndexSet<Column> columns) {
            this.myDelegate.cellsUpdated(columns, rows);
        }
    }
}

