/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.diff.Migrator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiffElement
extends DiffElement<DbElement> {
    public static final String IGNORE_ORDER = "IGNORE_ORDER";
    public static final String IGNORE_CASE = "IGNORE_CASE";
    private final DbElement myElement;
    private DirDiffSettings mySettings;

    public DbDiffElement(DbElement element) {
        this.myElement = element;
    }

    public String getPresentablePath() {
        return this.myElement.getDataSource().getName() + ":/" + this.getPath();
    }

    public String getPath() {
        return this.getPath(this.getValue());
    }

    private String getPath(DbElement value) {
        if (value == null) {
            return "";
        }
        String name = this.getIdentifierMode().apply(value.getName());
        DbElement parent = value.getDbParent();
        if (value instanceof DbColumn) {
            return this.getPath(parent) + this.getSeparator() + name;
        }
        if (value instanceof DbTable) {
            return this.getPath(parent) + name;
        }
        return name.isEmpty() ? this.getPath(parent) : name + this.getSeparator();
    }

    @NotNull
    public String getName() {
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                String elementName = DbDiffElement.this.myElement.getName();
                if (StringUtil.isEmpty((String)elementName)) {
                    if (DbDiffElement.this.myElement instanceof DbForeignKey) {
                        elementName = "foreign key";
                    } else if (DbDiffElement.this.myElement instanceof DbTableKey) {
                        elementName = DasUtil.getPrimaryKey((DasTable)((DbTableKey)DbDiffElement.this.myElement).getTable()) == DbDiffElement.this.myElement ? "primary key" : "key";
                    } else if (DbDiffElement.this.myElement instanceof DbIndex) {
                        boolean unique = ((DbIndex)DbDiffElement.this.myElement).isUnique();
                        elementName = unique ? "unique index" : "index";
                    }
                }
                return DbDiffElement.this.getIdentifierMode().apply(elementName);
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbDiffElement", "getName"));
        }
        return string;
    }

    public long getSize() {
        return -1L;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public FileType getFileType() {
        return SqlLanguage.INSTANCE.getAssociatedFileType();
    }

    protected Editor createViewComponentEditor(Project project, @Nullable byte[] content, @Nullable FileType fileType) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        if (editorFactory == null) {
            return null;
        }
        Pair<Document, PsiFile> pair = this.createDocumentAndFile(content);
        EditorEx editor = (EditorEx)editorFactory.createViewer((Document)pair.first, project);
        Language language = DbSqlUtil.getSqlDialect(this.myElement);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)((PsiFile)pair.second).getViewProvider().getVirtualFile());
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
        return editor;
    }

    public boolean isContainer() {
        return !(this.myElement.getDelegate() instanceof DasTableChild);
    }

    public DiffElement[] getChildren() {
        List list = ContainerUtil.map((Iterable)this.myElement.getDataSource().getModel().traverser().children((Object)this.myElement), (Function)new Function<DasObject, DiffElement>(){

            public DiffElement fun(DasObject object) {
                DbDiffElement element = new DbDiffElement((DbElement)object);
                element.setSettings(DbDiffElement.this.mySettings);
                return element;
            }
        });
        return list.isEmpty() ? EMPTY_ARRAY : list.toArray(new DiffElement[list.size()]);
    }

    public byte[] getContent() throws IOException {
        return (byte[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<byte[]>(){

            public byte[] compute() {
                String text = new DdlBuilder().sort(DbDiffElement.this.isIgnoreOrder()).keywordCase(DbDiffElement.this.getKeywordMode()).identifierCase(Casing.create((Case)DbDiffElement.this.getIdentifierMode(), (Case)DbDiffElement.this.getIdentifierMode())).element((DasObject)DbDiffElement.this.myElement).getStatement();
                return text.getBytes(DbDiffElement.this.getCharset());
            }
        });
    }

    private Pair<Document, PsiFile> createDocumentAndFile(byte[] content) {
        Project project = this.myElement.getProject();
        Language language = DbSqlUtil.getSqlDialect(this.myElement);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a." + this.getFileType().getDefaultExtension(), language, (CharSequence)StringUtil.convertLineSeparators((String)new String(content)), false, true);
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        if (virtualFile instanceof LightVirtualFile) {
            ((LightVirtualFile)virtualFile).setWritable(false);
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        return Pair.create((Object)document, (Object)psiFile);
    }

    protected DiffContent createDiffContent() throws IOException {
        final Pair<Document, PsiFile> pair = this.createDocumentAndFile(this.getContent());
        return new SimpleContent(new String(this.getContent(), this.getCharset()), this.getFileType()){

            public Document getDocument() {
                return (Document)pair.first;
            }

            public VirtualFile getFile() {
                return ((PsiFile)pair.second).getViewProvider().getVirtualFile();
            }
        };
    }

    @NotNull
    private Case getIdentifierMode() {
        Case case_ = this.isIgnoreCase() ? Case.LOWER : Case.MIXED;
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbDiffElement", "getIdentifierMode"));
        }
        return case_;
    }

    @NotNull
    private Case getKeywordMode() {
        Case case_ = this.isIgnoreCase() ? Case.UPPER : Case.MIXED;
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbDiffElement", "getKeywordMode"));
        }
        return case_;
    }

    private boolean isIgnoreOrder() {
        return (Boolean)this.getSettings().customSettings.get(IGNORE_ORDER);
    }

    private boolean isIgnoreCase() {
        return (Boolean)this.getSettings().customSettings.get(IGNORE_CASE);
    }

    @Nullable
    public DbElement getValue() {
        return this.myElement.isValid() ? this.myElement : null;
    }

    public Icon getIcon() {
        DbElement value = this.getValue();
        if (value == null) {
            return null;
        }
        Icon icon = value.getIcon();
        if (icon != null) {
            return icon;
        }
        return DbPresentation.getIcon((ObjectKind)value.getKind());
    }

    public DirDiffSettings getSettings() {
        return this.mySettings;
    }

    public void setSettings(DirDiffSettings settings) {
        this.mySettings = settings;
    }

    public void generateMigrationStatements(DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
        DbElement o = this.getValue();
        if (o == null) {
            return;
        }
        Migrator<DbElement> migrator = Migrator.getMigrator(o);
        if (migrator != null) {
            migrator.script(o, builder, addKeyBuilder, dropKeyBuilder, targetDialect);
        } else {
            String action = targetDialect == null ? "drop" : "create";
            builder.plain(String.format("-- todo %s %s: %s", action, o.getTypeName(), o.getName())).newLine();
        }
    }

    public String toString() {
        return "DbDiffElement{kind=" + this.myElement.getKind() + ", name=" + QNameUtil.getQualifiedName(this.myElement) + '}';
    }
}

