/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.util.EventDispatcher;
import java.awt.Rectangle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

class GridScrollingModel
implements ScrollingModel {
    private final JTable myView;
    private final JScrollPane myScrollPane;
    private final Editor myFakeEditor;
    private final EventDispatcher<VisibleAreaListener> myEventDispatcher;

    public GridScrollingModel(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/diff/GridScrollingModel", "<init>"));
        }
        this.myEventDispatcher = EventDispatcher.create(VisibleAreaListener.class);
        this.myView = (JTable)grid.getPreferredFocusedComponent();
        this.myFakeEditor = (Editor)Proxy.newProxyInstance(GridScrollingModel.class.getClassLoader(), new Class[]{Editor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new UnsupportedOperationException("Should not be called");
            }
        });
        this.myScrollPane = grid.getScrollPane();
        this.myScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private Rectangle myLastViewRect;

            @Override
            public void stateChanged(ChangeEvent event) {
                Rectangle viewRect = GridScrollingModel.this.getVisibleArea();
                VisibleAreaEvent visibleAreaEvent = new VisibleAreaEvent(GridScrollingModel.this.myFakeEditor, this.myLastViewRect, viewRect);
                this.myLastViewRect = viewRect;
                ((VisibleAreaListener)GridScrollingModel.this.myEventDispatcher.getMulticaster()).visibleAreaChanged(visibleAreaEvent);
            }
        });
    }

    @NotNull
    public Editor getFakeEditor() {
        Editor editor = this.myFakeEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/GridScrollingModel", "getFakeEditor"));
        }
        return editor;
    }

    @NotNull
    public Rectangle getVisibleArea() {
        Rectangle rectangle = this.myView.getVisibleRect();
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/GridScrollingModel", "getVisibleArea"));
        }
        return rectangle;
    }

    @NotNull
    public Rectangle getVisibleAreaOnScrollingFinished() {
        throw new UnsupportedOperationException("Implement me");
    }

    public void scrollToCaret(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollType", "com/intellij/database/diff/GridScrollingModel", "scrollToCaret"));
        }
        Rectangle rect = this.myView.getCellRect(this.myView.getSelectedRow(), this.myView.getSelectedColumn(), true);
        this.myView.scrollRectToVisible(rect);
    }

    public void scrollTo(@NotNull LogicalPosition pos, @NotNull ScrollType scrollType) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/database/diff/GridScrollingModel", "scrollTo"));
        }
        if (scrollType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollType", "com/intellij/database/diff/GridScrollingModel", "scrollTo"));
        }
        Rectangle rect = this.myView.getCellRect(pos.line, pos.column, true);
        this.myView.scrollRectToVisible(rect);
    }

    public void runActionOnScrollingFinished(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/diff/GridScrollingModel", "runActionOnScrollingFinished"));
        }
        throw new UnsupportedOperationException("Implement me");
    }

    public void disableAnimation() {
    }

    public void enableAnimation() {
    }

    public int getVerticalScrollOffset() {
        return this.myScrollPane.getVerticalScrollBar().getValue();
    }

    public int getHorizontalScrollOffset() {
        return this.myScrollPane.getHorizontalScrollBar().getValue();
    }

    public void scrollVertically(int scrollOffset) {
        this.myScrollPane.getVerticalScrollBar().setValue(scrollOffset);
    }

    public void scrollHorizontally(int scrollOffset) {
        this.myScrollPane.getHorizontalScrollBar().setValue(scrollOffset);
    }

    public void addVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/diff/GridScrollingModel", "addVisibleAreaListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/diff/GridScrollingModel", "removeVisibleAreaListener"));
        }
        this.myEventDispatcher.removeListener((EventListener)listener);
    }
}

