/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.diff.ObjectWrapper;
import com.intellij.database.diff.TableDiffBuilder;
import com.intellij.database.diff.TableDiffSettingsHolder;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TableDiffAdapter {
    private static final ObjectWrapper.HasherAndComparator<Object> DB_VALUE_HASHER = new ObjectWrapper.HasherAndComparator<Object>(){

        @Override
        public boolean equals(Object a, Object b) {
            return DbImplUtil.valuesEqual(a, b);
        }

        @Override
        public int hash(Object v) {
            return DbImplUtil.valueHashCode(v);
        }
    };

    public static TableDiffBuilder.Data adapt(@NotNull DataGrid grid1, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows1, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols1, @NotNull DataGrid grid2, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows2, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols2, @NotNull TableDiffSettingsHolder.Settings settings, @NotNull ProgressIndicator indicator, @NotNull TableDiffBuilder.TableDiffResult result) {
        if (grid1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid1", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (skippedRows1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedRows1", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (skippedCols1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCols1", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (grid2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid2", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (skippedRows2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedRows2", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (skippedCols2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCols2", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        return new TableDiffBuilder.Data(TableDiffAdapter.adapt(grid1, skippedRows1, skippedCols1, result.skippedRows1, result.skippedCols1), TableDiffAdapter.adapt(grid2, skippedRows2, skippedCols2, result.skippedRows2, result.skippedCols2), settings, indicator);
    }

    private static List<List<Object>> adapt(@NotNull DataGrid grid, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols, @NotNull TIntArrayList skippedVisRows, @NotNull TIntArrayList skippedVisCols) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (skippedRows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedRows", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (skippedCols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCols", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (skippedVisRows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedVisRows", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        if (skippedVisCols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedVisCols", "com/intellij/database/diff/TableDiffAdapter", "adapt"));
        }
        ArrayList values = ContainerUtil.newArrayList();
        List cols = TableDiffAdapter.difference(grid, grid.getVisibleColumns().asIterable(), skippedCols);
        List rows = TableDiffAdapter.difference(grid, grid.getVisibleRows().asIterable(), skippedRows);
        for (JBIterable band : TableDiffAdapter.iterateCells(rows, cols, !grid.isTransposed())) {
            ArrayList row = ContainerUtil.newArrayList();
            for (Pair cell : band) {
                row.add(new ObjectWrapper<Object>(grid.getDataModel().getValueAt((ModelIndex)cell.first, (ModelIndex)cell.second), DB_VALUE_HASHER));
            }
            values.add(row);
        }
        TableDiffAdapter.generateSkipped(grid, rows, grid.getDataModel().getRowCount(), !grid.isTransposed() ? skippedVisRows : skippedVisCols);
        TableDiffAdapter.generateSkipped(grid, cols, grid.getDataModel().getColumnCount(), grid.isTransposed() ? skippedVisRows : skippedVisCols);
        return values;
    }

    private static <T> void generateSkipped(@NotNull DataGrid grid, @NotNull Iterable<ModelIndex<T>> ids, int count, @NotNull TIntArrayList skipped) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/diff/TableDiffAdapter", "generateSkipped"));
        }
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/database/diff/TableDiffAdapter", "generateSkipped"));
        }
        if (skipped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipped", "com/intellij/database/diff/TableDiffAdapter", "generateSkipped"));
        }
        TIntHashSet existing = new TIntHashSet();
        for (ModelIndex<T> index : ids) {
            existing.add(index.toView(grid).asInteger());
        }
        for (int i = 0; i < count; ++i) {
            if (existing.contains(i)) continue;
            skipped.add(i);
        }
    }

    private static JBIterable<JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>>> iterateCells(final Iterable<ModelIndex<DataConsumer.Row>> rows, final Iterable<ModelIndex<DataConsumer.Column>> cols, boolean rowWise) {
        if (rowWise) {
            return JBIterable.from(rows).transform((Function)new Function<ModelIndex<DataConsumer.Row>, JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>>>(){

                public JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>> fun(ModelIndex<DataConsumer.Row> row) {
                    return TableDiffAdapter.iterateRowCells(row, cols);
                }
            });
        }
        return JBIterable.from(cols).transform((Function)new Function<ModelIndex<DataConsumer.Column>, JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>>>(){

            public JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>> fun(ModelIndex<DataConsumer.Column> col) {
                return TableDiffAdapter.iterateColumnCells(col, rows);
            }
        });
    }

    @NotNull
    private static JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>> iterateColumnCells(final ModelIndex<DataConsumer.Column> col, Iterable<ModelIndex<DataConsumer.Row>> rows) {
        JBIterable jBIterable = JBIterable.from(rows).transform((Function)new Function<ModelIndex<DataConsumer.Row>, Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>>(){

            public Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>> fun(ModelIndex<DataConsumer.Row> row) {
                return Pair.create(row, (Object)col);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffAdapter", "iterateColumnCells"));
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>> iterateRowCells(final ModelIndex<DataConsumer.Row> row, Iterable<ModelIndex<DataConsumer.Column>> cols) {
        JBIterable jBIterable = JBIterable.from(cols).transform((Function)new Function<ModelIndex<DataConsumer.Column>, Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>>>(){

            public Pair<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>> fun(ModelIndex<DataConsumer.Column> col) {
                return Pair.create((Object)row, col);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffAdapter", "iterateRowCells"));
        }
        return jBIterable;
    }

    private static <T> List<ModelIndex<T>> difference(final @NotNull DataGrid grid, @NotNull Iterable<ModelIndex<T>> visible, @NotNull Iterable<ModelIndex<T>> skipped) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/diff/TableDiffAdapter", "difference"));
        }
        if (visible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visible", "com/intellij/database/diff/TableDiffAdapter", "difference"));
        }
        if (skipped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipped", "com/intellij/database/diff/TableDiffAdapter", "difference"));
        }
        ArrayList res = ContainerUtil.newArrayList();
        TIntHashSet sset = new TIntHashSet();
        for (ModelIndex<T> index : skipped) {
            sset.add(index.asInteger());
        }
        for (ModelIndex<T> index : visible) {
            if (sset.contains(index.asInteger())) continue;
            res.add(index);
        }
        Collections.sort(res, new Comparator<ModelIndex<T>>(){

            @Override
            public int compare(ModelIndex<T> o1, ModelIndex<T> o2) {
                return Comparing.compare((int)o1.toView(grid).asInteger(), (int)o2.toView(grid).asInteger());
            }
        });
        return res;
    }

    public static TableDiffBuilder.TableDiffResult process(@NotNull DataGrid grid1, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows1, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols1, @NotNull DataGrid grid2, @NotNull Iterable<ModelIndex<DataConsumer.Row>> skippedRows2, @NotNull Iterable<ModelIndex<DataConsumer.Column>> skippedCols2, @NotNull TableDiffSettingsHolder.Settings settings, @NotNull ProgressIndicator indicator) {
        if (grid1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid1", "com/intellij/database/diff/TableDiffAdapter", "process"));
        }
        if (skippedRows1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedRows1", "com/intellij/database/diff/TableDiffAdapter", "process"));
        }
        if (skippedCols1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCols1", "com/intellij/database/diff/TableDiffAdapter", "process"));
        }
        if (grid2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid2", "com/intellij/database/diff/TableDiffAdapter", "process"));
        }
        if (skippedRows2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedRows2", "com/intellij/database/diff/TableDiffAdapter", "process"));
        }
        if (skippedCols2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCols2", "com/intellij/database/diff/TableDiffAdapter", "process"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/diff/TableDiffAdapter", "process"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/diff/TableDiffAdapter", "process"));
        }
        TableDiffBuilder.TableDiffResult result = new TableDiffBuilder.TableDiffResult();
        TableDiffBuilder.TableDiffResult subRes = TableDiffBuilder.process(TableDiffAdapter.adapt(grid1, skippedRows1, skippedCols1, grid2, skippedRows2, skippedCols2, settings, indicator, result));
        return result.apply(subRes);
    }
}

