/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.TableDiffColors;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableDiffColorSettingsPage
implements ColorSettingsPage {
    public static final AttributesDescriptor[] DESCRIPTORS = new AttributesDescriptor[]{new AttributesDescriptor("Fuzzy match - matched", TableDiffColors.TDIFF_FUZZY_MATCHED), new AttributesDescriptor("Fuzzy match - mismatched", TableDiffColors.TDIFF_FUZZY_MISMATCHED), new AttributesDescriptor("Excluded from diff", TableDiffColors.TDIFF_EXCLUDED_COLUMN)};

    @Nullable
    public Icon getIcon() {
        return AllIcons.Diff.Diff;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        PlainSyntaxHighlighter plainSyntaxHighlighter = new PlainSyntaxHighlighter();
        if (plainSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffColorSettingsPage", "getHighlighter"));
        }
        return plainSyntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if ("Matched text\n<ins>Inserted text</ins>\n<del>Removed text</del>\n<mod>Modified text</mod>\n<fm>Fuzzy matched <fmm>/mismatch/</fmm> text</fm>\n<exc>Excluded from diff</exc>\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffColorSettingsPage", "getDemoText"));
        }
        return "Matched text\n<ins>Inserted text</ins>\n<del>Removed text</del>\n<mod>Modified text</mod>\n<fm>Fuzzy matched <fmm>/mismatch/</fmm> text</fm>\n<exc>Excluded from diff</exc>\n";
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        HashMap map = ContainerUtil.newHashMap();
        map.put("ins", TableDiffColors.TDIFF_INSERTED);
        map.put("del", TableDiffColors.TDIFF_DELETED);
        map.put("mod", TableDiffColors.TDIFF_MODIFIED);
        map.put("fm", TableDiffColors.TDIFF_FUZZY_MATCHED);
        map.put("fmm", TableDiffColors.TDIFF_FUZZY_MISMATCHED);
        map.put("exc", TableDiffColors.TDIFF_EXCLUDED_COLUMN);
        return map;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (DESCRIPTORS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffColorSettingsPage", "getAttributeDescriptors"));
        }
        return DESCRIPTORS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffColorSettingsPage", "getColorDescriptors"));
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        if ("Table diff" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffColorSettingsPage", "getDisplayName"));
        }
        return "Table diff";
    }
}

