/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.database.editor.SqlInsertsTableFileEditor;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.database.vfs.fragment.SqlTableDataFragmentFile;
import com.intellij.database.vfs.fragment.TableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FragmentTableFileEditorProvider
extends WeighedFileEditorProvider {
    private static final String TYPE_ID = "table-data-fragment-editor";

    public static void openFragmentEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextRange range, @NotNull CsvFormat format) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        FragmentTableFileEditorProvider.openFragmentEditor(project, new CsvTableDataFragmentFile(file, range, format));
    }

    public static void openFragmentEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextRange range, @NotNull SqlLanguageDialect dialect) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        FragmentTableFileEditorProvider.openFragmentEditor(project, new SqlTableDataFragmentFile(file, range, dialect));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/FragmentTableFileEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/FragmentTableFileEditorProvider", "accept"));
        }
        return file instanceof TableDataFragmentFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/FragmentTableFileEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/FragmentTableFileEditorProvider", "createEditor"));
        }
        FileEditor fileEditor = FragmentTableFileEditorProvider.createEditor(project, (TableDataFragmentFile)file);
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/FragmentTableFileEditorProvider", "createEditor"));
        }
        return fileEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/editor/FragmentTableFileEditorProvider", "disposeEditor"));
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/database/editor/FragmentTableFileEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/FragmentTableFileEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/FragmentTableFileEditorProvider", "readState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/FragmentTableFileEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/editor/FragmentTableFileEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/FragmentTableFileEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/database/editor/FragmentTableFileEditorProvider", "writeState"));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if (TYPE_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/FragmentTableFileEditorProvider", "getEditorTypeId"));
        }
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/FragmentTableFileEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    private static void openFragmentEditor(@NotNull Project project, @NotNull TableDataFragmentFile fragmentFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        if (fragmentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragmentFile", "com/intellij/database/editor/FragmentTableFileEditorProvider", "openFragmentEditor"));
        }
        EditorWindow window = FileEditorManagerEx.getInstanceEx((Project)project).getCurrentWindow();
        window.split(0, true, (VirtualFile)fragmentFile, true);
    }

    @NotNull
    private static FileEditor createEditor(@NotNull Project project, @NotNull TableDataFragmentFile fragmentFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/FragmentTableFileEditorProvider", "createEditor"));
        }
        if (fragmentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragmentFile", "com/intellij/database/editor/FragmentTableFileEditorProvider", "createEditor"));
        }
        if (fragmentFile instanceof SqlTableDataFragmentFile) {
            SqlInsertsTableFileEditor sqlInsertsTableFileEditor = new SqlInsertsTableFileEditor(project, (SqlTableDataFragmentFile)fragmentFile);
            if (sqlInsertsTableFileEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/FragmentTableFileEditorProvider", "createEditor"));
            }
            return sqlInsertsTableFileEditor;
        }
        if (fragmentFile instanceof CsvTableDataFragmentFile) {
            CsvTableFileEditor csvTableFileEditor = new CsvTableFileEditor(project, (CsvTableDataFragmentFile)fragmentFile);
            if (csvTableFileEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/FragmentTableFileEditorProvider", "createEditor"));
            }
            return csvTableFileEditor;
        }
        throw new AssertionError((Object)fragmentFile);
    }
}

