/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataTypeFactory {
    private static final Pattern INNER_PATTERN = Pattern.compile("^\\s*(\\d+|\\*|max)\\s*(,\\s*(-?\\d+))?(chars?|bytes?|digits?)?\\s*$", 2);
    private static final ConcurrentMap<DataType, DataType> ourInterner = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
    private static final Set<DataType.Feature> NO_FEATURES = Collections.emptySet();

    @NotNull
    public static DataType of(@NotNull String specification) {
        if (specification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specification", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        Trio trio = DataTypeFactory.smartSplit(specification);
        if (trio.inner != null) {
            if (trio.primary.equalsIgnoreCase("enum") || trio.primary.equalsIgnoreCase("set")) {
                DataType dataType = DataTypeFactory.createEnumOrRet(specification);
                if (dataType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "of"));
                }
                return dataType;
            }
            Couple<String> packAndName = DataTypeFactory.splitPackAndName(trio.primary);
            Matcher m = INNER_PATTERN.matcher(trio.inner);
            boolean ok = m.matches();
            if (ok) {
                LengthUnit unit;
                String sizeStr = m.group(1);
                int size = sizeStr.equals("*") ? 0x7FFFFFFE : (sizeStr.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.parseInt(sizeStr));
                int scale = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
                LengthUnit lengthUnit = unit = m.group(4) != null ? LengthUnit.of((String)m.group(4)) : null;
                if (unit == null && scale != 0) {
                    unit = LengthUnit.DIGIT;
                }
                boolean explicitUnits = m.group(4) != null;
                DataType dataType = DataTypeFactory.of((String)packAndName.first, (String)packAndName.second, size, scale, unit, trio.suffix, explicitUnits, packAndName.first != null);
                if (dataType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "of"));
                }
                return dataType;
            }
            DataType dataType = DataTypeFactory.of((String)packAndName.first, (String)packAndName.second, trio.inner, trio.suffix);
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "of"));
            }
            return dataType;
        }
        Couple<String> packAndName = DataTypeFactory.splitPackAndName(specification);
        DataType dataType = DataTypeFactory.of((String)packAndName.first, (String)packAndName.second, -1, 0, LengthUnit.NONE, null, false, packAndName.first != null);
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        return dataType;
    }

    @Contract(pure=true)
    private static Trio smartSplit(@NotNull String specification) {
        if (specification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specification", "com/intellij/database/model/DataTypeFactory", "smartSplit"));
        }
        int n = specification.length();
        int p1 = Integer.MIN_VALUE;
        int p2 = Integer.MIN_VALUE;
        Stack<Character> stack = new Stack<Character>();
        block5: for (int i = 0; i < n; ++i) {
            char x;
            char c = specification.charAt(i);
            char c2 = x = stack.isEmpty() ? (char)'\u0000' : ((Character)stack.peek()).charValue();
            if (c == '(' && p1 < 0 && stack.isEmpty()) {
                p1 = i;
            }
            if (c == ')' && p1 >= 0 && p2 < 0 && stack.size() == 1 && x == ')') {
                p2 = i;
            }
            if (c == x) {
                stack.pop();
                if (!stack.isEmpty() || p2 <= 0) continue;
                break;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    stack.push(Character.valueOf(c));
                    continue block5;
                }
                case '[': {
                    stack.push(Character.valueOf(']'));
                    continue block5;
                }
                case '(': {
                    stack.push(Character.valueOf(')'));
                }
            }
        }
        Trio trio = new Trio();
        if (p2 > 0) {
            assert (p1 >= 0);
            trio.primary = specification.substring(0, p1).trim();
            trio.inner = specification.substring(p1 + 1, p2).trim();
            trio.suffix = specification.substring(p2 + 1).trim();
            if (trio.suffix.length() == 0) {
                trio.suffix = null;
            }
        } else {
            trio.primary = specification.trim();
        }
        assert (trio.primary != null);
        return trio;
    }

    @NotNull
    private static DataType createEnumOrRet(@NotNull String specification) {
        if (specification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specification", "com/intellij/database/model/DataTypeFactory", "createEnumOrRet"));
        }
        ArrayList res = ContainerUtil.newArrayList();
        int start = specification.indexOf("(");
        int end = StringUtil.lastIndexOf((CharSequence)specification, (char)')', (int)start, (int)specification.length());
        if (end > start && start > 1) {
            String meat = specification.substring(start + 1, end);
            for (String s : StringUtil.split((String)meat, (String)",")) {
                res.add(StringUtil.trim((String)s));
            }
            DataType dataType = DataTypeFactory.of(specification.substring(0, start), (List<String>)ContainerUtil.immutableList((List)res));
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "createEnumOrRet"));
            }
            return dataType;
        }
        DataType dataType = DataType.UNKNOWN;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "createEnumOrRet"));
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, @Nullable String vagueArg, @Nullable String suffix) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        DataType type = new DataType(schemaName, typeName, -1, 0, null, vagueArg, suffix, false, false, null, NO_FEATURES);
        DataType dataType = DataTypeFactory.intern(type);
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        DataType type = new DataType(schemaName, typeName, size, scale, sizeUnit, null, suffix, sizeUnitExplicit, custom, null, NO_FEATURES);
        DataType dataType = DataTypeFactory.intern(type);
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@NotNull String typeName, @NotNull List<String> values) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        DataType type = new DataType(null, typeName, -1, 0, null, null, null, false, false, values, NO_FEATURES);
        DataType dataType = DataTypeFactory.intern(type);
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataTypeFactory", "of"));
        }
        return dataType;
    }

    private static Couple<String> splitPackAndName(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/model/DataTypeFactory", "splitPackAndName"));
        }
        int dot = string.lastIndexOf(46);
        return dot < 0 ? Couple.of(null, (Object)string.trim()) : Couple.of((Object)string.substring(0, dot).trim(), (Object)string.substring(dot + 1).trim());
    }

    private static DataType intern(DataType dataType) {
        return dataType;
    }

    private static class Trio {
        String primary;
        String inner;
        String suffix;

        private Trio() {
        }
    }
}

