/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExplainPlanProvider {
    public static ExtensionPointName<ExplainPlanProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.explainPlanProvider");
    public static final ExplainPlanProvider NULL_PROVIDER = new NullExplainPlanProvider();

    @NotNull
    public static List<ExplainPlanProvider> getProvidersFor(@Nullable LocalDataSource dataSource) {
        ArrayList res = ContainerUtil.newArrayList();
        res.add(NULL_PROVIDER);
        if (dataSource != null) {
            for (ExplainPlanProvider provider : (ExplainPlanProvider[])Extensions.getExtensions(EP_NAME)) {
                if (!provider.isAvailableFor(dataSource)) continue;
                res.add(provider);
            }
        }
        Collections.sort(res, new Comparator<ExplainPlanProvider>(){

            @Override
            public int compare(ExplainPlanProvider o1, ExplainPlanProvider o2) {
                if (o1 == NULL_PROVIDER) {
                    return o2 == o1 ? 0 : 1;
                }
                if (o2 == NULL_PROVIDER) {
                    return -1;
                }
                return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
        });
        ArrayList arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ExplainPlanProvider", "getProvidersFor"));
        }
        return arrayList;
    }

    @NotNull
    public static ExplainPlanProvider getProviderByClassName(@Nullable String className) {
        if (StringUtil.isEmpty((String)className)) {
            ExplainPlanProvider explainPlanProvider = NULL_PROVIDER;
            if (explainPlanProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ExplainPlanProvider", "getProviderByClassName"));
            }
            return explainPlanProvider;
        }
        for (ExplainPlanProvider provider : (ExplainPlanProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.getClass().getCanonicalName().equals(className)) continue;
            ExplainPlanProvider explainPlanProvider = provider;
            if (explainPlanProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ExplainPlanProvider", "getProviderByClassName"));
            }
            return explainPlanProvider;
        }
        ExplainPlanProvider explainPlanProvider = NULL_PROVIDER;
        if (explainPlanProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ExplainPlanProvider", "getProviderByClassName"));
        }
        return explainPlanProvider;
    }

    @NotNull
    public abstract String getName();

    @Nullable
    public ConfigurableUi<LocalDataSource> createOptionsComponent() {
        return null;
    }

    public abstract boolean isAvailableFor(@NotNull LocalDataSource var1);

    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/plan/ExplainPlanProvider", "adjustModel"));
        }
        ScriptModel<V> scriptModel = model;
        if (scriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ExplainPlanProvider", "adjustModel"));
        }
        return scriptModel;
    }

    @Nullable
    public abstract DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx var1, @NotNull Consumer<PlanModel> var2, @NotNull LocalDataSource var3, @NotNull String var4, boolean var5);

    private static class NullExplainPlanProvider
    extends ExplainPlanProvider {
        private NullExplainPlanProvider() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("None" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ExplainPlanProvider$NullExplainPlanProvider", "getName"));
            }
            return "None";
        }

        @Override
        public boolean isAvailableFor(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/ExplainPlanProvider$NullExplainPlanProvider", "isAvailableFor"));
            }
            return true;
        }

        @Override
        @Nullable
        public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/ExplainPlanProvider$NullExplainPlanProvider", "createExplainRequest"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/ExplainPlanProvider$NullExplainPlanProvider", "createExplainRequest"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/ExplainPlanProvider$NullExplainPlanProvider", "createExplainRequest"));
            }
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/ExplainPlanProvider$NullExplainPlanProvider", "createExplainRequest"));
            }
            return null;
        }
    }
}

