/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.openapi.util.text.StringUtil;
import java.math.BigDecimal;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanModel {
    private final GenericNode myRoot;
    private final EnumSet<Feature> myUnsupported;

    public PlanModel(@NotNull GenericNode root, @NotNull EnumSet<Feature> unsupported) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/plan/PlanModel", "<init>"));
        }
        if (unsupported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsupported", "com/intellij/database/plan/PlanModel", "<init>"));
        }
        this.myRoot = root;
        this.myUnsupported = unsupported;
    }

    @NotNull
    public EnumSet<Feature> getUnsupported() {
        EnumSet<Feature> enumSet = this.myUnsupported;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel", "getUnsupported"));
        }
        return enumSet;
    }

    @NotNull
    public GenericNode getRoot() {
        GenericNode genericNode = this.myRoot;
        if (genericNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel", "getRoot"));
        }
        return genericNode;
    }

    public String dump() {
        return this.dump(false);
    }

    private static <E> String valueOf(E v) {
        return v == null ? null : v.toString();
    }

    public String dump(final boolean skeleton) {
        return new PlanVisitor(){
            int depth = 0;
            StringBuilder sb = new StringBuilder();
            {
                this.dump(PlanModel.this.getRoot());
            }

            private void appendProp(@NotNull String name, @Nullable String val) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/plan/PlanModel$1", "appendProp"));
                }
                this.sb.append("<").append(name).append(" = ").append(skeleton ? (val == null ? "N" : "*") : String.valueOf(val)).append(">");
            }

            @Override
            public void visit(@NotNull GenericNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/PlanModel$1", "visit"));
                }
                this.sb.append(node.getType().toString());
                this.appendProp("title", node.getTitle());
                this.appendProp("row_num", PlanModel.valueOf(node.getPlanNumRows()));
                this.appendProp("cost", PlanModel.valueOf(node.getTotalCost()));
                this.appendProp("startup_cost", PlanModel.valueOf(node.getStartupCost()));
            }

            @Override
            public void visit(@NotNull GenericAccessNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/PlanModel$1", "visit"));
                }
                this.visit((GenericNode)node);
                this.appendProp("relation", node.getRelation());
            }

            @Override
            public void visit(@NotNull IndexScanNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/PlanModel$1", "visit"));
                }
                this.visit((GenericAccessNode)node);
                this.appendProp("index", node.getIndex());
            }

            @Override
            public void visit(@NotNull SubQueryNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/PlanModel$1", "visit"));
                }
                this.visit((GenericNode)node);
                this.appendProp("scalar", PlanModel.valueOf(node.isScalar()));
                this.appendProp("correlated", PlanModel.valueOf(node.isCorrelated()));
            }

            public void dump(@NotNull GenericNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/PlanModel$1", "dump"));
                }
                for (int i = 0; i < this.depth; ++i) {
                    this.sb.append("  ");
                }
                node.accept(this);
                if (!skeleton) {
                    this.sb.append("[").append(node.getRawDescription()).append("]");
                }
                this.sb.append("\n");
                ++this.depth;
                for (GenericNode c : node.getChildren()) {
                    this.dump(c);
                }
                --this.depth;
            }
        }.sb.toString();
    }

    @NotNull
    public static GenericNode createNode(@NotNull NodeType type, @Nullable String title) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/PlanModel", "createNode"));
        }
        if (type.isKindOf(NodeType.SUBQUERY)) {
            SubQueryNode subQueryNode = new SubQueryNode(type, title);
            if (subQueryNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel", "createNode"));
            }
            return subQueryNode;
        }
        if (type.isKindOf(NodeType.INDEX_SCAN)) {
            IndexScanNode indexScanNode = new IndexScanNode(type, title);
            if (indexScanNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel", "createNode"));
            }
            return indexScanNode;
        }
        if (type.isKindOf(NodeType.ACCESS)) {
            GenericAccessNode genericAccessNode = new GenericAccessNode(type, title);
            if (genericAccessNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel", "createNode"));
            }
            return genericAccessNode;
        }
        GenericNode genericNode = new GenericNode(type, title);
        if (genericNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel", "createNode"));
        }
        return genericNode;
    }

    public static interface PlanVisitor {
        public void visit(@NotNull GenericNode var1);

        public void visit(@NotNull GenericAccessNode var1);

        public void visit(@NotNull IndexScanNode var1);

        public void visit(@NotNull SubQueryNode var1);
    }

    public static class IndexScanNode
    extends GenericAccessNode {
        private String myIndex;

        public IndexScanNode(@NotNull NodeType type, @Nullable String title) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/PlanModel$IndexScanNode", "<init>"));
            }
            super(type, title);
        }

        @Nullable
        public String getIndex() {
            return this.myIndex;
        }

        public void setIndex(@Nullable String index) {
            this.myIndex = index;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/plan/PlanModel$IndexScanNode", "accept"));
            }
            visitor.visit(this);
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (this.myIndex == null ? "" : " index: " + this.myIndex + ";");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$IndexScanNode", "getExtraInfo"));
            }
            return string;
        }
    }

    public static class GenericAccessNode
    extends GenericNode {
        private String myRelation;

        public GenericAccessNode(@NotNull NodeType type, @Nullable String title) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/PlanModel$GenericAccessNode", "<init>"));
            }
            super(type, title);
        }

        @Nullable
        public String getRelation() {
            return this.myRelation;
        }

        public void setRelation(@Nullable String relation) {
            this.myRelation = relation;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/plan/PlanModel$GenericAccessNode", "accept"));
            }
            visitor.visit(this);
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (this.myRelation == null ? "" : " table: " + this.myRelation + ";");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$GenericAccessNode", "getExtraInfo"));
            }
            return string;
        }
    }

    public static class SubQueryNode
    extends GenericNode {
        private boolean myScalar;
        private boolean myCorrelated;

        public SubQueryNode(@NotNull NodeType type, @Nullable String altTitle) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/PlanModel$SubQueryNode", "<init>"));
            }
            super(type, altTitle);
        }

        public boolean isScalar() {
            return this.myScalar;
        }

        public void setScalar(boolean scalar) {
            this.myScalar = scalar;
        }

        public boolean isCorrelated() {
            return this.myCorrelated;
        }

        public void setCorrelated(boolean correlated) {
            this.myCorrelated = correlated;
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (this.myScalar ? " Scalar;" : "") + (this.myCorrelated ? " Correlated;" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$SubQueryNode", "getExtraInfo"));
            }
            return string;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/plan/PlanModel$SubQueryNode", "accept"));
            }
            visitor.visit(this);
        }
    }

    public static class GenericNode {
        protected static final GenericNode[] NO_CHILDREN = new GenericNode[0];
        private final NodeType myType;
        private final String myTitle;
        private String myRawDescription;
        private GenericNode[] myChildren;
        private BigDecimal myNumRows;
        private Double myTotalCost;
        private Double myStartupCost;

        public GenericNode(@NotNull NodeType type, @Nullable String altTitle) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/PlanModel$GenericNode", "<init>"));
            }
            this.myRawDescription = "";
            this.myChildren = NO_CHILDREN;
            this.myType = type;
            this.myTitle = altTitle;
        }

        @NotNull
        public GenericNode[] getChildren() {
            if (this.myChildren == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$GenericNode", "getChildren"));
            }
            return this.myChildren;
        }

        @Nullable
        public BigDecimal getPlanNumRows() {
            return this.myNumRows;
        }

        public void setPlanNumRows(@Nullable BigDecimal numRows) {
            this.myNumRows = numRows;
        }

        public Double getTotalCost() {
            return this.myTotalCost;
        }

        public void setTotalCost(Double totalCost) {
            this.myTotalCost = totalCost;
        }

        public Double getStartupCost() {
            return this.myStartupCost;
        }

        public void setStartupCost(Double startupCost) {
            this.myStartupCost = startupCost;
        }

        @NotNull
        public String getRawDescription() {
            String string = this.myRawDescription;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$GenericNode", "getRawDescription"));
            }
            return string;
        }

        public void setRawDescription(@NotNull String rawDescription) {
            if (rawDescription == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawDescription", "com/intellij/database/plan/PlanModel$GenericNode", "setRawDescription"));
            }
            this.myRawDescription = rawDescription;
        }

        public void setChildren(@NotNull GenericNode[] children) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/plan/PlanModel$GenericNode", "setChildren"));
            }
            this.myChildren = children;
        }

        @NotNull
        public String getTitle() {
            String string = StringUtil.notNullize((String)this.myTitle, (String)this.myType.display);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$GenericNode", "getTitle"));
            }
            return string;
        }

        @NotNull
        public NodeType getType() {
            NodeType nodeType = this.myType;
            if (nodeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$GenericNode", "getType"));
            }
            return nodeType;
        }

        @NotNull
        protected String getDisplayTitleSuffix() {
            String string = this.myTitle == null ? "" : " (" + this.myTitle + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$GenericNode", "getDisplayTitleSuffix"));
            }
            return string;
        }

        @NotNull
        public String getDisplayTitle() {
            String string = StringUtil.capitalize((String)this.getType().display) + this.getDisplayTitleSuffix();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$GenericNode", "getDisplayTitle"));
            }
            return string;
        }

        @NotNull
        public String getExtraInfo() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/PlanModel$GenericNode", "getExtraInfo"));
            }
            return "";
        }

        public void accept(@NotNull PlanVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/plan/PlanModel$GenericNode", "accept"));
            }
            visitor.visit(this);
        }
    }

    public static enum NodeType {
        ROOT("root", null),
        UNKNOWN("unknown", null),
        OPERATION("operation", UNKNOWN),
        LOCK_ROWS("lock rows", OPERATION),
        SEQUENTIALLY("sequentially", OPERATION),
        DATA("data", UNKNOWN),
        VALUE("value", DATA),
        TABLE_FUNCTION("table function", DATA),
        ACCESS("access", DATA),
        ROWID_ACCESS("row id access", ACCESS),
        SEQ_SCAN("full scan", ACCESS),
        INDEX_SCAN("index scan", ACCESS),
        FULL_INDEX_SCAN("full index scan", INDEX_SCAN),
        UNIQUE_INDEX_SCAN("unique index scan", INDEX_SCAN),
        BITMAP_INDEX_SCAN("bitmap index scan", INDEX_SCAN),
        TEMPORARY("temporary", UNKNOWN),
        TRANSFORM("transformation", UNKNOWN),
        AGGREGATE("aggregate", TRANSFORM),
        FILTER("filter", TRANSFORM),
        GROUP_BY("group by", TRANSFORM),
        ORDER_BY("order by", TRANSFORM),
        SORT("sort", TRANSFORM),
        UNIQUE("unique", TRANSFORM),
        HASH_UNIQUE("hash unique", UNIQUE),
        SORT_UNIQUE("sort unique", UNIQUE),
        SET_OP("set operation", UNKNOWN),
        JOIN("join", SET_OP),
        NESTED_LOOPS("nested loops", SET_OP),
        MERGE_JOIN("merge join", SET_OP),
        HASH_JOIN("hash join", SET_OP),
        UNION_ALL("union all", SET_OP),
        UNION("union", SET_OP),
        EXCEPT("except", SET_OP),
        INTERSECT("intersection", SET_OP),
        SUBQUERY("subquery", UNKNOWN),
        STATEMENT("statement", null),
        SELECT("select", STATEMENT),
        MERGE("merge", STATEMENT),
        INSERT("insert", STATEMENT),
        UPDATE("update", STATEMENT),
        DELETE("delete", STATEMENT);

        public final String display;
        private final NodeType myParent;

        private NodeType(String display, NodeType parent) {
            this.display = display;
            this.myParent = parent;
        }

        public boolean isKindOf(@NotNull NodeType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/PlanModel$NodeType", "isKindOf"));
            }
            if (type == this) {
                return true;
            }
            if (this.myParent == null) {
                return false;
            }
            return this.myParent.isKindOf(type);
        }
    }

    public static enum Feature {
        NUM_ROWS,
        TOTAL_COST,
        STARTUP_COST;

    }
}

