/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.db2;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.plan.db2.Db2BuilderState;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntObjectIterator;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2PlanModelBuilder
extends AbstractPlanModelBuilder<Db2BuilderState> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = ContainerUtil.newHashMap();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = ContainerUtil.newHashMap();
    private static final Set<String> INDICES = ContainerUtil.newHashSet();
    private static final Set<String> RELATIONS = ContainerUtil.newHashSet();
    private final String myStatement;
    private Db2BuilderState.Shared myShared;

    public Db2PlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull String statement) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "<init>"));
        }
        super(owner, consumer, EnumSet.noneOf(PlanModel.Feature.class));
        this.myStatement = statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractStreams(@Nullable ResultSet resultSet, @NotNull Db2BuilderState.Shared shared) throws SQLException {
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "extractStreams"));
        }
        if (resultSet == null) {
            this.unsupportedFormat();
        }
        try {
            while (resultSet.next()) {
                Db2BuilderState.NodeId tid;
                Db2BuilderState.NodeId sid;
                int id = resultSet.getInt("STREAM_ID");
                String sourceType = resultSet.getString("SOURCE_TYPE");
                int sourceId = resultSet.getInt("SOURCE_ID");
                String targetType = resultSet.getString("TARGET_TYPE");
                int targetId = resultSet.getInt("TARGET_ID");
                String objectSchema = resultSet.getString("OBJECT_SCHEMA");
                String objectName = resultSet.getString("OBJECT_NAME");
                BigDecimal streamCount = resultSet.getBigDecimal("STREAM_COUNT");
                int predicateId = resultSet.getInt("PREDICATE_ID");
                if (sourceType.equals("O")) {
                    if (sourceId == -1) {
                        this.unsupportedFormat();
                    }
                    sid = new Db2BuilderState.NodeId(sourceId);
                } else {
                    sid = new Db2BuilderState.NodeId(new Db2BuilderState.ObjectId(objectSchema, objectName));
                }
                if (targetType.equals("O")) {
                    if (targetId == -1) {
                        this.unsupportedFormat();
                    }
                    tid = new Db2BuilderState.NodeId(targetId);
                } else {
                    if (sourceId == -1) {
                        this.unsupportedFormat();
                    }
                    tid = new Db2BuilderState.NodeId(new Db2BuilderState.ObjectId(objectSchema, objectName));
                }
                Db2BuilderState.Stream stream = new Db2BuilderState.Stream(id, streamCount, predicateId, sid, tid);
                ArrayList streams = shared.streamsByTargetId.get(tid);
                if (streams == null) {
                    streams = ContainerUtil.newArrayListWithCapacity((int)2);
                    shared.streamsByTargetId.put(tid, streams);
                }
                streams.add(stream);
                shared.streamBySourceId.put(sid, stream);
            }
        }
        finally {
            JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractOperators(@Nullable ResultSet resultSet, @NotNull Db2BuilderState.Shared shared) throws SQLException {
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "extractOperators"));
        }
        if (resultSet == null) {
            this.unsupportedFormat();
        }
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("OPERATOR_ID");
                String operatorType = resultSet.getString("OPERATOR_TYPE").trim();
                double totalCost = resultSet.getDouble("TOTAL_COST");
                double ioCost = resultSet.getDouble("IO_COST");
                double cpuCost = resultSet.getDouble("CPU_COST");
                double firstRowCost = resultSet.getDouble("FIRST_ROW_COST");
                Db2BuilderState.Operator operator = new Db2BuilderState.Operator(id, operatorType, totalCost, ioCost, cpuCost, firstRowCost);
                shared.operatorById.put(id, (Object)operator);
            }
        }
        finally {
            JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractObjects(@Nullable ResultSet resultSet, @NotNull Db2BuilderState.Shared shared) throws SQLException {
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "extractObjects"));
        }
        if (resultSet == null) {
            this.unsupportedFormat();
        }
        try {
            while (resultSet.next()) {
                String objectSchema = resultSet.getString("OBJECT_SCHEMA");
                String objectName = resultSet.getString("OBJECT_NAME");
                String objectType = resultSet.getString("OBJECT_TYPE");
                Db2BuilderState.Obj obj = new Db2BuilderState.Obj(new Db2BuilderState.ObjectId(objectSchema, objectName), objectType);
                shared.objectById.put(obj.id, obj);
            }
        }
        finally {
            JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
        }
    }

    private void fillSharedData(@NotNull Connection connection, @NotNull Db2BuilderState.Shared shared) {
        Statement statement;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "fillSharedData"));
        }
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "fillSharedData"));
        }
        try {
            statement = connection.createStatement();
        }
        catch (SQLException e) {
            throw new PlanRetrievalException("Failed create SQL statement", e);
        }
        try {
            String uuid = Db2PlanModelBuilder.randomShorterUUID().substring(0, 20);
            statement.execute("EXPLAIN PLAN SET QUERYTAG = '" + uuid + "' FOR " + this.myStatement);
            statement.execute("SELECT STREAM_ID, SOURCE_TYPE, SOURCE_ID, TARGET_TYPE, TARGET_ID, OBJECT_SCHEMA, OBJECT_NAME, STREAM_COUNT, PREDICATE_ID\nFROM SYSTOOLS.EXPLAIN_STATEMENT es\n  JOIN SYSTOOLS.EXPLAIN_STREAM ess\n    ON es.STMTNO = ess.STMTNO\n       AND es.SECTNO = ess.SECTNO\n       AND es.EXPLAIN_TIME = ess.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = ess.EXPLAIN_LEVEL WHERE QUERYTAG = '" + uuid + "'");
            this.extractStreams(statement.getResultSet(), shared);
            statement.execute("SELECT OPERATOR_ID, OPERATOR_TYPE, eos.TOTAL_COST, IO_COST, CPU_COST, FIRST_ROW_COST\nFROM SYSTOOLS.EXPLAIN_STATEMENT es\n  JOIN SYSTOOLS.EXPLAIN_OPERATOR eos\n    ON es.STMTNO = eos.STMTNO\n       AND es.SECTNO = eos.SECTNO\n       AND es.EXPLAIN_TIME = eos.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = eos.EXPLAIN_LEVEL WHERE QUERYTAG = '" + uuid + "'");
            this.extractOperators(statement.getResultSet(), shared);
            statement.execute("SELECT OBJECT_SCHEMA, OBJECT_NAME, OBJECT_TYPE\nFROM SYSTOOLS.EXPLAIN_STATEMENT es\n  JOIN SYSTOOLS.EXPLAIN_OBJECT eo\n    ON es.STMTNO = eo.STMTNO\n       AND es.SECTNO = eo.SECTNO\n       AND es.EXPLAIN_TIME = eo.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = eo.EXPLAIN_LEVEL\n       AND es.SOURCE_NAME = eo.SOURCE_NAME WHERE QUERYTAG = '" + uuid + "'");
            this.extractObjects(statement.getResultSet(), shared);
        }
        catch (SQLException e) {
            throw new PlanRetrievalException("Failed to execute plan retrieval SQL statement", e);
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    @Override
    @NotNull
    protected String dump() {
        StringBuilder sb = new StringBuilder();
        for (Db2BuilderState.Obj obj : this.myShared.objectById.values()) {
            sb.append(obj.id.schema).append(" ").append(obj.id.name).append(" ").append(obj.type).append("\n");
        }
        sb.append("\n");
        TIntObjectIterator it = this.myShared.operatorById.iterator();
        while (it.hasNext()) {
            it.advance();
            Db2BuilderState.Operator op = (Db2BuilderState.Operator)it.value();
            sb.append(op.id).append(" ").append(op.type).append(" ").append(op.cpuCost).append(" ").append(op.firstRowCost).append(" ").append(op.ioCost).append(" ").append(op.totalCost).append("\n");
        }
        sb.append("\n");
        HashSet visited = ContainerUtil.newHashSet();
        for (Db2BuilderState.Stream s : JBIterable.from(this.myShared.streamsByTargetId.values()).flatten(Functions.identity()).append(this.myShared.streamBySourceId.values())) {
            if (!visited.add(s)) continue;
            sb.append(s.id).append(" ").append(s.predId).append(" ").append(s.numRows).append(" ").append(s.sourceId.objectId).append(" ").append(s.sourceId.operatorId).append(" ").append(s.targetId.objectId).append(" ").append(s.targetId.operatorId).append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "dump"));
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull Connection connection) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "processRaw"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "processRaw"));
        }
        this.myShared = new Db2BuilderState.Shared();
        this.fillSharedData(connection, this.myShared);
        this.showRaw();
        this.parseRoot(new Db2BuilderState(this.myShared, null));
        this.modelReady();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseRawDescription"));
        }
        StringBuilder sb = new StringBuilder();
        for (Db2BuilderState.ObjectId id : state.nextObjectsIds()) {
            sb.append(id.toString()).append("; ");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseRawDescription"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseAccessRelation"));
        }
        List objs = ContainerUtil.filter(state.nextObjects(), (Condition)new Condition<Db2BuilderState.Obj>(){

            public boolean value(Db2BuilderState.Obj obj) {
                return RELATIONS.contains(obj.type);
            }
        });
        if (objs.size() > 1) {
            this.unsupportedFormat();
        }
        return objs.isEmpty() ? null : ((Db2BuilderState.Obj)objs.get((int)0)).id.toString();
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parsePlanNumRows"));
        }
        return state.prevStream == null ? null : state.prevStream.numRows;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseAccessIndex"));
        }
        List objs = ContainerUtil.filter(state.nextObjects(), (Condition)new Condition<Db2BuilderState.Obj>(){

            public boolean value(Db2BuilderState.Obj obj) {
                return INDICES.contains(obj.type);
            }
        });
        if (objs.size() > 1) {
            this.unsupportedFormat();
        }
        return objs.isEmpty() ? null : ((Db2BuilderState.Obj)objs.get((int)0)).id.toString();
    }

    @Nullable
    private static Db2BuilderState.Operator getOperator(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "getOperator"));
        }
        Db2BuilderState.NodeId nodeId = state.getCurrentNodeId();
        return nodeId == null || nodeId.operatorId == null ? null : (Db2BuilderState.Operator)state.shared.operatorById.get(nodeId.operatorId.intValue());
    }

    @Override
    protected void parsePlan(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parsePlan"));
        }
        Db2BuilderState.Operator op = Db2PlanModelBuilder.getOperator(state);
        if (op == null) {
            return;
        }
        this.openNode();
        this.parseSubPlans(state);
        String operatorType = op.type;
        PlanModel.NodeType type = TYPE_MAPPING.get(op.type);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        PlanModel.GenericNode node = this.createNode(state, type, operatorType);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseSubPlans"));
        }
        List<Db2BuilderState.Stream> streams = state.shared.streamsByTargetId.get(state.getCurrentNodeId());
        if (streams == null) {
            return;
        }
        for (Db2BuilderState.Stream stream : streams) {
            this.parsePlan(new Db2BuilderState(state.shared, stream));
        }
    }

    protected void parseRoot(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseRoot"));
        }
        Db2BuilderState.Operator op = Db2PlanModelBuilder.getOperator(state);
        if (op == null || !"RETURN".equals(op.type)) {
            this.unsupportedFormat();
        }
        List<Db2BuilderState.Stream> streams = state.shared.streamsByTargetId.get(state.getCurrentNodeId());
        this.openNode();
        for (Db2BuilderState.Stream stream : streams) {
            this.parseStatement(new Db2BuilderState(state.shared, stream));
        }
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    protected void parseStatement(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseStatement"));
        }
        Db2BuilderState.Operator op = Db2PlanModelBuilder.getOperator(state);
        if (op == null) {
            this.unsupportedFormat();
        }
        this.openNode();
        PlanModel.NodeType type = STATEMENT_MAPPING.get(op.type);
        if (type == null) {
            type = PlanModel.NodeType.SELECT;
            this.parsePlan(state);
        } else {
            this.parseSubPlans(state);
        }
        this.closeNode(this.createNode(state, type, null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseTotalCost"));
        }
        Db2BuilderState.Operator operator = Db2PlanModelBuilder.getOperator(state);
        return operator == null ? null : Double.valueOf(operator.totalCost);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseStartupCost"));
        }
        Db2BuilderState.Operator operator = Db2PlanModelBuilder.getOperator(state);
        return operator == null ? null : Double.valueOf(operator.firstRowCost);
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseSubqueryCorrelated"));
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Db2BuilderState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/db2/Db2PlanModelBuilder", "parseSubqueryScalar"));
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("TBFUNC", PlanModel.NodeType.TABLE_FUNCTION);
        TYPE_MAPPING.put("EISCAN", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("FETCH", PlanModel.NodeType.ROWID_ACCESS);
        TYPE_MAPPING.put("FILTER", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("GENROW", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("CMPEXP", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("GRPBY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("HSJOIN", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("IXAND", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("IXSCAN", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("MSJOIN", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("NLJOIN", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("RIDSCN", PlanModel.NodeType.ROWID_ACCESS);
        TYPE_MAPPING.put("RPD", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("SHIP", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("SORT", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("TBSCAN", PlanModel.NodeType.SEQ_SCAN);
        TYPE_MAPPING.put("TEMP", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("TQ", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("UNIQUE", PlanModel.NodeType.UNIQUE);
        TYPE_MAPPING.put("XISCAN", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("XSCAN", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("XANDOR", PlanModel.NodeType.UNKNOWN);
        STATEMENT_MAPPING.put("UPDATE", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("DELETE", PlanModel.NodeType.DELETE);
        STATEMENT_MAPPING.put("INSERT", PlanModel.NodeType.INSERT);
        INDICES.add("IX");
        INDICES.add("RX");
        INDICES.add("XI");
        INDICES.add("PI");
        INDICES.add("LI");
        INDICES.add("LX");
        INDICES.add("LP");
        RELATIONS.add("NK");
        RELATIONS.add("DP");
        RELATIONS.add("TA");
        RELATIONS.add("TF");
        RELATIONS.add("+A");
        RELATIONS.add("+C");
        RELATIONS.add("+F");
        RELATIONS.add("+G");
        RELATIONS.add("+N");
        RELATIONS.add("+T");
        RELATIONS.add("+V");
    }
}

