/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.sqlite;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlitePlanModelBuilder
extends AbstractPlanModelBuilder<MetaNode> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = ContainerUtil.newHashMap();
    private final String myStatement;
    private final List<PlanRow> myRows;
    private final TIntObjectHashMap<MetaNode> myStructure;
    private int myMaxId;

    public SqlitePlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull String statement) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "<init>"));
        }
        super(owner, consumer, EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST, PlanModel.Feature.NUM_ROWS));
        this.myRows = ContainerUtil.newArrayList();
        this.myStructure = new TIntObjectHashMap();
        this.myMaxId = 0;
        this.myStatement = statement;
    }

    private void getData(@NotNull Connection connection) {
        Statement statement;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "getData"));
        }
        try {
            statement = connection.createStatement();
        }
        catch (SQLException e) {
            throw new PlanRetrievalException("Failed create SQL statement", e);
        }
        ResultSet resultSet = null;
        try {
            statement.execute("EXPLAIN QUERY PLAN " + this.myStatement);
            resultSet = statement.getResultSet();
            if (resultSet == null) {
                throw new PlanRetrievalException("No data returned for plan query");
            }
            if (resultSet.getMetaData().getColumnCount() != 4) {
                throw new PlanRetrievalException("Database returned data in unknown format");
            }
            while (resultSet.next()) {
                this.myRows.add(new PlanRow(resultSet.getInt("selectid"), resultSet.getInt("order"), resultSet.getInt("from"), resultSet.getString("detail")));
            }
        }
        catch (SQLException e) {
            try {
                throw new PlanRetrievalException("Failed to execute plan retrieval SQL statement", e);
            }
            catch (Throwable throwable) {
                JdbcUtil.closeResultSetSafe(resultSet);
                JdbcUtil.closeStatementSafe((Statement)statement);
                throw throwable;
            }
        }
        JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
        JdbcUtil.closeStatementSafe((Statement)statement);
    }

    @Override
    @NotNull
    protected String dump() {
        StringBuilder sb = new StringBuilder();
        for (PlanRow row : this.myRows) {
            sb.append("\t").append(row.subqueryId).append("\t").append(row.order).append("\t").append(row.from).append("\t").append(row.detail).append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "dump"));
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull Connection connection) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "processRaw"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "processRaw"));
        }
        this.getData(connection);
        this.showRaw();
        this.parseStructure();
        this.cacheNodes();
        this.openNode();
        MetaNode root = (MetaNode)this.myStructure.get(0);
        this.parseStatement(root);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        this.modelReady();
    }

    private void cacheNodes() {
        this.openNode();
        TIntObjectIterator it = this.myStructure.iterator();
        while (it.hasNext()) {
            it.advance();
            this.parseSubPlans((MetaNode)it.value());
        }
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        this.resetRoot();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseRawDescription"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseRawDescription"));
        }
        return "";
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseAccessRelation"));
        }
        return null;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parsePlanNumRows"));
        }
        return null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseAccessIndex"));
        }
        return null;
    }

    @NotNull
    private PlanModel.GenericAccessNode buildTableScanNode(@NotNull ListIterator<String> tok) {
        PlanModel.GenericAccessNode res;
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildTableScanNode"));
        }
        String tableName = tok.next();
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "AS")) {
            tok.next();
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "USING")) {
            PlanModel.IndexScanNode node = (PlanModel.IndexScanNode)this.createNode(null, PlanModel.NodeType.INDEX_SCAN, null);
            res = node;
            if (SqlitePlanModelBuilder.checkOrRecover(tok, "INTEGER")) {
                this.consumeTokens(tok, "PRIMARY", "KEY");
            } else {
                String token = tok.next();
                if ("COVERING".equals(token)) {
                    token = tok.next();
                }
                this.checkToken(token, "INDEX");
                String indexName = tok.next();
                node.setIndex(indexName);
            }
            if (SqlitePlanModelBuilder.checkPrefSufAndRecover(tok, "(", "=?)")) {
                tok.next();
            }
        } else {
            res = (PlanModel.GenericAccessNode)this.createNode(null, PlanModel.NodeType.SEQ_SCAN, null);
        }
        res.setRelation(tableName);
        PlanModel.GenericAccessNode genericAccessNode = res;
        if (genericAccessNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildTableScanNode"));
        }
        return genericAccessNode;
    }

    @NotNull
    private PlanModel.GenericNode buildScanNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildScanNode"));
        }
        String token = tok.next();
        if (token.equals("TABLE")) {
            PlanModel.GenericAccessNode genericAccessNode = this.buildTableScanNode(tok);
            if (genericAccessNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildScanNode"));
            }
            return genericAccessNode;
        }
        this.checkToken("SUBQUERY", token);
        PlanModel.GenericNode genericNode = this.buildSubqueryScanNode(tok);
        if (genericNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildScanNode"));
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildSubqueryScanNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildSubqueryScanNode"));
        }
        this.parseSubquery(Integer.parseInt(tok.next()), true);
        PlanModel.GenericNode genericNode = this.createNode(null, PlanModel.NodeType.SUBQUERY, null);
        if (genericNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildSubqueryScanNode"));
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildNode(@NotNull ListIterator<String> tok) {
        PlanModel.GenericNode genericNode;
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildNode"));
        }
        try {
            String token = tok.next();
            PlanModel.GenericNode node = "SCAN".equals(token) || "SEARCH".equals(token) ? this.buildScanNode(tok) : ("EXECUTE".equals(token) ? this.buildSubqueryNode(tok) : ("COMPOUND".equals(token) ? this.buildCompoundNode(tok) : ("USE".equals(token) ? this.buildUseNode(tok) : this.createNode(null, PlanModel.NodeType.UNKNOWN, null))));
            if (SqlitePlanModelBuilder.checkPrefSufAndRecover(tok, "(~", null)) {
                node.setPlanNumRows(new BigDecimal(tok.next().substring(2)));
                this.consumeToken(tok, "rows)");
            }
            genericNode = node;
        }
        catch (NoSuchElementException e) {
            this.unsupportedFormat(e, null);
            PlanModel.GenericNode genericNode2 = this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            if (genericNode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildNode"));
            }
            return genericNode2;
        }
        catch (NumberFormatException e) {
            this.unsupportedFormat(e, null);
            PlanModel.GenericNode genericNode3 = this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            if (genericNode3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildNode"));
            }
            return genericNode3;
        }
        if (genericNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildNode"));
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildUseNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildUseNode"));
        }
        this.consumeTokens(tok, "TEMP", "B-TREE", "FOR");
        String op = tok.next();
        while (tok.hasNext()) {
            op = op + " " + tok.next();
        }
        PlanModel.NodeType type = TYPE_MAPPING.get(op);
        if (type == null) {
            type = PlanModel.NodeType.TRANSFORM;
        }
        PlanModel.GenericNode genericNode = this.createNode(null, type, type == PlanModel.NodeType.TRANSFORM ? op : null);
        if (genericNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildUseNode"));
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildCompoundNode(@NotNull ListIterator<String> tok) {
        PlanModel.NodeType type;
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildCompoundNode"));
        }
        this.consumeToken(tok, "SUBQUERIES");
        this.parseSubquery(Integer.parseInt(tok.next()), false);
        this.consumeToken(tok, "AND");
        this.parseSubquery(Integer.parseInt(tok.next()), false);
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "USING")) {
            this.consumeTokens(tok, "TEMP", "B-TREE");
        }
        String token = "";
        while (tok.hasNext()) {
            token = token + " " + tok.next();
        }
        if (!(token = token.trim()).startsWith("(") && token.endsWith(")")) {
            this.unsupportedFormat(token);
        }
        if ((type = TYPE_MAPPING.get(token = token.substring(1, token.length() - 1))) == null) {
            type = PlanModel.NodeType.SET_OP;
        }
        PlanModel.GenericNode genericNode = this.createNode(null, type, type == PlanModel.NodeType.SET_OP ? token : null);
        if (genericNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildCompoundNode"));
        }
        return genericNode;
    }

    private PlanModel.GenericNode buildSubqueryNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "buildSubqueryNode"));
        }
        boolean scalar = false;
        boolean correlated = false;
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "CORRELATED")) {
            correlated = true;
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "SCALAR")) {
            scalar = true;
        }
        this.consumeToken(tok, "SUBQUERY");
        this.parseSubquery(Integer.parseInt(tok.next()), false);
        PlanModel.SubQueryNode res = (PlanModel.SubQueryNode)this.createNode(null, PlanModel.NodeType.SUBQUERY, null);
        res.setCorrelated(correlated);
        res.setScalar(scalar);
        return res;
    }

    private static boolean checkOrRecover(@NotNull ListIterator<String> tok, @NotNull String token) {
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "checkOrRecover"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "checkOrRecover"));
        }
        if (tok.hasNext()) {
            if (tok.next().equals(token)) {
                return true;
            }
            tok.previous();
        }
        return false;
    }

    private static boolean checkPrefSufAndRecover(@NotNull ListIterator<String> tok, @Nullable String prefix, @Nullable String suffix) {
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "checkPrefSufAndRecover"));
        }
        if (tok.hasNext()) {
            String token = tok.next();
            tok.previous();
            if ((prefix == null || token.startsWith(prefix)) && (suffix == null || token.endsWith(suffix))) {
                return true;
            }
        }
        return false;
    }

    private void checkToken(@NotNull String current, @NotNull String token) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "checkToken"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "checkToken"));
        }
        if (!token.equals(current)) {
            this.unsupportedFormat("unexpected " + current + " != " + token);
        }
    }

    private void consumeToken(@NotNull ListIterator<String> tok, @NotNull String token) {
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "consumeToken"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "consumeToken"));
        }
        this.checkToken(tok.next(), token);
    }

    private void consumeTokens(@NotNull ListIterator<String> tok, String ... tokens) {
        if (tok == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tok", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "consumeTokens"));
        }
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "consumeTokens"));
        }
        for (String s : tokens) {
            this.consumeToken(tok, s);
        }
    }

    @Nullable
    private MetaNode removeSubquery(int id, boolean byteOverflow) {
        MetaNode node;
        MetaNode metaNode = node = id == 0 && byteOverflow ? null : (MetaNode)this.myStructure.get(id);
        if (byteOverflow) {
            while (node == null && id < this.myMaxId) {
                node = (MetaNode)this.myStructure.get(id += 256);
            }
        }
        return node != null ? (MetaNode)this.myStructure.remove(id) : null;
    }

    private void parseSubquery(int id, boolean byteOverflow) {
        MetaNode node = this.removeSubquery(id, byteOverflow);
        if (node == null) {
            node = new MetaNode(id, MetaNode.Type.DUMMY);
            node.children.add(new MetaNode(-1, MetaNode.Type.SIMPLE));
            this.myMaxId = Math.max(this.myMaxId, id);
        }
        this.parseSubPlans(node);
    }

    @Override
    protected void parsePlan(final @NotNull MetaNode state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parsePlan"));
        }
        assert (state.type != MetaNode.Type.DUMMY);
        this.addLazyNode(new Getter<PlanModel.GenericNode>(){

            public PlanModel.GenericNode get() {
                PlanModel.GenericNode node;
                if (state.cache != null) {
                    return state.cache;
                }
                if (state.type == MetaNode.Type.NESTED) {
                    node = SqlitePlanModelBuilder.this.createNode(state, PlanModel.NodeType.NESTED_LOOPS, null);
                } else if (state.type == MetaNode.Type.TEMP) {
                    node = SqlitePlanModelBuilder.this.createNode(state, PlanModel.NodeType.TEMPORARY, null);
                } else if (state.type == MetaNode.Type.SIMPLE) {
                    node = SqlitePlanModelBuilder.this.createNode(state, PlanModel.NodeType.VALUE, null);
                } else {
                    assert (state.type == MetaNode.Type.ROW);
                    PlanRow curRow = (PlanRow)SqlitePlanModelBuilder.this.myRows.get(state.rowId);
                    try {
                        node = SqlitePlanModelBuilder.this.buildNode(Arrays.asList(curRow.detail.split(" ")).listIterator());
                    }
                    catch (PlanRetrievalException e) {
                        throw new PlanRetrievalException("while building for" + curRow.detail, e);
                    }
                    node.setRawDescription(curRow.detail);
                }
                SqlitePlanModelBuilder.this.parseSubPlans(state);
                state.cache = node;
                return node;
            }
        }, this.isScan(state));
    }

    private boolean isScan(@NotNull MetaNode state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "isScan"));
        }
        if (state.type != MetaNode.Type.ROW) {
            return false;
        }
        PlanRow curRow = this.myRows.get(state.rowId);
        return StringUtil.startsWithIgnoreCase((String)curRow.detail, (String)"SCAN") || StringUtil.startsWithIgnoreCase((String)curRow.detail, (String)"SEARCH");
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseSubPlans"));
        }
        for (MetaNode child : state.children) {
            this.parsePlan(child);
        }
    }

    private void parseStructure() {
        if (!this.myRows.isEmpty()) {
            for (PlanRow myRow : this.myRows) {
                if (this.myStructure.containsKey(myRow.subqueryId)) continue;
                MetaNode node = new MetaNode(-1, MetaNode.Type.DUMMY);
                node.children.addAll(this.parseSubqueryStructure(myRow.subqueryId));
                this.myStructure.put(myRow.subqueryId, (Object)node);
                this.myMaxId = Math.max(this.myMaxId, myRow.subqueryId);
            }
        } else {
            MetaNode value = new MetaNode(0, MetaNode.Type.DUMMY);
            value.children.add(new MetaNode(-1, MetaNode.Type.SIMPLE));
            this.myStructure.put(0, (Object)value);
        }
    }

    @NotNull
    private MetaNode expandStructure(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "expandStructure"));
        }
        if (node.type == MetaNode.Type.ROW && this.myRows.get((int)node.rowId).detail.contains("TEMP B-TREE")) {
            boolean child = this.myRows.get((int)node.rowId).detail.startsWith("USING");
            MetaNode temp = new MetaNode(-1, MetaNode.Type.TEMP);
            if (child) {
                temp.children.addAll(node.children);
                node.children.clear();
                node.children.add(temp);
            } else {
                temp.children.add(node);
                node = temp;
            }
        }
        MetaNode metaNode = node;
        if (metaNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "expandStructure"));
        }
        return metaNode;
    }

    private List<MetaNode> parseSubqueryStructure(int id) {
        ArrayList res;
        List<Object> toPutScalarSubqueries = res = ContainerUtil.newArrayList();
        for (int i = 0; i < this.myRows.size(); ++i) {
            if (this.myRows.get((int)i).subqueryId != id || this.myRows.get((int)i).order != 0) continue;
            MetaNode node = this.parseNestedStructure(i);
            if (!res.isEmpty() && this.myRows.get((int)i).detail.startsWith("EXECUTE")) {
                toPutScalarSubqueries.add(node);
                continue;
            }
            node.children.addAll(res);
            if (toPutScalarSubqueries == res) {
                toPutScalarSubqueries = node.children;
            }
            res.clear();
            res.add(this.expandStructure(node));
        }
        return res;
    }

    private MetaNode parseNestedStructure(int idx) {
        ArrayList res = ContainerUtil.newArrayList();
        int i = idx;
        int depth = 0;
        while (i < this.myRows.size() && this.myRows.get((int)i).subqueryId == this.myRows.get((int)idx).subqueryId) {
            if (depth != this.myRows.get((int)i).order) {
                if (this.myRows.get((int)i).order == 0) break;
                this.unsupportedFormat(null);
            }
            res.add(new MetaNode(i, MetaNode.Type.ROW));
            ++i;
            ++depth;
        }
        if (res.size() == 1) {
            return (MetaNode)res.get(0);
        }
        MetaNode nested = new MetaNode(-1, MetaNode.Type.NESTED);
        nested.children.addAll(res);
        return nested;
    }

    @Override
    protected void parseStatement(@NotNull MetaNode s) {
        String[] split;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseStatement"));
        }
        this.openNode();
        PlanModel.NodeType type = PlanModel.NodeType.STATEMENT;
        if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"select") || StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"with")) {
            type = PlanModel.NodeType.SELECT;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"update")) {
            type = PlanModel.NodeType.UPDATE;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"insert")) {
            type = PlanModel.NodeType.INSERT;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"delete")) {
            type = PlanModel.NodeType.DELETE;
        }
        if (!this.myRows.isEmpty()) {
            this.parseSubPlans(s);
        }
        String title = null;
        if (type == PlanModel.NodeType.STATEMENT && (split = this.myStatement.split(" ")).length > 0) {
            title = StringUtil.toLowerCase((String)split[0]);
        }
        this.closeNode(this.createNode(s, type, title));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseTotalCost"));
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseStartupCost"));
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseSubqueryCorrelated"));
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/sqlite/SqlitePlanModelBuilder", "parseSubqueryScalar"));
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("UNION ALL", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("EXCEPT", PlanModel.NodeType.EXCEPT);
        TYPE_MAPPING.put("INTERSECT", PlanModel.NodeType.INTERSECT);
        TYPE_MAPPING.put("GROUP BY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("ORDER BY", PlanModel.NodeType.ORDER_BY);
        TYPE_MAPPING.put("DISTINCT", PlanModel.NodeType.UNIQUE);
    }

    public static class MetaNode {
        public final int rowId;
        public final Type type;
        public final List<MetaNode> children = ContainerUtil.newArrayListWithCapacity((int)0);
        public PlanModel.GenericNode cache = null;

        public MetaNode(int id, Type type) {
            this.rowId = id;
            this.type = type;
        }

        static enum Type {
            ROW,
            NESTED,
            DUMMY,
            TEMP,
            SIMPLE;

        }
    }

    public static class PlanRow {
        public final int subqueryId;
        public final int order;
        public final int from;
        public final String detail;

        public PlanRow(int subqueryId, int order, int from, String detail) {
            this.subqueryId = subqueryId;
            this.order = order;
            this.from = from;
            this.detail = detail;
        }
    }
}

