/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPackageImpl
extends DbElementImpl<Object, DbElement>
implements DbPackage {
    private final String myPackageName;

    DbPackageImpl(DbElement parent, String packageName, @Nullable Object delegate) {
        super(parent, delegate);
        this.myPackageName = packageName;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myPackageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPackageImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.myDelegate instanceof DasObject ? super.getKind() : ObjectKind.PACKAGE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPackageImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        StringBuilder sb = new StringBuilder();
        if (DbImplUtil.canConnectTo(this)) {
            this.scheduleAsyncDocumentationUpdate(sb);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPackageImpl", "getDocumentation"));
        }
        return stringBuilder;
    }

    @Override
    protected void loadSlowDocumentationInner(CharOut sb, ConnectionProvider provider) throws Exception {
        sb.append("<br><b>Definition:</b><br><code><pre>");
        StringBuilder builder = new StringBuilder();
        DbImplUtil.tryLoadPackageDefinition(provider, this, true, builder);
        sb.append(DbSqlUtil.sql2Html(this.getProject(), DbSqlUtil.getSqlDialect(this), builder));
        sb.append("</pre></code>");
    }
}

