/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.actions.ScriptProcessAction;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Function;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleDataRequest
extends DataRequest.QueryRequest {
    private final Shared shared;
    public final int queryIndex;
    public final boolean hasNext;
    public final Object resultType;
    public static Key<ErrorPanelInfo> QL_ERROR_PANEL_INFO_KEY = Key.create((String)"QL_ERROR_PANEL");

    @NotNull
    public static ConsoleDataRequest newConsoleRequest(AbstractQueryLanguageConsole<?> console, Editor editor, ScriptModel<?> model) {
        DataRequest.Constraints constraints = ConsoleDataRequest.newConstraints();
        Shared shared = new Shared(editor, model, constraints);
        shared.queries.next();
        DataRequest.TxMarker batchTx = console.getCurrentTx();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, batchTx, shared, 0);
        if (consoleDataRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "newConsoleRequest"));
        }
        return consoleDataRequest;
    }

    private ConsoleDataRequest(AbstractQueryLanguageConsole<?> console, DataRequest.TxMarker txMarker, Shared shared, int queryIndex) {
        super(console, txMarker, shared.queries.text(console.myPStorage, Conditions.alwaysFalse()), shared.constraints, null);
        this.shared = shared;
        this.queryIndex = queryIndex;
        this.resultType = shared.queries.resultType(console);
        this.hasNext = shared.queries.hasNext();
    }

    @NotNull
    private AbstractQueryLanguageConsole getConsole() {
        AbstractQueryLanguageConsole abstractQueryLanguageConsole = (AbstractQueryLanguageConsole)this.owner;
        if (abstractQueryLanguageConsole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "getConsole"));
        }
        return abstractQueryLanguageConsole;
    }

    @NotNull
    private DataProducer getDataProducer() {
        DataProducer dataProducer = this.getConsole().getMessageBus().getDataProducer();
        if (dataProducer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "getDataProducer"));
        }
        return dataProducer;
    }

    @NotNull
    public UserDataHolder getSharedDataHolder() {
        Shared shared = this.shared;
        if (shared == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "getSharedDataHolder"));
        }
        return shared;
    }

    public void onError(@Nullable String message, @Nullable Throwable th) {
        if (message != null) {
            Throwable throwable = new Throwable(message);
            throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
            this.reportError(throwable);
        } else if (th != null) {
            this.reportError(th);
        }
    }

    public void onFinished() {
        if (this.isLastInChain()) {
            return;
        }
        this.getDataProducer().processRequest(this.nextRequest());
    }

    public boolean isLastInChain() {
        return !this.shared.ignoreAll && this.shared.errCount > this.shared.errIgnored || !this.hasNext;
    }

    @NotNull
    private ConsoleDataRequest nextRequest() {
        this.shared.queries.next();
        AbstractQueryLanguageConsole console = this.getConsole();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, console.getCurrentTx(), this.shared, this.queryIndex + 1);
        if (consoleDataRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "nextRequest"));
        }
        return consoleDataRequest;
    }

    public void onStarted() {
        DbUIUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ConsoleDataRequest.this.hasNext || ((ConsoleDataRequest)ConsoleDataRequest.this).shared.lastUpdateTime < 0L || System.currentTimeMillis() - ((ConsoleDataRequest)ConsoleDataRequest.this).shared.lastUpdateTime > 100L) {
                    ConsoleDataRequest.this.updateConsoleUI(false);
                }
            }
        });
        this.shared.lastUpdateTime = System.currentTimeMillis();
    }

    private void updateConsoleUI(boolean scrollToQuery) {
        TextRange range;
        this.closeErrorPanel();
        if (scrollToQuery && (range = this.getRange()) != null) {
            this.scrollToRange(range);
        }
        this.updateHighlighting();
    }

    private void reportError(final @NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ConsoleDataRequest", "reportError"));
        }
        ++this.shared.errCount;
        DbUIUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ConsoleDataRequest.this.updateConsoleUI(!((ConsoleDataRequest)ConsoleDataRequest.this).shared.ignoreAll);
                if (!ConsoleDataRequest.this.hasNext) {
                    ConsoleDataRequest.this.handleQueryError(error, (ParameterizedRunnable<Decision>)null);
                } else if (!((ConsoleDataRequest)ConsoleDataRequest.this).shared.ignoreAll) {
                    ConsoleDataRequest.this.handleQueryError(error, (ParameterizedRunnable<Decision>)((ParameterizedRunnable)new ParameterizedRunnable<Decision>(){

                        public void run(Decision feedback) {
                            ConsoleDataRequest.this.closeErrorPanel();
                            switch (feedback) {
                                case STOP: {
                                    break;
                                }
                                case RETRY: {
                                    --((ConsoleDataRequest)ConsoleDataRequest.this).shared.errCount;
                                    ConsoleDataRequest.this.getDataProducer().processRequest(ConsoleDataRequest.this);
                                    break;
                                }
                                case IGNORE_ALL: {
                                    ((ConsoleDataRequest)ConsoleDataRequest.this).shared.ignoreAll = true;
                                    ConsoleDataRequest.this.getDataProducer().processRequest(ConsoleDataRequest.this.nextRequest());
                                    break;
                                }
                                case CONTINUE: {
                                    ++((ConsoleDataRequest)ConsoleDataRequest.this).shared.errIgnored;
                                    ConsoleDataRequest.this.getDataProducer().processRequest(ConsoleDataRequest.this.nextRequest());
                                }
                            }
                        }
                    }));
                }
            }
        });
    }

    public void closeErrorPanel() {
        ConsoleDataRequest.hideErrorPanel(this.shared.sourceEditor);
    }

    private void handleQueryError(@NotNull Throwable error, @Nullable ParameterizedRunnable<Decision> feedbackListener) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ConsoleDataRequest", "handleQueryError"));
        }
        if (error instanceof ProcessCanceledException) {
            return;
        }
        if (feedbackListener == null && !DatabaseSettings.getSettings().isShowErrorInEditor()) {
            return;
        }
        if (!this.shared.sourceEditor.getContentComponent().isShowing()) {
            return;
        }
        Project project = this.getConsole().getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            DatabaseDialect databaseDialect;
            ErrorNotificationPanel errorPanel = this.createErrorNotificationPanel(this.shared.sourceEditor, error, feedbackListener);
            editorManager.addBottomComponent(fileEditor, (JComponent)errorPanel);
            Container parent = errorPanel.getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).setBorder(IdeBorderFactory.createEmptyBorder());
            }
            QL_ERROR_PANEL_INFO_KEY.set((UserDataHolder)this.shared.sourceEditor, (Object)new ErrorPanelInfo(errorPanel, feedbackListener));
            this.shared.sourceEditor.getContentComponent().requestFocusInWindow();
            TextRange queryRange = this.getRange();
            SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((PsiElement)file);
            DatabaseDialect databaseDialect2 = databaseDialect = dialect != null ? dialect.getDatabaseDialect() : null;
            if (queryRange != null && databaseDialect != null) {
                int offset;
                int position = ConsoleDataRequest.getOffsetFromErrorMessage(databaseDialect.getFamilyId(), StringUtil.notNullize((String)error.getMessage()), this.query);
                int n = offset = position >= 0 ? position + queryRange.getStartOffset() : -1;
                if (offset > -1) {
                    this.scrollToRange(TextRange.create((int)offset, (int)offset));
                }
            }
        }
    }

    private static int getOffsetFromErrorMessage(@NotNull DatabaseFamilyId dialect, @NotNull String message, @NotNull String queryText) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromErrorMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromErrorMessage"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromErrorMessage"));
        }
        if (dialect.isPostgres()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bPosition: (\\d+)\\z", -1, -1, 1, message, queryText);
        }
        if (dialect.isMysql()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear '([^']*)' at line (\\d+)\\z", 1, 2, -1, message, queryText);
        }
        if (dialect.isTransactSql()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear '([^']*)'\\.\\z", 1, -1, -1, message, queryText);
        }
        if (dialect.isSqlite()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear \"([^\"]*)\":", 1, -1, -1, message, queryText);
        }
        if (dialect.isDerby()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bat line (\\d+), column (\\d+)\\.\\z", -1, 1, 2, message, queryText);
        }
        if (dialect.isHsqldb()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl(": (.*) : line: (\\d+)\\z", 1, 2, -1, message, queryText);
        }
        return 0;
    }

    private static int getOffsetFromMessageImpl(@NotNull @RegExp String pattern, int groupNear, int groupLine, int groupColumn, @NotNull String message, @NotNull String queryText) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromMessageImpl"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromMessageImpl"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromMessageImpl"));
        }
        Matcher matcher = Pattern.compile(pattern).matcher(message);
        if (matcher.find()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl(queryText, groupNear > 0 ? matcher.group(groupNear) : null, groupLine > 0 ? matcher.group(groupLine) : null, groupColumn > 0 ? matcher.group(groupColumn) : null);
        }
        return 0;
    }

    private static int getOffsetFromMessageImpl(@NotNull String queryText, @Nullable String near, @Nullable String strLine, @Nullable String strColumn) {
        int offset;
        int column;
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromMessageImpl"));
        }
        int line = strLine == null ? -1 : StringUtil.parseInt((String)strLine, (int)-1);
        int n = column = strColumn == null ? -1 : StringUtil.parseInt((String)strColumn, (int)-1);
        int n2 = strLine == null || line == -1 ? (column < 0 ? -1 : column - 1) : (offset = StringUtil.lineColToOffset((CharSequence)queryText, (int)(line - 1), (int)(column < 0 ? 0 : column - 1)));
        if (line > -1 && column > -1) {
            return offset;
        }
        return near == null ? offset : StringUtil.indexOfIgnoreCase((String)queryText, (String)near, (int)(offset < 0 ? 0 : offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/run/ConsoleDataRequest", "scrollToRange"));
        }
        Editor editor = this.shared.sourceEditor;
        if (editor.isDisposed() || !editor.getContentComponent().isShowing()) {
            return;
        }
        int offset = range.getEndOffset();
        editor.getCaretModel().moveToOffset(offset);
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        try {
            scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        finally {
            scrollingModel.enableAnimation();
        }
        editor.getSelectionModel().setSelection(offset, offset);
    }

    private void updateHighlighting() {
        Project project = this.getConsole().getProject();
        if (!project.isOpen() || this.shared.sourceEditor.isDisposed()) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file != null) {
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart(file);
        }
    }

    @Nullable
    public TextRange getRange() {
        return this.shared.adjustedRange(this.queryIndex);
    }

    private ErrorNotificationPanel createErrorNotificationPanel(Editor sourceEditor, Throwable error, final ParameterizedRunnable<Decision> feedbackListener) {
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(error, sourceEditor.getContentComponent());
        if (feedbackListener == null) {
            builder.addDetailsButton().addIconLink("config", "/general/settings.png", "Settings", AllIcons.General.Settings, new Runnable(){

                @Override
                public void run() {
                    ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)"");
                }
            });
        } else {
            builder.addLink("retry", "<span style=\"text-decoration:underline;\">R</span>etry", new Runnable(){

                @Override
                public void run() {
                    feedbackListener.run((Object)Decision.RETRY);
                }
            }).addLink("ignore", "<span style=\"text-decoration:underline;\">I</span>gnore", new Runnable(){

                @Override
                public void run() {
                    feedbackListener.run((Object)Decision.CONTINUE);
                }
            }).addLink("ignore_all", "Ignore <span style=\"text-decoration:underline;\">A</span>ll", new Runnable(){

                @Override
                public void run() {
                    feedbackListener.run((Object)Decision.IGNORE_ALL);
                }
            }).addLink("stop", "<span style=\"text-decoration:underline;\">S</span>top", new Runnable(){

                @Override
                public void run() {
                    feedbackListener.run((Object)Decision.STOP);
                }
            });
        }
        builder.addCloseButton(new Runnable(){

            @Override
            public void run() {
                ConsoleDataRequest.hideErrorPanel(((ConsoleDataRequest)ConsoleDataRequest.this).shared.sourceEditor);
            }
        });
        ErrorNotificationPanel notificationPanel = builder.build();
        notificationPanel.getContent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TextRange range;
                if (e.getClickCount() == 2 && (range = ConsoleDataRequest.this.getRange()) != null) {
                    ConsoleDataRequest.this.scrollToRange(range);
                    ((ConsoleDataRequest)ConsoleDataRequest.this).shared.sourceEditor.getContentComponent().requestFocusInWindow();
                    ConsoleDataRequest.this.updateHighlighting();
                }
            }
        });
        if (feedbackListener != null) {
            this.setupUiNotifier(notificationPanel);
        }
        return notificationPanel;
    }

    private void setupUiNotifier(ErrorNotificationPanel notificationPanel) {
        new UiNotifyConnector((Component)notificationPanel, new Activatable(){
            private final List<AnAction> myScriptActions = new ArrayList<AnAction>();

            public void showNotify() {
                this.addScriptAction((AnAction)new ScriptProcessAction.Retry(), 82);
                this.addScriptAction((AnAction)new ScriptProcessAction.Ignore(), 73);
                this.addScriptAction((AnAction)new ScriptProcessAction.IgnoreAll(), 65);
                this.addScriptAction((AnAction)new ScriptProcessAction.Stop(), 83);
            }

            public void hideNotify() {
                for (AnAction action : this.myScriptActions) {
                    action.unregisterCustomShortcutSet(((ConsoleDataRequest)ConsoleDataRequest.this).shared.sourceEditor.getContentComponent());
                }
                this.myScriptActions.clear();
            }

            private void addScriptAction(AnAction action, int mnemonicKey) {
                action.registerCustomShortcutSet(mnemonicKey, 512, ((ConsoleDataRequest)ConsoleDataRequest.this).shared.sourceEditor.getContentComponent());
                this.myScriptActions.add(action);
            }
        });
    }

    public static void hideErrorPanel(@NotNull Editor sourceEditor) {
        if (sourceEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceEditor", "com/intellij/database/run/ConsoleDataRequest", "hideErrorPanel"));
        }
        ErrorPanelInfo epInfo = (ErrorPanelInfo)QL_ERROR_PANEL_INFO_KEY.get((UserDataHolder)sourceEditor);
        if (epInfo == null || sourceEditor.getProject() == null) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)sourceEditor.getProject()).getPsiFile(sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)sourceEditor.getProject());
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            editorManager.removeBottomComponent(fileEditor, (JComponent)epInfo.getNotificationPanel());
            QL_ERROR_PANEL_INFO_KEY.set((UserDataHolder)sourceEditor, null);
            sourceEditor.getContentComponent().requestFocusInWindow();
        }
    }

    public static class EscapeHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public EscapeHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (this.myOriginalHandler != null && this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            ConsoleDataRequest.hideErrorPanel(editor);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ConsoleDataRequest$EscapeHandler", "isEnabledForCaret"));
            }
            if (caret == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/database/run/ConsoleDataRequest$EscapeHandler", "isEnabledForCaret"));
            }
            return QL_ERROR_PANEL_INFO_KEY.get((UserDataHolder)editor) != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }
    }

    public static class ErrorPanelInfo {
        private final ErrorNotificationPanel myNotificationPanel;
        private final ParameterizedRunnable<Decision> myExecutionFeedbackListener;

        public ErrorPanelInfo(@NotNull ErrorNotificationPanel notificationPanel, @Nullable ParameterizedRunnable<Decision> executionFeedbackListener) {
            if (notificationPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationPanel", "com/intellij/database/run/ConsoleDataRequest$ErrorPanelInfo", "<init>"));
            }
            this.myNotificationPanel = notificationPanel;
            this.myExecutionFeedbackListener = executionFeedbackListener;
        }

        @NotNull
        public ErrorNotificationPanel getNotificationPanel() {
            ErrorNotificationPanel errorNotificationPanel = this.myNotificationPanel;
            if (errorNotificationPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest$ErrorPanelInfo", "getNotificationPanel"));
            }
            return errorNotificationPanel;
        }

        @Nullable
        public ParameterizedRunnable<Decision> getExecutionFeedbackListener() {
            return this.myExecutionFeedbackListener;
        }
    }

    private static class Shared
    extends UserDataHolderBase {
        final Editor sourceEditor;
        final ScriptModel<?> scriptModel;
        final DataRequest.Constraints constraints;
        final ScriptModel.StatementIt<?> queries;
        final List<RangeMarker> rangeMarkers;
        long lastUpdateTime = -1L;
        boolean ignoreAll = false;
        int errCount;
        int errIgnored;

        public Shared(Editor sourceEditor, ScriptModel<?> scriptModel, DataRequest.Constraints constraints) {
            this.queries = scriptModel.statements();
            this.sourceEditor = sourceEditor;
            this.scriptModel = scriptModel;
            this.constraints = constraints;
            final Document document = sourceEditor.getDocument();
            this.rangeMarkers = scriptModel.statements().asCursor().transform(new Function<ScriptModel.StatementIt<?>, RangeMarker>(){

                public RangeMarker fun(ScriptModel.StatementIt<?> it) {
                    TextRange range = it.range().shiftRight((int)it.rangeOffset());
                    return range.getEndOffset() <= document.getTextLength() ? document.createRangeMarker(range) : null;
                }
            }).toList();
        }

        @Nullable
        TextRange adjustedRange(int idx) {
            RangeMarker marker = this.rangeMarkers.get(idx);
            return marker != null && marker.isValid() ? TextRange.create((Segment)marker) : null;
        }
    }

    public static enum Decision {
        STOP,
        CONTINUE,
        IGNORE_ALL,
        RETRY;

    }
}

