/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.Consumer;
import icons.DatabaseIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.ConsumerRunnable;

public abstract class TransactionAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/TransactionAction", "update"));
        }
        DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
        if (owner != null) {
            this.update(owner, e);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/TransactionAction", "actionPerformed"));
        }
        DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
        if (owner == null) {
            return;
        }
        this.actionPerformed(owner, e);
    }

    private static void stopEditingIfNecessary(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/TransactionAction", "stopEditingIfNecessary"));
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid != null && !dataGrid.stopEditing()) {
            dataGrid.cancelEditing();
        }
    }

    protected abstract void actionPerformed(@NotNull DataRequest.OwnerEx var1, @NotNull AnActionEvent var2);

    protected abstract void update(@NotNull DataRequest.OwnerEx var1, AnActionEvent var2);

    @Nullable
    private static DataRequest.OwnerEx getRequestOwner(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/TransactionAction", "getRequestOwner"));
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid == null) {
            return JdbcConsole.getConsole(e);
        }
        if (dataGrid.isEditable()) {
            return DataGridUtil.getDataBusHookUp(dataGrid);
        }
        return null;
    }

    public static class Rollback
    extends TransactionAction {
        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/run/actions/TransactionAction$Rollback", "update"));
            }
            DataRequest.TxMarker tx = owner.getCurrentTx();
            e.getPresentation().setEnabled(tx.getOwner() == owner);
            e.getPresentation().setVisible(true);
            e.getPresentation().setIcon(DatabaseIcons.Rollback);
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/run/actions/TransactionAction$Rollback", "actionPerformed"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/TransactionAction$Rollback", "actionPerformed"));
            }
            DataRequest request = DataRequest.newTxRollback(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }
    }

    public static class Commit
    extends TransactionAction {
        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/run/actions/TransactionAction$Commit", "update"));
            }
            DataRequest.TxMarker tx = owner.getCurrentTx();
            e.getPresentation().setEnabled(tx.getOwner() == owner);
            e.getPresentation().setVisible(true);
            e.getPresentation().setIcon(DatabaseIcons.Commit);
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/run/actions/TransactionAction$Commit", "actionPerformed"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/TransactionAction$Commit", "actionPerformed"));
            }
            TransactionAction.stopEditingIfNecessary(e);
            DataRequest request = DataRequest.newTxCommit(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }
    }

    public static class Autocommit
    extends CheckboxAction
    implements DumbAware {
        public JComponent createCustomComponent(Presentation presentation) {
            JComponent component = super.createCustomComponent(presentation);
            component.setFocusable(false);
            component.setOpaque(false);
            return component;
        }

        public void update(AnActionEvent e) {
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            if (owner == null) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                DataRequest.Owner txOwner = owner.getCurrentTx().getOwner();
                boolean enabled = txOwner == null || txOwner == owner;
                e.getPresentation().setEnabled(enabled);
                e.getPresentation().setVisible(true);
                if (!enabled) {
                    e.getPresentation().setDescription("Transaction active " + owner.getCurrentTx());
                }
                super.update(e);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            return owner != null && owner.getCurrentTx() == DataRequest.AUTO_COMMIT;
        }

        public void setSelected(AnActionEvent e, final boolean state) {
            final DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            if (owner == null) {
                return;
            }
            TransactionAction.stopEditingIfNecessary(e);
            DataRequest request = DataRequest.newTxCommit(owner);
            request.getPromise().done((Consumer)new ConsumerRunnable(){

                public void run() {
                    owner.setAutoCommit(state);
                    DataBus.shortCircuit(owner.getMessageBus()).getDataAuditor().print(DataRequest.newContext(owner, null, ""), state ? "auto-commit mode ON" : "auto-commit mode OFF");
                }
            });
            owner.getMessageBus().getDataProducer().processRequest(request);
        }
    }
}

