/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizableCellEditorsSupport
implements PropertyChangeListener,
TableColumnModelListener {
    private static final String CLIENT_PROPERTY_KEY = "ResizableCellEditorsSupport";
    private final JBTable myGrid;
    private final WeakHashMap<Component, Object> myNonMaximizableEditorComponents;
    private final Timer myResetEditingCellSizeTimer;
    private final Timer myCellEditorUpdateTimer;
    private ResizeMode myResizeMode;
    private int myColumnWidthBeforeMaximizing;
    private int myRowHeightBeforeEditing;
    private int myCalculatedRowHeight;

    public ResizableCellEditorsSupport(@NotNull JBTable grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport", "<init>"));
        }
        this.myNonMaximizableEditorComponents = new WeakHashMap();
        this.myResizeMode = ResizeMode.SPAN;
        this.myColumnWidthBeforeMaximizing = -1;
        this.myGrid = grid;
        this.myCellEditorUpdateTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizableCellEditorsSupport.this.expandCellEditorIfNeeded(ResizableCellEditorsSupport.this.myGrid.getEditingRow(), ResizableCellEditorsSupport.this.myGrid.getEditingColumn(), false);
            }
        });
        this.myResetEditingCellSizeTimer = new Timer(UIUtil.getMultiClickInterval(), null);
        this.myResetEditingCellSizeTimer.setRepeats(false);
        this.myGrid.addPropertyChangeListener((PropertyChangeListener)this);
        this.addColumnModelListener(this.myGrid.getColumnModel());
        grid.putClientProperty((Object)CLIENT_PROPERTY_KEY, (Object)this);
    }

    public boolean isEditingCellMaximized() {
        return this.myGrid.isEditing() && this.myResizeMode == ResizeMode.STRETCH;
    }

    public void maximizeEditingCell() {
        Component cellEditor;
        int editingColumn;
        int editingRow = this.myGrid.getEditingRow();
        if (this.canMaximizeEditingCell(editingRow, editingColumn = this.myGrid.getEditingColumn(), cellEditor = this.myGrid.getEditorComponent())) {
            Rectangle currentCellSize = this.myGrid.getCellRect(editingRow, editingColumn, true);
            if (this.myColumnWidthBeforeMaximizing == -1) {
                this.myColumnWidthBeforeMaximizing = currentCellSize.width;
            }
            this.setResizeMode(ResizeMode.STRETCH);
            JViewport viewport = (JViewport)ObjectUtils.tryCast((Object)this.myGrid.getParent(), JViewport.class);
            Rectangle visibleRect = viewport != null ? viewport.getVisibleRect() : this.myGrid.getVisibleRect();
            int height = Math.max(currentCellSize.height, (int)(0.9 * (double)visibleRect.height));
            int width = Math.max(currentCellSize.width, (int)(0.9 * (double)visibleRect.width));
            this.setCellSize(editingRow, editingColumn, width, height);
            this.scrollToCellEditor();
        }
    }

    public boolean canMaximizeEditingCell() {
        return this.canMaximizeEditingCell(this.myGrid.getEditingRow(), this.myGrid.getEditingColumn(), this.myGrid.getEditorComponent());
    }

    public void allowMaximizing(@NotNull Component cellEditorComponent, boolean allow) {
        if (cellEditorComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellEditorComponent", "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport", "allowMaximizing"));
        }
        if (allow) {
            this.myNonMaximizableEditorComponents.remove((Object)cellEditorComponent);
        } else {
            this.myNonMaximizableEditorComponents.put((Object)cellEditorComponent, ObjectUtils.NULL);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("tableCellEditor".equals(property)) {
            if (evt.getNewValue() != null) {
                this.editingStarted();
            } else {
                this.editingStopped();
            }
        } else if ("columnModel".equals(property)) {
            this.removeColumnModelListener((TableColumnModel)ObjectUtils.tryCast((Object)evt.getOldValue(), TableColumnModel.class));
            this.addColumnModelListener((TableColumnModel)ObjectUtils.tryCast((Object)evt.getNewValue(), TableColumnModel.class));
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ResizableCellEditorsSupport.this.updateCellEditorWidth(ResizableCellEditorsSupport.this.myGrid.getEditingColumn(), true);
            }
        });
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public static ResizableCellEditorsSupport get(@Nullable JTable table) {
        return table != null ? (ResizableCellEditorsSupport)ObjectUtils.tryCast((Object)table.getClientProperty(CLIENT_PROPERTY_KEY), ResizableCellEditorsSupport.class) : null;
    }

    public static void allowMaximizing(@NotNull JTable table, @NotNull Component editorComponent, boolean allow) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport", "allowMaximizing"));
        }
        if (editorComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorComponent", "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport", "allowMaximizing"));
        }
        ResizableCellEditorsSupport support = ResizableCellEditorsSupport.get(table);
        if (support != null) {
            support.allowMaximizing(editorComponent, allow);
        }
    }

    public static boolean canMaximizeEditingCell(@Nullable JTable table) {
        ResizableCellEditorsSupport support = ResizableCellEditorsSupport.get(table);
        return support != null && support.canMaximizeEditingCell();
    }

    private boolean canMaximizeEditingCell(int editingRow, int editingColumn, Component cellEditor) {
        return editingRow != -1 && editingColumn != -1 && cellEditor != null && !this.myNonMaximizableEditorComponents.containsKey((Object)cellEditor);
    }

    private void setResizeMode(ResizeMode mode) {
        this.myResizeMode = mode;
        ResizableCellEditor editor = (ResizableCellEditor)ObjectUtils.tryCast((Object)this.myGrid.getEditorComponent(), ResizableCellEditor.class);
        if (editor != null) {
            editor.setWidthChangeEnabled(mode != ResizeMode.SPAN);
        }
    }

    private void editingStarted() {
        int editingColumn = this.myGrid.getEditingColumn();
        int editingRow = this.myGrid.getEditingRow();
        if (editingColumn == -1 || editingRow == -1) {
            Point editorLocation;
            Component cellEditor = this.myGrid.getEditorComponent();
            Point point = editorLocation = cellEditor != null ? cellEditor.getBounds().getLocation() : null;
            if (editorLocation != null) {
                editingColumn = this.myGrid.columnAtPoint(editorLocation);
                editingRow = this.myGrid.rowAtPoint(editorLocation);
            }
        }
        if (editingRow != -1 && editingColumn != -1) {
            this.stopResetEditingRowHeightTimer();
            this.myColumnWidthBeforeMaximizing = -1;
            this.setResizeMode(ResizeMode.SPAN);
            this.myRowHeightBeforeEditing = this.myGrid.getRowHeight(editingRow);
            this.expandCellEditorIfNeeded(editingRow, editingColumn, true);
            this.scrollToCellEditor();
            this.myCellEditorUpdateTimer.start();
        }
    }

    private void editingStopped() {
        this.myCellEditorUpdateTimer.stop();
        this.resetEditingCellSize();
    }

    private void scrollToCellEditor() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Component cellEditor = ResizableCellEditorsSupport.this.myGrid.getEditorComponent();
                if (cellEditor == null || !cellEditor.isVisible()) {
                    return;
                }
                Rectangle editorBounds = cellEditor.getBounds();
                Rectangle visibleRect = ResizableCellEditorsSupport.this.myGrid.getVisibleRect();
                if (!visibleRect.contains(editorBounds)) {
                    int margin = ResizableCellEditorsSupport.this.myGrid.getRowHeight();
                    editorBounds.x -= margin;
                    editorBounds.y -= margin;
                    editorBounds.width += 2 * margin;
                    editorBounds.height += 2 * margin;
                    ResizableCellEditorsSupport.this.myGrid.scrollRectToVisible(editorBounds);
                }
            }
        });
    }

    private void expandCellEditorIfNeeded(int editingRow, int editingColumn, boolean force) {
        this.updateCellEditorWidth(editingColumn, force);
        this.updateEditingRowHeight(editingRow, force);
    }

    private void updateCellEditorWidth(int editingColumn, boolean force) {
        Component cellEditor = this.myGrid.getEditorComponent();
        if (cellEditor == null || editingColumn < 0) {
            return;
        }
        int preferredWidth = cellEditor.getPreferredSize().width + this.myGrid.getColumnModel().getColumnMargin();
        int currentWidth = cellEditor.getWidth();
        if (!force && currentWidth >= preferredWidth) {
            return;
        }
        Rectangle visibleRect = this.myGrid.getVisibleRect();
        int rightmostVisibleX = visibleRect.x + visibleRect.width;
        int newWidth = this.myGrid.getCellRect((int)0, (int)editingColumn, (boolean)true).width - this.myGrid.getColumnModel().getColumnMargin();
        ResizableCellEditor widthChangeSupport = (ResizableCellEditor)ObjectUtils.tryCast((Object)this.myGrid.getEditorComponent(), ResizableCellEditor.class);
        if (widthChangeSupport != null && this.myResizeMode == ResizeMode.SPAN) {
            for (int column = editingColumn + 1; column < this.myGrid.getColumnCount() && newWidth < preferredWidth; ++column) {
                Rectangle r = this.myGrid.getCellRect(0, column, true);
                if (rightmostVisibleX < r.x + r.width) continue;
                newWidth += r.width;
            }
        }
        if (force && currentWidth != newWidth || currentWidth < newWidth) {
            Rectangle bounds = cellEditor.getBounds();
            bounds.width = newWidth;
            ResizableCellEditorsSupport.setCellEditorBounds(cellEditor, bounds);
        }
    }

    private static void setCellEditorBounds(@NotNull Component cellEditor, @NotNull Rectangle bounds) {
        if (cellEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellEditor", "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport", "setCellEditorBounds"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport", "setCellEditorBounds"));
        }
        ResizableCellEditor widthChangeSupport = (ResizableCellEditor)ObjectUtils.tryCast((Object)cellEditor, ResizableCellEditor.class);
        if (widthChangeSupport != null) {
            widthChangeSupport.setWidthChangeEnabled(true);
        }
        cellEditor.setBounds(bounds);
        if (widthChangeSupport != null) {
            widthChangeSupport.setWidthChangeEnabled(false);
        }
    }

    private void updateEditingRowHeight(int editingRow, boolean force) {
        Component editor = this.myGrid.getEditorComponent();
        if (editor != null && editingRow >= 0) {
            int newRowHeight = Math.min(10 * this.myGrid.getRowHeight(), editor.getPreferredSize().height + this.myGrid.getRowMargin());
            int currentRowHeight = this.myGrid.getRowHeight(editingRow);
            if (force || this.myCalculatedRowHeight == currentRowHeight) {
                if (currentRowHeight < newRowHeight) {
                    this.setCellSize(editingRow, -1, -1, newRowHeight);
                }
                this.myCalculatedRowHeight = newRowHeight;
            }
        }
    }

    private void stopResetEditingRowHeightTimer() {
        this.myResetEditingCellSizeTimer.stop();
        for (ActionListener listener : this.myResetEditingCellSizeTimer.getActionListeners()) {
            listener.actionPerformed(null);
        }
    }

    private void resetEditingCellSize() {
        final int row = this.myGrid.getEditingRow();
        final int column = this.myGrid.getEditingColumn();
        final int height = this.myRowHeightBeforeEditing;
        final int width = this.myColumnWidthBeforeMaximizing;
        if (IdeEventQueue.getInstance().getTrueCurrentEvent() instanceof MouseEvent) {
            this.myResetEditingCellSizeTimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResizableCellEditorsSupport.this.setCellSize(row, column, width, height);
                    ResizableCellEditorsSupport.this.myResetEditingCellSizeTimer.removeActionListener(this);
                }
            });
            this.myResetEditingCellSizeTimer.start();
        } else {
            this.setCellSize(row, column, width, height);
        }
    }

    private void setCellSize(int row, int column, int width, int height) {
        this.hideExpansionHint();
        if (row != -1 && height != -1) {
            this.myGrid.setRowHeight(row, height);
        }
        if (column != -1 && width != -1) {
            this.myGrid.getColumnModel().getColumn(column).setPreferredWidth(width);
        }
    }

    private void hideExpansionHint() {
        ExpandableItemsHandler h = this.myGrid.getExpandableItemsHandler();
        if (h.isEnabled() && !h.getExpandedItems().isEmpty()) {
            h.setEnabled(false);
            h.setEnabled(true);
        }
    }

    private void addColumnModelListener(@Nullable TableColumnModel to) {
        if (to != null) {
            to.addColumnModelListener(this);
        }
    }

    private void removeColumnModelListener(@Nullable TableColumnModel from) {
        if (from != null) {
            from.removeColumnModelListener(this);
        }
    }

    public static interface ResizableCellEditor {
        public void setWidthChangeEnabled(boolean var1);
    }

    private static enum ResizeMode {
        SPAN,
        STRETCH;

    }
}

