/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import com.michaelbaranov.microba.calendar.CalendarPane;
import com.michaelbaranov.microba.calendar.ui.basic.BasicCalendarPaneUI;
import com.michaelbaranov.microba.calendar.ui.basic.CalendarGridPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.sql.Date;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultDateEditorFactory
extends FormatBasedGridCellEditorFactory {
    DefaultDateEditorFactory() {
    }

    @Override
    @NotNull
    protected Format getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getFormat"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getFormat"));
        }
        SimpleDateFormat simpleDateFormat = grid.getObjectFormatter().getDateFormat();
        if (simpleDateFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getFormat"));
        }
        return simpleDateFormat;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel().getColumn(column));
        return ExtractorsUtil.guessJdbcType(c) == 91 ? 1 : 0;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(final @NotNull DataGrid grid, Project project, @NotNull Format format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "createEditorImpl"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "createEditorImpl"));
        }
        FormatBasedGridCellEditor.WithBrowseButton withBrowseButton = new FormatBasedGridCellEditor.WithBrowseButton(project, grid, format, value, nullValue, initiator){

            @Override
            @Nullable
            public Object getValue() {
                Object v = super.getValue();
                return v instanceof java.util.Date ? new Date(((java.util.Date)v).getTime()) : v;
            }

            @Override
            public void browseButtonPressed() {
                Object value = this.getValue();
                java.util.Date initialDate = value instanceof java.util.Date ? (java.util.Date)value : new java.util.Date();
                final MyCalendarPane calendarPane = new MyCalendarPane(initialDate, this.getNullValue() != null);
                final JBPopup popup = this.createPopup((JComponent)((Object)calendarPane), (JComponent)((Object)calendarPane));
                calendarPane.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (popup.isDisposed()) {
                            return;
                        }
                        java.util.Date date = calendarPane.getDate();
                        this.getTextField().setText(date == null ? "" : this.format(date));
                        popup.closeOk(null);
                        grid.stopEditing();
                    }
                });
                this.showPopup(popup);
            }
        };
        if (withBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "createEditorImpl"));
        }
        return withBrowseButton;
    }

    private static class MyCalendarPane
    extends CalendarPane {
        private boolean mySettingDate;

        public MyCalendarPane(java.util.Date initialDate, boolean showNoneButton) {
            super(initialDate);
            this.setFocusLostBehavior(3);
            this.setShowNoneButton(showNoneButton);
            this.setShowNumberOfWeek(true);
            this.setShowTodayButton(true);
            this.setStripTime(false);
        }

        public void updateUI() {
            this.setUI((ComponentUI)new BasicCalendarPaneUI(){

                protected void createNestedComponents() {
                    super.createNestedComponents();
                    CalendarGridPanel gridComponent = this.gridPanel;
                    ActionMap actionMap = gridComponent.getActionMap();
                    actionMap.put("##microba.commit##", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                this.commit();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.invalidate();
        }

        public void setDate(java.util.Date date) throws PropertyVetoException {
            if (this.mySettingDate) {
                super.setDate(date);
            } else {
                this.doSetDate(date);
            }
        }

        private void doSetDate(java.util.Date date) throws PropertyVetoException {
            this.mySettingDate = true;
            try {
                boolean dateChanged = !Comparing.equal((Object)date, (Object)this.getDate());
                super.setDate(date);
                if (!dateChanged) {
                    this.fireActionEvent();
                }
            }
            finally {
                this.mySettingDate = false;
            }
        }
    }
}

