/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorTextField;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatBasedGridCellEditor
extends GridCellEditor.Adapter {
    private final Format myFormat;
    private final ReservedCellValue myNullValue;
    private final GridCellEditorTextField myTextField;
    private final DataGrid myGrid;

    public FormatBasedGridCellEditor(Project project, @NotNull DataGrid grid, @NotNull Format format, @Nullable Object value, @Nullable ReservedCellValue nullValue, @Nullable EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "<init>"));
        }
        this.myFormat = format;
        this.myNullValue = nullValue;
        this.myGrid = grid;
        String text = this.doFormat(value);
        text = text != null ? text : this.format(null);
        this.myTextField = new GridCellEditorTextField(project, grid, Language.ANY, text, null, false, initiator);
        if (nullValue != null) {
            this.myTextField.addSettingsProvider(new EditorSettingsProvider(){

                public void customizeSettings(EditorEx editor) {
                    editor.setPlaceholder((CharSequence)FormatBasedGridCellEditor.this.myNullValue.getDisplayName());
                    editor.setShowPlaceholderWhenFocused(true);
                }
            });
        }
        Disposer.register((Disposable)this, (Disposable)this.myTextField);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "getComponent"));
        }
        return gridCellEditorTextField;
    }

    @Override
    @Nullable
    public Object getValue() {
        String text = this.myTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return this.myNullValue;
        }
        try {
            return this.myFormat.parseObject(text);
        }
        catch (ParseException ignore) {
            return text;
        }
    }

    @Override
    public boolean stop() {
        MarkupModel markupModel;
        String text = this.myTextField.getText();
        ParsePosition pos = new ParsePosition(0);
        this.myFormat.parseObject(text, pos);
        if (pos.getErrorIndex() == -1 || text.isEmpty()) {
            return true;
        }
        Editor editor = this.myTextField.getEditor();
        MarkupModel markupModel2 = markupModel = editor != null ? editor.getMarkupModel() : null;
        if (markupModel != null) {
            markupModel.removeAllHighlighters();
            markupModel.addRangeHighlighter(0, editor.getDocument().getTextLength(), 3000, editor.getColorsScheme().getAttributes(DatabaseColors.GRID_ERROR_VALUE), HighlighterTargetArea.EXACT_RANGE);
        }
        return false;
    }

    @NotNull
    protected GridCellEditorTextField getTextField() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "getTextField"));
        }
        return gridCellEditorTextField;
    }

    @Nullable
    protected ReservedCellValue getNullValue() {
        return this.myNullValue;
    }

    @NotNull
    protected String format(@Nullable Object value) {
        String string = (String)ObjectUtils.assertNotNull((Object)this.doFormat(value));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "format"));
        }
        return string;
    }

    @Nullable
    private String doFormat(@Nullable Object value) {
        try {
            return value instanceof ReservedCellValue || value == null ? "" : this.myFormat.format(value);
        }
        catch (IllegalArgumentException iae) {
            if (DataGridUtil.LOG.isDebugEnabled()) {
                DatabaseFamilyId dialectFamily = DataGridUtil.getDatabaseDialect(this.myGrid).getFamilyId();
                String message = "Failed to format object " + value + " of class " + value.getClass().getName() + " using format " + this.myFormat + ". Dialect: " + dialectFamily + "\n";
                DataGridUtil.LOG.debug(message, (Throwable)iae);
            }
            return null;
        }
    }

    protected static abstract class WithBrowseButton
    extends FormatBasedGridCellEditor
    implements ActionListener {
        private final ComponentWithBrowseButton<GridCellEditorTextField> myComponent;

        public WithBrowseButton(Project project, @NotNull DataGrid grid, @NotNull Format format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "<init>"));
            }
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "<init>"));
            }
            super(project, grid, format, value, nullValue, initiator);
            this.myComponent = new ComponentWithBrowseButton<GridCellEditorTextField>(this.getTextField(), (ActionListener)this){

                public void addNotify() {
                    super.addNotify();
                    DbUIUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WithBrowseButton.this.browseButtonPressed();
                        }
                    });
                }
            };
            this.myComponent.getButton().setBorder(UIManager.getBorder("Button.border"));
            this.myComponent.setRequestFocusEnabled(true);
            this.getTextField().addSettingsProvider(new EditorSettingsProvider(){

                public void customizeSettings(EditorEx editor) {
                    editor.getSelectionModel().removeSelection();
                }
            });
        }

        @NotNull
        public ComponentWithBrowseButton<GridCellEditorTextField> getComponent() {
            ComponentWithBrowseButton<GridCellEditorTextField> componentWithBrowseButton = this.myComponent;
            if (componentWithBrowseButton == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "getComponent"));
            }
            return componentWithBrowseButton;
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.browseButtonPressed();
        }

        @NotNull
        protected JBPopup createPopup(@NotNull JComponent component, @Nullable JComponent preferredFocusedComponent) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "createPopup"));
            }
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(component, preferredFocusedComponent).setModalContext(false).setFocusable(true).setCancelOnClickOutside(true).setRequestFocus(true).setResizable(false).createPopup();
            Disposer.register((Disposable)this, (Disposable)popup);
            JBPopup jBPopup = popup;
            if (jBPopup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "createPopup"));
            }
            return jBPopup;
        }

        protected void showPopup(@NotNull JBPopup popup) {
            if (popup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "showPopup"));
            }
            Dimension size = popup.getContent().getPreferredSize();
            FixedSizeButton button = this.getComponent().getButton();
            popup.show(new RelativePoint((Component)button, new Point(button.getWidth() - size.width, button.getHeight())));
        }

        protected abstract void browseButtonPressed();
    }
}

