/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.ChangeCellEditorLanguageAction;
import com.intellij.database.run.ui.grid.editors.CellEditorScratchRootType;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Consumer;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorTextField
extends EditorTextField
implements Disposable {
    private final DataGrid myGrid;

    public GridCellEditorTextField(Project project, @NotNull DataGrid grid, @NotNull Language language, @Nullable String text, @Nullable byte[] bytes, boolean multiline, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "<init>"));
        }
        super(GridCellEditorTextField.createDocument(project, language, text, bytes, initiator instanceof KeyEvent), project, (FileType)FileTypes.PLAIN_TEXT);
        this.putClientProperty("JBListTable.isTableCellEditor", Boolean.TRUE);
        this.myGrid = grid;
        this.installEditorSettingsProvider(multiline);
    }

    public String getText() {
        String lineSeparator;
        Document document = this.getDocument();
        String text = document.getText();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile file = documentManager.getFile(document);
        if (file != null && !(lineSeparator = documentManager.getLineSeparator(file, this.getProject())).equals("\n")) {
            text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
        }
        return text;
    }

    protected boolean shouldHaveBorder() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Editor editor = this.getEditor();
        if (editor instanceof EditorEx && !editor.isOneLineMode()) {
            JScrollBar horizontalScrollBar;
            JScrollPane scrollPane = ((EditorEx)editor).getScrollPane();
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            if (verticalScrollBar != null) {
                size.width += verticalScrollBar.getWidth();
            }
            if ((horizontalScrollBar = scrollPane.getHorizontalScrollBar()) != null) {
                size.height += horizontalScrollBar.getHeight();
            }
        }
        return size;
    }

    public Object getData(String dataId) {
        if (ChangeCellEditorLanguageAction.ACTION_HANDLER_KEY.is(dataId)) {
            return new ChangeCellEditorLanguageAction.Handler(){

                @Override
                public void changeLanguage(AnActionEvent e) {
                    Consumer<Language> chosenLanguageConsumer = new Consumer<Language>(){

                        public void consume(Language language) {
                            VirtualFile scratch;
                            Document document = language != null ? GridCellEditorTextField.this.getDocument() : null;
                            VirtualFile virtualFile = scratch = document != null ? FileDocumentManager.getInstance().getFile(document) : null;
                            if (scratch != null) {
                                CellEditorScratchRootType.setLanguage(GridCellEditorTextField.this.getProject(), scratch, language);
                                GridCellEditorTextField.this.setDocument(document);
                                IdeFocusManager.getInstance((Project)GridCellEditorTextField.this.getProject()).requestFocus((Component)((Object)GridCellEditorTextField.this), true);
                            }
                        }
                    };
                    LRUPopupBuilder.forFileLanguages((Project)GridCellEditorTextField.this.getProject(), null, (Consumer)chosenLanguageConsumer).showInBestPositionFor(e.getDataContext());
                }
            };
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return FileDocumentManager.getInstance().getFile(this.getDocument());
        }
        return super.getData(dataId);
    }

    public void dispose() {
        final VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
        if (file == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    file.delete((Object)GridCellEditorTextField.this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    protected boolean isEditable() {
        return true;
    }

    private void registerEnterAction(@NotNull Editor editor, final boolean multiline) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "registerEnterAction"));
        }
        CustomShortcutSet enterAndControlEnter = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"ENTER"), KeyboardShortcut.fromString((String)"control ENTER")});
        AnAction action = new AnAction("insertNewLineOrStopEditing1"){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)GridCellEditorTextField.this.getEditor()) == null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$3", "actionPerformed"));
                }
                InputEvent inputEvent = e.getInputEvent();
                boolean isCtrlEnter = inputEvent instanceof KeyEvent && inputEvent.isControlDown();
                boolean commitOnCtrlEnter = GridCellEditorTextField.this.myGrid.isEditingCellMaximized();
                if (!multiline || commitOnCtrlEnter == isCtrlEnter) {
                    GridCellEditorTextField.this.myGrid.stopEditing();
                } else {
                    this.performEditorEnter(e);
                }
            }

            private void performEditorEnter(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$3", "performEditorEnter"));
                }
                AnAction action = ActionManager.getInstance().getAction("EditorEnter");
                if (action != null) {
                    action.beforeActionPerformedUpdate(e);
                    if (e.getPresentation().isEnabled()) {
                        action.actionPerformed(e);
                    }
                }
            }
        };
        GridCellEditorTextField.registerAction(editor, action, (ShortcutSet)enterAndControlEnter);
    }

    private void registerTabAction(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "registerTabAction"));
        }
        CustomShortcutSet tabAndShiftTab = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"TAB"), KeyboardShortcut.fromString((String)"shift TAB")});
        AnAction action = new AnAction("insertTabOrStopEditing"){

            public void update(AnActionEvent e) {
                KeyEvent keyEvent = !GridCellEditorTextField.this.myGrid.isEditingCellMaximized() ? (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class) : null;
                e.getPresentation().setEnabledAndVisible(keyEvent != null);
            }

            public void actionPerformed(AnActionEvent e) {
                JComponent gridComponent = GridCellEditorTextField.this.myGrid.getPreferredFocusedComponent();
                KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
                KeyStroke stroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                Object actionKey = gridComponent.getInputMap(1).get(stroke);
                Action tabAction = gridComponent.getActionMap().get(actionKey);
                if (tabAction != null) {
                    tabAction.actionPerformed(new ActionEvent(gridComponent, keyEvent.getID(), keyEvent.toString(), keyEvent.getWhen(), keyEvent.getModifiers()));
                }
            }
        };
        GridCellEditorTextField.registerAction((Editor)editor, action, (ShortcutSet)tabAndShiftTab);
    }

    private static void registerAction(@NotNull Editor editor, @NotNull AnAction action, @NotNull ShortcutSet shortcutSet) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "registerAction"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "registerAction"));
        }
        if (shortcutSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutSet", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "registerAction"));
        }
        action.registerCustomShortcutSet(shortcutSet, editor.getComponent());
    }

    private void installEditorSettingsProvider(final boolean multiline) {
        this.addSettingsProvider(new EditorSettingsProvider(){

            public void customizeSettings(EditorEx editor) {
                VirtualFile file = FileDocumentManager.getInstance().getFile(GridCellEditorTextField.this.getDocument());
                if (file != null) {
                    EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file, editor.getColorsScheme(), GridCellEditorTextField.this.getProject());
                    editor.setHighlighter(highlighter);
                }
                editor.setRendererMode(!GridCellEditorTextField.this.isEditable());
                editor.setColorsScheme(editor.createBoundColorSchemeDelegate((EditorColorsScheme)GridCellEditorTextField.this.myGrid.getColorsScheme()));
                editor.setOneLineMode(!multiline);
                editor.setVerticalScrollbarVisible(multiline);
                editor.setHorizontalScrollbarVisible(multiline);
                editor.getSettings().setAdditionalColumnsCount(2);
                editor.getCaretModel().moveToOffset(0);
                if (GridCellEditorTextField.this.isEditable() && (!multiline || GridCellEditorTextField.this.getDocument().getLineCount() == 1)) {
                    editor.getSelectionModel().setSelection(0, GridCellEditorTextField.this.getDocument().getTextLength());
                }
                editor.setContextMenuGroupId(null);
                editor.addEditorMouseListener((EditorMouseListener)new EditorPopupHandler(){

                    public void invokePopup(EditorMouseEvent event) {
                        MouseEvent mouseEvent = event.getMouseEvent();
                        Component component = (Component)mouseEvent.getSource();
                        int x = mouseEvent.getX();
                        int y = mouseEvent.getY();
                        GridCellEditorsUtil.showCellEditorPopup(GridCellEditorTextField.this.myGrid, component, x, y);
                    }
                });
                GridCellEditorTextField.this.registerEnterAction((Editor)editor, multiline);
                GridCellEditorTextField.this.registerTabAction(editor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Document createDocument(@NotNull Project project, @NotNull Language language, @Nullable String text, @Nullable byte[] bytes, boolean clear) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "createDocument"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "createDocument"));
        }
        Document document = null;
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(GridCellEditor.class);
        try {
            VirtualFile scratchFile = CellEditorScratchRootType.newScratch(project);
            if (bytes != null) {
                scratchFile.setBinaryContent(bytes);
            } else if (text != null) {
                VfsUtil.saveText((VirtualFile)scratchFile, (String)text);
            }
            VfsUtilCore.virtualToIoFile((VirtualFile)scratchFile).deleteOnExit();
            CellEditorScratchRootType.setLanguage(project, scratchFile, language);
            document = FileDocumentManager.getInstance().getDocument(scratchFile);
            if (document != null && clear) {
                document.setText((CharSequence)"");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            token.finish();
        }
        Document document2 = document != null ? document : EditorFactory.getInstance().createDocument((CharSequence)StringUtil.notNullize((String)(clear ? null : text)));
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField", "createDocument"));
        }
        return document2;
    }
}

