/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridColumnTypeInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellRenderers
implements Disposable {
    private final DataGrid myGrid;
    private final Map<GridCellRendererFactory, GridCellRenderer> myCreatedRenderers;

    public GridCellRenderers(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/renderers/GridCellRenderers", "<init>"));
        }
        this.myCreatedRenderers = new THashMap(ContainerUtil.identityStrategy());
        this.myGrid = grid;
    }

    @Nullable
    public GridCellRenderer getRenderer(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        GridColumnTypeInfo typeInfo;
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/renderers/GridCellRenderers", "getRenderer"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/renderers/GridCellRenderers", "getRenderer"));
        }
        DataConsumer.Column c = this.myGrid.getDataModel().getColumn(column);
        GridColumnTypeInfo gridColumnTypeInfo = typeInfo = c != null ? new GridColumnTypeInfo(c) : null;
        if (typeInfo == null) {
            return null;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(this.myGrid);
        GridCellRenderer bestRenderer = null;
        int bestSuitability = 0;
        for (GridCellRendererFactory factory : GridCellRendererFactories.getInstance().getFactoriesFor(dialect, typeInfo)) {
            GridCellRenderer renderer = this.getOrCreateRenderer(factory);
            int suitability = renderer.getSuitability(row, column);
            if (suitability <= bestSuitability) continue;
            bestRenderer = renderer;
            bestSuitability = suitability;
        }
        return bestRenderer;
    }

    public void dispose() {
        for (GridCellRenderer renderer : this.myCreatedRenderers.values()) {
            Disposer.dispose((Disposable)renderer);
        }
    }

    private GridCellRenderer getOrCreateRenderer(GridCellRendererFactory factory) {
        GridCellRenderer renderer = this.myCreatedRenderers.get(factory);
        if (renderer == null) {
            renderer = factory.createRenderer(this.myGrid);
            this.myCreatedRenderers.put(factory, renderer);
        }
        return renderer;
    }
}

