/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.fix.DdlGraphFixing;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaEditorHelper {
    public static final Condition<DasObject> LIGHT_EXPORTED = new Condition<DasObject>(){

        public boolean value(DasObject object) {
            DeObject de = (DeObject)object;
            return de.lightExported;
        }
    };
    private final SchemaEditor mySchemaEditor;
    private final DdlGenerator myDdlGenerator;
    private DdlGraphBuilder myDdlGraphBuilder;

    public SchemaEditorHelper(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/SchemaEditorHelper", "<init>"));
        }
        this.myDdlGraphBuilder = null;
        this.mySchemaEditor = context.getDialect().getSchemaEditor();
        this.myDdlGenerator = this.mySchemaEditor.createGenerator(context);
    }

    @NotNull
    public static JBIterable<ObjectAction> basicTraversal(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/SchemaEditorHelper", "basicTraversal"));
        }
        JBIterable jBIterable = ((JBTreeTraverser)model.traverser().expandAndSkip(LIGHT_EXPORTED)).bfsTraversal().filter(DeObject.class).transform((Function)new Function<DeObject, ObjectAction>(){

            public ObjectAction fun(DeObject object) {
                return new ObjectAction(object.editedObject == null ? ObjectAction.Action.CREATE : ObjectAction.Action.ALTER, object);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "basicTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public SchemaEditor getSchemaEditor() {
        SchemaEditor schemaEditor = this.mySchemaEditor;
        if (schemaEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "getSchemaEditor"));
        }
        return schemaEditor;
    }

    @NotNull
    public SchemaExportHelper createExportHelper(@NotNull DasModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/SchemaEditorHelper", "createExportHelper"));
        }
        SchemaExportHelper schemaExportHelper = this.mySchemaEditor.createExportHelper(this.myDdlGenerator.getContext(), model);
        if (schemaExportHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "createExportHelper"));
        }
        return schemaExportHelper;
    }

    @NotNull
    public DdlGenerator getDdlGenerator() {
        DdlGenerator ddlGenerator = this.myDdlGenerator;
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "getDdlGenerator"));
        }
        return ddlGenerator;
    }

    @NotNull
    public DdlGraphBuilder getDdlGraphBuilder() {
        if (this.myDdlGraphBuilder == null) {
            this.myDdlGraphBuilder = new DdlGraphBuilder(this.myDdlGenerator.getContext().getDialect());
        }
        DdlGraphBuilder ddlGraphBuilder = this.myDdlGraphBuilder;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "getDdlGraphBuilder"));
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public List<DdlGraph> getGraphComponents() {
        List<DdlGraph> list = this.getDdlGraphBuilder().buildComponents();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "getGraphComponents"));
        }
        return list;
    }

    @NotNull
    public SchemaEditorHelper create(@NotNull DeObject object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/SchemaEditorHelper", "create"));
        }
        this.getDdlGenerator().addOperation(this.getDdlGraphBuilder(), DdlGraph.DdlOperation.CREATE, object, data);
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "create"));
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper alter(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/SchemaEditorHelper", "alter"));
        }
        SchemaEditorHelper schemaEditorHelper = this.alter(model, SchemaEditorHelper.basicTraversal(model));
        if (schemaEditorHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "alter"));
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper alter(@NotNull DeModel model, @NotNull JBIterable<ObjectAction> actions) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/SchemaEditorHelper", "alter"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/schemaEditor/SchemaEditorHelper", "alter"));
        }
        for (ObjectAction action : actions.toList()) {
            if (action.action == ObjectAction.Action.DROP) {
                model.getExportHelper().pullDependencies(action.object);
                continue;
            }
            if (action.action != ObjectAction.Action.ALTER) continue;
            model.getExportHelper().pullDependencies(action.object.editedObject);
        }
        for (ObjectAction action : actions) {
            if (action.action == ObjectAction.Action.DROP) {
                this.drop(action.object, null);
                continue;
            }
            if (action.action == ObjectAction.Action.CREATE) {
                this.create(action.object, null);
                continue;
            }
            if (action.action != ObjectAction.Action.ALTER) continue;
            DeObject object = (DeObject)ObjectUtils.tryCast((Object)action.object.editedObject, DeObject.class);
            this.alter((DeObject)ObjectUtils.assertNotNull((Object)object), action.object, null);
        }
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "alter"));
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper drop(@NotNull DeObject object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/SchemaEditorHelper", "drop"));
        }
        this.getDdlGenerator().addOperation(this.getDdlGraphBuilder(), DdlGraph.DdlOperation.DROP, object, data);
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "drop"));
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper alter(@NotNull DeObject object, @NotNull DeObject modified, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/SchemaEditorHelper", "alter"));
        }
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/intellij/database/schemaEditor/SchemaEditorHelper", "alter"));
        }
        if (data == null) {
            data = this.getDdlGraphBuilder().newData(null);
        }
        DasDdlOperations.set(data, DdlGraph.ALTER_TO, modified);
        this.getDdlGenerator().addOperation(this.getDdlGraphBuilder(), DdlGraph.DdlOperation.ALTER, object, data);
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "alter"));
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper fix() {
        DdlGraphFixing.fix(this.getDdlGenerator(), this.getDdlGraphBuilder());
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "fix"));
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper clear() {
        this.myDdlGraphBuilder = null;
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "clear"));
        }
        return schemaEditorHelper;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeModel editedModel, @NotNull Function<Runnable, ActionCallback> asyncProcessor) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/SchemaEditorHelper", "generate"));
        }
        if (editedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editedModel", "com/intellij/database/schemaEditor/SchemaEditorHelper", "generate"));
        }
        if (asyncProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncProcessor", "com/intellij/database/schemaEditor/SchemaEditorHelper", "generate"));
        }
        DdlBuilder ddlBuilder = this.getDdlGenerator().generate(builder, this.getDdlGraphBuilder(), new DdlBuildingContext(this.getDdlGenerator().buildState(editedModel), asyncProcessor, this.getDdlGenerator().getContext()));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "generate"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeModel editedModel) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/SchemaEditorHelper", "generate"));
        }
        if (editedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editedModel", "com/intellij/database/schemaEditor/SchemaEditorHelper", "generate"));
        }
        DdlBuilder ddlBuilder = this.generate(builder, editedModel, new Function<Runnable, ActionCallback>(){

            public ActionCallback fun(Runnable runnable) {
                runnable.run();
                return ActionCallback.DONE;
            }
        });
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditorHelper", "generate"));
        }
        return ddlBuilder;
    }

    public static class ObjectAction {
        public final Action action;
        public final DeObject object;

        public ObjectAction(Action action, DeObject object) {
            this.action = action;
            this.object = object;
        }

        public static enum Action {
            CREATE,
            ALTER,
            DROP;

        }
    }
}

