/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeKeysSet;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.ListSet;
import com.intellij.database.schemaEditor.model.ListSetImpl;
import com.intellij.database.util.DasUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeTable
extends DeObject
implements DasTable {
    public static final DeTable STUB = new DeTable("STUB", null, DeModel.STUB);
    public boolean temporary;
    @Nullable
    public DeObject parent;
    public final List<DeColumn> columns;
    public final ListSet<DeIndex> indices;
    public final ListSet<DeForeignKey> foreignKeys;
    public final ListSet<DeConstraint> constraints;
    public final DeKeysSet keys;

    public DeTable(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeTable", "<init>"));
        }
        super(model);
        this.columns = ContainerUtil.newArrayList();
        this.indices = ListSetImpl.create();
        this.foreignKeys = ListSetImpl.create();
        this.constraints = ListSetImpl.create();
        this.keys = new DeKeysSet();
    }

    public DeTable(@NotNull String name, @Nullable DeObject parent, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/model/DeTable", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeTable", "<init>"));
        }
        super(name, model);
        this.columns = ContainerUtil.newArrayList();
        this.indices = ListSetImpl.create();
        this.foreignKeys = ListSetImpl.create();
        this.constraints = ListSetImpl.create();
        this.keys = new DeKeysSet();
        this.parent = parent;
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeTable", "copyFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeTable", "copyFrom"));
        }
        super.copyFrom(obj, withChildren, copier);
        DeTable tab = (DeTable)obj;
        this.parent = copier.copy(tab.parent, false);
        this.temporary = tab.temporary;
        DeTable deTable = this;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeTable", "copyFrom"));
        }
        return deTable;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeTable", "emptyClone"));
        }
        DeTable deTable = new DeTable(model);
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeTable", "emptyClone"));
        }
        return deTable;
    }

    @Override
    public void copyChildrenFrom(@NotNull DeObject obj, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeTable", "copyChildrenFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeTable", "copyChildrenFrom"));
        }
        super.copyChildrenFrom(obj, copier);
        DeTable tab = (DeTable)obj;
        this.columns.clear();
        for (DeColumn column : tab.columns) {
            this.columns.add(copier.copy(column, true));
        }
        this.indices.clear();
        for (DeIndex index : tab.indices) {
            this.indices.add(copier.copy(index, true));
        }
        this.foreignKeys.clear();
        for (DeForeignKey foreignKey : tab.foreignKeys) {
            this.foreignKeys.add(copier.copy(foreignKey, true));
        }
        this.constraints.clear();
        for (DeConstraint constraint : tab.constraints) {
            this.constraints.add(copier.copy(constraint, true));
        }
        List newKeys = ContainerUtil.newSmartList();
        for (DeTableKey key : tab.keys) {
            newKeys.add(copier.copy(key, true));
        }
        this.keys.setKeys(newKeys);
        this.keys.setPrimaryKey(copier.copy(tab.keys.getPrimaryKey(), true));
    }

    @Override
    @NotNull
    public JBIterable<DeObject> getChildren() {
        JBIterable jBIterable = JBIterable.from(this.columns).append(this.indices).append(this.foreignKeys).append(this.constraints).append((Iterable)this.keys);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeTable", "getChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public DeObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children, @NotNull Collection<? extends DasObject> otherChildren) {
        HashSet editedIgnore;
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/schemaEditor/model/DeTable", "isAlteredIgnoringChild"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/schemaEditor/model/DeTable", "isAlteredIgnoringChild"));
        }
        if (otherChildren == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherChildren", "com/intellij/database/schemaEditor/model/DeTable", "isAlteredIgnoringChild"));
        }
        DeTable table = (DeTable)other;
        if (children.isEmpty()) {
            editedIgnore = otherChildren;
        } else {
            editedIgnore = ContainerUtil.newHashSet();
            for (DeObject deObject : children) {
                if (deObject.editedObject == null) continue;
                editedIgnore.add(deObject.editedObject);
            }
            editedIgnore.addAll(otherChildren);
        }
        return super.isAlteredIgnoringChild(other, children, otherChildren) || DeTable.isAltered(this.columns, table.columns, children, (Collection<DasObject>)editedIgnore) || DeTable.isAltered(this.indices, table.indices, children, (Collection<DasObject>)editedIgnore) || DeTable.isAltered(this.foreignKeys, table.foreignKeys, children, (Collection<DasObject>)editedIgnore) || DeTable.isAltered(this.constraints, table.constraints, children, (Collection<DasObject>)editedIgnore) || DeTable.isAltered(this.keys, table.keys, children, (Collection<DasObject>)editedIgnore);
    }

    private static boolean isAltered(@NotNull Collection<? extends DeObject> a, @NotNull Collection<? extends DeObject> b, @NotNull Collection<? extends DeObject> ignore, @NotNull Collection<DasObject> editedIgnore) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/database/schemaEditor/model/DeTable", "isAltered"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/schemaEditor/model/DeTable", "isAltered"));
        }
        if (ignore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignore", "com/intellij/database/schemaEditor/model/DeTable", "isAltered"));
        }
        if (editedIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editedIgnore", "com/intellij/database/schemaEditor/model/DeTable", "isAltered"));
        }
        HashSet edited = ContainerUtil.newHashSet();
        for (DeObject deObject : a) {
            if (ignore.contains(deObject)) continue;
            DeObject editedObject = (DeObject)deObject.editedObject;
            if (!b.contains(editedObject)) {
                return true;
            }
            edited.add(editedObject);
        }
        for (DeObject deObject : b) {
            if (editedIgnore.contains(deObject) || edited.contains(deObject)) continue;
            return true;
        }
        for (DeObject deObject : a) {
            if (ignore.contains(deObject) || !deObject.isAltered((DeObject)ObjectUtils.assertNotNull((Object)deObject.editedObject))) continue;
            return true;
        }
        return false;
    }

    private static boolean isAltered(@Nullable DeObject a, @Nullable DeObject b) {
        if (a == null || b == null) {
            return a != b;
        }
        return a.editedObject != b || a.isAltered((DeObject)a.editedObject);
    }

    private static boolean isAltered(@NotNull List<? extends DeObject> a, @NotNull List<? extends DeObject> b, @NotNull Collection<? extends DeObject> ignore, @NotNull Collection<DasObject> editedIgnore) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/database/schemaEditor/model/DeTable", "isAltered"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/schemaEditor/model/DeTable", "isAltered"));
        }
        if (ignore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignore", "com/intellij/database/schemaEditor/model/DeTable", "isAltered"));
        }
        if (editedIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editedIgnore", "com/intellij/database/schemaEditor/model/DeTable", "isAltered"));
        }
        int i = 0;
        int j = 0;
        while (i < a.size() && j < b.size()) {
            boolean skip = false;
            if (ignore.contains(a.get(i))) {
                ++i;
                skip = true;
            }
            if (editedIgnore.contains(b.get(j))) {
                ++j;
                skip = true;
            }
            if (skip) continue;
            if (DeTable.isAltered(a.get(i), b.get(j))) {
                return true;
            }
            ++i;
            ++j;
        }
        return i != a.size() || j != b.size();
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
        DeColumn column = (DeColumn)ObjectUtils.tryCast((Object)columnInfo, DeColumn.class);
        if (column == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeTable", "getColumnAttrs"));
            }
            return set;
        }
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (column.flags.contains((Object)DeColumn.Flag.AUTO_INC)) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        if (this.keys.getPrimaryKey() != null && this.keys.getPrimaryKey().columns.contains(column)) {
            set.add(DasColumn.Attribute.PRIMARY_KEY);
        }
        for (DeForeignKey deForeignKey : this.foreignKeys) {
            if (!Iterables.contains(deForeignKey.getColumns(), (Object)column)) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DeIndex deIndex : this.indices) {
            if (!Iterables.contains(deIndex.getColumns(), (Object)column)) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeTable", "getColumnAttrs"));
        }
        return enumSet;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeTable", "getKind"));
        }
        return objectKind;
    }
}

