/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.mssql;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MssqlRenameKIFKOperations {

    private static class RecreateOrRenameOperationBase<T extends DeObject>
    extends DasDdlOperations.DropCreateOperation<T> {
        public RecreateOrRenameOperationBase(@NotNull DdlGraph.DdlOperation alter) {
            if (alter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alter", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "<init>"));
            }
            super(alter, DdlGraph.DdlOperation.DROP, DdlGraph.DdlOperation.CREATE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isRenameOnly(@NotNull DeObject from, @NotNull DeObject to) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "isRenameOnly"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "isRenameOnly"));
            }
            if (!Comparing.equal((String)to.name, (String)from.name)) {
                String name = to.name;
                try {
                    to.name = from.name;
                    boolean bl = !to.isAltered(from);
                    return bl;
                }
                finally {
                    to.name = name;
                }
            }
            return false;
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull T object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "generate"));
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            builder.keyword("EXEC").space().identifier("sp_rename").space().symbol("'");
            if (object.getKind() == ObjectKind.INDEX) {
                builder.formatQualification((DasObject)object, ObjectKind.SCHEMA, ObjectKind.TABLE, ObjectKind.INDEX);
            } else {
                builder.formatQualification((DasObject)object, ObjectKind.SCHEMA, object.getKind());
            }
            builder.symbol("',").space().identifier((DasObject)object, to.name).symbol(",").space();
            if (object.getKind() == ObjectKind.INDEX) {
                builder.literal("'INDEX'");
            } else {
                builder.literal("'OBJECT'");
            }
            DdlBuilder ddlBuilder = builder.newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull T from, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "addToBuilder"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "addToBuilder"));
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (RecreateOrRenameOperationBase.isRenameOnly(from, to)) {
                DdlGenerator ddlGenerator = this.addSelfToBuilder(generator, builder, from, data);
                if (ddlGenerator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "addToBuilder"));
                }
                return ddlGenerator;
            }
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, from, data);
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "addToBuilder"));
            }
            return ddlGenerator;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull T object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "getImplemented"));
            }
            JBIterable jBIterable = JBIterable.of((Object[])new DdlOperationKey[]{new DdlOperationKey((DeObject)object, DdlGraph.DdlOperation.RENAME), new DdlOperationKey((DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data)), DdlGraph.DdlOperation.POST_RENAME)});
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/mssql/MssqlRenameKIFKOperations$RecreateOrRenameOperationBase", "getImplemented"));
            }
            return jBIterable;
        }
    }

    public static class RecreateOrRenameForeignKeyOperation
    extends RecreateOrRenameOperationBase<DeForeignKey> {
        public RecreateOrRenameForeignKeyOperation() {
            super(DasDdlOperations.ALTER_FOREIGN_KEY);
        }
    }

    public static class RecreateOrRenameTableKeyOperation
    extends RecreateOrRenameOperationBase<DeTableKey> {
        public RecreateOrRenameTableKeyOperation() {
            super(DasDdlOperations.ALTER_TABLE_KEY);
        }
    }

    public static class RecreateOrRenameIndexOperation
    extends RecreateOrRenameOperationBase<DeIndex> {
        public RecreateOrRenameIndexOperation() {
            super(DasDdlOperations.ALTER_INDEX);
        }
    }
}

