/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.sqlite;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteAlterTableOperation
extends DasDdlOperations.AlterTableOperation {
    @Override
    @NotNull
    public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable from, @Nullable UserDataHolder data) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
        }
        assert (data != null);
        DeTable to = (DeTable)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        LinkedHashSet alter = ContainerUtil.newLinkedHashSet();
        LinkedHashSet drop = ContainerUtil.newLinkedHashSet();
        LinkedHashSet create = ContainerUtil.newLinkedHashSet();
        this.classifyChildren(from, to, create, alter, drop);
        boolean unsupOpsUsed = SqliteAlterTableOperation.isUnsupOpsUsed(create, alter, drop);
        if (!unsupOpsUsed) {
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, from, data);
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }
        generator.addOperation(builder, DasDdlOperations.SQLITE_REPLACE_TABLE, to, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_FROM, from));
        DdlGenerator ddlGenerator = generator;
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
        }
        return ddlGenerator;
    }

    private static boolean isUnsupOpsUsed(@NotNull Set<DeObject> create, @NotNull Set<DeObject> alter, @NotNull Set<DeObject> drop) {
        if (create == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "create", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "isUnsupOpsUsed"));
        }
        if (alter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alter", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "isUnsupOpsUsed"));
        }
        if (drop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drop", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "isUnsupOpsUsed"));
        }
        for (DeObject object : create) {
            if (object.getKind() == ObjectKind.COLUMN || object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        for (DeObject object : alter) {
            if (!object.isAltered((DeObject)ObjectUtils.assertNotNull((Object)object.editedObject)) || object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        for (DeObject object : drop) {
            if (object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public DdlGenerator removeFromBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable from, @Nullable UserDataHolder data) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "removeFromBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "removeFromBuilder"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "removeFromBuilder"));
        }
        assert (data != null);
        DeTable to = (DeTable)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        generator.removeOperation(builder, DasDdlOperations.SQLITE_REPLACE_TABLE, to, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_FROM, from));
        DdlGenerator ddlGenerator = super.removeFromBuilder(generator, builder, from, data);
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "removeFromBuilder"));
        }
        return ddlGenerator;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getImplemented(@NotNull DeTable object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "getImplemented"));
        }
        JBIterable jBIterable = super.getImplemented(object, data).append(DasDdlOperations.getObjectsRenameNDropKeys((Iterable<? extends DeObject>)((JBTreeTraverser)object.model.traverser().withRoot((Object)object)).filter(DeObject.class)));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "getImplemented"));
        }
        return jBIterable;
    }
}

