/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class DataViewsComponent
implements ConfigurableUi<DatabaseSettings> {
    private JPanel myPanel;
    private JTextField myResultPageSizeTextField;
    private JTextField myFilterHistorySizeField;
    private JTextField myLobLengthLimitField;
    private JTextField myPrefetchSizeTextField;

    public DataViewsComponent() {
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/DataViewsComponent", "reset"));
        }
        this.myResultPageSizeTextField.setText(String.valueOf(settings.getPageSize()));
        this.myFilterHistorySizeField.setText(String.valueOf(settings.getFiltersHistorySize()));
        this.myLobLengthLimitField.setText(String.valueOf(settings.getMaxLobLength()));
        this.myPrefetchSizeTextField.setText(String.valueOf(settings.getPrefetchSize()));
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/DataViewsComponent", "isModified"));
        }
        if (settings.getPageSize() != StringUtil.parseInt((String)this.myResultPageSizeTextField.getText(), (int)0)) {
            return true;
        }
        if (settings.getFiltersHistorySize() != StringUtil.parseInt((String)this.myFilterHistorySizeField.getText(), (int)0)) {
            return true;
        }
        if (settings.getMaxLobLength() != StringUtil.parseInt((String)this.myLobLengthLimitField.getText(), (int)0)) {
            return true;
        }
        return settings.getPrefetchSize() != StringUtil.parseInt((String)this.myPrefetchSizeTextField.getText(), (int)0);
    }

    public void apply(@NotNull DatabaseSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/DataViewsComponent", "apply"));
        }
        settings.setPageSize(StringUtil.parseInt((String)this.myResultPageSizeTextField.getText(), (int)0));
        settings.setFiltersHistorySize(StringUtil.parseInt((String)this.myFilterHistorySizeField.getText(), (int)0));
        settings.setMaxLobLength(StringUtil.parseInt((String)this.myLobLengthLimitField.getText(), (int)0));
        settings.setPrefetchSize(StringUtil.parseInt((String)this.myPrefetchSizeTextField.getText(), (int)0));
        DatabaseSettings.fireSettingsChanged();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/settings/DataViewsComponent", "getComponent"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBTextField jBTextField = new JBTextField();
        this.myResultPageSizeTextField = jBTextField;
        jBTextField.setColumns(6);
        jBTextField.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Result set page size:");
        jBLabel.setDisplayedMnemonic('P');
        jBLabel.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Filter history size:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBTextField jBTextField2 = new JBTextField();
        this.myFilterHistorySizeField = jBTextField2;
        jBTextField2.setColumns(6);
        jBTextField2.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField2, new GridConstraints(2, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Max LOB length (bytes):");
        jBLabel3.setDisplayedMnemonic('L');
        jBLabel3.setDisplayedMnemonicIndex(8);
        jBLabel3.setToolTipText("LOB values exceeding the limit will not be loaded and displayed");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBTextField jBTextField3 = new JBTextField();
        this.myLobLengthLimitField = jBTextField3;
        jBTextField3.setColumns(6);
        jBTextField3.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField3, new GridConstraints(3, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBTextField jBTextField4 = new JBTextField();
        this.myPrefetchSizeTextField = jBTextField4;
        jBTextField4.setColumns(6);
        jBTextField4.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField4, new GridConstraints(1, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Result set prefetch size:");
        jBLabel4.setDisplayedMnemonic('F');
        jBLabel4.setDisplayedMnemonicIndex(14);
        jBLabel4.setToolTipText("Default number of rows to be preloaded by a jdbc driver when fetching a result set");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField);
        jBLabel2.setLabelFor((Component)jBTextField2);
        jBLabel3.setLabelFor((Component)jBTextField3);
        jBLabel4.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

