/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.dataSource.DataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DataSourceUsageCollector
extends AbstractApplicationUsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/statistic/DataSourceUsageCollector", "getProjectUsages"));
        }
        HashSet set = new HashSet();
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            String name;
            if (!(dataSource.getDelegate() instanceof DataSource) || StringUtil.isEmpty((String)(name = dataSource.getDatabaseProductName()))) continue;
            set.add((Object)new UsageDescriptor(name + "/" + dataSource.getDatabaseProductVersion(), 1));
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/DataSourceUsageCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"jdbc-datasource", (double)100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/DataSourceUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

