/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.Case;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDialectsUtil;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public class DbImplUtil {
    public static final Condition<DbElement> CAN_CONNECT_TO = new Condition<DbElement>(){

        public boolean value(DbElement o) {
            return DbImplUtil.canConnectTo(o);
        }
    };
    private static char ESCAPE_CHAR = (char)35;
    private static final String COMPUTED_COLUMN = "COMPUTED_COLUMN";
    private static final VfsDependentEnum<String> myDialectAndDataSourcesEnumerator = new VfsDependentEnum("sql_dialects_and_data_sources", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);

    private DbImplUtil() {
    }

    public static boolean valuesEqual(Object v1, Object v2) {
        ThreeState result;
        if (v1 == ReservedCellValue.NULL) {
            v1 = null;
        }
        if (v2 == ReservedCellValue.NULL) {
            v2 = null;
        }
        if ((result = DbImplUtil.simpleEquals(v1, v2)) == ThreeState.UNSURE) {
            result = DbImplUtil.numberEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = DbImplUtil.arrayEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = DbImplUtil.clobEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = ThreeState.NO;
        }
        return result.toBoolean();
    }

    public static int valueHashCode(Object v) {
        if (v == ReservedCellValue.NULL) {
            v = null;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return Long.valueOf(n.longValue()).hashCode() * 31 + Double.valueOf(n.doubleValue()).hashCode();
        }
        if (v instanceof byte[]) {
            return Arrays.hashCode((byte[])v);
        }
        if (v instanceof char[]) {
            return Arrays.hashCode((char[])v);
        }
        if (v instanceof LobInfo.ClobInfo) {
            return Comparing.hashcode((Object)((LobInfo.ClobInfo)v).data);
        }
        return Comparing.hashcode((Object)v);
    }

    private static ThreeState simpleEquals(Object v1, Object v2) {
        return Comparing.equal((Object)v1, (Object)v2) ? ThreeState.YES : ThreeState.UNSURE;
    }

    private static ThreeState numberEquals(Object v1, Object v2) {
        Number n1 = (Number)ObjectUtils.tryCast((Object)v1, Number.class);
        Number n2 = (Number)ObjectUtils.tryCast((Object)v2, Number.class);
        if (n1 != null && n2 != null) {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            return ThreeState.fromBoolean((l1 == l2 && (d1 == d2 || Double.isNaN(d1) && Double.isNaN(d2)) ? 1 : 0) != 0);
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState arrayEquals(Object v1, Object v2) {
        if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && v1.getClass().isArray()) {
            if (v1 instanceof byte[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((byte[])v1, (byte[])v2));
            }
            if (v1 instanceof char[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((char[])v1, (char[])v2));
            }
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState clobEquals(Object v1, Object v2) {
        LobInfo.ClobInfo info1 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v1, LobInfo.ClobInfo.class);
        LobInfo.ClobInfo info2 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v2, LobInfo.ClobInfo.class);
        if (info1 != null && info2 != null) {
            return ThreeState.fromBoolean((!info2.isTruncated() && DbImplUtil.clobStringEquals(info1, info2.data) ? 1 : 0) != 0);
        }
        if (info1 != null && v2 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info1, (String)v2));
        }
        if (info2 != null && v1 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info2, (String)v1));
        }
        return ThreeState.UNSURE;
    }

    private static boolean clobStringEquals(@NotNull LobInfo.ClobInfo lob, @Nullable String s) {
        if (lob == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lob", "com/intellij/database/util/DbImplUtil", "clobStringEquals"));
        }
        return !lob.isTruncated() && Comparing.equal((String)lob.data, (String)s);
    }

    public static DdlBuilder createBuilderForExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createBuilderForExec"));
        }
        return new DdlBuilder().withDialect(dialect).qualifyReferences(true).quoteIdentifiers(true);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createBuilderForUIExec"));
        }
        return DbImplUtil.createBuilderForExec(dialect).quoteIdentifiers(false);
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect) {
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, -1);
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, int rows) {
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, rows, Collections.<String>emptyList(), Collections.emptyList());
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, final @NotNull DatabaseDialectEx dialect, int rows, final @NotNull Iterable<String> columnNames, final @NotNull Iterable<?> values) {
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        final DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect);
        Function<String, Boolean> appendWhereClause = Iterables.isEmpty(columnNames) ? null : new Function<String, Boolean>(){

            public Boolean fun(@NotNull String tableNameAlias) {
                if (tableNameAlias == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableNameAlias", "com/intellij/database/util/DbImplUtil$2", "fun"));
                }
                builder.space().keyword("WHERE").space();
                DbImplUtil.composeWhereCondition(builder, columnNames, values, tableNameAlias, dialect);
                return Boolean.TRUE;
            }
        };
        return DbImplUtil.createSelectAllQuery(builder, databaseTable, dialect, rows, appendWhereClause);
    }

    @NotNull
    public static List<Pair<DataConsumer.Column, Object>> createSelectAllQueryWithParameters(final @NotNull DdlBuilder builder, @NotNull DasTable table, final @NotNull DatabaseDialectEx dialect, int rows, final @NotNull List<DataConsumer.Column> columns, final @NotNull List<Object> values) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (columns.isEmpty()) {
            DbImplUtil.createSelectAllQuery(table, dialect, rows);
            ImmutableList immutableList = ContainerUtil.immutableList((Object[])new Pair[0]);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
            }
            return immutableList;
        }
        final List nullability = ContainerUtil.map(values, (Function)new Function<Object, Boolean>(){

            public Boolean fun(Object o) {
                return o == null;
            }
        });
        final ArrayList columnValuePairs = ContainerUtil.newArrayList();
        Function<String, Boolean> appendWhereClauseFunction = new Function<String, Boolean>(){

            public Boolean fun(@NotNull String tableNameAlias) {
                if (tableNameAlias == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableNameAlias", "com/intellij/database/util/DbImplUtil$4", "fun"));
                }
                builder.space().keyword("WHERE").space();
                List<DataConsumer.Column> parameterColumns = DbImplUtil.composeWhereConditionWithParameters(builder, columns, nullability, tableNameAlias, dialect);
                int originalColumnIdx = 0;
                for (DataConsumer.Column parameterColumn : parameterColumns) {
                    DataConsumer.Column originalColumn;
                    while (parameterColumn != (originalColumn = (DataConsumer.Column)columns.get(originalColumnIdx))) {
                        ++originalColumnIdx;
                    }
                    columnValuePairs.add(Pair.create((Object)originalColumn, values.get(originalColumnIdx)));
                }
                return Boolean.TRUE;
            }
        };
        DbImplUtil.createSelectAllQuery(builder, table, dialect, rows, appendWhereClauseFunction);
        ArrayList arrayList = columnValuePairs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        return arrayList;
    }

    private static DdlBuilder createSelectAllQuery(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @NotNull DatabaseDialectEx dialect, int rows, @Nullable Function<String, Boolean> appendWhereClause) {
        boolean whereClauseAppended;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dasTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        String rowsAsStr = String.valueOf(rows);
        builder.keyword("SELECT").space();
        DatabaseFamilyId familyId = dialect.getFamilyId();
        if (rows > 0 && familyId.isTransactSql()) {
            builder.keyword("TOP").space().literal(rowsAsStr).space();
        }
        String alias = "t";
        builder.alias(alias).symbol(".").symbol("*");
        builder.space().keyword("FROM").space().qualifiedRef((DasObject)dasTable).space().alias(alias);
        boolean bl = whereClauseAppended = appendWhereClause != null && Boolean.TRUE.equals(appendWhereClause.fun((Object)alias));
        if (rows > 0) {
            if (familyId.isOracle()) {
                if (!whereClauseAppended) {
                    builder.space().keyword("WHERE").space();
                } else {
                    builder.space().keyword("AND").space();
                }
                builder.keyword("ROWNUM").space().symbol("<=").space().literal(String.valueOf(rows));
            } else if (familyId.isMysql() || familyId.isPostgres() || familyId.isSqlite() || familyId.isHsqldb()) {
                builder.space().keyword("LIMIT").space().literal(rowsAsStr);
            } else if (familyId.isDb2() || familyId.isDerby()) {
                builder.space().keywords("FETCH", "FIRST").space().literal(rowsAsStr).space().keywords("ROWS", "ONLY");
            }
        }
        return builder;
    }

    @Nullable
    public static String createSelectCountQuery(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @Nullable String queryText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbImplUtil", "createSelectCountQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectCountQuery"));
        }
        queryText = queryText != null ? StringUtil.trimEnd((String)queryText, (String)";") : "";
        SqlResultSetExpression e = DbSqlUtil.parseQuery(project, DbSqlUtil.getSqlDialect(dialect), queryText, null);
        if (e == null) {
            return null;
        }
        SqlQueryExpression query = e instanceof SqlWithQueryExpression ? (SqlQueryExpression)ObjectUtils.tryCast((Object)((SqlWithQueryExpression)e).getExpression(), SqlQueryExpression.class) : (e instanceof SqlQueryExpression ? (SqlQueryExpression)e : null);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect);
        if (query == null || !DbImplUtil.buildOptimizedCountQuery(builder, query, queryText)) {
            DbImplUtil.buildCountQuery(builder, e, queryText);
        }
        return builder.getStatement();
    }

    private static DdlBuilder buildCountQuery(@NotNull DdlBuilder builder, @NotNull SqlResultSetExpression e, @NotNull String query) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "buildCountQuery"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/util/DbImplUtil", "buildCountQuery"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/util/DbImplUtil", "buildCountQuery"));
        }
        builder.keyword("SELECT").space().keyword("COUNT").symbol("(").symbol("*").symbol(")").space().keyword("FROM").space().symbol("(");
        boolean subqueryIsBuilt = false;
        boolean needSelectTargetAliases = builder.getDialect().getFamilyId().isMicrosoft();
        if (needSelectTargetAliases) {
            TIntArrayList endOffsets = new TIntArrayList();
            for (SqlSelectClause selectClause : SyntaxTraverser.psiTraverser((PsiElement)e).filter(SqlSelectClause.class)) {
                for (SqlExpression expression : selectClause.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    endOffsets.add(expression.getTextRange().getEndOffset());
                }
            }
            endOffsets.sort();
            int prevIdx = 0;
            int count = 0;
            int len = endOffsets.size();
            for (int i = 0; i < len; ++i) {
                int offset = endOffsets.get(i);
                builder.plain(query.substring(prevIdx, offset));
                builder.space().columnRef("_" + ++count);
                prevIdx = offset;
            }
            builder.plain(e.getText().substring(prevIdx));
            subqueryIsBuilt = true;
        }
        if (!subqueryIsBuilt) {
            builder.plain(query);
        }
        return builder.symbol(")").space().identifier("t");
    }

    private static boolean buildOptimizedCountQuery(@NotNull DdlBuilder builder, @NotNull SqlQueryExpression query, @NotNull String queryText) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "buildOptimizedCountQuery"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/util/DbImplUtil", "buildOptimizedCountQuery"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/util/DbImplUtil", "buildOptimizedCountQuery"));
        }
        SqlSelectClause selectClause = query.getSelectClause();
        if (selectClause == null) {
            return false;
        }
        for (SqlSelectOption option : selectClause.getOptions()) {
            if (!option.getOptionName().startsWith("DISTINCT") && option.getClause() == null) continue;
            return false;
        }
        SqlTableExpression tableExp = query.getTableExpression();
        if (tableExp == null || tableExp.getHavingClause() != null || tableExp.getGroupByClause() != null) {
            return false;
        }
        List expressions = selectClause.getExpressions();
        for (SqlExpression e : expressions) {
            if (((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)e)).preOrderDfsTraversal().filter(SqlFunctionCallExpression.class).isEmpty()) continue;
            return false;
        }
        SqlExpression firstExpression = (SqlExpression)ContainerUtil.getFirstItem((List)expressions);
        SqlExpression lastExpression = (SqlExpression)ContainerUtil.getLastItem((List)expressions);
        if (firstExpression == null || lastExpression == null) {
            return false;
        }
        int expressionsStartOffset = firstExpression.getTextRange().getStartOffset();
        int expressionsEndOffset = lastExpression.getTextRange().getEndOffset();
        builder.clear().plain(queryText.substring(0, expressionsStartOffset)).keyword("COUNT").symbol("(").symbol("*").symbol(")").plain(queryText.substring(expressionsEndOffset));
        return true;
    }

    @NotNull
    public static String resultSetToString(ResultSet rs, DatabaseDialectEx dialect, DataExtractor extractor) throws Exception {
        String string = DbImplUtil.resultSetToString("", rs, Integer.MAX_VALUE, dialect, extractor, CharOut.Util.newSink()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "resultSetToString"));
        }
        return string;
    }

    public static CharOut resultSetToString(String title, ResultSet rs, int size, DatabaseDialectEx dialect, DataExtractor extractor, CharOut out) throws Exception {
        DataConsumer.Column[] columns = JdbcEngine.getColumnDescriptors(rs, dialect);
        RemoteResultSet remoteResultSet = (RemoteResultSet)ObjectUtils.assertNotNull((Object)RemoteUtil.castToRemote((Object)rs, RemoteResultSet.class));
        List objects = remoteResultSet.getObjects(size, dialect.getClass().getSimpleName(), DatabaseSettings.getSettings().getMaxLobLength());
        List data = (List)RemoteUtil.handleRemoteResult((Object)objects, List.class, (Object)extractor);
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(data.size());
        if (data.isEmpty()) {
            return out;
        }
        for (int i = 0; i < data.size(); ++i) {
            rows.add(new DataConsumer.Row(i + 1, (Object[])data.get(i)));
        }
        out.append(String.format(title, data.size()));
        ExtractorsUtil.extract(out, dialect, false, Arrays.asList(columns), extractor, rows, new int[0]);
        return out;
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull LocalDataSource localDataSource) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbImplUtil", "getDbDataSource"));
        }
        if (localDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localDataSource", "com/intellij/database/util/DbImplUtil", "getDbDataSource"));
        }
        return DbPsiFacade.getInstance((Project)project).findDataSource(localDataSource.getUniqueId());
    }

    public static boolean isConnected(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "isConnected"));
        }
        return element.getDelegate() instanceof LocalDataSource && !JdbcDriverManager.getDriverManager(element.getProject()).getActiveConfigurations((LocalDataSource)((Object)element.getDelegate())).isEmpty();
    }

    public static boolean canConnectTo(@Nullable DbElement element) {
        Object ds = element == null ? null : element.getDataSource().getDelegate();
        return ds instanceof LocalDataSource && DbImplUtil.canConnectTo((LocalDataSource)((Object)ds));
    }

    public static boolean hasDriverFiles(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "hasDriverFiles"));
        }
        if (!dataSource.getClasspathElements().isEmpty()) {
            return true;
        }
        DatabaseDriver databaseDriver = dataSource.getDatabaseDriver();
        return databaseDriver != null && databaseDriver.isDownloaded();
    }

    public static boolean needUpdateDriverFiles(boolean domainAuth, @NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/util/DbImplUtil", "needUpdateDriverFiles"));
        }
        if (!domainAuth) {
            return false;
        }
        for (SimpleClasspathElement element : driver.getClasspathElements()) {
            for (String url : element.getClassesRootUrls()) {
                if (!url.contains("sqlserver-win-auth.jar")) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canConnectTo(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "canConnectTo"));
        }
        if (StringUtil.isEmptyOrSpaces((String)dataSource.getUrl())) {
            return false;
        }
        if (!DbImplUtil.hasDriverFiles(dataSource)) {
            return false;
        }
        String driverClass = dataSource.getDriverClass();
        return !StringUtil.isEmptyOrSpaces((String)driverClass);
    }

    public static boolean canConnectToAndModify(@Nullable DbElement element) {
        return element != null && element.isWritable() && DbImplUtil.canConnectTo(element);
    }

    @Nullable
    public static Connection getConnection(@NotNull DbElement element) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "getConnection"));
        }
        Object ds = element.getDataSource().getDelegate();
        if (!(ds instanceof LocalDataSource)) {
            return null;
        }
        Connection connection = ((LocalDataSource)((Object)ds)).getConnection(element.getProject());
        if (connection != null) {
            JdbcUtil.setCatalogSafe((Connection)connection, (String)DasUtil.getCatalog((DasObject)element));
        }
        return connection;
    }

    public static void setStatementParameter(@NotNull PreparedStatement statement, int idx, @NotNull DataConsumer.Column column, @Nullable Object value, boolean needsEscaping, @NotNull DatabaseDialect dialect) throws Exception {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/util/DbImplUtil", "setStatementParameter"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "setStatementParameter"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "setStatementParameter"));
        }
        if (value == null || value == ReservedCellValue.NULL) {
            statement.setNull(idx, column.type);
        } else if (value instanceof LobInfo.FileBlobInfo) {
            LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
            statement.setBlob(idx, (Blob)new FileBlob(info.file));
        } else if (value instanceof LobInfo.FileClobInfo) {
            LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
            statement.setClob(idx, (Clob)new FileClob(info.file, info.charset));
        } else if (value instanceof LobInfo.BlobInfo) {
            statement.setBytes(idx, ((LobInfo.BlobInfo)value).data);
        } else if (value instanceof LobInfo.ClobInfo) {
            statement.setString(idx, DbImplUtil.escapeSql(((LobInfo.ClobInfo)value).data, needsEscaping, dialect));
        } else if (value instanceof ObjectFormatter.ImageInfo) {
            statement.setBytes(idx, ((ObjectFormatter.ImageInfo)value).bytes);
        } else if (value instanceof ObjectFormatter.TextInfo) {
            statement.setBytes(idx, ((ObjectFormatter.TextInfo)value).bytes);
        } else if (dialect.getFamilyId().isPostgres() && (Arrays.asList("bit", "varbit", "tid", "uuid", "money").contains(column.typeName) || column.type == 2003 || column.type == 2002 || column.type == 1111 || Object.class.getName().equals(column.clazz))) {
            statement.setObject(idx, value, 1111);
        } else if (value instanceof Date) {
            long millis = ((Date)value).getTime();
            if (column.type == 93) {
                statement.setTimestamp(idx, new Timestamp(millis));
            } else if (column.type == 92) {
                statement.setTime(idx, new Time(millis));
            } else {
                statement.setDate(idx, new java.sql.Date(millis));
            }
        } else {
            statement.setObject(idx, DbImplUtil.escapeSql(value, needsEscaping, dialect));
        }
    }

    public static boolean canInsertBlob(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "canInsertBlob"));
        }
        int type = ExtractorsUtil.guessJdbcType(column);
        return type == -2 || type == 2004 || type == -4 || type == -3;
    }

    public static boolean canInsertClob(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "canInsertClob"));
        }
        int type = ExtractorsUtil.guessJdbcType(column);
        return type == 2005 || type == 2011 || type == -1 || type == -16 || type == -15 || type == 1 || type == 12 || type == -9 || type == 2009;
    }

    @Nullable
    public static LobInfo.FileClobInfo clobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/util/DbImplUtil", "clobFromFile"));
        }
        Charset encoding = EncodingManager.getInstance().getEncoding(virtualFile, true);
        String charset = encoding != null ? encoding.name() : null;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        return new LobInfo.FileClobInfo(file, charset);
    }

    @NotNull
    public static LobInfo.FileBlobInfo blobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/util/DbImplUtil", "blobFromFile"));
        }
        LobInfo.FileBlobInfo fileBlobInfo = new LobInfo.FileBlobInfo(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
        if (fileBlobInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "blobFromFile"));
        }
        return fileBlobInfo;
    }

    public static void tryLoadFirstNRows(Connection connection, String query, StringBuilder sb, int rows) {
        try {
            DbImplUtil.tryLoadFirstNRows("", connection, query, CharOut.Util.newSink(sb), rows);
        }
        catch (Exception e) {
            DbImplUtil.exceptionToHtml(e, "Unable to load table data", sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadFirstNRows(String title, Connection connection, String query, CharOut sb, int rows) throws Exception {
        if (connection == null) {
            return;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            ObjectFormatter converter = new ObjectFormatter(){

                @Override
                @Nullable
                public String objectToString(@Nullable Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                    Object o1 = 5.objectToObject(o, column);
                    if (o1 instanceof ObjectFormatter.ImageInfo) {
                        ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)o1;
                        o1 = new ObjectFormatter.ImageInfo(info.format, info.width, info.height, info.size, null);
                    }
                    return super.objectToString(o1, column, dialect, forDisplay);
                }
            };
            HtmlValuesExtractor extractor = new HtmlValuesExtractor(converter){

                @Override
                protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect, boolean forDisplay) {
                    if (row == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/util/DbImplUtil$6", "getValueAsString"));
                    }
                    if (column == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil$6", "getValueAsString"));
                    }
                    if (dialect == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil$6", "getValueAsString"));
                    }
                    String unescaped = super.getValueAsString(6.getOriginalRow(row, column), 6.getOriginalColumn(row, column), dialect, forDisplay, false);
                    return this.escapeChars(unescaped != null && unescaped.length() > 50 ? unescaped.substring(0, 50) + "..." : unescaped);
                }
            };
            extractor.setDisplayMode(true);
            extractor.setIncludeColumnNames(true);
            DbImplUtil.resultSetToString(title, resultSet, rows, GenericDialect.INSTANCE, extractor, sb);
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    public static StringBuilder exceptionToHtml(Exception e, String str, StringBuilder sb) {
        sb.append(str).append(":<br>");
        sb.append("<code>").append(e).append("</code><br>");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadViewDefinition(ConnectionProvider provider, @NotNull DbTable element, StringBuilder sb) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "tryLoadViewDefinition"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsViewDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            DatabaseFamilyId familyId = dialect.getFamilyId();
            String s = dialect.sqlViewDefinition((DasObject)element);
            int initialLength = sb.length();
            DbImplUtil.concatStringResults(provider.getConnection(), dialect, 0, s, sb);
            if (sb.length() > initialLength) {
                if (familyId.isMysql() || familyId.isPostgres()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    String fullDefinition = dialect.sqlCreateView(builder, (DasTable)element, sb.substring(initialLength), "").getStatement();
                    sb.setLength(initialLength);
                    sb.append(fullDefinition);
                } else if (familyId.isDerby()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element, true).getStatement() + ";\n");
                } else if (familyId.isMicrosoft()) {
                    DbImplUtil.replaceTokenInDefinition((DbElement)element, sb, dialect, SqlCreateViewStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
                } else if (familyId.isSybase()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element, true).newLine().keyword("GO").getStatement() + "\n");
                } else if (familyId.isH2()) {
                    sb.insert(initialLength + "CREATE ".length(), "OR REPLACE ");
                }
            }
        }
        finally {
            provider.release();
        }
    }

    public static DdlBuilder endStatement(@NotNull DdlBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "endStatement"));
        }
        if (builder.getDialect().getFamilyId().isTransactSql()) {
            builder.newLine().keyword("go").newStatement();
        } else {
            builder.newStatement();
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tryLoadProcedureDefinition(@NotNull ConnectionProvider provider, @NotNull DbRoutine element, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/util/DbImplUtil", "tryLoadProcedureDefinition"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "tryLoadProcedureDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/util/DbImplUtil", "tryLoadProcedureDefinition"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!provider.acquire()) {
            provider.release();
            return;
        }
        String fromDialect = dialect.tryToLoadProcedureDefinition((DasRoutine)element, provider.getConnection());
        if (StringUtil.isNotEmpty((String)fromDialect)) {
            sb.append(fromDialect);
            provider.release();
            return;
        }
        if (!dialect.supportsProcedureDefinition()) {
            return;
        }
        DatabaseFamilyId familyId = dialect.getFamilyId();
        String definitionQuery = dialect.sqlProcedureDefinition((DasRoutine)element);
        StringBuilder definition = DbImplUtil.concatStringResults(provider.getConnection(), dialect, definitionQuery, 0, new StringBuilder());
        if (StringUtil.isEmptyOrSpaces((String)definition.toString())) return;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
        if (familyId.isOracle()) {
            definition.insert(0, builder.keywords("create", "or", "replace").space().getStatement());
        } else if (familyId.isDb2()) {
            definition.insert(0, dialect.sqlDropProcedure(builder, (DasRoutine)element).getStatement() + ";\n");
        } else if (familyId.isMicrosoft()) {
            DbImplUtil.replaceTokenInDefinition((DbElement)element, definition, dialect, SqlCreateStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
        } else if (familyId.isSybase()) {
            builder.keyword("drop").space().keyword(StringUtil.startsWithIgnoreCase((String)definition.toString().trim(), (String)"create function") ? "function" : "procedure").space();
            dialect.qualifiedIdentifier(builder, element.getName(), (DasObject)element, (DasObject)element);
            builder.newLine();
            builder.keyword("go").newLine();
            definition.insert(0, builder.getStatement());
        }
        String trim = definition.toString().trim();
        sb.append(trim);
        if (familyId.isTransactSql()) {
            sb.append(DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false).clear().newLine().keyword("go").getStatement());
            return;
        }
        if (trim.endsWith(";")) return;
        sb.append(";");
        return;
    }

    private static void replaceTokenInDefinition(@NotNull DbElement element, @NotNull StringBuilder sb, @NotNull DatabaseDialectEx dialect, @NotNull Class<? extends SqlDefinition> defClazz, @NotNull SqlTokenType fromToken, @NotNull SqlTokenType toToken) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (defClazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defClazz", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (fromToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromToken", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (toToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toToken", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        SqlFile psi = SqlPsiFacade.getInstance((Project)element.getProject()).createSqlReader().getReadOnlyPsi(DbImplUtil.getSqlDialect(dialect), (CharSequence)sb);
        SyntaxTraverser st = SyntaxTraverser.psiTraverser((PsiElement)psi);
        PsiElement keyword = (PsiElement)st.traverse().skipWhile(Conditions.notInstanceOf(defClazz)).filter(Conditions.compose((Function)st.api.TO_TYPE(), (Condition)Conditions.equalTo((Object)fromToken))).first();
        if (keyword != null) {
            TextRange r = st.api.rangeOf((Object)keyword);
            int i0 = r.getStartOffset();
            int i1 = r.getEndOffset();
            String replacement = ((Case)ObjectUtils.notNull((Object)Case.forString((String)sb.substring(i0, i1)), (Object)Case.EXACT)).apply(toToken.toString());
            sb.replace(i0, i1, replacement);
        }
    }

    public static boolean isDataTable(@Nullable DasTable info) {
        if (info == null) {
            return false;
        }
        return DbImplUtil.isDataTable(info.getKind());
    }

    public static boolean isDataTable(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/DbImplUtil", "isDataTable"));
        }
        return kind == ObjectKind.TABLE || kind == ObjectKind.VIEW || kind == ObjectKind.MAT_VIEW;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        DbDataSource dataSource = element.getDataSource();
        DatabaseDialectEx databaseDialectEx = dataSource instanceof DbDataSourceImpl ? ((DbDataSourceImpl)dataSource).getDatabaseDialect() : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull JdbcConsole console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(console.getDataSource());
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionInfo", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(connectionInfo), (Object)GenericDialect.INSTANCE);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        DatabaseFamilyId familyId;
        if (connectionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionInfo", "com/intellij/database/util/DbImplUtil", "guessDatabaseDialect"));
        }
        DatabaseFamilyId databaseFamilyId = familyId = connectionInfo instanceof DatabaseSystem ? DatabaseFamilyId.forDataSource((DatabaseSystem)((DatabaseSystem)connectionInfo)) : DatabaseFamilyId.forConnection((RawConnectionConfig)connectionInfo);
        if (familyId == DatabaseFamilyId.UNKNOWN) {
            return null;
        }
        for (DatabaseDialectEx dialect : DatabaseDialects.getSupportedDialects()) {
            if (dialect.getFamilyId() != familyId) continue;
            return dialect;
        }
        return null;
    }

    public static boolean supportsDynamicSchemaSwitching(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "supportsDynamicSchemaSwitching"));
        }
        DatabaseDialectEx dialect = DbImplUtil.guessDatabaseDialect(dataSource);
        return dialect == null || !dialect.getFamilyId().isMysql() || !dataSource.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadPackageDefinition(ConnectionProvider provider, DbPackage element, boolean spec, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsPackageDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String query = spec ? dialect.sqlPackageDefinition((DasObject)element) : dialect.sqlPackageBodyDefinition((DasObject)element);
            StringBuilder def = DbImplUtil.concatStringResults(provider.getConnection(), dialect, query, 0, new StringBuilder());
            Case caseMode = (Case)ObjectUtils.notNull((Object)Case.forString((String)def.substring(0, Math.min(sb.length(), 7))), (Object)Case.EXACT);
            if (StringUtil.startsWith((CharSequence)def, (CharSequence)"package") || StringUtil.startsWith((CharSequence)def, (CharSequence)"PACKAGE")) {
                def.insert(0, caseMode.apply("CREATE OR REPLACE "));
            }
            sb.append((CharSequence)def);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSequenceDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsSequenceDefinition()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        String drop = dialect.sqlDropSequence(DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false), (DasTable)element, false).getStatement() + ";\n";
        builder.append(drop);
        try {
            if (!provider.acquire()) {
                return;
            }
            DbImplUtil.concatStringResults(provider.getConnection(), dialect, dialect.sqlSequenceDefinition((DasObject)element), 0, builder);
            sb.append((CharSequence)builder);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadTableDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadTableDefinition((DasTable)element, provider.getConnection());
            if (!StringUtil.isEmptyOrSpaces((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> tryLoadTableInfo(ConnectionProvider provider, DbTable element) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableInfo()) {
            return Collections.emptyMap();
        }
        try {
            if (!provider.acquire()) {
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            Map<String, Object> map = dialect.tryToLoadTableInfo(element, provider.getConnection());
            return map;
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSynonymDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadSynonymDefinition((DasTable)element, provider.getConnection());
            if (!StringUtil.isEmpty((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    public static String concatStringResults(Connection connection, DatabaseDialectEx dialect, String query, int forcedColumn) throws SQLException {
        return DbImplUtil.concatStringResults(connection, dialect, query, forcedColumn, new StringBuilder()).toString().trim();
    }

    public static StringBuilder concatStringResults(Connection connection, DatabaseDialectEx dialect, int forcedColumn, String query, StringBuilder sb) throws SQLException {
        return DbImplUtil.concatStringResults(connection, dialect, query, forcedColumn, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder concatStringResults(Connection connection, DatabaseDialectEx dialect, String query, int forcedColumn, StringBuilder sb) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            int updateCount;
            ResultSet rs = statement.executeQuery(query);
            boolean resultSetHere = rs != null;
            int n = updateCount = resultSetHere ? -1 : JdbcEngine.getUpdateCountSafe(statement);
            while (resultSetHere || updateCount != -1) {
                if (resultSetHere && rs == null) {
                    rs = statement.getResultSet();
                }
                if (rs != null) {
                    try {
                        DbImplUtil.concatStringResults(rs, dialect, forcedColumn, sb);
                    }
                    finally {
                        JdbcUtil.closeResultSetSafe((ResultSet)rs);
                    }
                }
                rs = null;
                resultSetHere = statement.getMoreResults();
                updateCount = JdbcEngine.getUpdateCountSafe(statement);
            }
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
        return sb;
    }

    protected static void concatStringResults(ResultSet rs, DatabaseDialectEx dialect, int forcedColumn, StringBuilder sb) throws SQLException {
        boolean joinWithoutTrim = dialect.getFamilyId().isTransactSql();
        DataConsumer.Column[] columns = JdbcEngine.getColumnDescriptors(rs, dialect);
        int columnCount = columns.length;
        while (rs.next()) {
            for (int i = forcedColumn > 0 ? forcedColumn : 1; i <= (forcedColumn > 0 ? forcedColumn : columnCount); ++i) {
                CharSequence s;
                Object object = rs.getObject(i);
                if (object instanceof CharSequence) {
                    s = (CharSequence)object;
                } else if (object instanceof Clob) {
                    Clob clob = (Clob)object;
                    s = clob.getSubString(1L, (int)clob.length());
                } else {
                    if (!(object instanceof Number)) continue;
                    sb.append("\n");
                    continue;
                }
                if (joinWithoutTrim) {
                    sb.append(s);
                    continue;
                }
                String trailing = StringUtil.trimTrailing((String)s.toString());
                sb.append(StringUtil.trimLeading((String)trailing));
                if (s.length() == trailing.length()) continue;
                sb.append(" ");
            }
            if (joinWithoutTrim) continue;
            sb.append("\n");
        }
    }

    public static Map<String, Object> resultRowAsMap(Connection connection, String query, String ... columnSelection) throws SQLException {
        Map result = Collections.emptyMap();
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(query);
        if (rs.next()) {
            result = JdbcUtil.resultSetRowToMapSafe((ResultSet)rs);
            if (columnSelection.length > 0 && !result.isEmpty()) {
                assert (columnSelection.length % 2 == 0);
                LinkedHashMap map = ContainerUtil.newLinkedHashMap();
                for (int i = 0; i < columnSelection.length; i += 2) {
                    Object o = result.get(columnSelection[i]);
                    if (o == null) continue;
                    map.put(columnSelection[i + 1], o);
                }
                result = map;
            }
        }
        JdbcUtil.closeResultSetSafe((ResultSet)rs);
        JdbcUtil.closeStatementSafe((Statement)statement);
        return result;
    }

    @Nullable
    public static DbDataSource getForcedDataSource(PsiFile psiFile) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        DbDataSource element = virtualFile instanceof VirtualFileWindow ? DbImplUtil.getForcedDataSource(InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile)) : (virtualFile instanceof DatabaseElementVirtualFileImpl ? ((DatabaseElementVirtualFileImpl)virtualFile).findDataSource() : (DbConsoleRootType.isConsoleFile(virtualFile) ? DbConsoleRootType.getDataSource(psiFile.getProject(), virtualFile) : (DbDataSource)psiFile.getUserData(DatabaseDataKeys.DATA_SOURCE_KEY)));
        return element != null && element.isValid() ? element : null;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForExec(@NotNull PsiFile file, boolean ignoreForced, boolean matchingOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbImplUtil", "getDataSourcesForExec"));
        }
        DbDataSource forced = ignoreForced ? null : DbImplUtil.getForcedDataSource(file);
        JBIterable result = forced != null ? JBIterable.of((Object[])new DbDataSource[]{forced}) : DbSqlUtil.getAppropriateDataSources(file, false, matchingOnly);
        JBIterable jBIterable = result.filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getDataSourcesForExec"));
        }
        return jBIterable;
    }

    public static DdlBuilder composeWhereCondition(@NotNull DdlBuilder builder, @NotNull List<DataConsumer.Column> columns, @NotNull List<Object> values, @NotNull DatabaseDialect dialect, @Nullable String tableAlias) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "composeWhereCondition"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/util/DbImplUtil", "composeWhereCondition"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/util/DbImplUtil", "composeWhereCondition"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "composeWhereCondition"));
        }
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                builder.space().keyword("AND").space();
            }
            DataConsumer.Column column = columns.get(i);
            boolean useLike = "java.lang.String".equals(column.clazz);
            DbImplUtil.composeWhereItem(builder, column.name, values.get(i), useLike, tableAlias, dialect);
        }
        return builder;
    }

    public static DdlBuilder composeWhereCondition(DdlBuilder builder, Iterable<String> names, Iterable<?> values, String alias, DatabaseDialect dialect) {
        boolean first = true;
        Iterator<String> it1 = names.iterator();
        Iterator<?> it2 = values.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (first) {
                first = false;
            } else {
                builder.space().keyword("AND").space();
            }
            DbImplUtil.composeWhereItem(builder, it1.next(), it2.next(), true, alias, dialect);
        }
        return builder;
    }

    public static DdlBuilder composeWhereItem(@NotNull DdlBuilder builder, String columnName, Object value, boolean useLike, String alias, @NotNull DatabaseDialect dialect) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "composeWhereItem"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "composeWhereItem"));
        }
        if (alias != null) {
            builder.alias(alias).symbol(".");
        }
        builder.identifier(columnName).space();
        if (value == null) {
            builder.keywords("IS", "NULL");
        } else {
            boolean isString = value instanceof String;
            boolean bl = useLike = useLike && isString && !dialect.getFamilyId().isSqlite();
            if (useLike) {
                builder.keyword("LIKE");
            } else {
                builder.symbol("=");
            }
            String literal = isString ? DbImplUtil.escapeSql((String)value, useLike, dialect) : value.toString();
            builder.space().literal(isString ? "'" + literal.replace("'", "''") + "'" : literal);
            if (useLike && literal.indexOf(ESCAPE_CHAR) > -1) {
                builder.space().keyword("ESCAPE").space().plain("'" + ESCAPE_CHAR + "'");
            }
        }
        return builder;
    }

    @NotNull
    public static List<DataConsumer.Column> composeWhereConditionWithParameters(@NotNull DdlBuilder builder, @NotNull List<DataConsumer.Column> keyColumns, @NotNull List<Boolean> columnNullability, @Nullable String alias, @NotNull DatabaseDialect dialect) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        if (keyColumns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyColumns", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        if (columnNullability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNullability", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        boolean first = true;
        for (int i = 0; i < keyColumns.size(); ++i) {
            if (first) {
                first = false;
            } else {
                builder.space().keyword("AND").space();
            }
            DataConsumer.Column column = keyColumns.get(i);
            Boolean nullability = columnNullability.get(i);
            int placeholdersAdded = DbImplUtil.composeWhereItemWithParameters(builder, column, nullability, alias, dialect);
            for (int j = 0; j < placeholdersAdded; ++j) {
                parameters.add(column);
            }
        }
        ArrayList arrayList = parameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        return arrayList;
    }

    public static int composeWhereItemWithParameters(@NotNull DdlBuilder builder, @NotNull DataConsumer.Column column, @Nullable Boolean nullability, @Nullable String alias, @NotNull DatabaseDialect dialect) {
        boolean useLike;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "composeWhereItemWithParameters"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "composeWhereItemWithParameters"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "composeWhereItemWithParameters"));
        }
        if (nullability == null) {
            builder.symbol("(");
        }
        if (DbImplUtil.isComputedColumn(column)) {
            builder.plain(column.name);
        } else {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column.name);
        }
        builder.space();
        if (nullability == Boolean.TRUE) {
            builder.keywords("IS", "NULL");
            return 0;
        }
        boolean bl = useLike = !dialect.getFamilyId().isSqlite() && "java.lang.String".equals(column.clazz);
        if (useLike) {
            builder.keyword("LIKE");
        } else {
            builder.symbol("=");
        }
        builder.space().symbol("?");
        if (useLike) {
            builder.space().keyword("ESCAPE").space().plain("'" + ESCAPE_CHAR + "'");
        }
        if (nullability == null) {
            builder.space().keyword("OR").space().symbol("(");
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column.name).space().keywords("IS", "NULL", "AND").space().symbol("?").space().keywords("IS", "NULL");
            builder.symbol(")");
            builder.symbol(")");
            return 2;
        }
        return 1;
    }

    public static String escapeStr(String value) {
        return StringUtil.notNullize((String)value).replace("'", "''");
    }

    public static <T> T escapeSql(T value, boolean needsEscaping, @NotNull DatabaseDialect dialect) {
        Object[] objectArray;
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "escapeSql"));
        }
        if (!needsEscaping) {
            return value;
        }
        DatabaseFamilyId familyId = dialect.getFamilyId();
        if (familyId.isSqlite()) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        if (familyId.isMysql()) {
            String[] stringArray = new String[4];
            stringArray[0] = "%";
            stringArray[1] = "_";
            stringArray[2] = "\\";
            objectArray = stringArray;
            stringArray[3] = String.valueOf(ESCAPE_CHAR);
        } else {
            Object[] objectArray2 = new String[3];
            objectArray2[0] = "%";
            objectArray2[1] = "_";
            objectArray = objectArray2;
            objectArray2[2] = String.valueOf(ESCAPE_CHAR);
        }
        Object[] unescapedChars = objectArray;
        String[] escapedChars = (String[])ContainerUtil.map2Array((Object[])unescapedChars, String.class, (Function)new Function<String, String>(){

            public String fun(String s) {
                return ESCAPE_CHAR + s;
            }
        });
        return (T)StringUtil.replace((String)s, (String[])unescapedChars, (String[])escapedChars);
    }

    public static boolean isComputedColumn(DataConsumer.Column column) {
        return COMPUTED_COLUMN == column.table;
    }

    public static DataConsumer.Column makeComputedColumn(DataConsumer.Column column) {
        return new DataConsumer.Column(column.columnNum, column.name, column.type, column.typeName, column.clazz, -1, -1, COMPUTED_COLUMN, COMPUTED_COLUMN, COMPUTED_COLUMN);
    }

    public static boolean isSqlFileType(FileType fileType) {
        return fileType instanceof LanguageFileType && "sql".equals(fileType.getDefaultExtension());
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
        }
        for (SqlLanguageDialect language : SqlDialectsUtil.getSqlDialects()) {
            if (language.getDatabaseDialect() != dialect) continue;
            SqlLanguageDialect sqlLanguageDialect = language;
            if (sqlLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
            }
            return sqlLanguageDialect;
        }
        throw new AssertionError((Object)("SQL dialect not found for: " + dialect.getDisplayName()));
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @Nullable DatabaseSystem dataSource) {
        DatabaseSystem delegateInfo;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
        }
        DatabaseSystem databaseSystem = delegateInfo = dataSource instanceof DbElement ? (DatabaseSystem)((DbElement)dataSource).getDelegate() : dataSource;
        if (delegateInfo instanceof LocalDataSource) {
            Language result;
            String defaultDialect = ((LocalDataSource)delegateInfo).getDefaultDialect();
            Language language = result = StringUtil.isEmpty((String)defaultDialect) ? null : Language.findLanguageByID((String)defaultDialect);
            if (result instanceof SqlLanguageDialect) {
                SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)result;
                if (sqlLanguageDialect == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
                }
                return sqlLanguageDialect;
            }
        }
        if (delegateInfo instanceof RawConnectionConfig) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(project, (RawConnectionConfig)delegateInfo);
            if (sqlLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = SqlPsiFacade.getInstance((Project)project).getDefaultDialect();
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
        }
        return sqlLanguageDialect;
    }

    public static boolean writeVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute, @Nullable String value) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbImplUtil", "writeVFSAttributeSafe"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/database/util/DbImplUtil", "writeVFSAttributeSafe"));
        }
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        try {
            return DbImplUtil.writeVFSAttribute(file, attribute, value);
        }
        catch (IOException ex) {
            DataSourceUiUtil.LOG.warn((Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static String readVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbImplUtil", "readVFSAttributeSafe"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/database/util/DbImplUtil", "readVFSAttributeSafe"));
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try {
            return DbImplUtil.readVFSAttribute(file, attribute);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean writeVFSAttribute(@NotNull VirtualFile fileOrDir, @NotNull FileAttribute attribute, @Nullable String value) throws IOException {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/database/util/DbImplUtil", "writeVFSAttribute"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/database/util/DbImplUtil", "writeVFSAttribute"));
        }
        String oldValue = DbImplUtil.readVFSAttribute(fileOrDir, attribute);
        if (Comparing.equal((String)oldValue, (String)value)) {
            return false;
        }
        DataOutputStream oStream = attribute.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)myDialectAndDataSourcesEnumerator.getId((Object)StringUtil.notNullize((String)value)));
        oStream.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readVFSAttribute(VirtualFile fileOrDir, FileAttribute attribute) throws IOException {
        DataInputStream iStream = attribute.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                String string = StringUtil.nullize((String)((String)myDialectAndDataSourcesEnumerator.getById(DataInputOutputUtil.readINT((DataInput)iStream))));
                return string;
            }
            finally {
                iStream.close();
            }
        }
        return null;
    }

    public static boolean isRemoteConnectionSupported(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/util/DbImplUtil", "isRemoteConnectionSupported"));
        }
        return driver.getSupportedLocations().contains((Object)StatelessJdbcUrlParser.LocationType.REMOTE);
    }

    public static boolean isRemoteConnectionSupported(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "isRemoteConnectionSupported"));
        }
        return dataSource.getDatabaseDriver() != null && DbImplUtil.isRemoteConnectionSupported(dataSource.getDatabaseDriver());
    }

    public static boolean isAuthRequired(@NotNull LocalDataSource info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/util/DbImplUtil", "isAuthRequired"));
        }
        return info.isAuthRequired();
    }

    public static void initLanguageComboBox(JComboBox comboBox, boolean allowNull) {
        ArrayList langs = new ArrayList();
        if (allowNull) {
            langs.add(null);
        }
        langs.addAll(SqlDialectsUtil.getTopLevelSqlDialects());
        comboBox.setModel(new CollectionComboBoxModel(langs));
        comboBox.setEditable(false);
        comboBox.setRenderer(new ListCellRendererWrapper<Language>(){

            public void customize(JList list, Language language, int index, boolean selected, boolean hasFocus) {
                if (language == null) {
                    this.setText("<default>");
                    this.setIcon(null);
                } else {
                    if (language instanceof SqlLanguageDialect) {
                        this.setIcon(((SqlLanguageDialect)language).getDatabaseDialect().getIcon());
                    } else {
                        LanguageFileType fileType = language.getAssociatedFileType();
                        this.setIcon(fileType == null ? null : fileType.getIcon());
                    }
                    this.setText(language.getDisplayName());
                }
            }
        });
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull RawConnectionConfig info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/util/DbImplUtil", "guessDatabaseDriver"));
        }
        Collection<? extends DatabaseDriver> allDrivers = DatabaseDriverManager.getInstance().getDrivers();
        List matchedDrivers = ContainerUtil.newSmartList();
        for (DatabaseDriver databaseDriver : allDrivers) {
            if (!Comparing.equal((String)info.getDriverClass(), (String)databaseDriver.getDriverClass())) continue;
            matchedDrivers.add(databaseDriver);
        }
        if (matchedDrivers.isEmpty()) {
            return null;
        }
        if (matchedDrivers.size() == 1) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        for (DatabaseDriver databaseDriver : matchedDrivers) {
            if (!databaseDriver.matchesUrl(info.getUrl())) continue;
            return databaseDriver;
        }
        return (DatabaseDriver)matchedDrivers.get(0);
    }

    @NotNull
    public static LocalDataSource getLocalDataSource(@Nullable DatabaseSystem info) {
        if (info instanceof LocalDataSource) {
            LocalDataSource localDataSource = (LocalDataSource)info;
            if (localDataSource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getLocalDataSource"));
            }
            return localDataSource;
        }
        if (info instanceof DbElement) {
            LocalDataSource localDataSource = DbImplUtil.getLocalDataSource((DatabaseSystem)((DbElement)info).getDelegate());
            if (localDataSource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getLocalDataSource"));
            }
            return localDataSource;
        }
        throw new AssertionError(info);
    }

    public static void setActionCallbackDone(final @Nullable AsyncPromise<Void> callback, final boolean done, final @Nullable String reason) {
        if (callback == null) {
            return;
        }
        DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (done) {
                    callback.setResult(null);
                } else {
                    callback.setError(StringUtil.isEmptyOrSpaces((String)reason) ? "not done" : reason);
                }
            }
        });
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done) {
        DbImplUtil.setActionCallbackDone(callback, done, null);
    }

    @NotNull
    public static EnumSet<ReservedCellValue> getSpecialValues(@Nullable DasColumn databaseColumn) {
        if (databaseColumn == null) {
            EnumSet<ReservedCellValue> enumSet = EnumSet.of(ReservedCellValue.NULL);
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSpecialValues"));
            }
            return enumSet;
        }
        EnumSet<ReservedCellValue> result = EnumSet.noneOf(ReservedCellValue.class);
        if (DasUtil.isAutoVal((DasColumn)databaseColumn)) {
            result.add(ReservedCellValue.GENERATED);
        }
        if (!databaseColumn.isNotNull()) {
            result.add(ReservedCellValue.NULL);
        }
        if (databaseColumn.getDefault() != null) {
            result.add(ReservedCellValue.DEFAULT);
        }
        EnumSet<ReservedCellValue> enumSet = result;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSpecialValues"));
        }
        return enumSet;
    }

    @NotNull
    public static DasModel getModelNoCancel(@NotNull DbDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/util/DbImplUtil", "getModelNoCancel"));
        }
        for (int i = 0; i < 3; ++i) {
            DasModel dasModel;
            try {
                dasModel = source.getModel();
            }
            catch (ProcessCanceledException processCanceledException) {
                continue;
            }
            if (dasModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getModelNoCancel"));
            }
            return dasModel;
        }
        DasModel dasModel = DasUtil.loadingModel();
        if (dasModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getModelNoCancel"));
        }
        return dasModel;
    }

    @NotNull
    public static Condition<DasObject> getResolveUnqualifiedCondition(final @NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "getResolveUnqualifiedCondition"));
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)dataSource.getProject());
        Set elements = (Set)manager.getCachedValue((UserDataHolder)dataSource, (CachedValueProvider)new CachedValueProvider<Set<DasObject>>(){

            @Nullable
            public CachedValueProvider.Result<Set<DasObject>> compute() {
                return CachedValueProvider.Result.create((Object)DbImplUtil.calcDefaultImports(dataSource), (Object[])new Object[]{DbPsiFacade.getInstance((Project)dataSource.getProject())});
            }
        });
        Condition condition = Conditions.oneOf((Collection)elements);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getResolveUnqualifiedCondition"));
        }
        return condition;
    }

    @NotNull
    private static Set<DasObject> calcDefaultImports(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "calcDefaultImports"));
        }
        Object d = dataSource.getDelegate();
        DbDataSource parentDataSource = d instanceof SqlDataSource ? ((SqlDataSource)d).getParentDataSource() : null;
        Object parentDelegate = parentDataSource != null ? parentDataSource.getDelegate() : null;
        Object delegate = parentDelegate instanceof DatabaseSystem ? (DatabaseSystem)parentDelegate : d;
        Pattern pattern = delegate instanceof LocalDataSource ? DataSourceUiUtil.getDefaultSchemasPattern((LocalDataSource)((Object)delegate)) : null;
        HashSet set = ContainerUtil.newHashSet();
        JBIterable objects = ((JBTreeTraverser)dataSource.getModel().traverser().expandAndFilter(DasUtil.byClass(DasNamespace.class))).traverse();
        if (pattern == null) {
            Set set2 = (Set)objects.addAllTo((Collection)set);
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "calcDefaultImports"));
            }
            return set2;
        }
        for (DasObject o : objects) {
            String name = QNameUtil.getQualifiedName(o);
            if (!pattern.matcher(name).matches() && !pattern.matcher("." + name).matches() && !pattern.matcher(name + ".").matches()) continue;
            DasUtil.dasParents((DasObject)o).addAllTo((Collection)set);
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "calcDefaultImports"));
        }
        return hashSet;
    }
}

