/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.ssrp;

import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInfo {
    private static final String SERVER_NAME = "ServerName";
    private static final String INSTANCE_NAME = "InstanceName";
    public static final String PORT = "tcp";
    public static final String PIPE = "np";
    public static final String VERSION = "Version";
    private final THashMap<String, SsrpServer> myServers;

    public SsrpInfo() {
        this.myServers = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    public SsrpInfo(@NotNull String str) throws SsrpConstants.SsrpException {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "<init>"));
        }
        this.myServers = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        this.merge(str);
    }

    private void merge(@NotNull String str) throws SsrpConstants.SsrpException {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "merge"));
        }
        for (String inst : str.split(";;")) {
            SsrpServer server;
            String[] split = inst.split(";");
            if (split.length < 2) continue;
            if (!split[0].equals(SERVER_NAME)) {
                SsrpInfo.expected(SERVER_NAME, new String[]{str, inst});
            }
            if ((server = (SsrpServer)this.myServers.get((Object)split[1])) == null) {
                server = new SsrpServer(split[1]);
                this.myServers.put((Object)split[1], (Object)server);
            }
            server.merge(split);
        }
    }

    public void removeServer(@NotNull String server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "removeServer"));
        }
        this.myServers.remove((Object)server);
    }

    @NotNull
    public Collection<SsrpServer> getServers() {
        Collection collection = this.myServers.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "getServers"));
        }
        return collection;
    }

    @Nullable
    public SsrpServer getServer(@NotNull String server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "getServer"));
        }
        return (SsrpServer)this.myServers.get((Object)server);
    }

    @Contract(value="_,_->fail")
    private static void expected(@NotNull String s, @NotNull String[] split) throws SsrpConstants.SsrpException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "expected"));
        }
        if (split == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "split", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "expected"));
        }
        throw new SsrpConstants.SsrpException("Expected " + s + " in `" + StringUtil.join((String[])split, (String)";") + "`");
    }

    public static class SsrpInstance {
        private String myName;
        private final Map<String, String> myAttributes;

        public SsrpInstance(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "<init>"));
            }
            this.myAttributes = ContainerUtil.newHashMap();
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "getName"));
            }
            return string;
        }

        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "setName"));
            }
            this.myName = name;
        }

        @Nullable
        public String getAttribute(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "getAttribute"));
            }
            return this.myAttributes.get(name);
        }
    }

    public static final class SsrpServer {
        private String myName;
        private final Map<String, SsrpInstance> myInstances;

        public SsrpServer(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "<init>"));
            }
            this.myInstances = ContainerUtil.newTreeMap();
            this.myName = name;
        }

        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "setName"));
            }
            this.myName = name;
        }

        private void merge(@NotNull String[] split) throws SsrpConstants.SsrpException {
            if (split == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "split", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "merge"));
            }
            if (split.length < 4 || !split[2].equals(SsrpInfo.INSTANCE_NAME)) {
                SsrpInfo.expected(SsrpInfo.INSTANCE_NAME, split);
            }
            SsrpInstance instance = new SsrpInstance(split[3]);
            int i = 4;
            while (i + 1 < split.length) {
                instance.myAttributes.put(split[i], split[i + 1]);
                ++i;
            }
            this.myInstances.put(split[3], instance);
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "getName"));
            }
            return string;
        }

        @NotNull
        public Collection<SsrpInstance> getInstances() {
            Collection<SsrpInstance> collection = this.myInstances.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "getInstances"));
            }
            return collection;
        }

        @Nullable
        public SsrpInstance getInstance(@NotNull String instance) {
            if (instance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "getInstance"));
            }
            return this.myInstances.get(instance);
        }
    }
}

