/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.ssrp;

import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.database.vendors.mssql.ssrp.SsrpNet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SofterReference;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInfoCache {
    private static final SsrpInfoCache INSTANCE = new SsrpInfoCache();
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private SofterReference<SsrpInfo> myInfo;
    private boolean myQueued;
    private final Task.Backgroundable myUpdateTask = new Task.Backgroundable(null, "Discovering Reachable SQL Server Instances", true){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache$1", "run"));
            }
            try {
                String instances = SsrpNet.queryNetworkInstances(1434, 5000);
                SsrpInfo info = new SsrpInfo(instances);
                SsrpInfoCache ssrpInfoCache = INSTANCE;
                synchronized (ssrpInfoCache) {
                    INSTANCE.myInfo = new SofterReference((Object)info);
                }
                ((Listener)SsrpInfoCache.this.myDispatcher.getMulticaster()).consume(null);
            }
            catch (SsrpConstants.SsrpException e) {
                ((Listener)SsrpInfoCache.this.myDispatcher.getMulticaster()).consume(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancel() {
            SsrpInfoCache ssrpInfoCache = INSTANCE;
            synchronized (ssrpInfoCache) {
                INSTANCE.myQueued = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess() {
            SsrpInfoCache ssrpInfoCache = INSTANCE;
            synchronized (ssrpInfoCache) {
                INSTANCE.myQueued = false;
            }
        }
    };

    private SsrpInfoCache() {
    }

    public static void addListener(@NotNull Listener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache", "addListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache", "addListener"));
        }
        SsrpInfoCache.INSTANCE.myDispatcher.addListener((EventListener)listener, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SsrpInfo get() {
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        synchronized (ssrpInfoCache) {
            return SsrpInfoCache.INSTANCE.myInfo == null ? null : (SsrpInfo)SsrpInfoCache.INSTANCE.myInfo.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        synchronized (ssrpInfoCache) {
            if (SsrpInfoCache.INSTANCE.myQueued) {
                return;
            }
            SsrpInfoCache.INSTANCE.myQueued = true;
        }
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(SsrpInfoCache.INSTANCE.myUpdateTask, (ProgressIndicator)new BackgroundableProcessIndicator(SsrpInfoCache.INSTANCE.myUpdateTask), null, ModalityState.current());
    }

    public static interface Listener
    extends EventListener,
    Consumer<SsrpConstants.SsrpException> {
    }
}

