/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.ssrp;

import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.database.vendors.mssql.ssrp.SsrpDecoder;
import com.intellij.database.vendors.mssql.ssrp.SsrpEncoder;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class SsrpNet {
    public static String queryNetworkInstances(int port, int timeout) throws SsrpConstants.SsrpException {
        DatagramSocket sock = null;
        StringBuilder result = new StringBuilder();
        try {
            sock = new DatagramSocket();
            sock.setBroadcast(true);
            byte[] req = SsrpEncoder.createClientBroadcastReq();
            sock.setSoTimeout(timeout);
            sock.send(new DatagramPacket(req, req.length, InetAddress.getByName("255.255.255.255"), port));
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            while (SsrpNet.appendResponseOrTimeout(sock, packet, result)) {
            }
        }
        catch (UnknownHostException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (SocketException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        return result.toString();
    }

    public static String queryInstances(@NotNull String host, int port, int timeout) throws SsrpConstants.SsrpException {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "queryInstances"));
        }
        DatagramSocket sock = null;
        StringBuilder result = new StringBuilder();
        try {
            sock = new DatagramSocket();
            byte[] req = SsrpEncoder.createClientUnicastReq();
            sock.setSoTimeout(timeout);
            sock.send(new DatagramPacket(req, req.length, InetAddress.getByName(host), port));
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            SsrpNet.appendResponseOrTimeout(sock, packet, result);
        }
        catch (UnknownHostException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (SocketException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        return result.toString();
    }

    @NotNull
    private static DatagramPacket allocateLargePacket() {
        byte[] responseBuffer = new byte[65600];
        DatagramPacket datagramPacket = new DatagramPacket(responseBuffer, responseBuffer.length);
        if (datagramPacket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "allocateLargePacket"));
        }
        return datagramPacket;
    }

    private static boolean appendResponseOrTimeout(@NotNull DatagramSocket sock, @NotNull DatagramPacket buffer, @NotNull StringBuilder sb) throws SsrpConstants.SsrpException {
        if (sock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sock", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "appendResponseOrTimeout"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "appendResponseOrTimeout"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "appendResponseOrTimeout"));
        }
        try {
            sock.receive(buffer);
            String resp = SsrpDecoder.decodeResponseString(ByteBuffer.wrap(buffer.getData()));
            if (resp != null) {
                sb.append(resp);
            }
        }
        catch (SocketTimeoutException e) {
            return false;
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        return true;
    }
}

