/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseColorManager<T extends SharedColors>
implements PersistentStateComponent<T> {
    private static Key<CachedColor> COLOR_KEY = Key.create((String)"COLOR_KEY");
    private static final SimpleModificationTracker ourModificationTracker = new SimpleModificationTracker();
    protected T myState;

    public static DatabaseColorManager<LocalColors> getLocalColorManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseColorManager", "getLocalColorManager"));
        }
        return (DatabaseColorManager)ServiceManager.getService((Project)project, Local.class);
    }

    public static DatabaseColorManager<SharedColors> getSharedColorManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseColorManager", "getSharedColorManager"));
        }
        return (DatabaseColorManager)ServiceManager.getService((Project)project, Shared.class);
    }

    private static long getModCount() {
        return ourModificationTracker.getModificationCount() + UISettings.getInstance().getModificationCount();
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseColorManager", "getState"));
        }
        return t;
    }

    public void loadState(T state) {
        this.myState = state;
    }

    @Nullable
    public static Color getColorImpl(Project project, @Nullable VirtualFile file) {
        DbDataSource element = null;
        if (DbConsoleRootType.isConsoleFile(file)) {
            element = DbConsoleRootType.getDataSource(project, file);
        } else if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            DbElement tableOrView = dbFile.findElement();
            element = tableOrView != null ? tableOrView : dbFile.findDataSource();
        }
        return DatabaseColorManager.getColor((DbElement)element);
    }

    @Nullable
    public static Color getColor(@Nullable DbElement element) {
        if (element == null) {
            return null;
        }
        CachedColor info = (CachedColor)COLOR_KEY.get((UserDataHolder)element);
        long modificationCount = DatabaseColorManager.getModCount();
        if (info != null && info.modCount != modificationCount) {
            info = null;
        }
        if (info == null) {
            Color c;
            String colorName = DatabaseColorManager.getColorName(element, null);
            info = new CachedColor();
            info.modCount = modificationCount;
            if (colorName != null && (c = FileColorManager.getInstance((Project)element.getProject()).getColor(colorName)) != null) {
                info.color = c;
            }
            COLOR_KEY.set((UserDataHolder)element, (Object)info);
        }
        return info.color;
    }

    public static void setColorName(@NotNull DbElement element, @Nullable String colorName, boolean recursively, boolean isShared) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseColorManager", "setColorName"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DatabaseColorManager<LocalColors> localColorManager = DatabaseColorManager.getLocalColorManager(element.getProject());
        Object local = localColorManager.getState();
        Object shared = DatabaseColorManager.getSharedColorManager(element.getProject()).getState();
        String elementId = DatabaseColorManager.getElementId(element);
        boolean changed = ((SharedColors)shared).colors.remove(elementId) != null;
        changed |= ((SharedColors)local).colors.remove(elementId) != null;
        if (colorName != null) {
            boolean doNotChange;
            Ref sharedRef = Ref.create(null);
            boolean bl = doNotChange = !changed && colorName.equals(DatabaseColorManager.getColorName(element, (Ref<Boolean>)sharedRef)) && isShared == Boolean.TRUE.equals(sharedRef.get());
            if (!doNotChange) {
                changed = true;
                ((SharedColors)(isShared ? shared : local)).colors.put(elementId, colorName);
            }
        }
        if (recursively) {
            changed |= DatabaseColorManager.clearChildren(elementId, ((SharedColors)shared).colors);
            changed |= DatabaseColorManager.clearChildren(elementId, ((SharedColors)local).colors);
        }
        if (changed) {
            ourModificationTracker.incModificationCount();
        }
    }

    private static boolean clearChildren(String elementId, Map<String, String> colors) {
        boolean changed = false;
        String id = elementId.substring(0, elementId.lastIndexOf(58) + 1);
        for (String s : ArrayUtil.toStringArray(colors.keySet())) {
            int idx = s.indexOf(id);
            if (idx <= 0 || s.charAt(idx - 1) != '/') continue;
            changed |= colors.remove(s) != null;
        }
        return changed;
    }

    @Nullable
    public static String getColorName(@Nullable DbElement element, Ref<Boolean> sharedRef) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (element == null) {
            return null;
        }
        Object local = DatabaseColorManager.getLocalColorManager(element.getProject()).getState();
        Object shared = DatabaseColorManager.getSharedColorManager(element.getProject()).getState();
        if (((SharedColors)shared).colors.isEmpty() && ((SharedColors)local).colors.isEmpty()) {
            return null;
        }
        for (DbElement e = element; e != null; e = e.getDbParent()) {
            boolean isShared;
            String elementId = DatabaseColorManager.getElementId(e);
            String s = ((SharedColors)local).colors.get(elementId);
            boolean bl = isShared = s == null;
            if (s == null) {
                s = ((SharedColors)shared).colors.get(elementId);
                boolean bl2 = isShared = s != null;
            }
            if (s == null) continue;
            if (sharedRef != null) {
                sharedRef.set((Object)isShared);
            }
            return s;
        }
        return null;
    }

    private static String getElementId(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseColorManager", "getElementId"));
        }
        StringBuilder sb = new StringBuilder(DatabaseColorManager.getElementName(element));
        return DatabaseColorManager.getElementId(element.getDbParent(), sb).append(":").append(element.getKind().name()).toString();
    }

    @NotNull
    private static StringBuilder getElementId(DbElement element, @NotNull StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/view/DatabaseColorManager", "getElementId"));
        }
        if (element == null) {
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseColorManager", "getElementId"));
            }
            return stringBuilder;
        }
        StringBuilder stringBuilder = DatabaseColorManager.getElementId(element.getDbParent(), sb.append("/").append(DatabaseColorManager.getElementName(element)));
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseColorManager", "getElementId"));
        }
        return stringBuilder;
    }

    private static String getElementName(DbElement element) {
        return element instanceof DbDataSource ? ((DbDataSource)element).getUniqueId() : DatabaseElementVirtualFileImpl.escape(element.getName());
    }

    private static void cleanupColors(Project project) {
        Map local = ((LocalColors)DatabaseColorManager.getLocalColorManager((Project)project).getState()).colors;
        Map<String, String> shared = ((SharedColors)DatabaseColorManager.getSharedColorManager((Project)project).getState()).colors;
        if (local.isEmpty() && shared.isEmpty()) {
            return;
        }
        HashSet existingRoots = new HashSet();
        for (DbDataSource element : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            ContainerUtil.addIfNotNull((Collection)existingRoots, (Object)DatabaseColorManager.getElementName((DbElement)element));
        }
        DatabaseColorManager.cleanupColors(local, (Set<String>)existingRoots);
        DatabaseColorManager.cleanupColors(shared, (Set<String>)existingRoots);
    }

    private static void cleanupColors(Map<String, String> colors, Set<String> roots) {
        block0: for (String s : ArrayUtil.toStringArray(colors.keySet())) {
            for (String root : roots) {
                if (!s.contains(root)) continue;
                continue block0;
            }
            colors.remove(s);
        }
    }

    private static class CachedColor {
        Color color;
        long modCount;

        private CachedColor() {
        }
    }

    public static class LocalColors
    extends SharedColors {
        @OptionTag(value="use-colors")
        public boolean useColors = true;
        @OptionTag(value="in-editor-tabs")
        public boolean inEditorTabs = true;
        @OptionTag(value="in-database-view")
        public boolean inDatabaseView = true;
        @OptionTag(value="in-toolbars")
        public boolean useInToolbars = true;
    }

    public static class SharedColors {
        @Tag(value="colors")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, String> colors = new HashMap();
    }

    @State(name="DatabaseLocalColorSettings", storages={@Storage(file="$WORKSPACE_FILE$")})
    private static class Local
    extends DatabaseColorManager<LocalColors>
    implements PersistentStateComponent<LocalColors> {
        public Local(Project project) {
            this.myState = new LocalColors();
            ProjectManager.getInstance().addProjectManagerListener(project, (ProjectManagerListener)new ProjectManagerAdapter(){

                public boolean canCloseProject(Project project) {
                    DatabaseColorManager.cleanupColors(project);
                    return true;
                }
            });
        }
    }

    @State(name="DatabaseColorSettings", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/databaseColors.xml", scheme=StorageScheme.DIRECTORY_BASED)})
    private static class Shared
    extends DatabaseColorManager<SharedColors>
    implements PersistentStateComponent<SharedColors> {
        public Shared() {
            this.myState = new SharedColors();
        }
    }
}

