/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.DatabaseToolWindowFactory;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.psi.DbTable;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashSet;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@State(name="DatabaseView", storages={@Storage(file="$WORKSPACE_FILE$")})
public class DatabaseView
extends SimpleToolWindowPanel
implements PersistentStateComponent<Element>,
Disposable {
    public static final DataKey<DatabaseView> DATABASE_VIEW_KEY = DataKey.create((String)"DATABASE_VIEW_KEY");
    private final Project myProject;
    private final DbPsiFacade myDbFacade;
    private final Tree myTree;
    private final AbstractTreeBuilder myBuilder;
    private final CopyProvider myCopyProvider;
    private final DatabaseViewOptions myViewOptions = new DatabaseViewOptions();
    private static final DataSourceFactory MY_DATA_SOURCE_FACTORY = new DataSourceFactory(){

        @Override
        public void create(@NotNull DbPsiFacade facade, @NotNull DbPsiManager manager, @NotNull DataSourceTemplate template, @Nullable String s) {
            if (facade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/DatabaseView$12", "create"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/view/DatabaseView$12", "create"));
            }
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/DatabaseView$12", "create"));
            }
            DatabaseView.instantiateTemplate(facade, manager, template, s);
        }
    };

    public static DatabaseView getDatabaseView(Project project) {
        return (DatabaseView)((Object)ServiceManager.getService((Project)project, DatabaseView.class));
    }

    public DatabaseView(Project project) {
        super(true, true);
        this.myProject = project;
        this.myDbFacade = DbPsiFacade.getInstance((Project)project);
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new ProjectViewTree(project, model){

            @Nullable
            public Color getFileColorFor(Object object) {
                DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(this.getProject()).getState();
                if (!state.useColors || !state.inDatabaseView) {
                    return null;
                }
                Object o = object instanceof NodeDescriptor ? ((NodeDescriptor)object).getElement() : object;
                DbElement e = o instanceof PsiElement ? (DbElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), DbElement.class, (boolean)false) : null;
                return DatabaseColorManager.getColor(e);
            }

            public DefaultMutableTreeNode getSelectedNode() {
                TreePath path = this.getSelectionPath();
                return path == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
            }

            public boolean isFileColorsEnabled() {
                return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
            }
        };
        this.myBuilder = new AbstractTreeBuilder((JTree)this.myTree, model, (AbstractTreeStructure)new DatabaseStructure(this.myDbFacade, this.myViewOptions), (Comparator)new WeightBasedComparator(true){

            protected int getWeight(NodeDescriptor o1) {
                Object delegate;
                Object element = o1.getElement();
                int weight = super.getWeight(o1);
                if (!((DatabaseView)DatabaseView.this).myViewOptions.SORT_POSITIONED && element instanceof DbElement && (delegate = ((DbElement)element).getDelegate()) instanceof DasPositioned) {
                    return weight + ((DasPositioned)delegate).getPosition();
                }
                return weight;
            }

            protected int compareWeights(int w1, int w2) {
                return w1 - w2;
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.initComponents();
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myDbFacade.addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade modificationTracker) {
                DatabaseView.this.refreshView();
            }
        }, (Disposable)this);
        JdbcDriverManager.getDriverManager(project).addModificationTrackerListener(new ModificationTrackerListener<JdbcDriverManager>(){

            public void modificationCountChanged(JdbcDriverManager source) {
                DatabaseView.this.getTreeBuilder().queueUpdate(false);
            }
        }, this);
        this.enableDnD();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DatabaseSettings.TOPIC, (Object)new DatabaseSettings.Listener(){

            @Override
            public void settingsChanged() {
                DatabaseView.this.refreshView();
            }
        });
        this.myCopyProvider = new TextCopyProvider(){

            @Nullable
            public Collection<String> getTextLinesToCopy() {
                Set selectedElements = DatabaseView.this.getTreeBuilder().getSelectedElements(DbElement.class);
                if (selectedElements.isEmpty()) {
                    return null;
                }
                ArrayList lines = ContainerUtil.newArrayList();
                for (DbElement selectedElement : selectedElements) {
                    String name = selectedElement.getName();
                    if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                    lines.add(name);
                }
                return lines;
            }
        };
    }

    @NotNull
    public DatabaseViewOptions getViewOptions() {
        DatabaseViewOptions databaseViewOptions = this.myViewOptions;
        if (databaseViewOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getViewOptions"));
        }
        return databaseViewOptions;
    }

    @NotNull
    public static <T extends DbElement> Set<T> getSelectedElements(@NotNull DataContext dataContext, Class<T> aClass) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/view/DatabaseView", "getSelectedElements"));
        }
        Set set = (Set)JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext))).filter(aClass).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getSelectedElements"));
        }
        return set;
    }

    private void initComponents() {
        this.myBuilder.initRootNode();
        this.myTree.setDragEnabled(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.updateEmptyText();
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)"DatabaseViewPopupMenu", (String)"J2EEAttributesViewPopup");
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.setToolbar(this.createToolbar().getComponent());
    }

    private void updateEmptyText() {
        String shortcut;
        String emptyText = this.myDbFacade.getDataSources().isEmpty() ? (StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("NewElement")))) ? "Create a data source with " + shortcut : "Create a data source with context menu") : "Loading...";
        this.myTree.getEmptyText().setText(emptyText);
    }

    @NotNull
    public AbstractTreeBuilder getTreeBuilder() {
        AbstractTreeBuilder abstractTreeBuilder = this.myBuilder;
        if (abstractTreeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getTreeBuilder"));
        }
        return abstractTreeBuilder;
    }

    public Project getProject() {
        return this.myProject;
    }

    private ActionCallback refreshView() {
        this.updateEmptyText();
        return this.myBuilder.queueUpdate();
    }

    @NotNull
    public final Promise<Void> selectElements(DbElement ... elements) {
        if (this.myBuilder.isDisposed()) {
            Promise promise = Promise.REJECTED;
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "selectElements"));
            }
            return promise;
        }
        final AsyncPromise callback = new AsyncPromise();
        this.getTreeBuilder().select((Object[])elements, new Runnable(){

            @Override
            public void run() {
                callback.setResult(null);
            }
        });
        AsyncPromise asyncPromise = callback;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "selectElements"));
        }
        return asyncPromise;
    }

    @Nullable
    public static <T> T getSelectedElementOfType(Class<T> elementClass, boolean strict, AbstractTreeBuilder treeBuilder) {
        Set selectedElements = treeBuilder.getSelectedElements();
        if (strict && selectedElements.size() != 1) {
            return null;
        }
        T result = null;
        AbstractTreeStructure structure = (AbstractTreeStructure)ObjectUtils.assertNotNull((Object)treeBuilder.getTreeStructure());
        Iterator iterator = selectedElements.iterator();
        block0: while (iterator.hasNext()) {
            Object selected;
            Object cur = selected = iterator.next();
            while (cur != null) {
                if (elementClass.isInstance(cur)) {
                    if (result == null) {
                        result = elementClass.cast(cur);
                    } else if (result != cur) {
                        return null;
                    }
                }
                if (strict) continue block0;
                cur = structure.getParentElement(cur);
            }
        }
        return result;
    }

    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)this.myTree);
            DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(), (JComponent)this.myTree);
        }
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        AnAction group = ActionManager.getInstance().getAction("DatabaseViewToolbar");
        actionGroup.addAll(((DefaultActionGroup)group).getChildActionsOrStubs());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)actionGroup, true);
        toolbar.setTargetComponent((JComponent)this.myTree);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "createToolbar"));
        }
        return actionToolbar;
    }

    public void dispose() {
    }

    public void setupToolWindow(ToolWindowEx toolWindow) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new GroupObjectsByTypeAction());
        actionGroup.addAction((AnAction)new GroupNestedByTypeAction());
        actionGroup.addAction((AnAction)new ShowTableDetails());
        actionGroup.addAction((AnAction)new ShowEmptyGroupsAction());
        actionGroup.addAction((AnAction)new SortPositionedObjects());
        toolWindow.setAdditionalGearActions((ActionGroup)actionGroup);
        DumbAwareAction consoleTitleAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(!DatabaseView.this.isToolbarVisible());
            }

            public void actionPerformed(AnActionEvent e) {
                DbDataSource dataSource = DatabaseView.getSelectedElementOfType(DbDataSource.class, false, DatabaseView.this.getTreeBuilder());
                DatabaseEditorHelper.openConsoleFile((DbElement)dataSource);
            }
        };
        consoleTitleAction.copyFrom(ActionManager.getInstance().getAction("Jdbc.OpenConsole"));
        consoleTitleAction.getTemplatePresentation().setIcon(DatabaseIcons.ConsoleRun);
        consoleTitleAction.getTemplatePresentation().setHoveredIcon(DatabaseIcons.ConsoleRunHover);
        final AnAction baseAction = ActionManager.getInstance().getAction("DatabaseView.SynchronizeAction");
        DumbAwareAction refreshTitleAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(!DatabaseView.this.isToolbarVisible());
            }

            public void actionPerformed(AnActionEvent e) {
                baseAction.actionPerformed(new AnActionEvent(e.getInputEvent(), SimpleDataContext.getSimpleContext((String)DATABASE_VIEW_KEY.getName(), (Object)((Object)DatabaseView.this), (DataContext)e.getDataContext()), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
            }
        };
        refreshTitleAction.copyFrom(baseAction);
        refreshTitleAction.getTemplatePresentation().setIcon(DatabaseIcons.SchemaRefresh);
        refreshTitleAction.getTemplatePresentation().setHoveredIcon(DatabaseIcons.SchemaRefreshHover);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        toolWindow.setTitleActions(new AnAction[]{refreshTitleAction, consoleTitleAction, actionsManager.createCollapseAllHeaderAction((JTree)this.myTree)});
    }

    private static void doGenerateDDL(Collection<DbElement> selectedElements) {
        List tables;
        final THashSet visited = ContainerUtil.newTroveSet();
        DdlBuilder builder = new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder element(@NotNull DasObject element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseView$10", "element"));
                }
                if (!visited.add((Object)element)) {
                    10 v0 = this;
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$10", "element"));
                    }
                    return v0;
                }
                if (element.getKind() == ObjectKind.SCHEMA) {
                    JBIterable tables = element.getDbChildren(DbTable.class, ObjectKind.NONE);
                    tables.addAllTo((Collection)visited);
                    this.tables((Iterable<? extends DasTable>)tables);
                }
                DdlBuilder ddlBuilder = super.element(element);
                if (ddlBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$10", "element"));
                }
                return ddlBuilder;
            }
        };
        DbElement item = (DbElement)ContainerUtil.getFirstItem(selectedElements);
        if (item != null) {
            builder.configureFor(item);
        }
        if (!(tables = ContainerUtil.findAll(selectedElements, DbTable.class)).isEmpty()) {
            builder.tables(tables).newStatement();
            visited.addAll((Collection)tables);
        }
        builder.elements(selectedElements);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(builder.getStatement()));
    }

    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        AbstractTreeBuilder builder = this.getTreeBuilder();
        if (builder.isDisposed()) {
            return null;
        }
        if (DATABASE_VIEW_KEY.is(dataId)) {
            return this;
        }
        if (DatabaseDataKeys.DB_PSI_FACADE.is(dataId)) {
            return this.myDbFacade;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.tools.datasource";
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            Collection c = DatabaseView.getDataFromSelectedPaths(CommonDataKeys.PSI_ELEMENT, builder.getTree());
            if (c.isEmpty()) {
                return null;
            }
            if (JBIterable.from(c).filter(DbDataSource.class).size() == c.size()) {
                return new DdlActions.DeleteProvider1();
            }
            return new DdlActions.DeleteProvider2();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyProvider;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            Collection<PsiElement> c = DatabaseView.getDataFromSelectedPaths(CommonDataKeys.PSI_ELEMENT, builder.getTree());
            return c.isEmpty() ? null : c.toArray(new PsiElement[c.size()]);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Collection<Navigatable> c = DatabaseView.getDataFromSelectedPaths(CommonDataKeys.NAVIGATABLE, builder.getTree());
            return c.isEmpty() ? null : c.toArray(new Navigatable[c.size()]);
        }
        return DatabaseView.getDataFromPath(dataId, builder.getTree().getSelectionPath());
    }

    @NotNull
    private static <T> Collection<T> getDataFromSelectedPaths(@NotNull DataKey<T> key, @Nullable JTree tree) {
        TreePath[] paths;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/DatabaseView", "getDataFromSelectedPaths"));
        }
        TreePath[] treePathArray = paths = tree == null ? null : tree.getSelectionPaths();
        if (paths == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getDataFromSelectedPaths"));
            }
            return list;
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (TreePath path : paths) {
            ContainerUtil.addIfNotNull((Collection)result, DatabaseView.getDataFromPath(key.getName(), path));
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getDataFromSelectedPaths"));
        }
        return linkedHashSet;
    }

    @Nullable
    private static <T> T getDataFromPath(@NotNull String dataId, @Nullable TreePath path) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/database/view/DatabaseView", "getDataFromPath"));
        }
        Object lastNode = path == null ? null : path.getLastPathComponent();
        Object userObject = lastNode instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)lastNode).getUserObject() : null;
        return (T)(userObject instanceof DataProvider ? ((DataProvider)userObject).getData(dataId) : null);
    }

    @Nullable
    private DnDTarget findDndTargetAt(Point point) {
        DbElement element;
        DnDTarget target;
        Object userObject;
        Object o;
        TreePath path = this.myTree.getClosestPathForLocation(point.x, point.y);
        Object object = o = path == null ? null : path.getLastPathComponent();
        if (o instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)o).getUserObject()) instanceof DbNodeDescriptor && (target = (DnDTarget)(element = ((DbNodeDescriptor)((Object)userObject)).getElement()).getUserData(DatabaseDataKeys.DND_TARGET_KEY)) != null) {
            return target;
        }
        return null;
    }

    public static void select(@NotNull DbElement element, boolean requestFocus) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseView", "select"));
        }
        DatabaseView.select(element.getProject(), requestFocus, element);
    }

    public static void select(@NotNull Project project, boolean requestFocus, final DbElement ... elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseView", "select"));
        }
        ToolWindow window = DatabaseView.getDatabaseToolWindow(project);
        final DatabaseView databaseView = DatabaseView.getDatabaseView(project);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                databaseView.selectElements(elements);
            }
        };
        if (requestFocus) {
            window.activate(runnable);
        } else {
            runnable.run();
        }
    }

    @NotNull
    public static ToolWindow getDatabaseToolWindow(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseView", "getDatabaseToolWindow"));
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.DATABASE_VIEW);
        if (window == null) {
            DatabaseToolWindowFactory factory = new DatabaseToolWindowFactory();
            window = ToolWindowManager.getInstance((Project)project).registerToolWindow(ToolWindowId.DATABASE_VIEW, true, ToolWindowAnchor.RIGHT, (Disposable)project, true);
            factory.createToolWindowContent(project, window);
        }
        ToolWindow toolWindow = window;
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getDatabaseToolWindow"));
        }
        return toolWindow;
    }

    @Nullable
    public Element getState() {
        Element element = XmlSerializer.serialize((Object)this.myViewOptions, null);
        try {
            TreeState.createOn((JTree)this.myTree).writeExternal(element);
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    public void loadState(Element state) {
        XmlSerializer.deserializeInto((Object)this.myViewOptions, (Element)state);
        TreeState treeState = new TreeState();
        try {
            treeState.readExternal(state);
            treeState.applyTo((JTree)this.myTree);
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
    }

    private static void instantiateTemplate(@NotNull DbPsiFacade facade, @NotNull DbPsiManager manager, @NotNull DataSourceTemplate template, @Nullable String url) {
        LocalDataSource localDataSource;
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/DatabaseView", "instantiateTemplate"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/view/DatabaseView", "instantiateTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/DatabaseView", "instantiateTemplate"));
        }
        DatabaseSystem newDS = template.createDataSource(facade.getProject(), null, null);
        if (url != null && (localDataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)newDS, LocalDataSource.class))) != null) {
            localDataSource.setUrlSmart(url);
        }
        DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(newDS, (DbPsiManagerSpi)manager);
        DataSourceManagerDialog.showDialog(facade, newElement);
    }

    public static void addNewDataSourceActions(@NotNull List<AnAction> actions, boolean flatten, @NotNull DbPsiFacade facade, @Nullable Function.Mono<DataSourceTemplate> wrapper, PairConsumer<DbPsiManager, DataSourceTemplate> consumer) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/view/DatabaseView", "addNewDataSourceActions"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/DatabaseView", "addNewDataSourceActions"));
        }
        for (DbPsiManager manager : facade.getDbManagers()) {
            if (flatten) {
                actions.add((AnAction)Separator.getInstance());
            }
            int size = actions.size();
            DatabaseView.addNewDataSourceActions(actions, manager, manager.getDataSourceTemplates(), wrapper, consumer);
            for (AnAction action : actions.subList(size, actions.size())) {
                if (!(action instanceof ActionGroup)) continue;
                ((ActionGroup)action).setPopup(!flatten);
            }
        }
    }

    public static void addNewDataSourceActions(@NotNull List<AnAction> actions, final @NotNull DbPsiManager manager, @NotNull List<? extends DataSourceTemplate> templates, final @Nullable Function.Mono<DataSourceTemplate> wrapper, final @NotNull PairConsumer<DbPsiManager, DataSourceTemplate> consumer) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/view/DatabaseView", "addNewDataSourceActions"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/view/DatabaseView", "addNewDataSourceActions"));
        }
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/database/view/DatabaseView", "addNewDataSourceActions"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/view/DatabaseView", "addNewDataSourceActions"));
        }
        Condition<DataSourceTemplate> predefCondition = new Condition<DataSourceTemplate>(){

            public boolean value(DataSourceTemplate template) {
                return template instanceof DatabaseDriver && ((DatabaseDriver)template).isPredefined();
            }
        };
        Comparator<DataSourceTemplate> comparator = new Comparator<DataSourceTemplate>(){

            @Override
            public int compare(DataSourceTemplate o1, DataSourceTemplate o2) {
                return StringUtil.naturalCompare((String)o1.getFullName(), (String)o2.getFullName());
            }
        };
        JBIterable predef = JBIterable.from(templates).filter((Condition)predefCondition);
        JBIterable nonPredef = JBIterable.from(templates).filter(Conditions.not((Condition)predefCondition));
        if (wrapper != null) {
            predef = predef.transform(wrapper);
            nonPredef = nonPredef.transform(wrapper);
        }
        ArrayList sortedTemplates = ContainerUtil.newArrayList();
        sortedTemplates.addAll(nonPredef.toList());
        int sepIdx = sortedTemplates.size();
        sortedTemplates.addAll(predef.toList());
        Collections.sort(sortedTemplates.subList(0, sepIdx), comparator);
        Collections.sort(sortedTemplates.subList(sepIdx, sortedTemplates.size()), comparator);
        DataSourceTemplate sepItem = sepIdx == sortedTemplates.size() || sepIdx == 0 ? null : (DataSourceTemplate)sortedTemplates.get(sepIdx);
        for (final DataSourceTemplate template : sortedTemplates) {
            List subs;
            if (template == sepItem) {
                actions.add((AnAction)Separator.getInstance());
            }
            if (!(subs = template.getSubConfigurations()).isEmpty()) {
                actions.add((AnAction)new PopupActionGroup(template.getFullName(), null, template.getIcon(0)){

                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        ArrayList subActions = ContainerUtil.newArrayList();
                        DatabaseView.addNewDataSourceActions((List<AnAction>)subActions, manager, subs, (Function.Mono<DataSourceTemplate>)wrapper, (PairConsumer<DbPsiManager, DataSourceTemplate>)consumer);
                        AnAction[] anActionArray = subActions.toArray(new AnAction[subActions.size()]);
                        if (anActionArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$15", "getChildren"));
                        }
                        return anActionArray;
                    }

                    @Override
                    public void update(AnActionEvent e) {
                        e.getPresentation().setEnabled(true);
                    }
                });
                continue;
            }
            actions.add((AnAction)new DumbAwareAction(template.getName(), null, template.getIcon(0)){

                public void actionPerformed(AnActionEvent e) {
                    consumer.consume((Object)manager, (Object)template);
                }
            });
        }
    }

    private class ShowTableDetails
    extends ToggleAction
    implements DumbAware {
        private ShowTableDetails() {
            super("Show Keys && etc.");
        }

        public boolean isSelected(AnActionEvent e) {
            e.getPresentation().setVisible(!((DatabaseView)DatabaseView.this).myViewOptions.GROUP_CONTENTS);
            return ((DatabaseView)DatabaseView.this).myViewOptions.SHOW_TABLE_DETAILS;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state == ((DatabaseView)DatabaseView.this).myViewOptions.SHOW_TABLE_DETAILS) {
                return;
            }
            ((DatabaseView)DatabaseView.this).myViewOptions.SHOW_TABLE_DETAILS = state;
            DatabaseView.this.refreshView();
        }
    }

    private class SortPositionedObjects
    extends ToggleAction
    implements DumbAware {
        private SortPositionedObjects() {
            super("Sort Alphabetically");
        }

        public boolean isSelected(AnActionEvent e) {
            return ((DatabaseView)DatabaseView.this).myViewOptions.SORT_POSITIONED;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state == ((DatabaseView)DatabaseView.this).myViewOptions.SORT_POSITIONED) {
                return;
            }
            ((DatabaseView)DatabaseView.this).myViewOptions.SORT_POSITIONED = state;
            DatabaseView.this.refreshView();
        }
    }

    private class ShowEmptyGroupsAction
    extends ToggleAction
    implements DumbAware {
        private ShowEmptyGroupsAction() {
            super("Show Empty Groups");
        }

        public boolean isSelected(AnActionEvent e) {
            e.getPresentation().setVisible(((DatabaseView)DatabaseView.this).myViewOptions.GROUP_CONTENTS || ((DatabaseView)DatabaseView.this).myViewOptions.GROUP_SCHEMA);
            return ((DatabaseView)DatabaseView.this).myViewOptions.SHOW_EMPTY_GROUPS;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state == ((DatabaseView)DatabaseView.this).myViewOptions.SHOW_EMPTY_GROUPS) {
                return;
            }
            ((DatabaseView)DatabaseView.this).myViewOptions.SHOW_EMPTY_GROUPS = state;
            DatabaseView.this.refreshView();
        }
    }

    private class GroupNestedByTypeAction
    extends ToggleAction
    implements DumbAware {
        private GroupNestedByTypeAction() {
            super("Group Contents");
        }

        public boolean isSelected(AnActionEvent e) {
            return ((DatabaseView)DatabaseView.this).myViewOptions.GROUP_CONTENTS;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state == ((DatabaseView)DatabaseView.this).myViewOptions.GROUP_CONTENTS) {
                return;
            }
            ((DatabaseView)DatabaseView.this).myViewOptions.GROUP_CONTENTS = state;
            DatabaseView.this.refreshView();
        }
    }

    private class GroupObjectsByTypeAction
    extends ToggleAction
    implements DumbAware {
        private GroupObjectsByTypeAction() {
            super("Group Schema");
        }

        public boolean isSelected(AnActionEvent e) {
            return ((DatabaseView)DatabaseView.this).myViewOptions.GROUP_SCHEMA;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state == ((DatabaseView)DatabaseView.this).myViewOptions.GROUP_SCHEMA) {
                return;
            }
            ((DatabaseView)DatabaseView.this).myViewOptions.GROUP_SCHEMA = state;
            DatabaseView.this.refreshView();
        }
    }

    private static class MyTransferable
    implements Transferable {
        private final Object[] myObjects;

        public MyTransferable(Object[] objects) {
            this.myObjects = objects;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor, DnDEventImpl.ourDataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder sb = new StringBuilder();
                for (Object object : this.myObjects) {
                    if (!(object instanceof PsiNamedElement)) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(((PsiNamedElement)object).getName());
                }
                return sb.toString();
            }
            if (DnDEventImpl.ourDataFlavor.equals(flavor)) {
                return this.myObjects;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class MyDnDSource
    implements DnDSource {
        private MyDnDSource() {
        }

        public boolean canStartDragging(DnDAction action, Point dragOrigin) {
            AbstractTreeBuilder builder = DatabaseView.this.getTreeBuilder();
            return builder.getReady((Object)DatabaseView.this).isDone() && !builder.getSelectedElements().isEmpty();
        }

        public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
            return new DnDDragStartBean((Object)new MyTransferable(DatabaseView.this.getTreeBuilder().getSelectedElements().toArray()), dragOrigin);
        }

        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
            JTree tree = DatabaseView.this.getTreeBuilder().getTree();
            TreePath[] paths = tree.getSelectionPaths();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            PresentableNodeDescriptor nodeDescriptor = (PresentableNodeDescriptor)node.getUserObject();
            SimpleColoredComponent c = new SimpleColoredComponent();
            c.setForeground(tree.getForeground());
            c.setBackground(tree.getBackground());
            c.setIcon(nodeDescriptor.getPresentation().getIcon(false));
            for (PresentableNodeDescriptor.ColoredFragment fragment : nodeDescriptor.getPresentation().getColoredText()) {
                c.append(fragment.getText(), fragment.getAttributes());
            }
            if (paths.length > 1) {
                c.append(" +" + (paths.length - 1), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
            Dimension size = c.getPreferredSize();
            c.setSize(size);
            BufferedImage image = UIUtil.createImage((int)size.width, (int)size.height, (int)2);
            c.setOpaque(false);
            Graphics2D g = image.createGraphics();
            c.paint((Graphics)g);
            g.dispose();
            return Pair.create((Object)image, (Object)new Point(0, 0));
        }

        public void dragDropEnd() {
        }

        public void dropActionChanged(int gestureModifiers) {
        }
    }

    private class MyDnDTarget
    implements DnDNativeTarget {
        private MyDnDTarget() {
        }

        public boolean update(DnDEvent aEvent) {
            Point point = aEvent.getPointOn((Component)DatabaseView.this.myTree);
            DnDTarget target = DatabaseView.this.findDndTargetAt(point);
            boolean targetOk = target != null && aEvent.delegateUpdateTo(target);
            boolean ok = targetOk;
            if (!ok) {
                List files = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
                for (DbPsiManager manager : DatabaseView.this.myDbFacade.getDbManagers()) {
                    ok |= manager.canCreateDataSourceByFiles((Collection)files);
                }
                ok |= SystemInfo.isMac && files.isEmpty();
            }
            aEvent.setDropPossible(ok);
            if (ok) {
                RelativeRectangle rectangle;
                Rectangle bounds;
                if (targetOk) {
                    bounds = (Rectangle)ObjectUtils.assertNotNull((Object)DatabaseView.this.myTree.getPathBounds(DatabaseView.this.myTree.getClosestPathForLocation(point.x, point.y)));
                    rectangle = new RelativeRectangle((Component)DatabaseView.this.myTree, bounds);
                } else {
                    bounds = DatabaseView.this.getBounds();
                    rectangle = new RelativeRectangle((Component)((Object)DatabaseView.this), bounds);
                }
                aEvent.setHighlighting(rectangle, 1);
            }
            return ok;
        }

        public void drop(DnDEvent aEvent) {
            DnDTarget target = DatabaseView.this.findDndTargetAt(aEvent.getPointOn((Component)DatabaseView.this.myTree));
            if (target != null && aEvent.delegateUpdateTo(target)) {
                aEvent.delegateDropTo(target);
            } else {
                ArrayList newElements = new ArrayList();
                List files = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
                for (DbPsiManager manager : DatabaseView.this.myDbFacade.getDbManagers()) {
                    newElements.addAll(manager.createDataSourceByFiles((Collection)files));
                }
                DatabaseView.select(DatabaseView.this.myProject, true, newElements.toArray(new DbElement[newElements.size()]));
            }
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }

    static class GenerateDDLAction
    extends AnAction
    implements DumbAware {
        public GenerateDDLAction() {
            super(DatabaseMessages.message((String)"action.text.generate.ddl", (Object[])new Object[0]), null, DatabaseIcons.ExportDDL);
        }

        public void update(AnActionEvent e) {
            DatabaseView view = (DatabaseView)((Object)DATABASE_VIEW_KEY.getData(e.getDataContext()));
            AbstractTreeBuilder builder = view == null ? null : view.getTreeBuilder();
            boolean enabled = builder != null && builder.getReady((Object)view).isDone() && !builder.getSelectedElements(DbElement.class).isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || ActionPlaces.isToolbarPlace((String)e.getPlace()));
        }

        public void actionPerformed(AnActionEvent e) {
            DatabaseView view = (DatabaseView)((Object)DATABASE_VIEW_KEY.getData(e.getDataContext()));
            if (view == null) {
                return;
            }
            DatabaseView.doGenerateDDL(view.getTreeBuilder().getSelectedElements(DbElement.class));
        }
    }

    static class CopyAction
    extends AnAction
    implements DumbAware {
        public CopyAction() {
            super(DatabaseMessages.message((String)"action.name.copy.data.source", (Object[])new Object[0]), DatabaseMessages.message((String)"action.description.copy.data.source", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
        }

        public void update(AnActionEvent e) {
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            boolean enabled = elements.size() == 1 && elements.first() instanceof DbDataSource;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || !ActionPlaces.isPopupPlace((String)e.getPlace()));
        }

        public void actionPerformed(AnActionEvent e) {
            DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            if (facade == null) {
                return;
            }
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            PsiElement first = (PsiElement)elements.first();
            if (elements.size() != 1 || !(first instanceof DbDataSource)) {
                return;
            }
            DbDataSource element = (DbDataSource)first;
            DataSourceTemplate template = element.getDbManager().getDataSourceTemplate(element);
            if (template == null) {
                return;
            }
            DatabaseView view = (DatabaseView)((Object)DATABASE_VIEW_KEY.getData(e.getDataContext()));
            if (view == null) {
                return;
            }
            DatabaseSystem dsCopy = template.createDataSource(element.getProject(), (DatabaseSystem)element.getDelegate(), DbUtil.createNewDataSourceName((Project)facade.getProject(), (String)element.getName()));
            DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dsCopy, (DbPsiManagerSpi)element.getDbManager());
            DataSourceManagerDialog.showDialog(facade, newElement);
        }
    }

    static class ForgetSchemasAction
    extends DataSourceActionBase {
        public ForgetSchemasAction() {
            super("Forget Schemas", null, null);
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseView$ForgetSchemasAction", "isEnabledFor"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/DatabaseView$ForgetSchemasAction", "isEnabledFor"));
            }
            return dataSource.getDelegate() instanceof AbstractDataSource;
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseView$ForgetSchemasAction", "performActionImpl"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/view/DatabaseView$ForgetSchemasAction", "performActionImpl"));
            }
            final DataSourceManagerEx manager = DataSourceManagerEx.getInstanceEx(project);
            ForgetSchemasAction.performActionImpl(dataSources, "confirmation.text.forget.data.source.schema", "Confirm Forget Cached Schema", new Consumer<DbDataSource>(){

                public void consume(DbDataSource dataSource) {
                    AbstractDataSource delegate = (AbstractDataSource)((Object)dataSource.getDelegate());
                    if (delegate != null) {
                        delegate.updateState(DasUtil.emptyModel());
                    }
                    manager.updateDataSource(delegate);
                }
            });
        }
    }

    static class DisconnectAction
    extends DataSourceActionBase {
        public DisconnectAction() {
            super("Disconnect", null, AllIcons.Actions.Suspend);
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseView$DisconnectAction", "isEnabledFor"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/DatabaseView$DisconnectAction", "isEnabledFor"));
            }
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            Object delegate = dataSource.getDelegate();
            LocalDataSource local = delegate instanceof LocalDataSource ? (LocalDataSource)((Object)delegate) : null;
            return local != null && !manager.getActiveConfigurations(local).isEmpty();
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseView$DisconnectAction", "performActionImpl"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/view/DatabaseView$DisconnectAction", "performActionImpl"));
            }
            final JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            DisconnectAction.performActionImpl(dataSources, "confirmation.text.close.data.source.connection", "Confirm Disconnect", new Consumer<DbDataSource>(){

                public void consume(DbDataSource dataSource) {
                    manager.releaseDriver(DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource), null);
                }
            });
        }
    }

    static abstract class DataSourceActionBase
    extends DumbAwareAction {
        public DataSourceActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
            super(text, description, icon);
        }

        protected abstract boolean isEnabledFor(@NotNull Project var1, @NotNull DbDataSource var2);

        protected abstract void performActionImpl(@NotNull Project var1, @NotNull List<DbDataSource> var2);

        public void update(AnActionEvent e) {
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            boolean enabled = false;
            boolean strict = false;
            if (project != null && !elements.isEmpty()) {
                HashSet visited = ContainerUtil.newHashSet();
                for (DbElement element : elements) {
                    DbDataSource dataSource = element.getDataSource();
                    if (!visited.add(dataSource.getUniqueId())) continue;
                    strict |= element == dataSource;
                    if (enabled || !this.isEnabledFor(project, dataSource)) continue;
                    enabled = true;
                }
            }
            boolean inPopup = ActionPlaces.isPopupPlace((String)e.getPlace());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(inPopup && strict || !inPopup);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            if (project == null || elements.isEmpty()) {
                return;
            }
            ArrayList dataSources = ContainerUtil.newArrayList();
            HashSet visited = ContainerUtil.newHashSet();
            for (DbElement element : elements) {
                DbDataSource dataSource = element.getDataSource();
                if (!visited.add(dataSource.getUniqueId()) || !this.isEnabledFor(project, dataSource)) continue;
                dataSources.add(dataSource);
            }
            this.performActionImpl(project, dataSources);
        }

        protected static void performActionImpl(@NotNull List<DbDataSource> dataSources, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String key, @NotNull String title, @NotNull Consumer<DbDataSource> consumer) {
            String message;
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/view/DatabaseView$DataSourceActionBase", "performActionImpl"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/DatabaseView$DataSourceActionBase", "performActionImpl"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/DatabaseView$DataSourceActionBase", "performActionImpl"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/view/DatabaseView$DataSourceActionBase", "performActionImpl"));
            }
            if (dataSources.size() == 1) {
                message = DatabaseMessages.message((String)key, (Object[])new Object[]{dataSources.get(0).getName()});
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("<ol>");
                for (DbDataSource dataSource : dataSources) {
                    sb.append("<li>").append(dataSource.getName()).append("</li>\n");
                }
                sb.append("</ol>");
                message = XmlStringUtil.wrapInHtml((CharSequence)sb);
            }
            int ret = Messages.showOkCancelDialog((String)message, (String)title, (Icon)Messages.getWarningIcon());
            if (ret != 0) {
                return;
            }
            for (DbDataSource dataSource : dataSources) {
                consumer.consume((Object)dataSource);
            }
        }
    }

    static class DropAction
    extends PopupActionGroup {
        public DropAction() {
            super(DatabaseMessages.message((String)"action.name.drop.title", (Object[])new Object[0]), DatabaseMessages.message((String)"action.name.drop.desc", (Object[])new Object[0]), IconUtil.getRemoveIcon());
        }

        @Override
        public void update(AnActionEvent e) {
            DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
            boolean enabled = (element instanceof DbTable || element != null && element.getDbParent() instanceof DbTable) && DbImplUtil.canConnectToAndModify(element);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$DropAction", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            if (facade == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$DropAction", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            ArrayList<DumbAwareAction> actions = new ArrayList<DumbAwareAction>();
            actions.add(new DdlActions.DropPrimaryKeyAction());
            actions.add(new DdlActions.DropForeignKeyAction());
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$DropAction", "getChildren"));
            }
            return anActionArray;
        }
    }

    public static class AddDataSourceFromThatAction
    extends AddDataSourceFromPath.FromThat {
        public AddDataSourceFromThatAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    public static class AddDataSourceHereAction
    extends AddDataSourceFromPath.Here {
        public AddDataSourceHereAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    public static class AddDataSourceFromPathAction
    extends AddDataSourceFromPath.FromDialog {
        public AddDataSourceFromPathAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    public static class AddDataSourceFromUrlAction
    extends AddDataSourceFromUrl {
        public AddDataSourceFromUrlAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    public static interface DataSourceFactory {
        public void create(@NotNull DbPsiFacade var1, @NotNull DbPsiManager var2, @NotNull DataSourceTemplate var3, @Nullable String var4);
    }

    public static class AddDataSourcesGroup
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$AddDataSourcesGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            final DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            if (facade == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$AddDataSourcesGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            ArrayList actions = ContainerUtil.newArrayList();
            DatabaseView.addNewDataSourceActions((List<AnAction>)actions, false, facade, null, new PairConsumer<DbPsiManager, DataSourceTemplate>(){

                public void consume(DbPsiManager manager, DataSourceTemplate template) {
                    DatabaseView.instantiateTemplate(facade, manager, template, null);
                }
            });
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView$AddDataSourcesGroup", "getChildren"));
            }
            return anActionArray;
        }
    }

    public static class AddActionGroupPopup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            boolean toolbar = ActionPlaces.isToolbarPlace((String)e.getPlace());
            e.getPresentation().setIcon(toolbar ? IconUtil.getAddIcon() : AllIcons.General.Add);
        }
    }

    static abstract class PopupActionGroup
    extends ActionGroup
    implements DumbAware {
        public PopupActionGroup(String name, String desc, @Nullable Icon icon) {
            super(name, desc, icon);
            this.setPopup(true);
        }

        public void update(AnActionEvent e) {
            DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            e.getPresentation().setEnabled(facade != null);
        }

        public void actionPerformed(AnActionEvent e) {
            AnAction[] children = this.getChildren(e);
            if (children.length == 0) {
                return;
            }
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(e.getPresentation().getText(), (ActionGroup)new DefaultActionGroup(children), e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            InputEvent event = e.getInputEvent();
            if (event instanceof KeyEvent) {
                popup.showInBestPositionFor(e.getDataContext());
            } else {
                popup.showUnderneathOf(event.getComponent());
            }
        }
    }
}

